~VERSION INFORMATION
VERS.           2.0   :CWLS Log ASCII Standard - VERSION 2.0
WRAP.           NO    :One Line per depth step
PROD.  Schlumberger   :LAS Producer
PROG.  DLIS to ASCII 17C0-154                          :LAS Program name and version
CREA.        2010/03/31 16:00                          :LAS Creation date {YYYY/MM/DD hh:mm}
DLIS_CREA.  2010-Mar-31 15:41                          :DLIS Creation date and time {YYYY-MMM-DD hh:mm}
SOURCE.     IDL_SFL_SLT_LDL_CNL_038PUP.DLIS            :DLIS File Name
FILE-ID.     IDL_SFL_SLT_LDL_CNL_038PUP                :File Identification Number
#--------------------------------------------------
~WELL INFORMATION
#MNEM.UNIT      DATA             DESCRIPTION
#---- ------ --------------   -----------------------------
STRT .M      320.0400        :START DEPTH     
STOP .M      446.5320        :STOP DEPTH     
STEP .M       0.1524         :STEP     
NULL .          -999.25      :NULL VALUE
COMP .        Deer Lake Oil and Gas, Inc.              :COMPANY
WELL .        Werner Hatch 1                           :WELL
FLD  .        Deer Lake Basin                          :FIELD
LOC  .        UTM Coordinates                          :LOCATION
PROV .        Logan Hydro 44                           :PROVINCE
UWI  .        Easting: 474768E                         :UNIQUE WELL ID
LIC  .                                                 :LICENSE NUMBER
CTRY .        CA                                       :COUNTRY (WWW code)
DATE .        30-Mar-2010                              :LOG DATE {DD-MMM-YYYY}
SRVC .        Schlumberger                             :SERVICE COMPANY
LATI .DEG     46 DEG 23 MIN 57.8 S                     :LATITUDE
LONG .DEG     48 DEG 27 MIN 52.1 S                     :LONGITUDE
GDAT .                                                 :GeoDetic Datum
SECT .        49.22 N                                  :Section
TOWN .        57.34 W                                  :Township
#-----------------------------------------------------------------------------
~PARAMETER INFORMATION
#MNEM.UNIT    VALUE                      DESCRIPTION
#---- -----   --------------------       ------------------------
RUN  .          Run 1                    :RUN NUMBER
PDAT .        Ground Level               :Permanent Datum
EPD  .M          43.499996               :Elevation of Permanent Datum above Mean Sea Level
EREF .M          46.700005               :Elevation of tool zero above Mean Sea Level
DREF .          Kelly Bushing            :Logging Measured From (Name of Logging Elevation Reference)
APD  .M           3.200005               :Elevation of Depth Reference (LMF) above Permanent Datum
#-----------------------------------------------------------------------------
~CURVE INFORMATION
#MNEM.UNIT   API CODE                                  DESCRIPTION
#---- -----  --------                                  -----------------------
DEPT .M                                                :DEPTH (BOREHOLE) {F10.4}
AMF  .OHMM                                             :Array Induction Mud Resistivity Fully Calibrated {F13.4}
BS   .MM                                               :Bit Size {F13.4}
CALI .MM                                               :Caliper {F13.4}
DPHI .V/V                                              :Density Porosity {F13.4}
DPHI_SAN.V/V                                           :Density Porosity (matrix Sandstone) {F13.4}
DRHO .K/M3                                             :Bulk Density Correction {F13.4}
DT   .US/M                                             :Delta-T {F13.4}
DTC_RA_BHC.US/M                                        :Delta-T Compressional / RA - BHC Upper/Lower {F13.4}
DTC_RA_LT.US/M                                         :Delta-T Compressional / RA - Lower Tx {F13.4}
DTC_RA_UT.US/M                                         :Delta-T Compressional / RA - Upper Tx {F13.4}
DTCO .US/M                                             :Delta-T Compressional {F13.4}
DTS_RA_BHC.US/M                                        :Delta-T Shear / RA - BHC Upper/Lower {F13.4}
DTS_RA_LT.US/M                                         :Delta-T Shear / RA - Lower Tx {F13.4}
DTS_RA_UT.US/M                                         :Delta-T Shear / RA - Upper Tx {F13.4}
DTSM .US/M                                             :Delta-T Shear {F13.4}
GR   .GAPI                                             :Gamma Ray {F13.4}
GTEM .DEGC                                             :Generalized Borehole Temperature {F13.4}
HDPH .V/V                                              :High Resolution Density Porosity {F13.4}
HDPH_SAN.V/V                                           :High Resolution Density Porosity (matrix Sandstone) {F13.4}
HDRH .K/M3                                             :High Resolution Density Correction {F13.4}
HGR  .GAPI                                             :High Resolution Gamma Ray {F13.4}
HPEF .                                                 :High Resolution Photoelectric Factor {F13.4}
HRHO .K/M3                                             :High Resolution Bulk Density {F13.4}
ICD2 .MM/M                                             :Induction Two Foot Conductivity Deep {F13.4}
ICD4 .MM/M                                             :Induction Four Foot Conductivity Deep {F13.4}
ICM2 .MM/M                                             :Induction Two Foot Conductivity Medium {F13.4}
ICM4 .MM/M                                             :Induction Four Foot Conductivity Medium {F13.4}
ICS2 .MM/M                                             :Induction Two Foot Conductivity Shallow {F13.4}
ICS4 .MM/M                                             :Induction Four Foot Conductivity Shallow {F13.4}
ILD2 .OHMM                                             :Induction Two Foot Resistivity Deep {F13.4}
ILD4 .OHMM                                             :Induction Four Foot Resistivity Deep {F13.4}
ILM2 .OHMM                                             :Induction Two Foot Resistivity Medium {F13.4}
ILM4 .OHMM                                             :Induction Four Foot Resistivity Medium {F13.4}
ILS2 .OHMM                                             :Induction Two Foot Resistivity Shallow {F13.4}
ILS4 .OHMM                                             :Induction Four Foot Resistivity Shallow {F13.4}
ITT  .S                                                :Integrated Transit Time {F13.4}
NPOR .V/V                                              :Enhanced Thermal Neutron Porosity in Selected Lithology {F13.4}
NPOR_SAN.V/V                                           :Enhanced Thermal Neutron Porosity (matrix Sandstone) {F13.4}
PEF  .                                                 :Photoelectric Factor {F13.4}
PR   .                                                 :Poisson's Ratio {F13.4}
RHOB .K/M3                                             :Bulk Density {F13.4}
RT   .OHMM                                             :True Resistivity {F13.4}
SFLB .OHMM                                             :SFL Borehole Corrected Resistivity {F13.4}
SP   .MV                                               :SP Shifted {F13.4}
SPHI .V/V                                              :Sonic Porosity {F13.4}
SVEL .M/S                                              :Sonic Velocity {F13.4}
TEMP_ITGN.DEGC                                         :Borehole Temperature {F13.4}
TENS .LBF                                              :Cable Tension {F13.4}
TNPH .V/V                                              :Thermal Neutron Porosity (Ratio Method) in Selected Lithology {F13.4}
TNPH_SAN.V/V                                           :Thermal Neutron Porosity (matrix Sandstone) {F13.4}
#-----------------------------------------------------------------------------
# 
#     DEPT        AMF          BS           CALI         DPHI       DPHI_SAN       DRHO         DT        DTC_RA_BHC   DTC_RA_LT    DTC_RA_UT       DTCO      DTS_RA_BHC   DTS_RA_LT    DTS_RA_UT       DTSM         GR           GTEM         HDPH       HDPH_SAN       HDRH         HGR          HPEF         HRHO         ICD2         ICD4         ICM2         ICM4         ICS2         ICS4         ILD2         ILD4         ILM2         ILM4         ILS2         ILS4         ITT          NPOR       NPOR_SAN       PEF          PR           RHOB         RT           SFLB         SP           SPHI         SVEL      TEMP_ITGN       TENS         TNPH       TNPH_SAN
#
~A  
  320.0400       0.6085      96.0000      97.3177       0.1175       0.1175       4.5445     249.1388     243.6026     244.5883     242.6169     249.1388     466.8912     468.5664     465.2159     469.2594     103.2329      34.3580       0.1097       0.1097       6.3963     114.4753       3.2057    2468.9172      42.8533      42.1123      46.0578      45.9711      51.7760      52.0589      23.3354      23.7460      21.7118      21.7528      19.3140      19.2090       0.0271       0.3767       0.3767       3.2039       0.3037    2456.1716      23.3354      20.2389     363.2500       0.1641    4013.8271    -999.2500    1153.0000       0.3772       0.3772
  320.1924       0.6078      96.0000      97.4223       0.1175       0.1175       4.5445     249.1388     243.6026     244.5883     242.6169     249.1388     466.8912     468.5664     465.2159     469.2594     103.2329      34.3648       0.1097       0.1097       6.3963     114.4753       3.2057    2468.9172      42.8533      42.1123      46.0578      45.9711      51.7760      52.0589      23.3354      23.7460      21.7118      21.7528      19.3140      19.2090       0.0271       0.3767       0.3767       3.2039       0.3037    2456.1716      23.3354      20.2389     353.4375       0.1641    4013.8271    -999.2500    1170.0000       0.3772       0.3772
  320.3448       0.6071      96.0000      97.2131       0.1172       0.1172       4.2482     249.1388     243.6026     244.5883     242.6169     249.1388     466.8912     468.5664     465.2159     469.2594     103.2329      34.3717       0.1150       0.1150       4.6277     114.4753       3.3236    2460.3098      42.8533      42.1123      46.0578      45.9711      51.7760      52.0589      23.3354      23.7460      21.7118      21.7528      19.3140      19.2090       0.0271       0.3767       0.3767       3.1097       0.3037    2456.5691      23.3354      20.2389     358.1875       0.1641    4013.8271    -999.2500    1141.0000       0.3772       0.3772
  320.4972       0.6077      96.0000      97.6315       0.1179       0.1179       8.7143     249.1388     243.6026     244.5883     242.6169     249.1388     466.8912     468.5664     465.2159     469.2594     103.2329      34.3785       0.1196       0.1196       8.3324     114.4753       3.0674    2452.6418      42.8533      42.1123      46.0578      45.9711      51.7760      52.0589      23.3354      23.7460      21.7118      21.7528      19.3140      19.2090       0.0271       0.3802       0.3802       3.2090       0.3037    2455.3831      23.3354      19.5281     350.7500       0.1641    4013.8271    -999.2500    1133.0000       0.3814       0.3814
  320.6496       0.6083      96.0000      97.4746       0.1219       0.1219       7.3958     249.1388     243.6026     244.5883     242.6169     249.1388     466.8912     468.5664     465.2159     469.2594     103.2329      34.3854       0.1218       0.1218       7.7728     114.4753       3.2276    2448.9570      43.6054      42.4753      46.4361      45.8223      51.7395      51.5110      22.9329      23.5431      21.5350      21.8234      19.3276      19.4133       0.0271       0.3843       0.3843       3.2113       0.3037    2448.8271      23.3354      19.6320     351.6875       0.1641    4013.8271    -999.2500    1156.0000       0.3792       0.3792
  320.8020       0.6093      96.0000      97.5269       0.1157       0.1157      11.2117     249.1388     243.6026     244.5883     242.6169     249.1388     466.8912     468.5664     465.2159     469.2594     103.2329      34.3922       0.1214       0.1214      10.7298     114.4753       3.3483    2449.7180      44.9540      42.8758      46.9776      45.7768      51.7290      50.9439      22.2450      23.3232      21.2867      21.8451      19.3315      19.6294       0.0271       0.4010       0.4010       3.2754       0.3037    2459.0852      22.9329      20.8410     345.3750       0.1641    4013.8271    -999.2500    1151.0000       0.3844       0.3844
  320.9544       0.6103      96.0000      97.5269       0.1167       0.1167      11.2981     249.1388     241.4038     241.9081     240.8996     249.1388     458.4544     461.1151     455.7936     469.2594     103.2329      34.3990       0.1028       0.1028      16.1036     114.4753       3.2609    2480.3574      44.3997      43.3265      45.6102      45.3085      50.1899      50.1096      22.5227      23.0806      21.9249      22.0709      19.9243      19.9563       0.0271       0.3821       0.3821       3.3099       0.3037    2457.3892      22.2450      22.9079     351.1250       0.1641    4013.8271    -999.2500    1180.0000       0.3858       0.3858
  321.1068       0.6102      96.0000      97.3177       0.1148       0.1148      10.3440     249.1388     242.8693     242.4727     243.2659     249.1388     458.6958     461.5144     455.8771     469.2594     103.2329      34.4059       0.1257       0.1257       5.6791     114.4753       3.3289    2442.6118      43.0114      43.7862      43.4657      45.0585      48.0219      49.8722      23.2497      22.8382      23.0066      22.1934      20.8238      20.0512       0.0271       0.3661       0.3661       3.3367       0.3037    2460.5471      22.5227      25.6188     341.6875       0.1641    4013.8271    -999.2500    1162.0000       0.3797       0.3797
  321.2592       0.6100      96.0000      97.4223       0.1139       0.1139      13.0364     249.1388     250.9544     253.5915     248.3173     249.1388     475.8982     478.3651     473.4313     469.2594     103.2329      34.4127       0.1129       0.1129      13.0858     114.4753       3.4252    2463.7004      43.7816      44.7155      43.5684      44.8566      47.9839      49.2689      22.8406      22.3636      22.9524      22.2933      20.8403      20.2968       0.0271       0.3577       0.3577       3.4748       0.3037    2462.0964      23.2497      26.0609     346.5625       0.1641    4013.8271    -999.2500    1182.0000       0.3716       0.3716
  321.4116       0.6112      96.0000      97.4223       0.1156       0.1156      12.5848     249.1388     255.1362     260.7044     249.5679     249.1388     484.5261     489.0368     480.0154     469.2594     103.2329      34.4195       0.1041       0.1041      17.7899     114.4753       3.6748    2478.2095      46.4710      45.2840      45.6657      45.0511      50.1454      49.5034      21.5188      22.0829      21.8983      22.1970      19.9420      20.2006       0.0271       0.3791       0.3791       3.4394       0.3037    2459.1931      22.8406      22.2255     340.0000       0.1641    4013.8271    -999.2500    1196.0000       0.3683       0.3683
  321.5640       0.6124      96.0000      97.5269       0.1075       0.1075      16.7094     249.1388     254.8339     260.0616     249.6063     249.1388     480.6859     483.3599     478.0118     469.2594     103.2329      34.4264       0.1266       0.1266      11.5520     114.4753       3.2202    2441.0613      48.9293      45.6804      47.8048      44.9617      52.3820      49.4858      20.4376      21.8912      20.9184      22.2412      19.0905      20.2078       0.0271       0.3892       0.3892       3.3620       0.3037    2472.5679      21.5188      20.1880     339.2500       0.1641    4013.8271    -999.2500    1178.0000       0.3753       0.3753
  321.7164       0.6151      96.0000      97.4223       0.1101       0.1101       8.2200     249.1388     251.9631     259.4313     244.4949     249.1388     469.2872     469.3149     469.2594     469.2594     103.2329      34.4332       0.0945       0.0945      14.7478     112.2403       3.1955    2494.0784      47.7067      44.8486      46.5731      43.8606      51.1718      48.4137      20.9614      22.2972      21.4716      22.7995      19.5420      20.6553       0.0271       0.3914       0.3914       3.1640       0.3037    2468.3643      20.4376      22.1583     341.6875       0.1641    4013.8271    -999.2500    1161.0000       0.3796       0.3796
  321.8688       0.6178      96.0000      97.6315       0.0932       0.0932      12.4707     246.7999     249.3983     250.5559     248.2406     246.7999     451.9101     461.8877     441.9324     441.9324     103.3089      34.4401       0.1021       0.1021       7.7845      96.9593       3.0696    2481.5603      44.2761      42.3623      43.3570      41.3677      47.9594      45.9451      22.5856      23.6059      23.0643      24.1735      20.8510      21.7651       0.0270       0.3758       0.3758       3.1776       0.2734    2496.2500      20.9614      24.0573     334.0625       0.1597    4051.8657    -999.2500    1181.0000       0.3683       0.3683
  322.0212       0.6198      96.0000      97.4223       0.0930       0.0930       8.0065     244.4290     241.4025     241.4066     241.3983     244.4290     450.4000     460.8354     439.9647     439.9647     100.8209      34.4469       0.0862       0.0862      10.2569     101.3871       3.2617    2507.7129      40.2579      38.1933      39.7034      37.4009      44.3448      41.9934      24.8399      26.1826      25.1867      26.7373      22.5505      23.8132       0.0270       0.3530       0.3530       3.1502       0.2768    2496.5325      22.5856      26.9718     339.9375       0.1552    4091.1680    -999.2500    1176.0000       0.3604       0.3604
  322.1736       0.6218      96.0000      97.5269       0.0878       0.0878      12.7375     239.2065     244.8558     245.6904     244.0213     239.2065     444.9432     458.5432     431.3431     431.3431     106.9668      34.4537       0.0880       0.0880      11.6897     103.8990       3.1203    2504.8560      34.9254      32.5342      34.8059      32.0705      39.6190      36.6798      28.6324      30.7369      28.7308      31.1813      25.2404      27.2630       0.0270       0.3873       0.3873       3.1571       0.2779    2505.1548      24.8399      26.8857     330.7500       0.1450    4180.4878    -999.2500    1177.0000       0.3571       0.3571
  322.3260       0.6232      96.0000      97.5269       0.0850       0.0850      11.0332     232.2220     235.0511     241.6299     228.4723     232.2220     426.7867     437.3340     416.2393     416.2393     109.6571      34.4606       0.0944       0.0944       8.9423     115.3970       3.0866    2494.2871      26.1788      25.7630      26.4838      25.6767      31.4870      30.4887      38.1988      38.8153      37.7589      38.9458      31.7591      32.7990       0.0269       0.3784       0.3784       3.0696       0.2740    2509.7505      28.6324      35.2022     336.6250       0.1305    4306.2251    -999.2500    1163.0000       0.3463       0.3463
  322.4784       0.6245      96.0000      97.4746       0.0773       0.0773      10.1367     222.3218     222.6865     228.0163     217.3567     222.3218     400.6387     406.3908     394.8867     394.8867     117.5519      34.4674       0.0728       0.0728      11.6242     111.7467       3.0045    2529.8223      16.6962      19.0314      17.1459      19.2140      22.3456      24.1501      59.8939      52.5448      58.3231      52.0453      44.7515      41.4077       0.0269       0.3049       0.3049       3.0004       0.2680    2522.5159      38.1988      63.7978     326.4375       0.1085    4497.9854    -999.2500    1194.0000       0.3127       0.3127
  322.6308       0.6255      96.0000      97.4223       0.0654       0.0654       6.0047     214.8566     217.6205     217.0524     218.1885     214.8566     386.8489     391.1804     382.5174     382.5174     123.5831      34.4742       0.0668       0.0668       5.1787     127.5833       2.9125    2539.8352       9.4045      13.3163       9.5328      13.6003      14.9713      18.8013     106.3322      75.0957     104.9005      73.5280      66.7946      53.1878       0.0269       0.2611       0.2611       2.9267       0.2695    2542.0750      59.8939     123.2277     331.9375       0.0906    4654.2676    -999.2500    1207.0000       0.2820       0.2820
  322.7832       0.6264      96.0000      97.6315       0.0648       0.0648       4.4531     210.8837     217.4623     214.5753     220.3493     210.8837     377.3090     378.1932     376.4248     376.4248     131.2814      34.4811       0.0536       0.0536       5.7983     132.6397       2.8670    2561.6228       6.1079       9.5580       5.7387       9.7912      11.3475      15.2321     163.7211     104.6246     174.2557     102.1321      88.1251      65.6509       0.0268       0.2408       0.2408       2.9503       0.2713    2543.0750     106.3322     182.5764     331.4375       0.0805    4741.9507    -999.2500    1183.0000       0.2627       0.2627
  322.9356       0.6256      96.0000      97.5269       0.0631       0.0631       7.7429     210.6594     215.6924     216.4032     214.9816     210.6594     375.5902     372.3394     378.8410     378.8410     133.3226      34.4879       0.0713       0.0713       6.6305     132.7706       3.0709    2532.3110       5.0953       7.9466       4.6569       8.2029      10.3443      13.8149     196.2581     125.8393     214.7350     121.9077      96.6714      72.3857       0.0268       0.2439       0.2439       3.0358       0.2762    2545.9543     163.7211     179.5827     328.1250       0.0799    4746.9990    -999.2500    1171.0000       0.2560       0.2560
  323.0880       0.6248      96.0000      97.3177       0.0691       0.0691       8.5430     212.3255     218.7442     218.3106     219.1779     212.3255     382.6253     376.8730     388.3777     388.3777     124.0328      34.4948       0.0636       0.0636      11.5277     133.7068       3.1779    2545.0979       5.5823       8.2511       5.7104       8.7643      11.3642      14.4556     179.1361     121.1963     175.1176     114.0993      87.9958      69.1775       0.0268       0.2388       0.2388       3.1380       0.2869    2535.9985     196.2581     167.5393     331.9375       0.0842    4709.7510    -999.2500    1135.0000       0.2547       0.2547
  323.2404       0.6240      96.0000      97.3177       0.0746       0.0746       7.5605     214.8566     219.4658     220.5306     218.4009     214.8566     392.5721     393.3169     391.8274     391.8274     123.1985      34.5016       0.0694       0.0694      11.3174     105.6210       3.1676    2535.4297       8.4069      10.2433       9.0927      11.0498      14.5769      16.7078     118.9506      97.6252     109.9787      90.4998      68.6019      59.8522       0.0267       0.2492       0.2492       3.2243       0.2850    2526.9343     179.1361     126.2919     324.5000       0.0906    4654.2676    -999.2500    1133.0000       0.2605       0.2605
  323.3928       0.6232      96.0000      97.4223       0.0830       0.0830       8.1884     219.6625     223.2445     225.9556     220.5334     219.6625     400.4755     395.6403     405.3107     405.3107     115.4736      34.5084       0.0856       0.0856       6.7860     130.3556       3.3309    2508.8293      13.3105      13.4461      14.1983      14.4168      19.4651      19.8981      75.1284      74.3710      70.4309      69.3637      51.3739      50.2560       0.0267       0.2786       0.2786       3.2495       0.2921    2513.0144     118.9506      72.7575     335.8125       0.1022    4552.4385    -999.2500    1146.0000       0.2708       0.2708
  323.5452       0.6231      96.0000      97.3177       0.0947       0.0947       8.5289     225.2694     229.0065     230.9995     227.0137     225.2694     421.0894     420.8657     421.3131     421.3131     118.4250      34.5153       0.0914       0.0914       9.1490     110.7723       3.2460    2499.2681      18.3797      17.0043      19.2640      17.9911      24.3131      23.2706      54.4079      58.8088      51.9102      55.5831      41.1301      42.9726       0.0267       0.3047       0.3047       3.2740       0.2998    2493.7703      75.1284      53.5043     330.1875       0.1153    4439.1294    -999.2500    1144.0000       0.2909       0.2909
  323.6976       0.6229      96.0000      97.3177       0.0975       0.0975      10.4254     229.8510     231.0800     227.8002     234.3598     229.8510     432.3004     435.7756     428.8252     428.8252     117.5787      34.5221       0.1081       0.1081       8.5210     114.4753       3.2474    2471.5984      22.6244      20.2072      23.4180      21.1271      28.3179      26.1802      44.2000      49.4872      42.7022      47.3327      35.3133      38.1968       0.0266       0.3489       0.3489       3.2745       0.2984    2489.0449      54.4079      43.0570     335.1875       0.1254    4350.6440    -999.2500    1146.0000       0.3242       0.3242
  323.8500       0.6234      96.0000      97.5269       0.1045       0.1045       9.5490     233.4395     235.1826     235.4103     234.9550     233.4395     438.5735     441.5099     435.6370     435.6370     128.1926      34.5289       0.0945       0.0945      12.4577     126.4964       3.3277    2494.1509      24.4774      22.5472      25.1445      23.3362      30.0516      28.2398      40.8541      44.3515      39.7701      42.8519      33.2761      35.4110       0.0266       0.3471       0.3471       3.3360       0.2986    2477.6184      44.2000      42.8694     322.4375       0.1331    4283.7661    -999.2500    1145.0000       0.3409       0.3409
  324.0024       0.6239      96.0000      97.3177       0.1007       0.1007      11.4640     232.5103     233.1964     236.6918     229.7010     232.5103     441.1048     439.9598     442.2498     442.2498     155.8651      34.5358       0.1111       0.1111       7.8592     142.3738       3.4265    2466.6104      25.2232      23.7635      25.8170      24.4074      30.7495      29.3398      39.6460      42.0814      38.7341      40.9712      32.5208      34.0834       0.0266       0.3275       0.3275       3.3965       0.3090    2483.8462      40.8541      43.7071     333.7500       0.1311    4300.8848    -999.2500    1147.0000       0.3381       0.3381
  324.1548       0.6244      96.0000      97.4223       0.1052       0.1052       8.2625     229.6268     231.7705     233.0863     230.4547     229.6268     430.3036     432.3274     428.2797     428.2797     214.2651      34.5426       0.0992       0.0992      11.1128     197.2592       3.4184    2486.2683      25.4466      23.9987      26.0392      24.5643      30.9927      29.5170      39.2980      41.6690      38.4037      40.7095      32.2656      33.8788       0.0265       0.3357       0.3357       3.3777       0.2983    2476.3896      39.6460      40.0634     327.5000       0.1249    4354.8936    -999.2500    1144.0000       0.3420       0.3420
  324.3072       0.6249      96.0000      97.6315       0.0991       0.0991       6.2858     226.3267     229.4981     228.8034     230.1928     226.3267     426.1517     427.2041     425.0994     425.0994     250.1494      34.5494       0.1072       0.1072       4.1857     302.9283       3.2740    2473.0540      24.3175      23.6380      24.9511      24.2167      29.9741      29.1775      41.1227      42.3047      40.0783      41.2939      33.3621      34.2730       0.0265       0.3731       0.3731       3.3417       0.3022    2486.4358      39.2980      40.8839     328.8125       0.1176    4418.3916    -999.2500    1137.0000       0.3453       0.3453
  324.4596       0.6261      96.0000      97.4223       0.0942       0.0942       4.9716     221.2645     228.0822     226.8601     229.3044     221.2645     415.3525     415.7811     414.9239     414.9239     235.8893      34.5563       0.0892       0.0892       7.1973     250.0268       3.3252    2502.8049      22.7603      23.0362      23.3879      23.6511      28.3791      28.6491      43.9362      43.4100      42.7572      42.2813      35.2372      34.9051       0.0265       0.3564       0.3564       3.3593       0.3013    2494.5554      41.1227      46.9724     331.9375       0.1060    4519.4790    -999.2500    1125.0000       0.3432       0.3432
  324.6120       0.6273      96.0000      97.3177       0.0867       0.0867       8.2565     218.7974     223.7711     222.3576     225.1847     218.7974     409.8853     411.5562     408.2144     408.2144     190.5293      34.5631       0.0821       0.0821       9.3514     155.2817       3.4950    2514.5894      20.9510      22.5682      21.6474      23.2717      26.6346      28.2827      47.7304      44.3101      46.1950      42.9707      37.5452      35.3573       0.0264       0.3332       0.3332       3.3832       0.2985    2506.9575      43.9362      55.5568     324.4375       0.1002    4570.4380    -999.2500    1124.0000       0.3370       0.3370
  324.7644       0.6266      96.0000      97.3177       0.0838       0.0838      13.9274     219.9829     222.5261     219.3532     225.6990     219.9829     417.0125     418.7760     415.2490     415.2490     146.2364      34.5700       0.0851       0.0851      14.1275     166.8480       3.3445    2509.6599      20.4947      22.4856      21.2000      23.2375      26.2017      28.2481      48.7932      44.4730      47.1699      43.0338      38.1654      35.4007       0.0264       0.3172       0.3172       3.4732       0.3049    2511.7776      47.7304      59.1999     326.8125       0.1030    4545.8081    -999.2500    1149.0000       0.3287       0.3287
  324.9168       0.6258      96.0000      97.5269       0.0895       0.0895      16.5307     223.1868     227.7997     225.8801     229.7193     223.1868     421.4330     428.9264     413.9397     413.9397     131.3395      34.5768       0.0836       0.0836      19.3552     117.2421       3.5778    2512.1335      22.3317      22.6308      23.1789      23.4583      28.2160      28.4689      44.7793      44.1876      43.1426      42.6289      35.4409      35.1261       0.0264       0.3127       0.3127       3.5066       0.2951    2502.2668      48.7932      49.9547     322.2500       0.1105    4480.5513    -999.2500    1153.0000       0.3315       0.3315
  325.0692       0.6287      96.0000      97.6315       0.0885       0.0885      15.7962     228.2491     234.7041     234.8007     234.6074     228.2491     434.0748     439.4133     428.7364     428.7364     111.2681      34.5836       0.1008       0.1008      14.3531     110.0224       3.5927    2483.7324      25.2052      22.3393      26.2688      23.2397      31.4852      28.3612      39.6744      44.7641      38.0680      43.0298      31.7610      35.2594       0.0263       0.3662       0.3662       3.4596       0.3022    2503.9280      44.7793      35.4505     329.6875       0.1219    4381.1792    -999.2500    1161.0000       0.3411       0.3411
  325.2216       0.6316      96.0000      97.5269       0.0877       0.0877      11.1021     227.4481     232.8062     234.4042     231.2083     227.4481     429.1773     431.9659     426.3887     426.3887      99.2270      34.5905       0.0795       0.0795      14.0240     106.6337       3.2104    2518.7712      25.6885      20.9578      26.8766      21.9247      32.1743      27.1842      38.9279      47.7150      37.2070      45.6106      31.0807      36.7861       0.0263       0.3993       0.3993       3.3046       0.3011    2505.2708      39.6744      32.9903     317.6875       0.1201    4396.6079    -999.2500    1165.0000       0.3497       0.3497
  325.3740       0.6332      96.0000      97.4223       0.0703       0.0703       9.4251     221.3926     227.8990     228.7498     227.0482     221.3926     414.4341     417.1581     411.7101     411.7101      89.9376      34.5973       0.0800       0.0800       6.7820      81.7694       3.1243    2517.9905      21.3329      18.2098      22.4686      19.1943      27.8744      24.5265      46.8760      54.9155      44.5065      52.0988      35.8753      40.7722       0.0262       0.3521       0.3521       3.1642       0.2966    2534.0356      38.9279      46.6163     331.0000       0.1063    4516.8623    -999.2500    1167.0000       0.3284       0.3284
  325.5264       0.6347      96.0000      97.4746       0.0536       0.0536       9.5332     212.7740     216.5277     217.2787     215.7766     212.7740     389.0912     391.4222     386.7603     386.7603      83.5046      34.6041       0.0479       0.0479       9.3511      82.1542       3.1613    2571.0300      14.1411      14.6017      15.0861      15.5655      20.6596      20.9986      70.7160      68.4852      66.2864      64.2445      48.4036      47.6223       0.0262       0.2776       0.2776       3.1185       0.2830    2561.6304      46.8760      87.0524     313.7500       0.0853    4699.8223    -999.2500    1176.0000       0.2842       0.2842
  325.6788       0.6351      96.0000      97.6315       0.0335       0.0335      12.8252     202.7136     203.0330     197.3924     208.6735     202.7136     365.0743     366.0316     364.1171     364.1171      85.9056      34.6110       0.0282       0.0282      15.5054      87.3350       3.0913    2603.5330       8.0326      11.0368       8.6882      11.9515      14.4399      17.5077     124.4922      90.6062     115.0988      83.6712      69.2525      57.1177       0.0262       0.2335       0.2335       3.1694       0.2754    2594.6570      70.7160     134.5683     326.3750       0.0585    4933.0679    -999.2500    1183.0000       0.2582       0.2582
  325.8312       0.6355      96.0000      97.5269       0.0327       0.0327       9.9607     200.1184     197.7773     195.7111     199.8436     200.1184     360.3080     361.3582     359.2577     359.2577      90.4647      34.6178       0.0235       0.0235      13.0010      90.5593       3.2765    2611.1602       5.3631       8.3840       5.7852       9.2442      11.6608      14.9696     186.4576     119.2745     172.8543     108.1755      85.7572      66.8020       0.0262       0.2143       0.2143       3.1550       0.2751    2596.1257     124.4922     172.7264     317.6875       0.0512    4997.0410    -999.2500    1188.0000       0.2385       0.2385
  325.9836       0.6356      96.0000      97.3177       0.0353       0.0353      10.5625     200.5670     203.6267     207.4997     199.7537     200.5670     361.8196     361.2171     362.4221     362.4221      90.4564      34.6247       0.0414       0.0414       7.4770      95.3724       3.1196    2581.6086       5.3165       6.8639       5.8944       7.6839      11.8409      13.5398     188.0927     145.6902     169.6525     130.1423      84.4528      73.8564       0.0261       0.2220       0.2220       3.2237       0.2793    2591.7473     186.4576     142.8091     315.7500       0.0525    4985.8657    -999.2500    1209.0000       0.2383       0.2383
  326.1360       0.6358      96.0000      97.4746       0.0515       0.0515       7.2299     206.8147     211.6785     212.7826     210.5743     206.8147     374.8124     375.2069     374.4180     374.4180      95.1360      34.6315       0.0414       0.0414      10.2092      87.3099       3.2802    2581.7195       6.1677       6.1401       7.0906       6.9561      13.0285      12.9021     162.1353     162.8634     141.0322     143.7579      76.7549      77.5066       0.0261       0.2535       0.2535       3.1585       0.2805    2565.0176     188.0927     116.5953     315.0000       0.0698    4835.2471    -999.2500    1209.0000       0.2473       0.2473
  326.2884       0.6362      96.0000      97.4223       0.0558       0.0558      11.9891     215.4333     216.4980     217.7859     215.2101     215.4333     388.3240     391.8697     384.7783     384.7783     100.8475      34.6383       0.0709       0.0709       4.8286     102.2665       3.0841    2532.9741       6.3064       5.8491       7.3735       6.7090      13.3451      12.5940     158.5692     170.9669     135.6214     149.0545      74.9339      79.4026       0.0261       0.2834       0.2834       3.2445       0.2717    2558.0042     162.1353     117.3684     310.1875       0.0920    4641.8086    -999.2500    1215.0000       0.2677       0.2677
  326.4408       0.6366      96.0000      97.4223       0.0624       0.0624      16.3876     221.9052     225.3120     228.4444     222.1797     221.9052     397.0052     396.4582     397.5524     397.5524     101.1645      34.6452       0.0551       0.0551      20.8444     111.3243       3.3823    2559.1450       5.7672       5.6051       6.7331       6.5011      12.6842      12.3491     173.3944     178.4104     148.5202     153.8204      78.8379      80.9775       0.0260       0.2853       0.2853       3.2286       0.2737    2547.0305     158.5692     133.2867     321.3125       0.1075    4506.4277    -999.2500    1196.0000       0.2819       0.2819
  326.5932       0.6366      96.0000      97.6315       0.0682       0.0682      15.4789     228.5695     233.7747     230.8685     236.6808     228.5695     416.9464     420.2628     413.6298     413.6298      97.6436      34.6520       0.0650       0.0650      18.3384      88.2606       3.2328    2542.7036       4.9260       5.4367       5.8169       6.2988      11.8275      12.2074     203.0054     183.9343     171.9129     158.7605      84.5488      81.9177       0.0260       0.2906       0.2906       3.2737       0.2802    2537.4290     173.3944     193.0260     303.7500       0.1226    4375.0381    -999.2500    1205.0000       0.2885       0.2885
  326.7456       0.6367      96.0000      97.5269       0.0752       0.0752      17.8207     233.5996     237.6573     236.3837     238.9308     233.5996     424.2321     428.5760     419.8881     419.8881      99.8718      34.6588       0.0801       0.0801      14.0493      92.7246       3.2209    2517.7571       4.5629       5.4840       5.3543       6.3713      11.2797      12.3889     219.1612     182.3489     186.7656     156.9549      88.6546      80.7172       0.0260       0.2812       0.2812       3.3151       0.2759    2525.8821     203.0054     209.3474     315.6250       0.1334    4280.8286    -999.2500    1256.0000       0.2938       0.2938
  326.8980       0.6361      96.0000      97.4746       0.0850       0.0850      12.0661     234.2084     239.6564     242.1255     237.1873     234.2084     431.8981     435.7351     428.0610     428.0610     119.1103      34.6657       0.0843       0.0843      14.6580     119.6507       3.5119    2510.9060       4.9084       6.1539       5.6906       7.1469      11.5306      13.0634     203.7332     162.4996     175.7299     139.9199      86.7256      76.5498       0.0259       0.2962       0.2962       3.2747       0.2864    2509.6758     219.1612     158.4675     302.6250       0.1347    4269.7017    -999.2500    1229.0000       0.3062       0.3062
  327.0504       0.6356      96.0000      97.6315       0.0835       0.0835      15.6002     230.5559     232.2899     233.6372     230.9426     230.5559     425.8823     426.8870     424.8776     424.8776     137.6471      34.6725       0.0877       0.0877      11.6300     145.9762       3.1145    2505.2263       6.2643       7.2616       7.1724       8.3125      12.9192      14.1657     159.6356     137.7103     139.4227     120.3011      77.4044      70.5930       0.0259       0.3181       0.3181       3.4406       0.2913    2512.2651     203.7332     150.3782     316.7500       0.1269    4337.3428    -999.2500    1242.0000       0.3170       0.3170
  327.2028       0.6360      96.0000      97.4223       0.0791       0.0791      14.9908     223.8917     229.7236     229.8501     229.5971     223.8917     413.1466     411.9868     414.3064     414.3064     152.1291      34.6794       0.0806       0.0806      15.8700     145.8582       3.7123    2517.0591       9.0303       8.3930      10.2035       9.5117      15.8359      15.3315     110.7384     119.1475      98.0058     105.1334      63.1478      65.2252       0.0259       0.3141       0.3141       3.4678       0.2938    2519.5015     159.6356      91.8768     308.7500       0.1121    4466.4453    -999.2500    1216.0000       0.3125       0.3125
  327.3552       0.6364      96.0000      97.5269       0.0759       0.0759      14.5013     212.7740     217.4506     215.4967     219.4044     212.7740     392.5045     391.8440     393.1650     393.1650     151.4834      34.6862       0.0670       0.0670      19.7133     164.9361       3.6046    2539.4436      11.5574       9.3926      12.9520      10.5658      18.4149      16.2037      86.5247     106.4669      77.2084      94.6447      54.3037      61.7142       0.0258       0.3420       0.3420       3.6218       0.2929    2524.8469     110.7384      65.9039     312.3750       0.0853    4699.8223    -999.2500    1207.0000       0.3147       0.3147
  327.5076       0.6368      96.0000      97.4223       0.0728       0.0728      10.8647     204.6360     210.7705     208.8848     212.6561     204.6360     374.1454     372.5524     375.7385     375.7385     141.1115      34.6930       0.0814       0.0814       5.6378     144.0392       3.5578    2515.6111      11.3725       9.7370      12.7624      10.9577      18.1125      16.4313      87.9315     102.7015      78.3551      91.2598      55.2104      60.8594       0.0258       0.3237       0.3237       3.4708       0.2892    2529.8909      86.5247      77.9968     311.3125       0.0639    4886.7261    -999.2500    1234.0000       0.3083       0.3083
  327.6600       0.6372      96.0000      97.6315       0.0689       0.0689       8.1170     200.6631     202.8429     198.7268     206.9591     200.6631     364.7349     362.4101     367.0597     367.0597     133.0634      34.6999       0.0681       0.0681      10.5552     116.1987       3.2703    2537.6089       9.4200       9.5026      10.5894      10.7331      15.8411      16.0914     106.1569     105.2339      94.4339      93.1696      63.1269      62.1451       0.0258       0.2885       0.2885       3.3631       0.2869    2536.3376      87.9315      95.5290     304.3125       0.0528    4983.4775    -999.2500    1221.0000       0.3039       0.3039
  327.8124       0.6375      96.0000      97.5269       0.0599       0.0599      10.9972     198.9970     202.1759     199.0237     205.3281     198.9970     364.5079     361.3815     367.6343     367.6343     128.4394      34.7067       0.0527       0.0527      14.8518     138.9521       3.2753    2563.0432       8.4901       8.9780       9.4978      10.1553      14.5798      15.3968     117.7842     111.3838     105.2872      98.4705      68.5879      64.9486       0.0257       0.2953       0.2953       3.2710       0.2928    2551.2275     106.1569     101.4133     315.6875       0.0480    5025.2007    -999.2500    1216.0000       0.2949       0.2949
  327.9648       0.6377      96.0000      97.5269       0.0548       0.0548      12.8485     198.4844     198.1143     198.8127     197.4159     198.4844     361.8182     360.3394     363.2971     363.2971     129.9022      34.7135       0.0577       0.0577       9.4438     130.4073       3.2730    2554.7485       8.6414       8.4841       9.7167       9.6544      14.6584      14.7958     115.7224     117.8675     102.9158     103.5798      68.2201      67.5866       0.0257       0.2992       0.2992       3.2348       0.2873    2559.5107     117.7842     101.9898     302.6250       0.0465    5038.1792    -999.2500    1252.0000       0.2934       0.2934
  328.1172       0.6375      96.0000      97.4223       0.0576       0.0576       9.2491     197.3630     196.7649     198.3010     195.2287     197.3630     361.9544     358.6620     365.2468     365.2468     117.9233      34.7204       0.0573       0.0573       9.1990     120.5870       3.1602    2555.4109       8.6944       8.1236       9.7033       9.2421      14.6888      14.1884     115.0169     123.0988     103.0578     108.2002      68.0790      70.4803       0.0257       0.2874       0.2874       3.1667       0.2938    2555.0325     115.7224     108.5252     312.3750       0.0432    5066.8052    -999.2500    1240.0000       0.2843       0.2843
  328.2696       0.6372      96.0000      97.5269       0.0553       0.0553       8.0942     196.1776     198.3424     198.4570     198.2278     196.1776     358.2821     355.7563     360.8080     360.8080     113.0433      34.7272       0.0606       0.0606       3.8714     104.4717       3.0807    2550.0906       8.1187       7.6982       9.0959       8.6610      14.0251      13.6582     123.1723     129.9008     109.9395     115.4601      71.3006      73.2162       0.0256       0.2820       0.2820       3.1482       0.2901    2558.7319     115.0169     116.9610     302.6250       0.0397    5097.4229    -999.2500    1235.0000       0.2722       0.2722
  328.4220       0.6364      96.0000      97.4746       0.0487       0.0487      12.4530     195.7290     197.9860     197.4864     198.4856     195.7290     349.4275     349.9933     348.8616     348.8616     113.8943      34.7341       0.0464       0.0464      13.2230     114.3474       3.2089    2573.3730       7.3746       7.3308       8.2608       8.2354      13.3264      13.2988     135.5998     136.4107     121.0537     121.4265      75.0392      75.1949       0.0256       0.2567       0.2567       3.1562       0.2703    2569.6677     123.1723     124.7227     312.3750       0.0383    5109.1045    -999.2500    1200.0000       0.2609       0.2609
  328.5744       0.6356      96.0000      97.3177       0.0435       0.0435      16.5437     196.3057     197.6769     197.4732     197.8806     196.3057     353.9262     352.1985     355.6539     355.6539     118.0517      34.7409       0.0392       0.0392      19.2498     123.1397       3.1846    2585.2578       6.5796       7.0773       7.4476       7.9926      12.5365      13.0629     151.9841     141.2958     134.2706     125.1161      79.7671      76.5525       0.0256       0.2368       0.2368       3.2805       0.2809    2578.2961     135.5998     130.9447     302.6250       0.0400    5094.0952    -999.2500    1232.0000       0.2523       0.2523
  328.7268       0.6360      96.0000      97.5269       0.0448       0.0448      19.3476     196.8824     197.7145     197.5660     197.8629     196.8824     357.2696     358.4703     356.0689     356.0689     125.8489      34.7477       0.0446       0.0446      17.7901     114.7364       3.4717    2576.4519       5.8411       7.0087       6.6898       7.9648      11.7598      13.0311     171.1995     142.6799     149.4810     125.5532      85.0352      76.7396       0.0255       0.2454       0.2454       3.2196       0.2798    2576.0793     151.9841     115.0580     311.5000       0.0418    5079.1733    -999.2500    1242.0000       0.2523       0.2523
  328.8792       0.6365      96.0000      97.4746       0.0522       0.0522      18.1212     198.9009     198.5967     197.8941     199.2993     198.9009     360.3356     360.2183     360.4529     360.4529     120.0186      34.7546       0.0502       0.0502      21.6426     138.9192       3.0288    2567.2185       5.5765       7.4275       6.1385       8.3646      11.3389      13.4030     179.3236     134.6349     162.9061     119.5511      88.1918      74.6100       0.0255       0.2560       0.2560       3.1887       0.2811    2563.8162     171.1995     112.1859     307.3750       0.0477    5027.6289    -999.2500    1203.0000       0.2549       0.2549
  329.0316       0.6363      96.0000      97.4223       0.0599       0.0599      17.4491     202.1369     201.0394     199.0762     203.0026     202.1369     369.5463     370.2733     368.8193     368.8193     113.2131      34.7614       0.0647       0.0647      13.2085     105.6487       3.0850    2543.2017       6.6924       8.7656       7.1944       9.6692      12.2455      14.8754     149.4243     114.0829     138.9966     103.4212      81.6627      67.2252       0.0255       0.2487       0.2487       3.0898       0.2853    2551.1489     179.3236     116.8766     312.3750       0.0569    4947.1421    -999.2500    1183.0000       0.2574       0.2574
  329.1840       0.6361      96.0000      97.3177       0.0704       0.0704      12.1980     206.3661     203.6107     197.7491     209.4723     206.3661     377.4894     381.0734     373.9053     373.9053     105.3174      34.7682       0.0697       0.0697      12.1407      93.5415       3.1444    2535.0176       9.9352      11.1163      10.8676      12.1830      15.7748      17.2404     100.6526      89.9580      92.0167      82.0817      63.3922      58.0034       0.0255       0.2569       0.2569       3.1854       0.2810    2533.7742     149.4243     101.9948     312.3750       0.0686    4845.7568    -999.2500    1176.0000       0.2674       0.2674
  329.3364       0.6378      96.0000      97.1085       0.0772       0.0772       7.8883     212.0691     214.7943     214.7863     214.8024     212.0691     391.5918     395.5860     387.5975     387.5975     121.7212      34.7751       0.0805       0.0805       8.4567     115.2322       3.3319    2517.2556      14.4417      13.2961      15.7225      14.5385      20.9715      19.6808      69.2438      75.2102      63.6031      68.7828      47.6837      50.8108       0.0254       0.2775       0.2775       3.2800       0.2864    2522.6582     100.6526      77.0456     314.9375       0.0835    4715.4434    -999.2500    1197.0000       0.2744       0.2744
  329.4888       0.6394      96.0000      97.6315       0.0837       0.0837       5.3131     217.8362     217.7749     214.4466     221.1032     217.8362     410.3497     414.8831     405.8164     405.8164     121.4732      34.7819       0.0809       0.0809       4.5579     155.5676       3.3881    2516.4988      18.9489      15.8572      20.3650      17.1075      25.4857      22.4053      52.7736      63.0628      49.1038      58.4539      39.2377      44.6323       0.0254       0.3062       0.3062       3.3509       0.2976    2511.9443      69.2438      57.3748     317.6875       0.0979    4590.6045    -999.2500    1197.0000       0.2912       0.2912
  329.6412       0.6409      96.0000      97.5269       0.0807       0.0807       8.1509     220.0790     220.7699     215.2414     226.2983     220.0790     415.3635     419.9323     410.7947     410.7947     117.1241      34.7887       0.0877       0.0877       8.0415      94.3274       3.3497    2505.3455      20.3862      17.6848      21.7570      19.0177      27.1974      24.1427      49.0528      56.5456      45.9623      52.5827      36.7682      41.4204       0.0254       0.3350       0.3350       3.3331       0.2987    2516.8010      52.7736      48.2097     312.3750       0.1032    4543.8228    -999.2500    1154.0000       0.3066       0.3066
  329.7936       0.6423      96.0000      97.4746       0.0698       0.0698      13.4045     220.8800     221.9020     216.9462     226.8578     220.8800     415.3068     417.8104     412.8033     412.8033      93.9096      34.7956       0.0741       0.0741      12.7590     102.1848       3.2739    2527.7007      19.4640      17.9287      20.7272      19.2760      26.4260      24.7208      51.3769      55.7765      48.2458      51.8779      37.8416      40.4518       0.0253       0.3303       0.3303       3.2674       0.2994    2534.8411      49.0528      49.0716     322.1875       0.1051    4527.3457    -999.2500    1199.0000       0.3171       0.3171
  329.9460       0.6433      96.0000      97.4223       0.0604       0.0604      14.3730     218.2207     219.3101     217.0467     221.5736     218.2207     407.9714     408.6728     407.2701     407.2701      88.0788      34.8024       0.0500       0.0500      16.4248      85.6560       3.1812    2567.5073      18.0588      17.2579      19.2528      18.5509      25.0459      24.2543      55.3747      57.9443      51.9404      53.9057      39.9266      41.2299       0.0253       0.3115       0.3115       3.1982       0.2986    2550.2815      51.3769      55.4415     309.8125       0.0988    4582.5166    -999.2500    1191.0000       0.3145       0.3145
  330.0984       0.6443      96.0000      97.4746       0.0582       0.0582       9.7493     213.8313     216.4234     219.4711     213.3758     213.8313     395.5842     395.1481     396.0202     396.0202      79.3683      34.8093       0.0611       0.0611       7.2708      76.8351       3.1319    2549.1797      16.2922      16.0116      17.4297      17.2223      23.0770      23.0201      61.3789      62.4548      57.3735      58.0643      43.3333      43.4402       0.0253       0.3049       0.3049       3.1007       0.2942    2553.9004      55.3747      62.7366     321.3125       0.0880    4676.5840    -999.2500    1195.0000       0.3038       0.3038
  330.2508       0.6453      96.0000      97.1608       0.0581       0.0581       6.6609     210.6594     209.7001     211.5657     207.8345     210.6594     384.9450     391.6011     378.2890     378.2890      77.4258      34.8161       0.0635       0.0635       5.9558      76.0531       2.9688    2545.1560      14.4002      14.3711      15.4130      15.4973      21.0799      21.1511      69.4436      69.5842      64.8802      64.5275      47.4385      47.2789       0.0252       0.2901       0.2901       3.0425       0.2752    2554.1628      61.3789      74.0379     306.4375       0.0799    4746.9990    -999.2500    1185.0000       0.2933       0.2933
  330.4032       0.6462      96.0000      97.4223       0.0567       0.0567       7.5619     209.2817     214.2813     217.9954     210.5671     209.2817     378.0647     382.0143     374.1150     374.1150      77.7397      34.8229       0.0496       0.0496       8.7258      78.5719       3.0229    2568.1350      12.5976      12.6261      13.6881      13.8189      19.3284      19.4827      79.3803      79.2009      73.0562      72.3647      51.7373      51.3275       0.0252       0.2749       0.2749       3.0625       0.2723    2556.4744      69.4436      86.3767     314.0000       0.0763    4778.2485    -999.2500    1189.0000       0.2841       0.2841
  330.5556       0.6473      96.0000      97.4746       0.0640       0.0640      10.1108     214.6003     220.2682     221.2191     219.3173     214.6003     386.4963     392.5239     380.4687     380.4687      87.6216      34.8298       0.0554       0.0554      12.1938      77.7765       3.1865    2558.6252      11.1163      11.0921      12.1920      12.1898      17.9445      17.8762      89.9578      90.1541      82.0212      82.0359      55.7275      55.9405       0.0252       0.2708       0.2708       3.1291       0.2667    2544.3298      79.3803      90.4446     308.5000       0.0899    4659.8267    -999.2500    1182.0000       0.2791       0.2791
  330.7080       0.6483      96.0000      97.3177       0.0791       0.0791      10.8037     222.9946     228.7957     231.3148     226.2766     222.9946     409.5677     413.1087     406.0267     406.0267     103.1887      34.8366       0.0862       0.0862      10.3832     105.6989       3.1869    2507.8521       9.8755       9.4484      11.0660      10.5997      16.8301      16.2894     101.2611     105.8385      90.3672      94.3420      59.4174      61.3898       0.0251       0.2756       0.2756       3.1591       0.2840    2519.4358      89.9578      85.1720     312.3750       0.1101    4484.4136    -999.2500    1161.0000       0.2870       0.2870
  330.8604       0.6493      96.0000      97.5269       0.0863       0.0863      14.3448     232.8307     237.3051     235.1417     239.4684     232.8307     429.7892     439.6209     419.9575     419.9575     119.7988      34.8434       0.0935       0.0935      11.5003     126.7744       3.1182    2495.6987       7.9884       7.9219       9.1283       8.9524      14.9290      14.7098     125.1808     126.2323     109.5497     111.7013      66.9835      67.9817       0.0251       0.3146       0.3146       3.1743       0.2781    2507.6311     101.2611      98.2192     308.0625       0.1318    4294.9663    -999.2500    1210.0000       0.2973       0.2973
  331.0128       0.6503      96.0000      97.5269       0.0930       0.0930      12.6285     240.0716     237.8705     232.8026     242.9384     240.0716     436.7749     439.9683     433.5815     433.5815     138.1091      34.8503       0.0815       0.0815      17.1244     127.6070       3.2265    2515.5940       6.0000       6.3810       7.0075       7.4244      12.8311      13.2115     166.6671     156.7158     142.7039     134.6907      77.9355      75.6915       0.0251       0.3179       0.3179       3.1180       0.2789    2496.5020     125.1808     128.3584     311.6250       0.1467    4165.4238    -999.2500    1199.0000       0.3117       0.3117
  331.1652       0.6500      96.0000      97.2131       0.0907       0.0907      10.2215     240.9687     243.2934     244.2433     242.3435     240.9687     434.4880     436.2949     432.6811     432.6811     141.2416      34.8571       0.1077       0.1077       2.9054     160.6296       3.0012    2472.2781       4.2192       4.9429       5.0535       5.8776      10.9264      11.7051     237.0125     202.3112     197.8821     170.1381      91.5211      85.4331       0.0250       0.3195       0.3195       3.0679       0.2752    2500.3508     166.6671     170.5949     321.3125       0.1485    4149.9165    -999.2500    1194.0000       0.3131       0.3131
  331.3176       0.6497      96.0000      97.5269       0.0923       0.0923       5.8183     239.4949     242.2446     244.3076     240.1817     239.4949     424.0106     425.2969     422.7243     422.7243     143.4611      34.8640       0.0841       0.0841       8.4882     135.4882       2.9771    2511.2476       3.0458       3.9124       3.6623       4.6704       9.5456      10.5575     328.3224     255.5965     273.0525     214.1129     104.7607      94.7192       0.0250       0.3209       0.3209       3.0222       0.2636    2497.6829     237.0125     300.7298     305.1250       0.1455    4175.4541    -999.2500    1197.0000       0.3141       0.3141
  331.4700       0.6494      96.0000      97.3177       0.0771       0.0771       7.1723     232.6064     237.4722     237.7974     237.1469     232.6064     412.7227     411.9541     413.4912     413.4912     151.3730      34.8708       0.0852       0.0852       5.2134     134.9239       3.0780    2509.4773       2.5518       3.5055       2.9295       4.1708       8.8941      10.0602     391.8776     285.2652     341.3566     239.7599     112.4339      99.4017       0.0249       0.2991       0.2991       3.1170       0.2685    2522.7488     328.3224     398.3733     322.1875       0.1313    4299.1074    -999.2500    1211.0000       0.2963       0.2963
  331.6224       0.6490      96.0000      97.4223       0.0619       0.0619       8.0350     224.0519     231.2361     228.5760     233.8963     224.0519     394.5393     392.6791     396.3996     396.3996     167.9599      34.8776       0.0608       0.0608       9.5396     184.3654       3.3070    2549.7014       2.6527       3.7366       2.9461       4.4770       8.9772      10.4448     376.9766     267.6198     339.4272     223.3618     111.3939      95.7415       0.0249       0.2588       0.2588       3.1696       0.2653    2547.9089     391.8776     313.8230     307.9375       0.1125    4463.2520    -999.2500    1224.0000       0.2754       0.2754
  331.7748       0.6482      96.0000      97.5269       0.0337       0.0337      16.7711     215.0168     222.5914     223.7651     221.4176     215.0168     376.5713     372.8536     380.2889     380.2889     185.4216      34.8845       0.0336       0.0336      16.7434     185.2489       3.1259    2594.5232       3.6043       4.6560       4.1949       5.5724      10.1991      11.6143     277.4483     214.7761     238.3850     179.4544      98.0478      86.1009       0.0249       0.2389       0.2389       3.2484       0.2651    2594.4221     376.9766     204.5055     322.1875       0.0910    4650.8003    -999.2500    1205.0000       0.2567       0.2567
  331.9272       0.6473      96.0000      97.3177       0.0291       0.0291      14.7366     204.8603     209.3059     209.7250     208.8869     204.8603     362.1143     359.4419     364.7867     364.7867     194.4869      34.8913       0.0051       0.0051      23.5276     187.3098       3.3092    2641.5322       5.6930       6.2186       6.6458       7.2998      12.5104      13.3067     175.6532     160.8070     150.4714     136.9903      79.9333      75.1500       0.0248       0.2442       0.2442       3.3442       0.2697    2601.9526     277.4483     139.1040     314.4375       0.0645    4881.3760    -999.2500    1230.0000       0.2500       0.2500
  332.0796       0.6474      96.0000      97.5269       0.0339       0.0339      13.2508     200.3747     202.7239     199.1720     206.2758     200.3747     355.8554     349.3372     362.3737     362.3737     195.0108      34.8981       0.0469       0.0469       6.5429     211.5612       3.6188    2572.6213       8.3790       7.8457       9.5145       8.9861      15.2487      14.7740     119.3466     127.4579     105.1025     111.2826      65.5793      67.6864       0.0248       0.2407       0.2407       3.4500       0.2798    2594.1433     175.6532     107.8808     320.2500       0.0519    4990.6489    -999.2500    1219.0000       0.2435       0.2435
  332.2320       0.6474      96.0000      97.7360       0.0576       0.0576       3.2868     198.6766     202.2767     198.3478     206.2057     198.6766     356.1103     350.6732     361.5472     361.5472     180.0395      34.9050       0.0519       0.0519       4.7210     186.8206       3.4279    2564.2827      11.3917       9.4867      12.5495      10.6023      18.2356      16.3529      87.7833     105.4105      79.6846      94.3191      54.8377      61.1513       0.0248       0.2431       0.2431       3.4768       0.2837    2554.9419     119.3466      79.0625     332.3750       0.0470    5033.3042    -999.2500    1228.0000       0.2429       0.2429
  332.3844       0.6485      96.0000      97.7360       0.0672       0.0672       5.4456     199.7660     198.9460     198.5366     199.3553     199.7660     362.1909     358.4109     365.9710     365.9710     150.8576      34.9118       0.0705       0.0705       4.1924     142.5894       3.3839    2533.6479      12.9845      10.5889      14.0406      11.6286      19.5311      17.3354      77.0147      94.4389      71.2219      85.9952      51.2003      57.6853       0.0248       0.2621       0.2621       3.2393       0.2878    2539.1604      87.7833      73.2155     323.8125       0.0502    5005.8574    -999.2500    1220.0000       0.2490       0.2490
  332.5368       0.6496      96.0000      97.4223       0.0771       0.0771       5.5668     200.8874     204.2699     208.1031     200.4366     200.8874     363.7225     361.3233     366.1217     366.1217     128.1854      34.9187       0.0776       0.0776       7.7420     124.0153       2.9137    2521.9114      12.4212      10.8694      13.3205      11.8068      18.8591      17.2963      80.5073      92.0011      75.0721      84.6970      53.0247      57.8159       0.0247       0.2750       0.2750       3.1202       0.2846    2522.7031      77.0147      77.6078     336.5000       0.0534    4977.9141    -999.2500    1236.0000       0.2597       0.2597
  332.6892       0.6498      96.0000      97.1608       0.0700       0.0700      11.3775     200.7592     206.0388     207.4321     204.6454     200.7592     364.6102     362.2941     366.9263     366.9263     124.9317      34.9255       0.0806       0.0806       8.3709     118.8042       3.0662    2517.0894      10.6462      10.3329      11.2910      11.1480      16.8932      16.6851      93.9305      96.7784      88.5663      89.7019      59.1955      59.9337       0.0247       0.2726       0.2726       3.0595       0.2864    2534.5669      80.5073      85.8333     331.9375       0.0530    4981.0918    -999.2500    1225.0000       0.2672       0.2672
  332.8416       0.6500      96.0000      97.3177       0.0733       0.0733      12.3648     200.1184     201.3994     198.6591     204.1396     200.1184     362.9109     360.4763     365.3455     365.3455     129.8570      34.9323       0.0489       0.0489      21.4754     131.9755       3.1879    2569.3335       9.0890       9.9375       9.8444      10.6674      15.3516      16.2111     110.0231     100.6288     101.5808      93.7434      65.1399      61.6862       0.0247       0.2578       0.2578       3.1439       0.2857    2529.1299      93.9305     106.3494     334.0625       0.0512    4997.0410    -999.2500    1219.0000       0.2621       0.2621
  332.9940       0.6495      96.0000      97.6315       0.0776       0.0776      11.7634     199.7980     197.2232     195.5069     198.9394     199.7980     361.1327     361.0547     361.2107     361.2107     120.0267      34.9392       0.0884       0.0884       9.3339     138.1366       3.1782    2504.1624       8.1212       9.3914       8.8675      10.1613      14.3658      15.6619     123.1339     106.4801     112.7710      98.4126      69.6096      63.8490       0.0246       0.2454       0.2454       3.1695       0.2796    2521.9153     110.0231     113.8562     334.5000       0.0503    5005.0547    -999.2500    1179.0000       0.2609       0.2609
  333.1464       0.6490      96.0000      97.7883       0.0898       0.0898      12.8778     201.4641     200.2242     198.6703     201.7781     201.4641     365.2502     365.9329     364.5675     364.5675     121.1677      34.9460       0.0899       0.0899      12.1498      89.5851       3.1396    2501.7039       7.8301       9.3080       8.5250      10.0896      14.0065      15.5832     127.7130     107.4342     117.3026      99.1123      71.3957      64.1715       0.0246       0.2611       0.2611       3.1901       0.2802    2501.8184     123.1339     106.3446     331.9375       0.0550    4963.6641    -999.2500    1189.0000       0.2681       0.2681
  333.2988       0.6485      96.0000      97.3177       0.0907       0.0907      13.0644     203.6107     209.0406     208.1837     209.8975     203.6107     376.7635     379.2492     374.2777     374.2777     117.5069      34.9528       0.0941       0.0941      13.2729     135.3986       3.2284    2494.7957       8.4321       9.9371       9.0667      10.6835      14.4767      16.1784     118.5945     100.6331     110.2942      93.6025      69.0765      61.8107       0.0246       0.2834       0.2834       3.1729       0.2898    2500.4084     127.7130      92.8462     350.9375       0.0610    4911.3330    -999.2500    1202.0000       0.2817       0.2817
  333.4512       0.6480      96.0000      97.4746       0.0942       0.0942      11.3167     206.5904     212.7765     212.7064     212.8465     206.5904     383.4072     387.6985     379.1160     379.1160     143.9250      34.9597       0.0894       0.0894      13.1641     126.5673       3.1375    2502.5635       9.9733      11.7221      10.6361      12.4773      16.0515      17.8861     100.2677      85.3089      94.0199      80.1458      62.2993      55.9092       0.0245       0.3057       0.3057       3.2498       0.2888    2494.5730     118.5945      80.4569     335.6875       0.0692    4840.4966    -999.2500    1223.0000       0.2946       0.2946
  333.6036       0.6478      96.0000      97.7361       0.0968       0.0968       4.9435     210.6594     215.3443     214.7227     215.9660     210.6594     389.7254     392.7501     386.7008     386.7008     185.0463      34.9665       0.1024       0.1024       3.5541     168.5675       3.3792    2481.0938      13.2419      14.2622      14.1116      15.1105      19.5067      20.5250      75.5181      70.1152      70.8637      66.1792      51.2645      48.7210       0.0245       0.3078       0.3078       3.2501       0.2890    2490.3430     100.2677      74.5475     352.6250       0.0799    4746.9990    -999.2500    1251.0000       0.3047       0.3047
  333.7560       0.6476      96.0000      97.5269       0.0941       0.0941       2.1484     214.5682     218.5057     216.3645     220.6470     214.5682     396.9849     396.6592     397.3106     397.3106     240.0456      34.9734       0.0956       0.0956       2.8123     262.4834       3.2431    2492.2898      17.1887      17.3222      18.1796      18.2961      23.4981      23.6901      58.1776      57.7293      55.0068      54.6564      42.5567      42.2117       0.0245       0.3149       0.3149       3.3275       0.2941    2494.7227      75.5181      63.8012     341.6875       0.0898    4660.5225    -999.2500    1276.0000       0.3165       0.3165
  333.9084       0.6479      96.0000      97.5269       0.0874       0.0874       2.4177     219.9188     221.6509     216.7318     226.5700     219.9188     411.6042     414.1267     409.0818     409.0818     234.0623      34.9802       0.0822       0.0822       3.1204     292.8069       3.3726    2514.3789      21.1016      20.4674      22.0704      21.4544      27.3129      26.7741      47.3897      48.8582      45.3095      46.6104      36.6128      37.3495       0.0244       0.3278       0.3278       3.3168       0.2968    2505.7222      58.1776      52.3493     357.9375       0.1029    4547.1328    -999.2500    1245.0000       0.3275       0.3275
  334.0608       0.6483      96.0000      97.3177       0.0810       0.0810       5.2047     224.4684     228.6621     226.7559     230.5683     224.4684     423.9604     426.1542     421.7668     421.7668     191.8105      34.9870       0.0814       0.0814       6.0628     153.0935       3.3343    2515.6851      24.7987      23.8338      25.7072      24.8231      30.9094      30.0639      40.3247      41.9573      38.8996      40.2851      32.3526      33.2625       0.0244       0.3328       0.3328       3.3494       0.3024    2516.3076      47.3897      45.1709     351.4375       0.1134    4454.9697    -999.2500    1220.0000       0.3286       0.3286
  334.2132       0.6488      96.0000      97.3177       0.0788       0.0788       7.4310     227.7364     231.0013     230.1305     231.8722     227.7364     428.3150     430.6356     425.9945     425.9945     130.5001      34.9939       0.0785       0.0785       8.6993     132.0072       3.3153    2520.4885      27.7605      26.5230      28.5875      27.4669      33.7898      32.6668      36.0224      37.7031      34.9804      36.4075      29.5947      30.6122       0.0244       0.3370       0.3370       3.3535       0.2999    2520.0315      40.3247      39.5284     356.7500       0.1208    4391.0410    -999.2500    1219.0000       0.3330       0.3330
  334.3656       0.6493      96.0000      97.4746       0.0719       0.0719       8.0516     228.1529     230.1382     231.6818     228.5946     228.1529     426.5790     429.1667     423.9912     423.9912     112.0418      35.0007       0.0759       0.0759       8.9926     108.8599       3.3845    2524.7534      30.1954      28.4240      30.9577      29.2901      36.1848      34.4896      33.1176      35.1816      32.3021      34.1413      27.6359      28.9942       0.0243       0.3388       0.3388       3.3241       0.2962    2531.3794      36.0224      35.4246     361.2500       0.1217    4383.0249    -999.2500    1215.0000       0.3318       0.3318
  334.5180       0.6504      96.0000      97.4746       0.0652       0.0652       5.1058     223.6674     226.4284     228.0760     224.7807     223.6674     416.2885     419.1765     413.4005     413.4005     107.6277      35.0075       0.0600       0.0600       8.4179      95.2425       3.2426    2550.9221      31.8692      29.3025      32.5650      30.0612      37.8823      35.2848      31.3783      34.1267      30.7078      33.2655      26.3976      28.3408       0.0243       0.3447       0.3447       3.4150       0.2931    2542.4219      33.1176      30.9856     351.9375       0.1116    4470.9238    -999.2500    1233.0000       0.3304       0.3304
  334.6704       0.6514      96.0000      97.6315       0.0592       0.0592       1.1552     220.2712     221.4845     223.2914     219.6776     220.2712     403.5620     401.0676     406.0564     406.0564     113.2579      35.0144       0.0563       0.0563       1.9918     118.5253       3.6341    2557.0444      31.0212      29.0564      31.6299      29.6779      36.9090      34.9941      32.2360      34.4158      31.6156      33.6951      27.0937      28.5763       0.0243       0.3151       0.3151       3.4826       0.2915    2552.3284      31.3783      33.7926     362.0000       0.1037    4539.8574    -999.2500    1209.0000       0.3139       0.3139
  334.8228       0.6514      96.0000      97.7883       0.0492       0.0492       5.4493     216.7469     220.1737     218.3368     222.0106     216.7469     394.5509     394.0063     395.0955     395.0955     117.5675      35.0212       0.0547       0.0547       3.1198     125.7663       3.5880    2559.8201      27.9425      28.0402      28.4561      28.7019      33.6681      33.9878      35.7878      35.6631      35.1419      34.8409      29.7017      29.4223       0.0242       0.2872       0.2872       3.5968       0.2847    2568.8796      32.2360      42.1580     351.4375       0.0952    4613.6763    -999.2500    1194.0000       0.2964       0.2964
  334.9752       0.6514      96.0000      97.4223       0.0461       0.0461       8.2384     218.1566     221.5534     218.7622     224.3445     218.1566     395.7806     393.6353     397.9260     397.9260     115.3510      35.0280       0.0364       0.0364      10.2181     106.0575       3.5772    2589.9207      25.1409      27.4099      25.6079      27.8902      31.0244      33.1980      39.7757      36.4832      39.0505      35.8549      32.2327      30.1223       0.0242       0.2561       0.2561       3.4981       0.2851    2573.9685      35.7878      43.9218     363.9375       0.0986    4583.8623    -999.2500    1229.0000       0.2858       0.2858
  335.1276       0.6515      96.0000      97.4746       0.0527       0.0527      11.3808     221.2965     220.0793     215.8180     224.3405     221.2965     406.5845     407.3398     405.8291     405.8291     118.8774      35.0349       0.0453       0.0453      14.4655     112.1704       3.3494    2575.3088      25.6958      26.8544      26.2517      27.3469      31.1909      32.7552      38.9169      37.2378      38.0928      36.5672      32.0606      30.5295       0.0242       0.2792       0.2792       3.4307       0.2884    2563.0962      39.7757      40.5990     355.9375       0.1061    4518.8242    -999.2500    1207.0000       0.2900       0.2900
  335.2800       0.6516      96.0000      97.5269       0.0673       0.0673       6.6652     221.0722     224.2730     227.3248     221.2213     221.0722     407.7584     405.1740     410.3429     410.3429     137.8469      35.0417       0.0783       0.0783       3.7327     136.3453       3.3649    2520.8552      27.3307      26.8894      28.0018      27.4189      32.8284      32.3873      36.5888      37.1894      35.7120      36.4713      30.4614      30.8763       0.0241       0.3312       0.3312       3.3198       0.2955    2538.8767      38.9169      36.7009     363.0000       0.1056    4523.4087    -999.2500    1195.0000       0.3051       0.3051
  335.4324       0.6520      96.0000      97.3177       0.0740       0.0740       2.8592     220.0470     223.4966     224.0676     222.9256     220.0470     396.6183     394.7195     398.5171     398.5171     153.9913      35.0486       0.0769       0.0769       2.6716     165.0798       3.2289    2523.0859      27.7861      26.9449      28.4987      27.4009      33.0582      32.1258      35.9892      37.1127      35.0894      36.4952      30.2497      31.1276       0.0241       0.3423       0.3423       3.3309       0.2807    2527.9663      36.5888      37.0648     368.0625       0.1032    4544.4849    -999.2500    1221.0000       0.3180       0.3180
  335.5848       0.6524      96.0000      97.9452       0.0687       0.0687       3.7972     216.5226     218.0047     219.3642     216.6452     216.5226     390.9155     392.2146     389.6164     389.6164     160.6776      35.0554       0.0653       0.0653       4.2045     160.7773       3.3941    2542.2556      25.3107      26.8284      25.9971      27.4806      30.2071      31.9004      39.5090      37.2740      38.4658      36.3893      33.1048      31.3475       0.0241       0.3003       0.3003       3.3138       0.2766    2536.6973      35.9892      38.6860     359.0000       0.0947    4618.4551    -999.2500    1227.0000       0.3115       0.3115
  335.7372       0.6536      96.0000      97.7360       0.0677       0.0677       4.3944     214.4721     215.5685     217.0294     214.1076     214.4721     387.2694     391.2481     383.2906     383.2906     150.1918      35.0622       0.0624       0.0624       5.2835     156.9407       3.3313    2547.0518      24.3016      26.8235      24.9590      27.5258      28.7284      31.7267      41.1496      37.2807      40.0656      36.3295      34.8088      31.5192       0.0240       0.2984       0.2984       3.3668       0.2721    2538.3408      39.5090      38.1847     365.4375       0.0896    4662.6113    -999.2500    1236.0000       0.3031       0.3031
  335.8896       0.6548      96.0000      97.5269       0.0676       0.0676       9.5898     214.4400     215.3667     217.3757     213.3578     214.4400     387.4572     391.5351     383.3794     383.3794     140.9300      35.0691       0.0719       0.0719       8.1818     133.6225       3.3934    2531.3284      26.9920      27.5228      27.8819      28.2975      31.0765      32.0618      37.0480      36.3335      35.8655      35.3388      32.1786      31.1897       0.0240       0.3060       0.3060       3.3858       0.2723    2538.4343      41.1496      35.0717     351.4375       0.0895    4663.3076    -999.2500    1274.0000       0.2997       0.2997
  336.0420       0.6552      96.0000      97.1608       0.0699       0.0699      10.4593     214.2158     215.1248     216.6455     213.6041     214.2158     386.4875     390.5777     382.3974     382.3974     130.9860      35.0759       0.0706       0.0706      10.7547     133.4565       3.4493    2533.5273      29.5782      28.1158      30.6420      29.1183      33.5498      32.4511      33.8087      35.5671      32.6350      34.3426      29.8065      30.8156       0.0240       0.3045       0.3045       3.4112       0.2713    2534.6802      37.0480      32.0268     361.2500       0.0890    4668.1904    -999.2500    1201.0000       0.2978       0.2978
  336.1944       0.6556      96.0000      97.7360       0.0721       0.0721      13.6445     213.6711     214.7126     216.0764     213.3489     213.6711     385.9160     390.9901     380.8420     380.8420     126.8708      35.0827       0.0652       0.0652      15.9637     126.5720       3.4014    2542.4246      30.2964      28.8153      31.5053      29.8145      34.0542      32.8344      33.0072      34.7038      31.7407      33.5408      29.3649      30.4559       0.0239       0.3064       0.3064       3.3658       0.2703    2531.0037      33.8087      33.6695     351.4375       0.0876    4680.0898    -999.2500    1193.0000       0.3084       0.3084
  336.3468       0.6556      96.0000      97.6315       0.0794       0.0794      12.6848     213.0303     214.3193     216.0863     212.5522     213.0303     385.4619     390.8810     380.0429     380.0429     125.1015      35.0896       0.0810       0.0810      12.7228     122.0769       3.2464    2516.3857      29.3035      29.3151      30.5241      30.4316      33.5126      33.5152      34.1256      34.1122      32.7610      32.8606      29.8396      29.8372       0.0239       0.2966       0.2966       3.2902       0.2709    2518.9216      33.0072      33.6531     353.8125       0.0860    4694.1675    -999.2500    1206.0000       0.3062       0.3062
  336.4992       0.6556      96.0000      97.4746       0.0879       0.0879      11.5164     213.1264     214.6200     217.1242     212.1158     213.1264     384.4037     390.5134     378.2940     378.2940     121.6800      35.0964       0.0918       0.0918       9.2140     127.4555       3.2274    2498.5466      28.2404      29.8678      29.4348      31.0999      32.5381      34.1934      35.4103      33.4809      33.9734      32.1545      30.7332      29.2454       0.0239       0.3032       0.3032       3.2389       0.2675    2504.9287      34.1256      32.2198     352.8125       0.0862    4692.0503    -999.2500    1197.0000       0.3131       0.3131
  336.6516       0.6557      96.0000      97.6315       0.0884       0.0884       8.0232     213.5109     215.8433     218.7254     212.9613     213.5109     384.3981     391.2268     377.5694     377.5694     129.3127      35.1033       0.0958       0.0958       4.8348     116.9252       3.2459    2491.9626      28.4591      30.8055      29.4831      32.0527      32.7887      35.1499      35.1382      32.4617      33.9177      31.1987      30.4983      28.4496       0.0238       0.3218       0.3218       3.2713       0.2649    2504.1941      35.4103      30.5303     353.8750       0.0872    4683.6016    -999.2500    1197.0000       0.3084       0.3084
  336.8040       0.6558      96.0000      97.6315       0.0728       0.0728       9.0354     212.1973     215.4117     217.5252     213.2982     212.1973     380.1176     382.7536     377.4817     377.4817     134.8552      35.1101       0.0795       0.0795       6.3403     144.1750       3.3494    2518.7522      30.7636      32.7012      31.6279      33.8039      34.9832      37.1062      32.5060      30.5799      31.6176      29.5823      28.5852      26.9497       0.0238       0.3064       0.3064       3.3553       0.2690    2529.9319      35.1382      29.4667     357.5000       0.0839    4712.5957    -999.2500    1219.0000       0.3051       0.3051
  336.9564       0.6559      96.0000      97.5269       0.0641       0.0641       6.8418     215.3051     218.8768     223.0461     214.7074     215.3051     384.4141     390.0843     378.7437     378.7437     141.2514      35.1169       0.0424       0.0424      13.1752     144.8141       3.4839    2580.0898      35.1276      35.2662      35.9529      36.2707      39.3893      39.7934      28.4676      28.3557      27.8142      27.5705      25.3876      25.1298       0.0238       0.2839       0.2839       3.4639       0.2613    2544.1660      32.5060      33.0550     351.4375       0.0917    4644.5718    -999.2500    1226.0000       0.2930       0.2930
  337.1088       0.6560      96.0000      97.7883       0.0584       0.0584       7.5338     218.5411     223.8807     227.5764     220.1850     218.5411     389.1413     394.7590     383.5235     383.5235     136.2540      35.1238       0.0677       0.0677       4.3184     135.4961       3.5750    2538.3691      40.5426      37.4207      41.2596      38.2883      45.4833      42.1763      24.6654      26.7232      24.2368      26.1176      21.9861      23.7100       0.0237       0.2890       0.2890       3.4343       0.2596    2553.6743      28.4676      31.0565     361.2500       0.0996    4575.7983    -999.2500    1226.0000       0.2956       0.2956
  337.2612       0.6559      96.0000      97.6315       0.0691       0.0691       2.6553     224.1480     227.9917     227.3829     228.6005     224.1480     414.8022     416.2758     413.3287     413.3287     127.0050      35.1306       0.0652       0.0652       4.3032     129.1828       3.2529    2542.5020      43.5250      39.8377      44.1249      40.4808      48.7172      44.7328      22.9753      25.1018      22.6630      24.7031      20.5266      22.3550       0.0237       0.3020       0.3020       3.3760       0.2917    2536.0430      24.6654      25.7475     353.1250       0.1127    4461.3379    -999.2500    1210.0000       0.3010       0.3010
  337.4136       0.6558      96.0000      97.5269       0.0714       0.0714       3.6109     234.0802     239.6259     242.6485     236.6032     234.0802     434.6852     437.6129     431.7575     431.7575     115.0288      35.1374       0.0729       0.0729       2.9326     115.2038       3.3139    2529.7361      42.2699      41.1517      42.5974      41.7654      48.0101      46.3537      23.6575      24.3003      23.4756      23.9433      20.8289      21.5733       0.0237       0.3268       0.3268       3.2726       0.2919    2532.2219      22.9753      24.8864     362.6875       0.1344    4272.0391    -999.2500    1196.0000       0.3170       0.3170
  337.5660       0.6569      96.0000      97.7883       0.0745       0.0745       6.1793     237.0599     242.1705     243.7137     240.6274     237.0599     440.0780     440.6405     439.5155     439.5155     117.2891      35.1443       0.0757       0.0757       5.3654      99.5675       3.2590    2525.1370      41.5163      41.4261      41.8239      41.8862      47.4171      47.2919      24.0869      24.1394      23.9098      23.8742      21.0895      21.1453       0.0236       0.3386       0.3386       3.3453       0.2949    2527.0098      23.6575      22.5504     354.5625       0.1406    4218.3428    -999.2500    1204.0000       0.3300       0.3300
  337.7184       0.6579      96.0000      97.5269       0.0762       0.0762       5.3981     240.2959     237.4776     234.7097     240.2454     240.2959     443.8183     442.9419     444.6947     444.6947     128.3098      35.1511       0.0802       0.0802       3.1236     137.1650       3.4672    2517.6570      41.3377      41.4204      41.5250      41.7125      47.2392      47.5936      24.1910      24.1427      24.0819      23.9736      21.1689      21.0112       0.0236       0.3532       0.3532       3.3091       0.2938    2524.2173      24.0869      22.8977     358.9375       0.1471    4161.5361    -999.2500    1230.0000       0.3397       0.3397
  337.8708       0.6580      96.0000      97.5269       0.0724       0.0724       6.0064     238.8221     241.8531     242.7440     240.9622     238.8221     442.0919     439.7823     444.4014     444.4014     139.0659      35.1580       0.0742       0.0742       6.1497     149.3979       3.2134    2527.6089      41.0637      41.1837      41.4640      41.4904      46.8599      47.1686      24.3524      24.2814      24.1173      24.1020      21.3402      21.2005       0.0236       0.3210       0.3210       3.3776       0.2970    2530.6191      24.1910      24.9803     354.3750       0.1442    4187.2178    -999.2500    1240.0000       0.3323       0.3323
  338.0232       0.6581      96.0000      97.4223       0.0734       0.0734       3.2592     233.7598     240.4318     238.9099     241.9537     233.7598     426.8814     429.1623     424.6006     424.6006     133.9040      35.1648       0.0636       0.0636       7.4688     131.8357       3.4617    2545.0166      40.6372      40.7167      41.2094      41.0707      46.4390      46.4445      24.6080      24.5599      24.2663      24.3483      21.5336      21.5311       0.0235       0.3083       0.3083       3.3289       0.2825    2528.9597      24.3524      25.5491     354.8750       0.1338    4277.8950    -999.2500    1229.0000       0.3240       0.3240
  338.1756       0.6583      96.0000      97.7883       0.0724       0.0724       3.5020     230.8122     236.1388     231.8539     240.4238     230.8122     421.9338     425.1068     418.7610     418.7610     130.9640      35.1716       0.0788       0.0788       1.8710     118.6025       3.3193    2519.9468      40.3653      39.8504      41.1103      40.4359      46.2764      45.7012      24.7738      25.0939      24.3248      24.7305      21.6093      21.8812       0.0235       0.3325       0.3325       3.3732       0.2818    2530.5608      24.6080      26.3049     361.0000       0.1275    4332.5264    -999.2500    1249.0000       0.3295       0.3295
  338.3280       0.6585      96.0000      97.7361       0.0686       0.0686       5.5987     225.4937     231.2848     230.3798     232.1898     225.4937     412.5258     414.6049     410.4467     410.4467     133.0509      35.1785       0.0742       0.0742       1.6836     140.5779       3.3358    2527.5618      40.1948      38.9769      41.2138      39.7605      46.1393      44.8975      24.8789      25.6562      24.2637      25.1506      21.6735      22.2730       0.0235       0.3536       0.3536       3.3655       0.2838    2536.8010      24.7738      25.2821     349.3125       0.1158    4434.7144    -999.2500    1289.0000       0.3353       0.3353
  338.4804       0.6589      96.0000      97.7360       0.0623       0.0623       6.0674     221.9693     226.4619     226.6720     226.2518     221.9693     399.5273     395.0753     403.9793     403.9793     136.0231      35.1853       0.0544       0.0544      11.2525     138.0964       3.4332    2560.2419      37.9903      38.1231      39.1544      39.0917      44.0430      44.0604      26.3225      26.2308      25.5399      25.5809      22.7051      22.6961       0.0234       0.3349       0.3349       3.3494       0.2838    2547.2522      24.8789      26.6212     351.4375       0.1077    4505.1270    -999.2500    1258.0000       0.3368       0.3368
  338.6328       0.6594      96.0000      97.4223       0.0582       0.0582      10.4911     220.4955     224.7675     224.8256     224.7094     220.4955     394.8820     394.4514     395.3126     395.3126     137.2001      35.1921       0.0557       0.0557      10.2006     127.6763       3.2681    2558.0662      34.8027      37.2440      35.9483      38.3838      40.6251      43.2373      28.7334      26.8500      27.8177      26.0526      24.6153      23.1282       0.0234       0.3195       0.3195       3.3584       0.2742    2553.9724      26.3225      28.8639     341.6875       0.1042    4535.2397    -999.2500    1280.0000       0.3274       0.3274
  338.7852       0.6599      96.0000      97.6315       0.0658       0.0658       9.1362     218.8295     219.7037     214.7161     224.6914     218.8295     392.4172     393.9778     390.8565     390.8565     136.3360      35.1990       0.0644       0.0644      11.5732     144.1091       3.3702    2543.7610      35.3343      36.5551      36.4559      37.7808      40.9807      42.4530      28.3012      27.3559      27.4304      26.4684      24.4017      23.5555       0.0234       0.3279       0.3279       3.3604       0.2717    2541.4446      28.7334      26.3284     348.3125       0.1003    4569.7686    -999.2500    1252.0000       0.3245       0.3245
  338.9376       0.6604      96.0000      97.6315       0.0662       0.0662      10.6179     217.1634     222.0918     218.9999     225.1836     217.1634     391.6179     392.9111     390.3246     390.3246     131.3140      35.2058       0.0755       0.0755       8.1365     135.5040       3.4496    2525.3818      37.2590      36.0170      38.4079      37.4089      43.1783      41.9451      26.8392      27.7647      26.0363      26.7316      23.1598      23.8407       0.0233       0.3305       0.3305       3.3929       0.2758    2540.7358      28.3012      24.5324     341.0625       0.0962    4604.8271    -999.2500    1236.0000       0.3216       0.3216
  339.0900       0.6610      96.0000      97.4746       0.0562       0.0562      11.4206     215.9780     220.2921     218.1880     222.3961     215.9780     390.5707     391.8825     389.2589     389.2589     127.2590      35.2127       0.0600       0.0600       9.8599     114.3290       3.3589    2550.9570      37.0048      35.4844      38.0602      36.9506      42.8745      41.3435      27.0236      28.1814      26.2742      27.0632      23.3239      24.1876       0.0233       0.3209       0.3209       3.4090       0.2776    2557.2908      26.8392      27.4034     341.6875       0.0933    4630.1025    -999.2500    1220.0000       0.3106       0.3106
  339.2424       0.6615      96.0000      97.4746       0.0499       0.0499       7.4449     215.4012     215.4284     216.3676     214.4893     215.4012     378.6186     378.5196     378.7176     378.7176     119.9237      35.2195       0.0329       0.0329      13.1144     129.6682       3.4212    2595.7603      35.0727      35.1722      35.9556      36.2667      40.7118      40.7199      28.5122      28.4316      27.8121      27.5735      24.5629      24.5580       0.0233       0.2839       0.2839       3.3153       0.2609    2567.7292      27.0236      30.3235     345.8750       0.0919    4642.4990    -999.2500    1230.0000       0.2976       0.2976
  339.3948       0.6616      96.0000      97.7360       0.0496       0.0496       7.3318     214.1197     216.5087     216.9643     216.0530     214.1197     379.7110     380.1762     379.2458     379.2458     124.9136      35.2263       0.0530       0.0530       3.4241     113.4983       3.1655    2562.4849      33.6190      34.7060      34.3553      35.5769      39.2160      40.3313      29.7451      28.8135      29.1076      28.1082      25.4998      24.7946       0.0232       0.2655       0.2655       3.2820       0.2660    2568.1443      28.5122      32.3744     340.3750       0.0887    4670.2856    -999.2500    1199.0000       0.2844       0.2844
  339.5472       0.6616      96.0000      97.6315       0.0593       0.0593       4.6004     214.5362     214.9964     216.4772     213.5155     214.5362     380.2588     380.3350     380.1826     380.1826     127.6262      35.2332       0.0625       0.0625       4.0075     129.2988       3.2608    2546.8481      33.9677      34.6768      34.5643      35.4409      39.4573      40.3003      29.4398      28.8377      28.9316      28.2160      25.3439      24.8137       0.0232       0.2950       0.2950       3.3002       0.2664    2552.1858      29.7451      28.9691     343.8750       0.0898    4661.2188    -999.2500    1210.0000       0.2891       0.2891
  339.6996       0.6621      96.0000      97.7360       0.0581       0.0581       9.5238     215.5935     215.4807     216.9589     214.0024     215.5935     386.1183     391.2156     381.0211     381.0211     141.6054      35.2400       0.0594       0.0594      11.1458     139.9497       3.4818    2551.9829      34.6988      34.6928      35.2915      35.1733      40.2976      40.4531      28.8195      28.8244      28.3354      28.4307      24.8154      24.7200       0.0232       0.3120       0.3120       3.3656       0.2645    2554.1401      29.4398      26.7294     333.6250       0.0924    4638.3594    -999.2500    1184.0000       0.2933       0.2933
  339.8520       0.6626      96.0000      97.5269       0.0653       0.0653       7.5188     214.3760     214.7812     216.5187     213.0437     214.3760     378.3692     378.2873     378.4511     378.4511     143.3648      35.2468       0.0528       0.0528      11.9191     155.4357       3.3640    2562.8308      35.6721      34.7132      36.0361      35.2009      41.1155      40.4480      28.0331      28.8075      27.7500      28.4084      24.3217      24.7231       0.0231       0.2894       0.2894       3.3835       0.2638    2542.1826      28.8195      27.9184     341.6875       0.0894    4664.7017    -999.2500    1188.0000       0.2927       0.2927
  340.0044       0.6625      96.0000      97.7883       0.0708       0.0708       3.5113     214.3119     214.8752     216.0967     213.6536     214.3119     378.8038     380.4881     377.1196     377.1196     137.9979      35.2537       0.0836       0.0836      -0.1146     134.5771       3.3209    2512.1262      35.8289      34.5299      36.1535      34.9269      40.9611      40.0046      27.9104      28.9604      27.6599      28.6312      24.4134      24.9971       0.0231       0.2836       0.2836       3.2963       0.2615    2533.2615      28.0331      27.6255     331.9375       0.0892    4666.0967    -999.2500    1208.0000       0.2879       0.2879
  340.1568       0.6624      96.0000      97.7883       0.0708       0.0708       3.6143     213.6391     214.3230     214.6617     213.9842     213.6391     376.2377     376.1010     376.3744     376.3744     126.6080      35.2605       0.0734       0.0734       2.5322     123.9809       3.2120    2528.9521      34.7700      33.7631      35.1673      34.0844      39.7380      38.8821      28.7604      29.6181      28.4355      29.3389      25.1648      25.7188       0.0231       0.2885       0.2885       3.3011       0.2623    2533.1436      27.9104      29.2341     334.5000       0.0875    4680.7920    -999.2500    1217.0000       0.2864       0.2864
  340.3092       0.6604      96.0000      97.7360       0.0632       0.0632       8.3056     212.2934     213.1464     212.7232     213.5696     212.2934     374.7732     373.7101     375.8362     375.8362     117.8578      35.2673       0.0539       0.0539      10.5336     122.0708       3.3720    2561.0359      32.6080      32.4426      33.1444      32.8352      37.5009      37.4242      30.6674      30.8236      30.1710      30.4551      26.6660      26.7207       0.0230       0.2839       0.2839       3.3560       0.2657    2545.7827      28.7604      31.5073     332.4375       0.0841    4710.4619    -999.2500    1229.0000       0.2839       0.2839
  340.4616       0.6584      96.0000      98.4680       0.0660       0.0660       9.9293     211.8449     213.3079     213.1022     213.5134     211.8449     374.8067     373.5678     376.0456     376.0456     115.8391      35.2742       0.0615       0.0615      12.0001     108.3268       3.4954    2548.4939      30.6806      31.0380      31.3883      31.5940      35.5673      35.9352      32.5938      32.2186      31.8590      31.6516      28.1157      27.8279       0.0230       0.2704       0.2704       3.4051       0.2675    2541.1704      30.6674      32.8150     330.7500       0.0830    4720.4355    -999.2500    1232.0000       0.2786       0.2786
  340.6140       0.6603      96.0000      98.7817       0.0722       0.0722      15.7186     212.7099     214.4999     216.4567     212.5430     212.7099     377.1334     377.3403     376.9266     376.9266     113.5756      35.2810       0.0771       0.0771      12.0515     117.9247       3.3467    2522.8000      28.9337      29.7356      29.7683      30.4832      33.7449      34.6746      34.5618      33.6298      33.5928      32.8049      29.6341      28.8396       0.0230       0.2735       0.2735       3.5618       0.2664    2530.8206      32.5938      32.5947     337.1875       0.0852    4701.2383    -999.2500    1226.0000       0.2754       0.2754
  340.7664       0.6621      96.0000      98.8862       0.0697       0.0697      20.2591     214.4080     215.5058     218.2838     212.7278     214.4080     386.2120     392.2311     380.1929     380.1929     120.5294      35.2879       0.0770       0.0770      22.1678     114.4753       3.8552    2522.9546      26.8303      28.7705      27.6820      29.6602      31.5919      33.7441      37.2713      34.7579      36.1246      33.7153      31.6537      29.6348       0.0229       0.2889       0.2889       3.6433       0.2668    2535.0623      34.5618      32.4608     329.2500       0.0894    4664.0049    -999.2500    1209.0000       0.2777       0.2777
  340.9188       0.6642      96.0000      99.0953       0.0657       0.0657      19.2210     216.4265     219.7289     227.1835     212.2743     216.4265     387.8025     392.5864     383.0185     383.0185     122.7466      35.2947       0.0512       0.0512      29.2787     129.1880       3.7590    2565.5156      26.2009      28.2498      26.9932      29.1850      30.6568      33.1946      38.1667      35.3985      37.0464      34.2642      32.6192      30.1254       0.0229       0.2894       0.2894       3.6188       0.2655    2541.5996      37.2713      33.0861     334.4375       0.0944    4620.5063    -999.2500    1204.0000       0.2834       0.2834
  341.0712       0.6663      96.0000      96.5332       0.0524       0.0524      13.2837     215.2090     215.6916     219.4697     211.9135     215.2090     387.4051     392.7209     382.0893     382.0893     121.5541      35.3015       0.0679       0.0679       5.2380     126.7618       3.2448    2537.9675      29.0472      27.7735      30.0084      28.7073      34.3485      32.7986      34.4267      36.0056      33.3240      34.8343      29.1133      30.4891       0.0229       0.2987       0.2987       3.4359       0.2677    2563.4617      38.1667      32.9916     330.8750       0.0914    4646.6460    -999.2500    1224.0000       0.2932       0.2932
  341.2236       0.6670      96.0000      96.3763       0.0437       0.0437       5.5405     213.1585     214.6132     218.4743     210.7522     213.1585     383.6467     387.6323     379.6612     379.6612     112.8572      35.3084       0.0367       0.0367       7.7134     110.8980       3.3261    2589.3735      31.7590      27.0183      32.7847      27.8987      37.4139      32.2631      31.4871      37.0120      30.5020      35.8440      26.7280      30.9952       0.0228       0.3144       0.3144       3.2775       0.2698    2577.8499      34.4267      34.8083     331.0000       0.0863    4691.3452    -999.2500    1236.0000       0.2902       0.2902
  341.3760       0.6678      96.0000      96.5332       0.0246       0.0246      11.4127     207.2312     207.9020     213.6767     202.1274     207.2312     370.6085     368.9019     372.3151     372.3151     103.2727      35.3152       0.0205       0.0205      12.3419     103.0973       3.2403    2616.1809      28.6196      25.6045      29.5616      26.4520      34.4961      31.0982      34.9411      39.0556      33.8277      37.8043      28.9888      32.1562       0.0228       0.2772       0.2772       3.2949       0.2756    2609.3342      31.4871      39.6862     336.5000       0.0709    4825.5288    -999.2500    1240.0000       0.2743       0.2743
  341.5284       0.6681      96.0000      96.3763       0.0198       0.0198       6.9960     203.0981     203.3261     208.8663     197.7860     203.0981     361.3637     359.8294     362.8981     362.8981     100.6580      35.3220       0.0229       0.0229       5.6935      95.0733       3.2807    2612.2251      23.0394      23.6304      23.8405      24.4266      29.0324      29.3537      43.4039      42.3183      41.9454      40.9389      34.4443      34.0673       0.0228       0.2458       0.2458       3.2581       0.2720    2617.3652      34.9411      43.7933     324.6875       0.0596    4923.7295    -999.2500    1244.0000       0.2558       0.2558
  341.6808       0.6685      96.0000      96.3763       0.0124       0.0124      10.2935     202.8418     203.3231     209.1643     197.4820     202.8418     360.9157     359.6082     362.2233     362.2233      94.7031      35.3289       0.0124       0.0124       9.7480     103.0537       3.2445    2629.5625      18.6758      21.6011      19.3753      22.4354      24.9544      27.6100      53.5453      46.2939      51.6120      44.5724      40.0730      36.2188       0.0227       0.2234       0.2234       3.3136       0.2716    2629.5466      43.4039      56.3513     333.1250       0.0589    4929.9512    -999.2500    1282.0000       0.2412       0.2412
  341.8332       0.6689      96.0000      96.6901       0.0162       0.0162       8.9157     200.7592     199.3606     198.4443     200.2768     200.7592     360.8336     359.3594     362.3078     362.3078      94.7650      35.3357       0.0027       0.0027      14.3857      85.0868       3.4076    2645.5859      17.4048      20.1420      17.9805      20.9163      23.9719      26.4463      57.4554      49.6474      55.6157      47.8095      41.7154      37.8125       0.0227       0.2223       0.2223       3.3534       0.2785    2623.2915      53.5453      51.0460     322.1875       0.0530    4981.0918    -999.2500    1251.0000       0.2345       0.2345
  341.9856       0.6693      96.0000      96.3763       0.0188       0.0188       9.3477     201.8806     204.8297     206.3976     203.2619     201.8806     363.2910     359.8832     366.6987     366.6987      90.4256      35.3426       0.0292       0.0292       8.1782      96.0086       3.4022    2601.8147      17.9006      19.6636      18.4398      20.3178      24.4864      26.2784      55.8642      50.8555      54.2306      49.2179      40.8390      38.0540       0.0227       0.2429       0.2429       3.3253       0.2825    2618.9634      57.4554      50.0892     331.2500       0.0562    4953.4233    -999.2500    1256.0000       0.2347       0.2347
  342.1380       0.6683      96.0000      96.4809       0.0237       0.0237       5.7570     203.0660     207.5762     208.0644     207.0880     203.0660     362.3268     359.7256     364.9282     364.9282      87.3978      35.3494       0.0237       0.0237       5.5683      90.0354       3.1564    2610.9363      19.0620      20.3064      19.6679      20.8934      25.4333      26.9335      52.4604      49.2455      50.8443      47.8621      39.3186      37.1284       0.0226       0.2311       0.2311       3.2817       0.2757    2610.9746      55.8642      57.6587     322.1875       0.0595    4924.5063    -999.2500    1249.0000       0.2352       0.2352
  342.2904       0.6673      96.0000      96.5332       0.0219       0.0219       6.9491     204.0272     210.8326     211.1507     210.5145     204.0272     364.6006     360.5347     368.6664     368.6664      88.3045      35.3562       0.0143       0.0143       9.2271      76.7171       3.2729    2626.3572      20.9971      21.6540      21.7153      22.3820      27.2374      28.0655      47.6256      46.1809      46.0505      44.6787      36.7142      35.6310       0.0226       0.2250       0.2250       3.2442       0.2793    2613.9192      52.4604      54.6487     329.0000       0.0622    4901.3066    -999.2500    1215.0000       0.2357       0.2357
  342.4428       0.6679      96.0000      96.5855       0.0200       0.0200       9.8858     206.2379     213.1018     213.6773     212.5263     206.2379     366.6649     362.4171     370.9128     370.9128      94.9862      35.3631       0.0286       0.0286       6.3888     100.4693       3.2857    2602.7644      24.0988      22.8770      24.9286      23.6326      30.5121      29.3563      41.4959      43.7121      40.1145      42.3144      32.7739      34.0643       0.0226       0.2313       0.2313       3.2968       0.2762    2617.0725      47.6256      40.8777     330.9375       0.0682    4848.7681    -999.2500    1221.0000       0.2386       0.2386
  342.5952       0.6685      96.0000      96.6901       0.0268       0.0268      10.0459     208.9293     214.5965     214.7445     214.4486     208.9293     370.9596     368.3821     373.5370     373.5370     107.7242      35.3699       0.0194       0.0194      12.2518     110.0805       3.3296    2618.0496      26.7138      23.7421      27.5845      24.5473      33.0734      30.1587      37.4338      42.1193      36.2522      40.7377      30.2358      33.1579       0.0226       0.2613       0.2613       3.3138       0.2724    2605.7566      41.4959      35.4278     322.1875       0.0754    4786.3091    -999.2500    1191.0000       0.2489       0.2489
  342.7476       0.6698      96.0000      96.3763       0.0288       0.0288       9.2329     208.2564     213.6546     213.9953     213.3138     208.2564     370.4791     367.7141     373.2442     373.2442     109.7665      35.3767       0.0355       0.0355       8.3525     114.3632       3.3159    2591.3481      26.4600      23.5636      27.2809      24.3612      32.7418      29.8655      37.7929      42.4384      36.6556      41.0488      30.5420      33.4835       0.0225       0.2762       0.2762       3.3580       0.2740    2602.4490      37.4338      36.9347     331.9375       0.0736    4801.7720    -999.2500    1193.0000       0.2596       0.2596
  342.9000       0.6712      96.0000      96.5332       0.0351       0.0351      10.0881     207.3273     212.6800     212.9657     212.3944     207.3273     371.3891     370.0054     372.7727     372.7727     115.2821      35.3836       0.0280       0.0280      12.0666     104.1238       3.4301    2603.7488      23.7844      22.2528      24.5290      23.0120      30.1180      28.4688      42.0443      44.9381      40.7681      43.4556      33.2027      35.1262       0.0225       0.2695       0.2695       3.4464       0.2761    2592.0032      37.7929      45.3413     322.1875       0.0711    4823.2915    -999.2500    1188.0000       0.2607       0.2607
  343.0524       0.6717      96.0000      96.3763       0.0292       0.0292      15.4617     204.7641     210.4971     210.0475     210.9465     204.7641     366.9520     363.1086     370.7954     370.7954     110.9536      35.3904       0.0392       0.0392      12.8023     126.6274       3.5887    2585.3464      20.1650      19.9761      20.8189      20.6832      26.5019      26.2700      49.5909      50.0599      48.0333      48.3485      37.7332      38.0662       0.0225       0.2590       0.2590       3.4648       0.2806    2601.8992      42.0443      53.3604     332.2500       0.0642    4883.6675    -999.2500    1219.0000       0.2605       0.2605
  343.2048       0.6723      96.0000      96.3763       0.0304       0.0304      16.7987     202.1049     205.4691     203.1420     207.7962     202.1049     363.3367     360.6418     366.0316     366.0316     118.3068      35.3973       0.0200       0.0200      20.3980     101.3778       3.3789    2616.9614      16.9408      17.6561      17.5450      18.3018      23.3131      23.9866      59.0289      56.6376      56.9962      54.6395      42.8943      41.6899       0.0224       0.2686       0.2686       3.3961       0.2807    2599.7854      49.5909      60.6359     322.1875       0.0568    4947.9263    -999.2500    1217.0000       0.2606       0.2606
  343.3572       0.6723      96.0000      96.5332       0.0251       0.0251      17.6669     200.7912     206.5074     207.7254     205.2894     200.7912     361.3730     358.6793     364.0668     364.0668     125.3058      35.4041       0.0342       0.0342      13.0118     126.4993       3.2318    2593.5168      14.1868      15.4094      14.7316      15.9998      20.5837      21.7682      70.4880      64.8955      67.8813      62.5006      48.5821      45.9386       0.0224       0.2555       0.2555       3.3224       0.2814    2608.6426      59.0289      74.2328     331.9375       0.0531    4980.2969    -999.2500    1225.0000       0.2569       0.2569
  343.5096       0.6722      96.0000      96.2717       0.0291       0.0291      12.0661     195.5688     197.3028     197.8767     196.7289     195.5688     350.0447     348.0487     352.0406     352.0406     157.0678      35.4109       0.0218       0.0218      17.2356     147.6244       3.3564    2613.9834      12.0863      13.8939      12.5641      14.4125      18.5980      20.2543      82.7381      71.9741      79.5921      69.3843      53.7691      49.3722       0.0224       0.2498       0.2498       3.2589       0.2768    2601.9990      70.4880      81.1646     322.1875       0.0378    5113.2896    -999.2500    1232.0000       0.2513       0.2513
  343.6620       0.6711      96.0000      96.4809       0.0214       0.0214       8.4114     193.9028     196.9702     195.6975     198.2430     193.9028     340.5098     330.9888     350.0307     350.0307     326.4957      35.4178       0.0306       0.0306       6.4694     196.6638       3.1955    2599.4727      11.0068      13.5821      11.4093      14.0640      17.5009      20.0938      90.8532      73.6264      87.6475      71.1033      57.1398      49.7667       0.0223       0.2347       0.2347       3.3500       0.2786    2614.6135      82.7381      94.5795     334.8750       0.0328    5157.2241    -999.2500    1241.0000       0.2393       0.2393
  343.8144       0.6700      96.0000      96.3763       0.0309       0.0309       4.4179     196.4659     197.8186     196.0254     199.6118     196.4659     348.3773     344.0887     352.6659     352.6659     670.9595      35.4246       0.0073       0.0073       7.5287     651.4924       3.5041    2637.9441      11.5981      14.7966      11.9764      15.3018      17.9104      21.3920      86.2210      67.5829      83.4975      65.3517      55.8333      46.7465       0.0223       0.1927       0.1927       3.4288       0.2750    2599.0273      90.8532      95.0730     334.6250       0.0405    5089.9414    -999.2500    1237.0000       0.2291       0.2291
  343.9668       0.6687      96.0000      96.4809       0.0432       0.0432       7.2084     198.7407     200.1515     194.6398     205.6631     198.7407     353.5625     350.4385     356.6864     356.6864     762.8884      35.4314       0.0495       0.0495       5.3936    1191.2699       3.5735    2568.2524      14.8716      17.4922      15.3515      18.0540      20.9005      23.9871      67.2421      57.1684      65.1404      55.3893      47.8457      41.6891       0.0223       0.2142       0.2142       3.4210       0.2749    2578.7073      86.2210      61.6044     335.1875       0.0472    5031.6812    -999.2500    1212.0000       0.2319       0.2319
  344.1192       0.6673      96.0000      96.3763       0.0574       0.0574       8.3349     206.8467     204.9238     198.0500     211.7976     206.8467     370.1882     369.0827     371.2936     371.2936     610.8626      35.4383       0.0701       0.0701       7.1173     472.4504       3.1758    2534.3938      20.9729      21.2319      21.5844      21.8500      26.6513      27.3982      47.6807      47.0989      46.3297      45.7665      37.5216      36.4987       0.0222       0.2814       0.2814       3.2913       0.2750    2555.2246      67.2421      48.2556     343.0625       0.0699    4834.4980    -999.2500    1245.0000       0.2501       0.2501
  344.2716       0.6674      96.0000      96.2194       0.0684       0.0684       4.1727     212.6779     215.1881     215.5909     214.7853     212.6779     376.3391     376.9458     375.7324     375.7324     259.1333      35.4451       0.0549       0.0549       8.0845     179.1214       3.1175    2559.4700      27.3502      25.1009      27.9838      25.7210      32.7104      30.7569      36.5628      39.8392      35.7349      38.8787      30.5713      32.5130       0.0222       0.2877       0.2877       3.2003       0.2643    2537.1345      47.6807      37.2189     336.1250       0.0851    4701.9463    -999.2500    1245.0000       0.2677       0.2677
  344.4240       0.6675      96.0000      96.5332       0.0778       0.0778      -1.5456     214.2158     216.5816     216.9468     216.2165     214.2158     383.7805     390.6291     376.9320     376.9320     141.2247      35.4520       0.0790       0.0790      -1.7848     124.1532       3.2838    2519.6594      30.8430      28.6212      31.4045      29.2049      35.6933      33.9469      32.4223      34.9392      31.8426      34.2408      28.0164      29.4577       0.0222       0.2822       0.2822       3.2223       0.2615    2521.7085      36.5628      29.1025     343.4375       0.0890    4668.1904    -999.2500    1236.0000       0.2730       0.2730
  344.5764       0.6679      96.0000      96.3763       0.0889       0.0889      -1.2847     216.0100     218.3286     217.9823     218.6750     216.0100     385.1351     390.8847     379.3856     379.3856     122.4785      35.4588       0.0910       0.0910      -1.6161     118.4921       3.2332    2499.8120      32.6272      31.1401      33.1244      31.6663      37.0368      35.9654      30.6493      32.1129      30.1892      31.5793      27.0002      27.8045       0.0221       0.2776       0.2776       3.2670       0.2602    2503.2678      32.4223      29.5791     336.5000       0.0934    4629.4155    -999.2500    1274.0000       0.2791       0.2791
  344.7288       0.6684      96.0000      96.2194       0.0912       0.0912       1.9040     214.6323     217.7662     217.0864     218.4461     214.6323     378.0557     378.6099     377.5015     377.5015     120.9801      35.4656       0.0941       0.0941       0.6652     122.4881       3.2536    2494.7424      34.9967      32.3705      35.5347      32.8610      39.1826      36.7608      28.5741      30.8923      28.1415      30.4312      25.5216      27.2029       0.0221       0.2765       0.2765       3.2354       0.2612    2499.4907      30.6493      29.1735     341.6875       0.0900    4659.1313    -999.2500    1242.0000       0.2790       0.2790
  344.8812       0.6687      96.0000      96.3763       0.0869       0.0869       7.6889     214.2799     217.7767     216.6770     218.8763     214.2799     376.7540     376.5371     376.9708     376.9708     128.6518      35.4725       0.0881       0.0881       5.4592     121.3332       3.2181    2504.5933      34.4076      32.3202      35.0699      32.8671      38.6306      36.5103      29.0633      30.9404      28.5145      30.4256      25.8862      27.3895       0.0221       0.2811       0.2811       3.2927       0.2613    2506.6201      28.5741      31.2369     338.8750       0.0891    4666.7944    -999.2500    1243.0000       0.2802       0.2802
  345.0336       0.6689      96.0000      96.5855       0.0838       0.0838      10.3699     214.3439     217.0123     216.3869     217.6376     214.3439     382.6371     390.7718     374.5023     374.5023     126.7085      35.4793       0.0822       0.0822      11.1304     141.2893       3.4043    2514.3262      31.3430      31.7158      32.2947      32.1991      35.8623      35.7557      31.9050      31.5300      30.9649      31.0567      27.8844      27.9676       0.0221       0.2711       0.2711       3.3483       0.2564    2511.7329      29.0633      33.0478     341.6875       0.0893    4665.3994    -999.2500    1213.0000       0.2792       0.2792
  345.1860       0.6693      96.0000      96.3763       0.0800       0.0800      17.2835     214.0556     215.5396     216.7036     214.3756     214.0556     384.8096     391.7037     377.9155     377.9155     134.0479      35.4861       0.0799       0.0799      16.6695     117.0531       3.4160    2518.2151      28.7478      31.3513      29.5642      32.1378      33.0199      35.6947      34.7853      31.8966      33.8247      31.1160      30.2848      28.0154       0.0220       0.2840       0.2840       3.4074       0.2638    2517.9294      31.9050      31.3234     344.4375       0.0886    4671.6841    -999.2500    1196.0000       0.2845       0.2845
  345.3384       0.6697      96.0000      96.3763       0.0803       0.0803      15.2506     214.0876     215.3104     216.6091     214.0117     214.0876     386.1536     391.7199     380.5872     380.5872     124.9441      35.4930       0.0824       0.0824      17.2629     143.5856       3.4038    2514.0112      28.5025      31.0044      29.2171      31.8729      32.4806      35.2883      35.0846      32.2535      34.2265      31.3746      30.7876      28.3380       0.0220       0.3046       0.3046       3.3974       0.2685    2517.4546      34.7853      29.2766     336.9375       0.0886    4670.9849    -999.2500    1200.0000       0.2954       0.2954
  345.4908       0.6700      96.0000      96.3763       0.0784       0.0784       9.4902     214.7925     215.1118     216.5637     213.6599     214.7925     386.6110     391.9939     381.2281     381.2281     133.1444      35.4998       0.0803       0.0803       9.1328     114.4278       3.3712    2517.4583      30.3070      32.0084      31.0018      32.8118      34.0290      36.0741      32.9956      31.2418      32.2562      30.4768      29.3867      27.7207       0.0220       0.3122       0.3122       3.4229       0.2675    2520.7207      35.0846      31.8305     347.5000       0.0904    4655.6563    -999.2500    1171.0000       0.2980       0.2980
  345.6432       0.6703      96.0000      96.5855       0.0745       0.0745       2.0764     215.9780     217.5895     220.6511     214.5280     215.9780     389.2453     394.6431     383.8474     383.8474     134.5969      35.5066       0.0738       0.0738       0.3807     141.4935       3.4976    2528.2754      33.4185      33.2263      34.0716      34.1809      37.7490      37.4861      29.9235      30.0966      29.3499      29.2561      26.4907      26.6765       0.0219       0.2959       0.2959       3.4206       0.2684    2527.1514      32.9956      33.3041     339.6250       0.0933    4630.1025    -999.2500    1218.0000       0.3021       0.3021
  345.7956       0.6703      96.0000      96.5855       0.0653       0.0653       2.7596     218.6052     222.4610     224.8807     220.0414     218.6052     397.9003     404.8646     390.9359     390.9359     137.7751      35.5135       0.0664       0.0664       1.9581     147.7088       3.3925    2540.3687      37.8577      34.1841      38.5232      34.9648      42.7068      38.9574      26.4147      29.2534      25.9584      28.6002      23.4155      25.6690       0.0219       0.3048       0.3048       3.4099       0.2725    2542.2820      29.9235      30.9453     346.8750       0.0997    4574.4570    -999.2500    1212.0000       0.3073       0.3073
  345.9480       0.6704      96.0000      96.3763       0.0573       0.0573       8.9561     223.0266     225.1564     227.0864     223.2265     223.0266     412.1654     415.1009     409.2299     409.2299     129.0753      35.5203       0.0529       0.0529      11.2752     123.9625       3.3402    2562.6719      39.0030      35.4854      39.5350      36.0584      44.3407      40.2694      25.6390      28.1806      25.2940      27.7328      22.5527      24.8328       0.0219       0.3207       0.3207       3.4213       0.2887    2555.4758      26.4147      30.0645     341.6875       0.1101    4483.7695    -999.2500    1221.0000       0.3174       0.3174
  346.1004       0.6710      96.0000      96.3763       0.0547       0.0547      11.6321     226.5189     227.8965     229.6259     226.1671     226.5189     419.9449     425.6063     414.2835     414.2835     125.8136      35.5272       0.0554       0.0554       8.9205     116.5571       3.5429    2558.6382      36.4919      35.6710      36.4639      36.2090      42.2010      41.0124      27.4033      28.0340      27.4244      27.6174      23.6961      24.3829       0.0218       0.3058       0.3058       3.4464       0.2868    2559.7373      25.6390      28.7858     349.3125       0.1181    4414.6421    -999.2500    1242.0000       0.3185       0.3185
  346.2528       0.6716      96.0000      96.5855       0.0617       0.0617       9.4761     227.6083     228.4414     230.1310     226.7518     227.6083     425.1461     425.8272     424.4650     424.4650     130.3568      35.5340       0.0587       0.0587       9.0915     137.9237       3.4681    2553.1423      34.3807      35.2229      35.1866      35.4822      40.3233      41.2515      29.0861      28.3906      28.4199      28.1831      24.7995      24.2415       0.0218       0.3286       0.3286       3.4578       0.2982    2548.1853      27.4033      27.3551     351.4375       0.1205    4393.5132    -999.2500    1219.0000       0.3245       0.3245
  346.4052       0.6728      96.0000      96.3763       0.0572       0.0572       8.2389     228.0568     228.7377     230.4818     226.9936     228.0568     420.1517     424.6795     415.6239     415.6239     142.5244      35.5408       0.0739       0.0739       4.2858     138.8967       3.3676    2528.1118      34.1278      34.7219      34.4805      34.8119      39.9975      41.0311      29.3016      28.8003      29.0019      28.7258      25.0016      24.3718       0.0218       0.3377       0.3377       3.4608       0.2846    2555.6877      29.0861      27.6470     343.8125       0.1215    4384.8721    -999.2500    1251.0000       0.3221       0.3221
  346.5576       0.6739      96.0000      96.3763       0.0545       0.0545       8.2696     225.1412     228.3661     229.6728     227.0593     225.1412     414.2896     416.4025     412.1768     412.1768     147.0305      35.5477       0.0341       0.0341      17.0436     152.0575       3.5514    2593.6604      34.2179      34.0226      34.6009      34.2924      40.3130      40.3813      29.2245      29.3922      28.9010      29.1610      24.8059      24.7639       0.0217       0.3108       0.3108       3.3799       0.2874    2560.1563      29.3016      28.9150     351.4375       0.1150    4441.6563    -999.2500    1285.0000       0.3189       0.3189
  346.7100       0.6742      96.0000      96.5332       0.0398       0.0398      10.8887     222.0014     226.9949     227.2511     226.7387     222.0014     408.4751     409.7604     407.1898     407.1898     156.5241      35.5545       0.0522       0.0522       7.4381     151.9276       3.2446    2563.9177      33.6047      33.1712      34.1353      33.6353      39.8964      39.3627      29.7577      30.1466      29.2951      29.7307      25.0649      25.4048       0.0217       0.3181       0.3181       3.3861       0.2885    2584.3655      29.2245      29.5737     341.6875       0.1078    4504.4771    -999.2500    1292.0000       0.3128       0.3128
  346.8624       0.6745      96.0000      96.5855       0.0408       0.0408       9.5106     217.3236     223.1526     225.1362     221.1689     217.3236     395.0335     394.3120     395.7550     395.7550     166.1300      35.5613       0.0312       0.0312      12.0990     166.0727       3.3837    2598.5742      32.2357      32.3329      32.9078      32.9784      38.5238      38.4149      31.0215      30.9282      30.3879      30.3229      25.9579      26.0315       0.0216       0.3124       0.3124       3.3554       0.2841    2582.6013      29.7577      33.0065     347.6250       0.0966    4601.4331    -999.2500    1269.0000       0.3038       0.3038
  347.0148       0.6747      96.0000      96.2194       0.0271       0.0271       9.5924     213.2866     217.7432     216.7164     218.7701     213.2866     387.5933     390.5145     384.6721     384.6721     197.8018      35.5682       0.0425       0.0425       4.2330     182.1640       3.4543    2579.8677      30.7784      31.4872      31.6589      32.1451      37.4190      37.6324      32.4904      31.7590      31.5867      31.1089      26.7244      26.5728       0.0216       0.3135       0.3135       3.5046       0.2781    2605.2498      31.0215      33.2881     335.8125       0.0866    4688.5264    -999.2500    1257.0000       0.3007       0.3007
  347.1672       0.6750      96.0000      96.4809       0.0277       0.0277       9.0506     212.9342     216.8374     214.9890     218.6858     212.9342     375.5500     373.3961     377.7039     377.7039     232.4202      35.5750       0.0060       0.0060      14.3631     246.4574       3.6931    2640.0933      29.9660      30.7466      30.8959      31.5791      36.6122      37.3370      33.3712      32.5239      32.3668      31.6666      27.3133      26.7831       0.0216       0.2793       0.2793       3.4880       0.2671    2604.2986      32.4904      35.9266     341.6875       0.0857    4696.2861    -999.2500    1218.0000       0.2917       0.2917
  347.3196       0.6753      96.0000      96.2717       0.0384       0.0384       5.6994     211.4924     215.4244     215.6040     215.2448     211.4924     374.8570     373.9796     375.7343     375.7343     232.5029      35.5819       0.0332       0.0332       8.1079     267.2268       3.3007    2595.1638      28.9190      30.9477      29.9575      32.0116      35.3718      37.6564      34.5793      32.3126      33.3806      31.2386      28.2711      26.5559       0.0215       0.2520       0.2520       3.4225       0.2681    2586.6443      33.3712      31.3505     331.9375       0.0821    4728.3018    -999.2500    1178.0000       0.2854       0.2854
  347.4720       0.6756      96.0000      96.3763       0.0521       0.0521       6.9924     213.5109     214.9398     215.0748     214.8047     213.5109     378.0782     374.5891     381.5672     381.5672     197.5240      35.5887       0.0689       0.0689       1.0141     181.6902       3.2726    2536.3408      29.2697      32.0728      30.2009      33.1853      35.3287      38.5707      34.1650      31.1790      33.1116      30.1338      28.3056      25.9264       0.0215       0.2982       0.2982       3.3552       0.2721    2564.0256      34.5793      28.0395     333.9375       0.0872    4683.6016    -999.2500    1177.0000       0.2825       0.2825
  347.6244       0.6758      96.0000      96.3763       0.0587       0.0587      11.6813     214.5682     216.3673     216.7746     215.9600     214.5682     377.8335     375.9543     379.7126     379.7126     149.0215      35.5955       0.0533       0.0533      13.5273     141.5207       3.4765    2562.0464      32.9417      33.7599      33.7758      34.7902      38.2276      39.9003      30.3567      29.6209      29.6070      28.7437      26.1591      25.0625       0.0215       0.2951       0.2951       3.4294       0.2654    2553.1157      34.1650      29.0338     335.0000       0.0898    4660.5225    -999.2500    1152.0000       0.2830       0.2830
  347.7768       0.6761      96.0000      96.6901       0.0596       0.0596      14.9276     213.5750     214.2488     216.0987     212.3988     213.5750     375.8698     375.4713     376.2683     376.2683     135.6323      35.6024       0.0574       0.0574      16.6312     124.9996       3.5526    2555.2698      37.1002      35.5624      37.8532      36.4722      42.3252      41.1462      26.9540      28.1196      26.4179      27.4181      23.6266      24.3036       0.0215       0.2741       0.2741       3.4749       0.2623    2551.6208      30.3567      26.3506     331.9375       0.0873    4682.1963    -999.2500    1136.0000       0.2779       0.2779
  347.9292       0.6767      96.0000      96.5332       0.0630       0.0630      14.9115     214.3439     214.9465     216.0029     213.8900     214.3439     375.1273     374.2083     376.0464     376.0464     136.4626      35.6092       0.0706       0.0706      11.7796     140.0076       3.3996    2533.5757      39.9319      37.2573      40.5651      37.9997      44.7241      42.4404      25.0426      26.8404      24.6518      26.3160      22.3593      23.5624       0.0214       0.2759       0.2759       3.4181       0.2594    2546.0159      26.9540      26.3450     332.7500       0.0893    4665.3994    -999.2500    1169.0000       0.2758       0.2758
  348.0816       0.6773      96.0000      96.5332       0.0710       0.0710       7.7581     214.6643     215.4483     216.8929     214.0037     214.6643     375.2014     374.7682     375.6347     375.6347     140.1465      35.6160       0.0654       0.0654       9.2336     144.0116       3.3063    2542.1548      40.2978      38.6627      40.8426      39.2445      44.6086      43.4049      24.8152      25.8647      24.4842      25.4813      22.4172      23.0389       0.0214       0.2556       0.2556       3.3494       0.2575    2532.8672      25.0426      27.2149     330.0000       0.0901    4658.4360    -999.2500    1183.0000       0.2677       0.2677
  348.2340       0.6786      96.0000      96.5855       0.0804       0.0804       4.4015     214.9847     216.4703     217.2947     215.6459     214.9847     376.4951     376.1921     376.7982     376.7982     137.6494      35.6229       0.0745       0.0745       6.3998     135.4724       3.3544    2527.0146      40.2023      39.5598      40.4390      40.1135      44.3006      43.8787      24.8742      25.2782      24.7286      24.9293      22.5730      22.7901       0.0214       0.2763       0.2763       3.3277       0.2587    2517.3171      24.8152      25.2818     333.0000       0.0909    4651.4932    -999.2500    1211.0000       0.2716       0.2716
  348.3864       0.6799      96.0000      96.5332       0.0872       0.0872       3.0367     215.7216     216.4718     217.3975     215.5462     215.7216     383.9721     390.8838     377.0604     377.0604     137.9646      35.6297       0.0996       0.0996      -0.6589     133.7701       3.3328    2485.6895      39.9562      39.4202      40.4289      39.9431      44.2660      43.8042      25.0274      25.3677      24.7348      25.0356      22.5907      22.8289       0.0213       0.2801       0.2801       3.3334       0.2567    2506.1912      24.8742      25.5820     325.7500       0.0927    4635.6040    -999.2500    1267.0000       0.2742       0.2742
  348.5388       0.6816      96.0000      96.3763       0.0914       0.0914       4.5142     216.1061     216.4445     217.9266     214.9624     216.1061     385.3848     391.6569     379.1127     379.1127     135.9217      35.6366       0.0840       0.0840       8.4250     145.2958       3.3245    2511.4614      39.2126      39.0136      39.7726      39.4783      43.4636      43.3127      25.5020      25.6321      25.1430      25.3304      23.0077      23.0879       0.0213       0.2758       0.2758       3.2623       0.2593    2499.2317      25.0274      26.2711     331.9375       0.0936    4627.3564    -999.2500    1251.0000       0.2780       0.2780
  348.6912       0.6833      96.0000      96.5332       0.0905       0.0905       6.6711     216.4906     216.7379     217.9930     215.4828     216.4906     385.9201     392.1013     379.7389     379.7389     138.0006      35.6434       0.0888       0.0888       8.8544     129.3436       3.1376    2503.5129      38.1907      38.3526      38.8875      38.8723      42.3926      42.5640      26.1844      26.0738      25.7152      25.7253      23.5890      23.4940       0.0213       0.2705       0.2705       3.2800       0.2592    2500.6814      25.5020      26.1592     327.9375       0.0946    4619.1387    -999.2500    1268.0000       0.2789       0.2789
  348.8436       0.6855      96.0000      96.5332       0.0884       0.0884       9.0928     217.1954     217.1547     218.4950     215.8143     217.1954     387.1493     392.7375     381.5611     381.5611     133.9361      35.6502       0.0959       0.0959       6.7452     139.7011       3.3816    2491.7305      37.0885      37.5242      38.1000      38.2517      41.4208      41.7583      26.9625      26.6495      26.2467      26.1426      24.1425      23.9473       0.0212       0.2859       0.2859       3.3413       0.2603    2504.0945      26.1844      25.2779     327.9375       0.0963    4604.1479    -999.2500    1280.0000       0.2838       0.2838
  348.9960       0.6876      96.0000      96.3763       0.0826       0.0826       9.3393     217.7401     217.4214     218.7929     216.0499     217.7401     389.1550     393.7921     384.5179     384.5179     130.1021      35.6571       0.0809       0.0809      10.5232     133.1651       3.5135    2516.4966      36.1097      36.2935      37.1006      37.3598      40.2107      40.9092      27.6934      27.5531      26.9537      26.7668      24.8690      24.4444       0.0212       0.3016       0.3016       3.4534       0.2640    2513.7212      26.9625      26.1034     329.1250       0.0976    4592.6309    -999.2500    1276.0000       0.2896       0.2896
  349.1484       0.6881      96.0000      96.6901       0.0686       0.0686      10.2087     216.7789     216.7807     218.9375     214.6238     216.7789     388.4097     391.6535     385.1659     385.1659     132.7674      35.6639       0.0702       0.0702       9.6260     118.4236       3.4597    2534.1338      34.8606      34.9952      35.7341      36.1572      39.3805      39.7845      28.6857      28.5753      27.9845      27.6570      25.3933      25.1354       0.0212       0.3066       0.3066       3.4164       0.2682    2536.8191      27.6934      28.2797     327.2500       0.0953    4612.9946    -999.2500    1251.0000       0.2947       0.2947
  349.3008       0.6886      96.0000      96.5332       0.0535       0.0535       8.0630     214.2799     215.3994     217.3882     213.4106     214.2799     388.2293     392.6941     383.7646     383.7646     130.2777      35.6707       0.0552       0.0552       7.0477     147.6970       3.2612    2558.9727      36.7090      33.7677      37.6043      34.7732      42.0036      38.7035      27.2413      29.6141      26.5927      28.7578      23.8075      25.8375       0.0211       0.3179       0.3179       3.3600       0.2735    2561.7583      28.6857      31.9203     331.9375       0.0891    4666.7944    -999.2500    1231.0000       0.2982       0.2982
  349.4532       0.6901      96.0000      96.5855       0.0375       0.0375       7.0802     214.4080     215.1694     216.8994     213.4395     214.4080     381.4530     381.1552     381.7509     381.7509     128.8427      35.6776       0.0328       0.0328       7.2413     126.2294       3.3471    2595.9299      37.6468      32.2473      38.4338      33.0455      42.9312      37.4971      26.5627      31.0104      26.0188      30.2613      23.2931      26.6687       0.0211       0.2919       0.2919       3.2668       0.2696    2588.0947      27.2413      36.3311     327.4375       0.0894    4664.0049    -999.2500    1235.0000       0.2940       0.2940
  349.6056       0.6917      96.0000      96.6901       0.0273       0.0273       7.4518     213.2546     214.5668     218.3553     210.7782     213.2546     385.7282     390.5180     380.9384     380.9384     116.1981      35.6844       0.0219       0.0219       9.6293     113.5365       3.1909    2613.8826      31.8451      29.8931      32.3957      30.6334      38.0993      35.1305      31.4020      33.4525      30.8683      32.6441      26.2472      28.4653       0.0211       0.2559       0.2559       3.2736       0.2718    2604.9260      26.5627      36.8346     334.3750       0.0865    4689.2310    -999.2500    1199.0000       0.2793       0.2793
  349.7580       0.6931      96.0000      96.4809       0.0295       0.0295       7.2381     212.2293     213.7778     216.8940     210.6615     212.2293     382.4395     383.5853     381.2936     381.2936     107.6092      35.6912       0.0233       0.0233      11.4801     110.3893       3.2785    2611.5400      25.4268      26.0528      26.3064      26.4885      31.9406      32.1740      39.3285      38.3836      38.0135      37.7523      31.3082      31.0810       0.0210       0.2775       0.2775       3.2928       0.2756    2601.2542      31.4020      36.6035     323.6250       0.0839    4711.8843    -999.2500    1233.0000       0.2729       0.2729
  349.9104       0.6946      96.0000      96.3763       0.0309       0.0309       6.8401     211.5885     213.6754     217.7679     209.5829     211.5885     378.0515     375.5788     380.5241     380.5241     103.8583      35.6981       0.0423       0.0423       2.2307      99.5279       3.4222    2580.2764      21.0415      22.7686      21.4312      23.1632      27.2688      28.8725      47.5252      43.9202      46.6610      43.1718      36.6719      34.6350       0.0210       0.2866       0.2866       3.3070       0.2762    2598.9934      39.3285      42.6513     334.4375       0.0823    4726.1538    -999.2500    1229.0000       0.2719       0.2719
  350.0628       0.6956      96.0000      96.6901       0.0357       0.0357       2.5331     205.5651     205.5591     211.4005     199.7177     205.5651     369.8490     364.7503     374.9477     374.9477     104.1063      35.7049       0.0286       0.0286       4.3994     102.2837       3.2351    2602.8479      17.3016      19.2669      17.6280      19.6085      23.9700      25.4950      57.7983      51.9025      56.7279      50.9982      41.7188      39.2234       0.0210       0.2820       0.2820       3.2887       0.2851    2591.1116      47.5252      53.9502     322.1875       0.0664    4864.6382    -999.2500    1219.0000       0.2712       0.2712
  350.2152       0.6965      96.0000      96.2717       0.0353       0.0353       4.2153     203.3864     200.9829     204.0563     197.9094     203.3864     365.3929     361.6039     369.1818     369.1818     112.8775      35.7118       0.0363       0.0363       1.0820     110.1640       3.2241    2590.1121      14.6694      15.6055      15.0922      15.9431      21.2341      22.2888      68.1690      64.0801      66.2596      62.7231      47.0941      44.8657       0.0209       0.2526       0.2526       3.1810       0.2821    2591.6958      57.7983      75.9469     331.2500       0.0604    4916.7485    -999.2500    1224.0000       0.2622       0.2622
  350.3676       0.6966      96.0000      96.5332       0.0422       0.0422       2.1418     199.8621     198.2451     199.3595     197.1308     199.8621     361.3556     358.2465     364.4648     364.4648     122.7480      35.7186       0.0435       0.0435       4.0430     125.8415       3.1035    2578.2346      12.4037      13.1164      13.0747      13.4517      19.0870      19.5935      80.6212      76.2403      76.4833      74.3398      52.3917      51.0374       0.0209       0.2356       0.2356       3.1268       0.2850    2580.3928      68.1690      90.3585     326.6875       0.0505    5003.4497    -999.2500    1241.0000       0.2491       0.2491
  350.5200       0.6967      96.0000      96.5855       0.0415       0.0415       6.4170     198.0999     197.7893     197.7950     197.7835     198.0999     359.5620     357.6139     361.5102     361.5102     131.2088      35.7254       0.0444       0.0444       6.1471     131.8951       3.0755    2576.7378      10.3043      11.1030      11.0748      11.5815      17.2050      17.5926      97.0465      90.0656      90.2951      86.3446      58.1226      56.8419       0.0209       0.2494       0.2494       3.1233       0.2854    2581.4802      80.6212     100.3026     326.9375       0.0453    5047.9570    -999.2500    1247.0000       0.2455       0.2455
  350.6724       0.6971      96.0000      96.3763       0.0396       0.0396       5.1143     198.7407     197.6754     197.8142     197.5365     198.7407     358.3039     355.3849     361.2229     361.2229     129.1843      35.7323       0.0403       0.0403       5.0660     136.2225       3.2004    2583.5361       8.3256       9.5744       9.0849      10.2023      15.4246      16.3307     120.1108     104.4447     110.0732      98.0173      64.8315      61.2345       0.0208       0.2392       0.2392       3.2193       0.2829    2584.7017      97.0465     119.7387     336.8125       0.0472    5031.6812    -999.2500    1234.0000       0.2429       0.2429
  350.8248       0.6974      96.0000      96.2717       0.0357       0.0357       8.1590     196.9465     197.6447     198.0060     197.2833     196.9465     353.8933     350.9987     356.7879     356.7879     134.0472      35.7391       0.0321       0.0321       9.4243     119.7681       3.4072    2596.9722       7.4932       8.6658       8.2387       9.4138      14.6889      15.7514     133.4541     115.3961     121.3785     106.2275      68.0785      63.4863       0.0208       0.2421       0.2421       3.2595       0.2809    2591.0569     120.1108     112.3722     326.4375       0.0420    5077.5210    -999.2500    1203.0000       0.2435       0.2435
  350.9772       0.6968      96.0000      96.3763       0.0363       0.0363       5.7306     198.4844     198.7623     199.2440     198.2807     198.4844     355.3550     355.1096     355.6004     355.6004     133.0404      35.7459       0.0388       0.0388       5.2388     145.7745       3.1828    2586.0444       7.5759       8.5508       8.2560       9.3364      14.7736      15.7818     131.9968     116.9485     121.1239     107.1073      67.6885      63.3641       0.0208       0.2369       0.2369       3.2979       0.2737    2590.1797     133.4541     113.2467     334.8125       0.0465    5038.1792    -999.2500    1229.0000       0.2412       0.2412
  351.1296       0.6963      96.0000      96.5855       0.0409       0.0409       2.2550     197.7155     196.5933     197.9527     195.2338     197.7155     353.1893     350.1407     356.2378     356.2378     134.3173      35.7528       0.0370       0.0370       3.2515     132.8695       3.3129    2588.9775       8.2553       9.1510       8.8131       9.8543      15.2814      16.3720     121.1340     109.2778     113.4680     101.4783      65.4390      61.0797       0.0207       0.2351       0.2351       3.2497       0.2774    2582.5508     131.9968     111.2049     334.8125       0.0442    5057.7734    -999.2500    1232.0000       0.2394       0.2394
  351.2820       0.6960      96.0000      96.2194       0.0451       0.0451       4.3964     199.1572     198.4243     197.5620     199.2866     199.1572     357.6566     358.0559     357.2571     357.2571     130.0508      35.7596       0.0427       0.0427       4.1936     123.6945       3.2490    2579.5186       9.7322      10.4645      10.1931      11.0224      16.5673      17.4858     102.7518      95.5616      98.1054      90.7246      60.3600      57.1891       0.0207       0.2283       0.2283       3.3156       0.2746    2575.5173     121.1340     105.3682     331.9375       0.0484    5021.1587    -999.2500    1204.0000       0.2389       0.2389
  351.4344       0.6956      96.0000      96.5855       0.0387       0.0387       8.8623     198.0038     198.0671     198.1813     197.9530     198.0038     357.4771     356.6841     358.2700     358.2700     131.9006      35.7665       0.0550       0.0550       4.2601     133.6844       3.3866    2559.2075      11.9773      12.3128      12.4012      12.7344      18.5783      19.1029      83.4913      81.2160      80.6377      78.5272      53.8263      52.3481       0.0207       0.2488       0.2488       3.3682       0.2801    2586.2222     102.7518      76.1065     341.6875       0.0451    5050.4082    -999.2500    1216.0000       0.2428       0.2428
  351.5868       0.6946      96.0000      96.2194       0.0341       0.0341      10.0050     195.4086     197.6847     197.8429     197.5265     195.4086     351.1866     347.1095     355.2637     355.2637     130.2933      35.7733       0.0181       0.0181      15.0407     137.4637       3.4597    2620.1921      14.1946      14.7007      14.5677      15.0805      20.5625      21.2705      70.4494      68.0238      68.6449      66.3107      48.6322      47.0134       0.0207       0.2706       0.2706       3.4187       0.2831    2593.6643      83.4913      64.8254     331.9375       0.0374    5117.4814    -999.2500    1217.0000       0.2522       0.2522
  351.7392       0.6936      96.0000      96.5332       0.0355       0.0355       7.7982     200.3107     198.2561     197.8498     198.6625     200.3107     352.7686     349.7178     355.8193     355.8193     129.7153      35.7801       0.0284       0.0284       9.3004     118.7765       3.4138    2603.0938      16.1165      17.9854      16.6104      18.4357      22.3745      24.3941      62.0484      55.6007      60.2033      54.2425      44.6937      40.9935       0.0206       0.2255       0.2255       3.2362       0.2680    2591.4460      70.4494      76.8384     343.7500       0.0517    4992.2456    -999.2500    1229.0000       0.2480       0.2480
  351.8916       0.6926      96.0000      96.4809       0.0533       0.0533       5.1236     204.0593     201.0689     197.0685     205.0693     204.0593     364.6028     363.4637     365.7421     365.7421     126.1428      35.7870       0.0569       0.0569       4.2183     131.9505       2.8792    2556.0920      19.9617      22.0838      20.5158      22.5903      26.0337      28.3459      50.0960      45.2822      48.7430      44.2667      38.4117      35.2784       0.0206       0.2280       0.2280       3.1487       0.2740    2562.1072      62.0484      57.0343     341.6875       0.0623    4900.5371    -999.2500    1200.0000       0.2502       0.2502
  352.0440       0.6916      96.0000      96.5855       0.0648       0.0648       6.9265     209.0895     210.5139     207.2630     213.7647     209.0895     375.3013     376.5447     374.0580     374.0580     132.2970      35.7938       0.0713       0.0713       6.4981     127.3317       3.1908    2532.3311      25.3693      26.7699      25.9842      27.3227      31.2174      32.8346      39.4177      37.3554      38.4849      36.5996      32.0334      30.4556       0.0206       0.2733       0.2733       3.1298       0.2728    2543.0806      50.0960      37.8946     343.6250       0.0758    4782.6416    -999.2500    1199.0000       0.2562       0.2562
  352.1964       0.6912      96.0000      96.2717       0.0677       0.0677       4.4436     213.5109     216.2258     214.3571     218.0946     213.5109     387.8524     391.8190     383.8860     383.8860     123.2551      35.8006       0.0710       0.0710       2.7621     137.2393       3.3343    2532.8545      30.8317      31.8195      31.5509      32.4454      36.5467      37.6664      32.4342      31.4273      31.6948      30.8211      27.3622      26.5489       0.0205       0.2980       0.2980       3.2605       0.2761    2538.2659      39.4177      28.6615     341.6875       0.0872    4683.6016    -999.2500    1209.0000       0.2697       0.2697
  352.3488       0.6907      96.0000      96.6901       0.0692       0.0692       0.1961     215.3051     217.2871     215.7226     218.8516     215.3051     385.0570     391.7762     378.3378     378.3378     120.8206      35.8075       0.0620       0.0620       1.7198     104.8246       3.2600    2547.6514      36.8311      36.9895      37.7574      37.7137      42.3973      42.6482      27.1509      27.0347      26.4849      26.5156      23.5864      23.4477       0.0205       0.2927       0.2927       3.3305       0.2605    2535.8274      32.4342      25.1287     341.6875       0.0917    4644.5718    -999.2500    1197.0000       0.2781       0.2781
  352.5012       0.6911      96.0000      96.3763       0.0679       0.0679       4.0172     216.0741     219.3008     217.9360     220.6655     216.0741     384.8440     392.4223     377.2657     377.2657     113.5267      35.8143       0.0701       0.0701       1.6941     120.8594       3.3760    2534.3169      43.1669      42.0351      44.1523      42.8515      48.6181      47.5263      23.1659      23.7897      22.6489      23.3364      20.5685      21.0410       0.0205       0.2623       0.2623       3.3398       0.2559    2537.9893      27.1509      23.7097     346.8125       0.0936    4628.0425    -999.2500    1196.0000       0.2732       0.2732
  352.6536       0.6915      96.0000      96.5332       0.0630       0.0630       9.6100     217.1314     222.2231     221.2072     223.2391     217.1314     392.5143     392.8589     392.1696     392.1696     123.9804      35.8212       0.0711       0.0711       8.5048     115.3574       3.3762    2532.6260      49.0215      46.6607      50.0519      47.5471      54.3284      52.0460      20.3992      21.4313      19.9793      21.0318      18.4066      19.2138       0.0204       0.2591       0.2591       3.4328       0.2790    2546.0413      23.1659      20.8645     341.0000       0.0962    4605.5068    -999.2500    1188.0000       0.2685       0.2685
  352.8060       0.6918      96.0000      96.4809       0.0667       0.0667      13.2999     220.5275     220.7176     216.8034     224.6319     220.5275     393.3619     394.9122     391.8116     391.8116     128.3783      35.8280       0.0463       0.0463      20.3952     136.1858       3.5305    2573.6775      53.3304      50.5566      54.3303      51.4919      58.3035      55.7975      18.7510      19.7798      18.4059      19.4205      17.1516      17.9220       0.0204       0.2709       0.2709       3.4134       0.2682    2539.9866      20.3992      18.9687     345.7500       0.1043    4534.5806    -999.2500    1197.0000       0.2655       0.2655
  352.9584       0.6920      96.0000      96.6901       0.0665       0.0665      12.3218     221.5208     224.1219     227.4935     220.7503     221.5208     398.3430     395.4699     401.2163     401.2163     144.6329      35.8348       0.0851       0.0851       7.7590     133.9013       3.3382    2509.6597      55.2257      53.5277      56.0700      54.4679      60.0766      58.4272      18.1075      18.6819      17.8349      18.3594      16.6454      17.1153       0.0204       0.2668       0.2668       3.4545       0.2807    2540.3213      18.7510      19.5178     344.3750       0.1066    4514.2495    -999.2500    1186.0000       0.2696       0.2696
  353.1108       0.6925      96.0000      96.6901       0.0777       0.0777      10.2538     222.7383     225.1302     228.2433     222.0171     222.7383     403.4908     397.4930     409.4886     409.4886     144.3872      35.8417       0.0658       0.0658      13.0729     164.1212       3.4939    2541.3738      55.8928      55.5251      56.5203      56.3534      60.6021      60.3535      17.8914      18.0099      17.6928      17.7451      16.5011      16.5690       0.0203       0.2747       0.2747       3.3632       0.2899    2521.7805      18.1075      18.5855     342.9375       0.1095    4489.5742    -999.2500    1208.0000       0.2758       0.2758
  353.2632       0.6929      96.0000      96.5855       0.0764       0.0764      10.9814     224.6606     226.5600     229.0735     224.0464     224.6606     407.4029     405.9327     408.8730     408.8730     145.1816      35.8485       0.0837       0.0837       8.6289     135.4487       3.2642    2511.8936      56.9923      57.0782      57.4372      57.7097      61.5950      61.8124      17.5462      17.5198      17.4103      17.3281      16.2351      16.1780       0.0203       0.2844       0.2844       3.3288       0.2838    2523.9507      17.8914      17.6450     348.8750       0.1139    4451.1582    -999.2500    1218.0000       0.2830       0.2830
  353.4156       0.6934      96.0000      96.4809       0.0834       0.0834       8.9120     226.0063     227.5054     230.0517     224.9592     226.0063     408.5632     408.3456     408.7808     408.7808     139.6735      35.8553       0.0813       0.0813       8.1344     136.3029       3.2342    2515.8123      58.5248      58.4475      58.8716      58.8974      63.0109      62.9939      17.0868      17.1094      16.9861      16.9787      15.8703      15.8745       0.0203       0.2879       0.2879       3.2755       0.2799    2512.3093      17.5462      17.4902     341.6875       0.1169    4424.6553    -999.2500    1230.0000       0.2853       0.2853
  353.5680       0.6940      96.0000      96.5332       0.0878       0.0878       7.3985     226.8073     229.5925     230.7263     228.4587     226.8073     410.9714     410.6609     411.2819     411.2819     141.7724      35.8622       0.0861       0.0861       8.8685     147.5967       3.3269    2508.0107      60.0271      59.5862      60.3565      59.9488      64.4789      64.0757      16.6591      16.7824      16.5682      16.6809      15.5089      15.6065       0.0202       0.2799       0.2799       3.3021       0.2815    2505.0527      17.0868      17.0642     346.4375       0.1187    4409.0298    -999.2500    1234.0000       0.2863       0.2863
  353.7204       0.6945      96.0000      96.4809       0.0988       0.0988       6.3700     227.2879     229.9962     230.8450     229.1474     227.2879     412.2077     412.6611     411.7544     411.7544     147.3666      35.8690       0.0954       0.0954       6.3659     140.9960       3.3425    2492.5476      61.2429      60.3803      61.6083      60.7414      65.7688      64.8592      16.3284      16.5617      16.2316      16.4632      15.2048      15.4180       0.0202       0.2884       0.2884       3.3242       0.2809    2486.9443      16.6591      16.4540     341.6875       0.1198    4399.7065    -999.2500    1218.0000       0.2886       0.2886
  353.8728       0.6951      96.0000      96.3763       0.1003       0.1003       7.6703     228.4093     230.3747     230.3439     230.4055     228.4093     413.9684     414.5369     413.3999     413.3999     144.8694      35.8759       0.1160       0.1160       1.6811     152.7577       3.3007    2458.6797      61.5962      60.7652      61.9976      61.1548      66.2179      65.3114      16.2348      16.4568      16.1297      16.3519      15.1017      15.3113       0.0202       0.3039       0.3039       3.3124       0.2803    2484.5020      16.3284      16.0208     346.5625       0.1223    4378.1064    -999.2500    1200.0000       0.2927       0.2927
  354.0252       0.6957      96.0000      96.5855       0.1023       0.1023       5.9893     227.0956     230.2743     230.4970     230.0516     227.0956     412.3329     412.6386     412.0272     412.0272     144.1990      35.8827       0.0953       0.0953       7.5936     140.1204       3.3088    2492.8030      61.0315      60.7463      61.4756      61.1643      65.7492      65.3809      16.3850      16.4619      16.2666      16.3494      15.2093      15.2950       0.0201       0.3012       0.3012       3.2673       0.2818    2481.2224      16.2348      16.0184     341.8125       0.1194    4403.4312    -999.2500    1193.0000       0.2962       0.2962
  354.1776       0.6963      96.0000      96.4809       0.0916       0.0916       4.3819     226.0063     230.0666     229.0413     231.0919     226.0063     400.3827     395.8083     404.9571     404.9571     140.5150      35.8895       0.1014       0.1014       0.6383     139.7341       3.1983    2482.6567      60.3852      60.3333      60.9352      60.7642      65.2673      65.0244      16.5604      16.5746      16.4109      16.4571      15.3216      15.3789       0.0201       0.3042       0.3042       3.2813       0.2738    2498.8044      16.3850      15.9179     341.6875       0.1169    4424.6553    -999.2500    1208.0000       0.3036       0.3036
  354.3300       0.6971      96.0000      96.5332       0.0821       0.0821       4.3253     225.9102     229.6655     228.1405     231.1905     225.9102     397.5224     395.0962     399.9486     399.9486     145.1326      35.8964       0.0804       0.0804       2.9012     140.6768       3.3488    2517.4077      59.9569      59.5002      60.5600      60.0114      64.9803      64.3494      16.6786      16.8067      16.5126      16.6635      15.3893      15.5402       0.0201       0.3052       0.3052       3.2938       0.2657    2514.6033      16.5604      17.5304     345.5625       0.1167    4426.5381    -999.2500    1220.0000       0.3045       0.3045
  354.4824       0.6980      96.0000      96.2717       0.0713       0.0713       9.6511     225.4616     230.1082     228.6646     231.5519     225.4616     396.9977     396.2071     397.7883     397.7883     145.2245      35.9032       0.0603       0.0603      13.3203     153.3047       3.3484    2550.4961      58.6822      58.5856      59.3503      59.1818      63.8335      63.6009      17.0409      17.0690      16.8491      16.8971      15.6657      15.7230       0.0200       0.2785       0.2785       3.3552       0.2634    2532.3909      16.6786      17.9995     339.1250       0.1157    4435.3447    -999.2500    1224.0000       0.2928       0.2928
  354.6348       0.6984      96.0000      96.1671       0.0722       0.0722      10.7460     225.8141     230.2354     228.9305     231.5403     225.8141     399.8096     396.9130     402.7061     402.7061     149.2631      35.9100       0.0729       0.0729      11.7682     140.7474       3.3846    2529.6333      57.5756      57.5386      58.2432      58.2006      62.8421      62.7250      17.3685      17.3796      17.1694      17.1820      15.9129      15.9426       0.0200       0.2950       0.2950       3.2941       0.2707    2530.9006      17.0409      17.3451     342.0625       0.1165    4428.4224    -999.2500    1223.0000       0.2887       0.2887
  354.7872       0.6989      96.0000      96.3763       0.0840       0.0840       5.4978     224.4684     229.5921     228.7825     230.4016     224.4684     396.8089     395.6431     397.9747     397.9747     138.8698      35.9169       0.0824       0.0824       6.8075     153.8218       3.1841    2514.0459      57.2900      56.1846      57.9201      56.8545      62.6472      61.4709      17.4551      17.7985      17.2652      17.5888      15.9624      16.2679       0.0200       0.2947       0.2947       3.3293       0.2667    2511.3606      17.3685      17.2423     336.1250       0.1134    4454.9697    -999.2500    1229.0000       0.2895       0.2895
  354.9396       0.6999      96.0000      96.4809       0.0843       0.0843       2.1272     221.1683     226.1134     224.4616     227.7652     221.1683     393.1646     393.3194     393.0097     393.0097     140.5733      35.9237       0.0946       0.0946       0.5906     125.4345       3.4376    2493.8333      56.0465      54.4082      56.6121      55.0270      61.4031      59.7562      17.8423      18.3796      17.6641      18.1729      16.2858      16.7347       0.0199       0.3062       0.3062       3.3193       0.2683    2510.9045      17.4551      17.2636     340.0000       0.1058    4521.4429    -999.2500    1278.0000       0.2947       0.2947
  355.0920       0.7010      96.0000      96.3763       0.0752       0.0752       4.7863     217.8683     222.2919     219.5182     225.0657     217.8683     389.9871     391.6069     388.3673     388.3673     129.6797      35.9306       0.0706       0.0706       6.5305     145.1204       3.3540    2533.4814      52.8373      52.4082      53.3187      52.9703      58.1241      57.8624      18.9260      19.0810      18.7551      18.8785      17.2046      17.2824       0.0199       0.2962       0.2962       3.4055       0.2704    2525.8936      17.8423      18.4235     337.2500       0.0979    4589.9292    -999.2500    1232.0000       0.2900       0.2900
  355.2444       0.7017      96.0000      96.6901       0.0632       0.0632      10.5884     214.7284     218.3977     217.7607     219.0346     214.7284     377.1425     374.3095     379.9756     379.9756     127.4981      35.9374       0.0568       0.0568      11.7189     121.7928       3.4188    2556.2986      49.0528      50.2894      49.4394      50.7714      54.5527      55.8576      20.3862      19.8849      20.2268      19.6961      18.3309      17.9027       0.0199       0.2708       0.2708       3.3842       0.2654    2545.6826      18.9260      20.9335     332.9375       0.0902    4657.0459    -999.2500    1223.0000       0.2789       0.2789
  355.3968       0.7024      96.0000      96.5855       0.0597       0.0597       8.3571     213.8313     216.1345     215.6696     216.5994     213.8313     375.1282     373.5875     376.6689     376.6689     123.3478      35.9442       0.0646       0.0646       9.1675     116.2330       3.3664    2543.4214      46.7686      48.7104      47.0984      49.1227      52.0331      54.2305      21.3819      20.5295      21.2321      20.3572      19.2185      18.4398       0.0198       0.2622       0.2622       3.4252       0.2622    2551.5195      20.3862      21.9981     335.1250       0.0880    4676.5840    -999.2500    1215.0000       0.2726       0.2726
  355.5492       0.7032      96.0000      96.5332       0.0582       0.0582      10.3739     215.4653     217.0363     217.2884     216.7842     215.4653     377.6192     377.1448     378.0937     378.0937     126.6393      35.9511       0.0548       0.0548       8.7415     131.9048       3.4835    2559.6604      46.3311      47.9253      46.6635      48.2944      51.2312      53.2151      21.5838      20.8658      21.4300      20.7063      19.5194      18.7917       0.0198       0.2599       0.2599       3.4236       0.2595    2554.0125      21.3819      22.9565     331.9375       0.0921    4641.1182    -999.2500    1179.0000       0.2706       0.2706
  355.7016       0.7040      96.0000      96.2717       0.0685       0.0685       6.6502     216.5867     217.2912     218.2608     216.3216     216.5867     386.2795     391.5812     380.9779     380.9779     137.1207      35.9579       0.0571       0.0571      10.4074     130.5820       3.4313    2555.7847      47.2597      47.8555      47.6635      48.2349      52.0281      52.7810      21.1597      20.8962      20.9804      20.7319      19.2204      18.9462       0.0198       0.2828       0.2828       3.3421       0.2612    2536.9041      21.5838      21.2049     334.1875       0.0948    4617.0889    -999.2500    1213.0000       0.2759       0.2759
  355.8540       0.7043      96.0000      96.3763       0.0740       0.0740      11.4663     219.4702     219.2763     219.7984     218.7542     219.4702     388.5541     392.8655     384.2426     384.2426     139.0071      35.9647       0.0898       0.0898       6.1476     147.6772       3.1384    2501.8577      48.1706      48.1581      48.8685      48.5623      52.9731      52.9257      20.7595      20.7649      20.4631      20.5921      18.8775      18.8944       0.0197       0.2743       0.2743       3.2805       0.2579    2527.8889      21.1597      20.3128     329.5000       0.1018    4556.4263    -999.2500    1204.0000       0.2782       0.2782
  356.0064       0.7046      96.0000      96.5855       0.0877       0.0877       9.0995     221.5849     223.7440     227.0467     220.4413     221.5849     390.9266     394.2318     387.6214     387.6214     134.3798      35.9716       0.0771       0.0771      11.7212     138.6735       3.2883    2522.7874      48.5282      48.3504      49.2375      48.7539      53.0272      52.8376      20.6066      20.6824      20.3097      20.5112      18.8582      18.9259       0.0197       0.2734       0.2734       3.2451       0.2573    2505.2517      20.7595      20.3959     333.1250       0.1068    4512.9438    -999.2500    1199.0000       0.2830       0.2830
  356.1588       0.7053      96.0000      96.5332       0.0885       0.0885      12.0685     222.3218     224.5052     227.6291     221.3814     222.3218     391.6895     395.6045     387.7744     387.7744     129.0921      35.9784       0.0939       0.0939      10.8872     117.1336       3.3083    2495.1316      47.8071      48.3933      48.6041      48.9556      52.1633      52.7505      20.9174      20.6640      20.5744      20.4267      19.1706      18.9572       0.0197       0.2964       0.2964       3.3701       0.2552    2504.0212      20.6066      19.4993     327.5000       0.1085    4497.9854    -999.2500    1199.0000       0.2894       0.2894
  356.3112       0.7060      96.0000      96.5855       0.0907       0.0907      10.5471     222.2256     224.1744     227.0388     221.3099     222.2256     394.2410     396.2640     392.2180     392.2180     126.9630      35.9852       0.0943       0.0943      11.0050     131.7272       3.5087    2494.4336      47.3792      48.4659      48.1821      49.2983      51.3910      52.9254      21.1063      20.6331      20.7546      20.2847      19.4587      18.8945       0.0196       0.3181       0.3181       3.3432       0.2636    2500.2751      20.9174      19.7666     332.5625       0.1083    4499.9307    -999.2500    1195.0000       0.3058       0.3058
  356.4636       0.7065      96.0000      96.4809       0.0824       0.0824       7.7233     220.9441     222.3335     224.8145     219.8525     220.9441     394.8722     396.6925     393.0519     393.0519     132.1342      35.9921       0.0840       0.0840       9.1469     131.9412       3.2059    2511.3230      48.3449      48.5026      49.1646      49.3944      52.5744      52.9648      20.6847      20.6175      20.3399      20.2452      19.0207      18.8805       0.0196       0.3214       0.3214       3.3585       0.2690    2514.1128      21.1063      21.4555     327.9375       0.1053    4526.0322    -999.2500    1185.0000       0.3128       0.3128
  356.6160       0.7071      96.0000      96.5332       0.0729       0.0729       2.4163     220.0470     220.6125     222.0975     219.1275     220.0470     395.1094     396.0408     394.1780     394.1780     144.9545      35.9989       0.0662       0.0662       5.4534     132.4689       3.3565    2540.7561      50.6789      48.4555      51.4319      49.2827      55.2294      52.9481      19.7321      20.6375      19.4432      20.2911      18.1063      18.8864       0.0196       0.3093       0.3093       3.3037       0.2736    2529.6416      20.6847      23.5677     330.2500       0.1032    4544.4849    -999.2500    1240.0000       0.3223       0.3223
  356.7684       0.7085      96.0000      96.4809       0.0666       0.0666       1.0048     221.3285     223.4548     224.8026     222.1071     221.3285     398.1626     394.0072     402.3180     402.3180     192.2052      36.0058       0.0612       0.0612       3.1427     170.2751       3.3556    2549.0959      51.4475      47.8835      52.0519      48.5862      55.8858      52.4647      19.4373      20.8840      19.2116      20.5820      17.8936      19.0604       0.0195       0.3178       0.3178       3.3760       0.2830    2540.0991      19.7321      22.6874     328.1875       0.1062    4518.1704    -999.2500    1239.0000       0.3187       0.3187
  356.9208       0.7098      96.0000      96.2194       0.0672       0.0672       1.6349     227.4481     229.5520     232.2476     226.8565     227.4481     415.1535     417.5576     412.7494     412.7494     230.3331      36.0126       0.0670       0.0670       2.6442     272.7112       3.4192    2539.4548      49.5300      46.1884      49.9609      46.7610      54.1507      50.6448      20.1898      21.6505      20.0156      21.3853      18.4670      19.7453       0.0195       0.3293       0.3293       3.3831       0.2820    2539.0637      19.4373      23.5335     331.9375       0.1201    4396.6079    -999.2500    1253.0000       0.3231       0.3231
  357.0732       0.7121      96.0000      96.4809       0.0626       0.0626       4.8302     229.6908     231.1702     232.2147     230.1256     229.6908     424.1824     426.6541     421.7108     421.7108     221.3654      36.0194       0.0713       0.0713       1.0823     247.0310       3.3945    2532.3862      46.6861      42.4791      46.9610      42.9702      51.9974      47.1593      21.4196      23.5410      21.2943      23.2719      19.2317      21.2047       0.0195       0.3427       0.3427       3.4117       0.2891    2546.7522      20.1898      21.1972     333.7500       0.1251    4353.6782    -999.2500    1256.0000       0.3247       0.3247
  357.2256       0.7144      96.0000      96.4809       0.0497       0.0497       6.7744     227.8646     230.2730     231.3469     229.1991     227.8646     416.0616     417.2144     414.9088     414.9088     174.0862      36.0263       0.0511       0.0511       6.0894     143.3720       3.4293    2565.6411      40.4087      36.5250      40.6188      36.9093      46.3738      41.9094      24.7472      27.3785      24.6192      27.0935      21.5639      23.8610       0.0194       0.3723       0.3723       3.3364       0.2841    2567.9900      21.4196      23.3854     331.9375       0.1211    4388.5713    -999.2500    1229.0000       0.3256       0.3256
  357.3780       0.7160      96.0000      96.4809       0.0256       0.0256      11.1092     219.0858     221.8598     228.0910     215.6287     219.0858     399.4601     395.5015     403.4188     403.4188     136.5220      36.0331       0.0247       0.0247      12.2933     131.8555       3.1814    2609.2432      29.9190      30.5298      30.1000      30.5868      35.8972      35.8924      33.4236      32.7548      33.2226      32.6939      27.8573      27.8611       0.0194       0.3336       0.3336       3.2543       0.2909    2607.7749      24.7472      37.8848     335.3750       0.1009    4564.4224    -999.2500    1243.0000       0.3103       0.3103
  357.5304       0.7175      96.0000      96.5332       0.0157       0.0157       8.8081     204.6360     213.8241     213.7451     213.9031     204.6360     371.6855     366.4622     376.9089     376.9089     143.4876      36.0399      -0.0029      -0.0029      17.5564     136.0200       3.1388    2654.7173      18.3995      23.4984      18.7575      23.9399      24.9131      29.4281      54.3492      42.5561      53.3120      41.7713      40.1395      33.9811       0.0194       0.2776       0.2776       3.2133       0.2910    2624.0439      33.4236      74.0983     326.8125       0.0639    4886.7261    -999.2500    1248.0000       0.2755       0.2755
  357.6828       0.7165      96.0000      96.3763       0.0044       0.0044      10.6411     196.1776     195.6173     195.8635     195.3710     196.1776     337.8227     331.2348     344.4106     344.4106     155.4782      36.0468       0.0194       0.0194       4.8803     164.2689       3.3036    2617.9546      11.8770      18.0386      11.9257      18.4507      18.4073      24.5678      84.1962      55.4365      83.8524      54.1986      54.3262      40.7038       0.0193       0.2160       0.2160       3.3215       0.2599    2642.7983      54.3492     106.5052     335.1250       0.0397    5097.4229    -999.2500    1242.0000       0.2467       0.2467
  357.8352       0.7155      96.0000      96.6901       0.0128       0.0128       7.5487     194.4154     194.9237     195.2763     194.5711     194.4154     339.6695     331.2176     348.1215     348.1215     164.5975      36.0536      -0.0052      -0.0052      12.2865     167.9592       3.5333    2658.5908      10.6868      15.7773      10.5205      16.0542      16.8612      22.5372      93.5730      63.3821      95.0522      62.2891      59.3077      44.3711       0.0193       0.1899       0.1899       3.4515       0.2734    2628.8486      84.1962     112.1694     326.3750       0.0344    5143.6255    -999.2500    1237.0000       0.2212       0.2212
  357.9876       0.7142      96.0000      96.5855       0.0276       0.0276       8.6021     199.8621     196.8920     197.5454     196.2386     199.8621     358.5996     358.9478     358.2514     358.2514     158.9407      36.0605       0.0227       0.0227       7.2221     161.6963       3.5114    2612.5461      12.8115      16.5042      13.0783      16.8504      19.1296      23.1928      78.0547      60.5906      76.4625      59.3459      52.2751      43.1168       0.0193       0.1872       0.1872       3.3755       0.2741    2604.4480      93.5730      91.9806     335.0625       0.0505    5003.4497    -999.2500    1239.0000       0.2144       0.2144
  358.1400       0.7129      96.0000      96.6901       0.0496       0.0496      10.5016     206.2059     205.0085     197.8139     212.2032     206.2059     370.1304     366.3491     373.9117     373.9117     152.8134      36.0673       0.0616       0.0616       6.8975     147.2254       3.1024    2548.4014      17.4748      19.1535      18.3082      19.8053      23.9719      25.8585      57.2252      52.2099      54.6202      50.4916      41.7155      38.6720       0.0192       0.2195       0.2195       3.3546       0.2815    2568.2087      78.0547      61.0972     330.2500       0.0681    4849.5215    -999.2500    1239.0000       0.2194       0.2194
  358.2924       0.7128      96.0000      96.2194       0.0552       0.0552      13.7865     210.0827     214.1062     212.1869     216.0255     210.0827     376.1892     372.3495     380.0289     380.0289     142.5887      36.0741       0.0647       0.0647      13.3797     149.4454       3.4618    2543.3027      23.3200      22.9138      24.4143      23.8874      29.7051      29.5530      42.8817      43.6418      40.9595      41.8630      33.6642      33.8375       0.0192       0.2716       0.2716       3.3395       0.2800    2558.8870      57.2252      37.8913     333.4375       0.0784    4760.0308    -999.2500    1237.0000       0.2427       0.2427
  358.4448       0.7126      96.0000      96.3763       0.0477       0.0477      14.6039     212.9342     215.0253     214.4484     215.6023     212.9342     377.1675     374.7491     379.5860     379.5860     141.5350      36.0810       0.0419       0.0419      15.1489     131.0222       3.4772    2580.8777      28.3415      26.9906      29.4301      27.9700      34.3269      33.2928      35.2839      37.0500      33.9789      35.7526      29.1317      30.0365       0.0192       0.2824       0.2824       3.3917       0.2704    2571.3745      42.8817      32.5449     332.3750       0.0857    4696.2861    -999.2500    1235.0000       0.2580       0.2580
  358.5972       0.7124      96.0000      96.6901       0.0471       0.0471       7.6953     213.1905     216.1111     216.8934     215.3288     213.1905     375.8183     375.8122     375.8244     375.8244     128.6995      36.0878       0.0377       0.0377      10.2043     145.1631       3.2447    2587.8340      32.0504      30.9490      33.0080      32.0488      37.6096      36.9580      31.2008      32.3112      30.2957      31.2024      26.5890      27.0578       0.0191       0.2613       0.2613       3.3219       0.2628    2572.3206      35.2839      32.3314     331.9375       0.0864    4690.6401    -999.2500    1241.0000       0.2637       0.2637
  358.7496       0.7122      96.0000      96.6901       0.0463       0.0463       6.9327     215.1449     217.7003     216.9208     218.4799     215.1449     376.9464     377.6406     376.2522     376.2522     128.3839      36.0946       0.0590       0.0590      -0.0885     110.9389       3.2382    2552.5791      35.5733      34.2387      36.4185      35.2422      40.7755      39.8460      28.1110      29.2067      27.4586      28.3751      24.5245      25.0966       0.0191       0.2644       0.2644       3.2494       0.2571    2573.5332      31.2008      27.8653     332.7500       0.0913    4648.0298    -999.2500    1268.0000       0.2610       0.2610
  358.9020       0.7124      96.0000      96.5332       0.0535       0.0535       7.8399     217.3877     218.0306     213.5983     222.4629     217.3877     380.2361     379.9850     380.4872     380.4872     134.7036      36.1015       0.0418       0.0418      10.4888     130.0755       3.2536    2580.9497      38.6064      36.6563      39.3872      37.5406      43.5574      41.8995      25.9025      27.2804      25.3890      26.6378      22.9582      23.8666       0.0191       0.2600       0.2600       3.2474       0.2577    2561.7114      28.1110      28.5744     329.1250       0.0968    4600.0767    -999.2500    1277.0000       0.2594       0.2594
  359.0544       0.7127      96.0000      96.5855       0.0550       0.0550      12.3857     217.1314     219.9033     218.4486     221.3581     217.1314     377.2500     376.5997     377.9004     377.9004     141.9655      36.1083       0.0596       0.0596      11.6469     164.6447       3.2255    2551.6885      40.0868      38.0391      40.8625      38.8423      44.9315      43.0141      24.9458      26.2887      24.4723      25.7451      22.2561      23.2482       0.0190       0.2636       0.2636       3.2948       0.2536    2559.2532      25.9025      26.5697     334.0625       0.0962    4605.5068    -999.2500    1291.0000       0.2580       0.2580
  359.2068       0.7136      96.0000      96.3763       0.0606       0.0606      10.1420     217.0352     217.6712     218.3598     216.9827     217.0352     378.3900     380.3904     376.3897     376.3897     141.2096      36.1152       0.0656       0.0656       9.5331     132.7245       3.3876    2541.7656      39.7309      38.3668      40.5724      39.1604      44.6281      43.2310      25.1693      26.0642      24.6473      25.5360      22.4074      23.1316       0.0190       0.2531       0.2531       3.2428       0.2509    2550.0129      24.9458      26.5529     326.3750       0.0959    4607.5464    -999.2500    1221.0000       0.2547       0.2547
  359.3592       0.7145      96.0000      96.1671       0.0615       0.0615       7.3532     216.4265     216.4823     218.5099     214.4546     216.4265     383.1330     390.5990     375.6671     375.6671     131.0930      36.1220       0.0583       0.0583       6.5140     127.5860       3.0974    2553.8276      38.3910      37.8531      39.3238      38.7122      43.4335      42.7704      26.0478      26.4179      25.4299      25.8316      23.0237      23.3807       0.0190       0.2363       0.2363       3.1850       0.2516    2548.5059      25.1693      27.2950     333.9375       0.0944    4620.5063    -999.2500    1229.0000       0.2518       0.2518
  359.5116       0.7147      96.0000      96.3763       0.0645       0.0645       3.6145     215.8498     216.2670     217.9075     214.6263     215.8498     383.3701     389.9535     376.7867     376.7867     131.1066      36.1288       0.0618       0.0618       5.0183     132.7469       3.0748    2548.0854      36.9040      37.1376      37.9180      37.9745      42.1497      42.1175      27.0973      26.9269      26.3727      26.3334      23.7249      23.7431       0.0189       0.2555       0.2555       3.1326       0.2558    2543.6477      26.0478      27.1968     327.1875       0.0930    4632.8516    -999.2500    1234.0000       0.2530       0.2530
  359.6640       0.7150      96.0000      96.5855       0.0597       0.0597       6.7620     215.3692     215.6089     217.1758     214.0420     215.3692     377.1770     377.1773     377.1767     377.1767     133.3004      36.1357       0.0687       0.0687       5.8670     132.7653       3.2344    2536.6165      35.1436      36.2846      36.1139      37.3258      40.3802      41.5442      28.4547      27.5599      27.6901      26.7912      24.7646      24.0708       0.0189       0.2590       0.2590       3.1525       0.2581    2551.5730      27.0973      27.5869     331.9375       0.0918    4643.1895    -999.2500    1187.0000       0.2535       0.2535
  359.8164       0.7149      96.0000      96.3763       0.0566       0.0566       9.5029     216.8110     216.1891     217.5764     214.8018     216.8110     378.9399     379.7847     378.0951     378.0951     140.2564      36.1425       0.0458       0.0458      11.5018     134.4604       3.1585    2574.4561      33.6596      35.8992      34.4726      36.9249      38.7682      41.2648      29.7092      27.8557      29.0086      27.0820      25.7944      24.2337       0.0189       0.2473       0.2473       3.2307       0.2550    2556.5808      28.4547      32.2339     330.6875       0.0954    4612.3130    -999.2500    1228.0000       0.2541       0.2541
  359.9688       0.7149      96.0000      96.5855       0.0584       0.0584       7.8492     219.2780     221.7161     227.3563     216.0759     219.2780     386.7157     392.1661     381.2654     381.2654     152.2792      36.1493       0.0554       0.0554       9.5133     153.6148       3.3291    2558.5076      35.0749      35.6601      35.8736      36.6712      40.4480      41.1380      28.5104      28.0425      27.8756      27.2694      24.7231      24.3085       0.0188       0.2399       0.2399       3.2765       0.2529    2553.6836      29.7092      34.3316     333.6250       0.1013    4560.4209    -999.2500    1226.0000       0.2596       0.2596
  360.1212       0.7174      96.0000      96.3763       0.0676       0.0676       2.0954     222.9946     224.5679     227.4342     221.7016     222.9946     391.8625     394.3866     389.3384     389.3384     157.2373      36.1562       0.0740       0.0740       0.4924     169.0158       3.3483    2527.9084      40.0052      35.4726      40.8795      36.3325      45.7703      41.0795      24.9968      28.1907      24.4621      27.5236      21.8482      24.3430       0.0188       0.2912       0.2912       3.3386       0.2559    2538.4390      28.5104      27.6556     340.4375       0.1101    4484.4136    -999.2500    1227.0000       0.2794       0.2794
  360.2736       0.7200      96.0000      96.3763       0.0676       0.0676       0.5719     224.5004     226.4530     229.1241     223.7819     224.5004     410.4719     413.0302     407.9137     407.9137     150.2994      36.1630       0.0698       0.0698       1.5813     149.2635       3.3463    2534.8364      41.1833      34.1478      41.9855      34.9432      47.0186      39.8824      24.2817      29.2845      23.8177      28.6179      21.2682      25.0737       0.0188       0.3347       0.3347       3.2887       0.2827    2538.4739      24.9968      25.8962     334.3125       0.1135    4454.3340    -999.2500    1229.0000       0.2983       0.2983
  360.4260       0.7220      96.0000      96.4809       0.0559       0.0559       4.1821     218.3809     220.8936     227.5717     214.2155     218.3809     393.6262     394.8632     392.3892     392.3892     136.3492      36.1699       0.0553       0.0553       3.1679     132.8009       3.1586    2558.7317      34.9729      30.5019      35.6488      31.2944      41.3823      36.3272      28.5936      32.7848      28.0514      31.9546      24.1649      27.5276       0.0187       0.3492       0.3492       3.3173       0.2756    2557.8157      24.2817      27.6292     341.6875       0.0992    4579.1553    -999.2500    1213.0000       0.3223       0.3223
  360.5784       0.7241      96.0000      96.5332       0.0361       0.0361       9.3614     209.1215     209.1444     209.4905     208.7983     209.1215     372.8051     365.0972     380.5132     380.5132     118.3224      36.1767       0.0431       0.0431       6.1604     125.8323       3.4411    2578.9534      25.0970      25.0449      25.6152      25.6397      31.8055      31.3651      39.8454      39.9282      39.0393      39.0020      31.4411      31.8826       0.0187       0.3522       0.3522       3.3436       0.2836    2590.4441      28.5936      42.1037     331.9375       0.0759    4781.9092    -999.2500    1220.0000       0.3130       0.3130
  360.7308       0.7241      96.0000      96.2194       0.0232       0.0232       9.5217     201.3359     198.4650     199.4085     197.5214     201.3359     360.2058     356.1777     364.2339     364.2339     113.0775      36.1835       0.0113       0.0113      14.3397      95.1831       3.4382    2631.3384      15.6988      20.1090      16.3105      20.8156      22.4164      26.5949      63.6991      49.7290      61.3102      48.0410      44.6102      37.6012       0.0187       0.2670       0.2670       3.4119       0.2800    2611.6885      39.8454      85.2369     338.5000       0.0547    4966.8237    -999.2500    1210.0000       0.2800       0.2800
  360.8832       0.7241      96.0000      96.6901       0.0091       0.0091      14.6461     195.0562     196.3435     197.5889     195.0980     195.0562     349.2140     347.6833     350.7447     350.7447     122.3122      36.1904       0.0116       0.0116      12.9989     117.0664       3.3523    2630.7920      10.4859      15.2602      10.7899      15.9543      17.4271      21.9961      95.3662      65.5300      92.6790      62.6790      57.3820      45.4626       0.0186       0.2174       0.2174       3.3971       0.2761    2635.0576      63.6991     109.2996     330.3125       0.0363    5126.7280    -999.2500    1240.0000       0.2447       0.2447
  361.0356       0.7241      96.0000      96.5332       0.0047       0.0047      13.2955     193.8387     196.1734     197.9448     194.4020     193.8387     347.8281     345.9856     349.6705     349.6705     131.6693      36.1972       0.0047       0.0047      14.1944     155.1066       3.3838    2642.2588       9.5615      12.4214       9.7296      12.8871      16.1834      19.5191     104.5858      80.5061     102.7790      77.5967      61.7918      51.2319       0.0186       0.2254       0.2254       3.3741       0.2782    2642.2942      95.3662      95.9132     331.0625       0.0326    5158.9287    -999.2500    1221.0000       0.2280       0.2280
  361.1880       0.7240      96.0000      96.3763      -0.0058      -0.0058      14.1427     193.4542     195.4640     196.9044     194.0235     193.4542     345.8534     342.2946     349.4122     349.4122     135.7384      36.2040      -0.0049      -0.0049      13.5869     123.2544       3.3458    2658.1448       9.8226      12.1205      10.1370      12.4920      16.3746      18.9486     101.8056      82.5047      98.6484      80.0510      61.0701      52.7744       0.0186       0.2217       0.2217       3.4050       0.2790    2659.6040     104.5858      96.0719     335.2500       0.0314    5169.1816    -999.2500    1235.0000       0.2208       0.2208
  361.3404       0.7222      96.0000      96.4809      -0.0014      -0.0014       6.7669     193.2940     196.0791     195.5169     196.6413     193.2940     339.7600     330.7092     348.8108     348.8108     127.0382      36.2109      -0.0165      -0.0165      11.6189     129.2737       3.4741    2677.2573      10.8508      13.3454      11.3431      13.8744      17.3947      20.1150      92.1592      74.9322      88.1591      72.0754      57.4887      49.7141       0.0186       0.1930       0.1930       3.6379       0.2784    2652.3286     101.8056     103.8545     330.0625       0.0309    5173.4658    -999.2500    1224.0000       0.2134       0.2134
  361.4928       0.7203      96.0000      96.2194       0.0146       0.0146       9.7040     196.7543     198.8617     196.4906     201.2329     196.7543     351.5737     348.0345     355.1128     355.1128     134.0126      36.2177       0.0051       0.0051      13.1630     129.7319       4.1509    2641.6311      14.0519      15.7796      14.8498      16.5587      20.7371      22.6135      71.1645      63.3730      67.3409      60.3912      48.2228      44.2213       0.0185       0.1818       0.1818       3.7154       0.2785    2625.8726      92.1592      91.3753     337.6250       0.0414    5082.4814    -999.2500    1226.0000       0.2105       0.2105
  361.6452       0.7202      96.0000      96.3763       0.0357       0.0357       7.6731     201.2398     200.4684     195.3688     205.5679     201.2398     364.0102     360.7735     367.2469     367.2469     130.7839      36.2245       0.0495       0.0495       5.4740     144.1777       3.5923    2568.2795      19.3204      18.9800      20.4082      19.9508      26.0108      25.8413      51.7587      52.6871      49.0000      50.1232      38.4456      38.6978       0.0185       0.2172       0.2172       3.5789       0.2854    2591.0898      71.1645      51.0637     329.8750       0.0544    4969.1963    -999.2500    1195.0000       0.2189       0.2189
  361.7976       0.7200      96.0000      96.0625       0.0452       0.0452      11.5601     207.0710     204.5892     198.1662     211.0122     207.0710     369.7754     365.1401     374.4106     374.4106     130.8131      36.2314       0.0449       0.0449      11.0168     119.5875       3.0976    2575.8511      24.0418      22.3647      25.0872      23.4056      30.5613      29.1016      41.5942      44.7134      39.8609      42.7247      32.7212      34.3624       0.0185       0.2763       0.2763       3.2695       0.2797    2575.4060      51.7587      38.6253     335.3750       0.0705    4829.2617    -999.2500    1223.0000       0.2420       0.2420
  361.9500       0.7201      96.0000      96.5855       0.0509       0.0509       5.2141     211.2681     213.6559     215.2042     212.1077     211.2681     374.8362     373.6742     375.9983     375.9983     121.4547      36.2382       0.0477       0.0477       6.5051     128.3646       3.1382    2571.3594      26.7936      25.3872      27.7905      26.4454      32.9167      31.9220      37.3224      39.3899      35.9835      37.8138      30.3798      31.3264       0.0184       0.2809       0.2809       3.2023       0.2693    2566.0007      41.5942      35.9406     332.5625       0.0815    4733.3213    -999.2500    1248.0000       0.2576       0.2576
  362.1024       0.7202      96.0000      96.4809       0.0515       0.0515       6.1612     212.1973     215.3008     216.4243     214.1772     212.1973     375.4854     374.8341     376.1366     376.1366     123.8312      36.2451       0.0554       0.0554       6.8170     117.9954       3.3636    2558.5505      28.3834      27.8640      29.3026      28.9006      33.9452      34.0293      35.2318      35.8886      34.1267      34.6013      29.4593      29.3865       0.0184       0.2652       0.2652       3.2556       0.2666    2564.9443      37.3224      32.9794     333.5000       0.0839    4712.5957    -999.2500    1228.0000       0.2608       0.2608
  362.2548       0.7211      96.0000      96.5332       0.0552       0.0552       3.5886     213.1264     216.1526     216.3485     215.9566     213.1264     375.4391     375.4651     375.4132     375.4132     121.9921      36.2519       0.0530       0.0530       4.0292     126.7170       3.2683    2562.4998      30.2026      29.7848      31.0879      30.7646      35.3936      35.4234      33.1098      33.5742      32.1668      32.5049      28.2537      28.2299       0.0184       0.2632       0.2632       3.3174       0.2622    2558.8838      35.2318      31.1818     339.5000       0.0862    4692.0503    -999.2500    1235.0000       0.2574       0.2574
  362.4072       0.7220      96.0000      96.4809       0.0543       0.0543       4.6997     214.0235     217.4995     216.9945     218.0045     214.0235     376.0987     376.0804     376.1170     376.1170     132.9643      36.2587       0.0554       0.0554       2.6225     123.1569       3.3097    2558.5083      32.2693      30.8286      33.1011      31.6665      37.4415      36.1410      30.9892      32.4374      30.2105      31.5791      26.7083      27.6694       0.0183       0.2571       0.2571       3.2786       0.2606    2560.4177      33.1098      32.1917     330.7500       0.0885    4672.3833    -999.2500    1265.0000       0.2553       0.2553
  362.5596       0.7223      96.0000      96.5332       0.0575       0.0575       3.0177     214.0235     217.8040     216.5419     219.0661     214.0235     373.9126     372.7014     375.1237     375.1237     133.2623      36.2656       0.0571       0.0571       2.9149     149.2063       3.2512    2555.8154      33.0617      31.0586      33.8330      31.8386      38.0676      36.1685      30.2465      32.1972      29.5569      31.4084      26.2690      27.6484       0.0183       0.2475       0.2475       3.2133       0.2587    2555.1819      30.9892      32.5330     337.4375       0.0885    4672.3833    -999.2500    1265.0000       0.2461       0.2461
  362.7120       0.7225      96.0000      96.5332       0.0589       0.0589       5.4090     213.9915     217.6520     217.0060     218.2980     213.9915     378.3621     376.9482     379.7760     379.7760     134.4949      36.2724       0.0586       0.0586       5.3787     127.6110       3.0741    2553.2625      32.0240      30.9644      32.7511      31.7847      36.7778      35.9146      31.2265      32.2952      30.5333      31.4617      27.1903      27.8438       0.0183       0.2307       0.2307       3.2377       0.2674    2552.8743      30.2465      33.0860     329.1875       0.0884    4673.0830    -999.2500    1260.0000       0.2370       0.2370
  362.8644       0.7220      96.0000      96.5855       0.0576       0.0576       5.6608     212.9022     214.9043     215.5059     214.3027     212.9022     374.8339     376.2921     373.3757     373.3757     127.6533      36.2792       0.0627       0.0627       6.9801     127.3099       3.3953    2546.5010      30.9446      30.9747      31.6710      31.6603      35.8466      35.7836      32.3158      32.2845      31.5746      31.5853      27.8966      27.9457       0.0182       0.2230       0.2230       3.2116       0.2591    2554.9771      31.2265      35.3320     334.3750       0.0856    4696.9932    -999.2500    1233.0000       0.2341       0.2341
  363.0168       0.7215      96.0000      96.4809       0.0639       0.0639       5.7285     213.8954     214.8455     215.6678     214.0231     213.8954     375.7265     377.9734     373.4797     373.4797     126.1594      36.2861       0.0484       0.0484      11.5799     128.4944       3.1714    2570.1748      30.4672      30.9841      31.1968      31.7643      35.5507      35.9328      32.8222      32.2746      32.0546      31.4819      28.1288      27.8297       0.0182       0.2219       0.2219       3.2208       0.2560    2544.5823      32.3158      40.8100     337.1250       0.0882    4675.1826    -999.2500    1247.0000       0.2356       0.2356
  363.1692       0.7219      96.0000      96.1671       0.0728       0.0728       0.9735     215.5935     217.3306     218.2288     216.4324     215.5935     381.2741     388.1881     374.3600     374.3600     128.1084      36.2929       0.0817       0.0817      -1.4578     123.1292       3.0986    2515.1931      29.0397      31.6165      29.7517      32.4140      33.8756      36.5392      34.4356      31.6290      33.6115      30.8509      29.5198      27.3678       0.0182       0.2364       0.2364       3.1149       0.2519    2529.8689      32.8222      34.6549     331.9375       0.0924    4638.3594    -999.2500    1251.0000       0.2462       0.2462
  363.3216       0.7222      96.0000      96.3763       0.0896       0.0896       1.7531     218.7974     219.4769     218.3558     220.5980     218.7974     387.1916     393.0972     381.2860     381.2860     129.5452      36.2998       0.0825       0.0825       2.1135     132.0816       3.0760    2513.8823      27.6394      32.6503      28.0802      33.3295      32.3372      37.6428      36.1803      30.6276      35.6123      30.0035      30.9242      26.5655       0.0181       0.2648       0.2648       3.1303       0.2545    2502.1284      34.4356      29.3889     339.1875       0.1002    4570.4380    -999.2500    1242.0000       0.2586       0.2586
  363.4740       0.7234      96.0000      96.3763       0.0924       0.0924       3.8086     222.8024     225.4702     227.0014     223.9389     222.8024     410.3518     413.7828     406.9208     406.9208     137.4084      36.3066       0.1073       0.1073      -0.0570     132.8049       3.2164    2473.0183      34.2145      34.1719      34.7240      34.7748      38.7088      38.8637      29.2273      29.2638      28.7986      28.7565      25.8339      25.7309       0.0181       0.2892       0.2892       3.1293       0.2859    2497.5356      36.1803      28.4423     332.0625       0.1096    4488.2832    -999.2500    1225.0000       0.2802       0.2802
  363.6264       0.7246      96.0000      96.5855       0.0911       0.0911       6.6612     224.4043     226.1164     228.3463     223.8865     224.4043     413.4411     416.0808     410.8015     410.8015     141.5125      36.3134       0.0866       0.0866       8.3238     146.7186       3.1040    2507.1033      42.0156      34.9629      42.5639      35.3923      46.8916      39.6922      23.8007      28.6018      23.4941      28.2547      21.3258      25.1939       0.0181       0.3062       0.3062       3.1842       0.2873    2499.7324      29.2273      26.6819     341.6875       0.1133    4456.2422    -999.2500    1229.0000       0.2934       0.2934
  363.7788       0.7261      96.0000      96.6901       0.0808       0.0808       4.2387     225.5257     226.3501     229.0152     223.6850     225.5257     417.0088     422.1075     411.9102     411.9102     153.4175      36.3203       0.0822       0.0822       4.3137     144.3458       3.2401    2514.3950      42.1512      34.3333      42.6576      34.6927      46.5871      39.1066      23.7241      29.1262      23.4425      28.8245      21.4652      25.5711       0.0180       0.3204       0.3204       3.2153       0.2859    2516.6575      23.8007      28.7645     334.6250       0.1158    4434.0845    -999.2500    1225.0000       0.3103       0.3103
  363.9312       0.7277      96.0000      96.2717       0.0689       0.0689       8.1263     226.1024     228.6419     232.0126     225.2712     226.1024     417.8794     423.1346     412.6243     412.6243     172.1132      36.3271       0.0707       0.0707       3.8816     168.5200       3.3143    2533.4236      34.9534      31.8408      35.3384      32.2521      39.9663      36.2153      28.6095      31.4062      28.2979      31.0057      25.0211      27.6126       0.0180       0.3320       0.3320       3.3024       0.2854    2536.3921      23.7241      35.6614     340.3125       0.1171    4422.7744    -999.2500    1253.0000       0.3194       0.3194
  364.0836       0.7301      96.0000      96.3763       0.0616       0.0616      10.4908     220.3674     223.5565     228.2942     218.8188     220.3674     410.8714     410.0385     411.7043     411.7043     188.6912      36.3339       0.0552       0.0552      15.2011     202.8057       3.3703    2558.9224      26.7826      27.0400      27.0688      27.4569      32.2634      32.0775      37.3377      36.9823      36.9429      36.4208      30.9948      31.1745       0.0180       0.3541       0.3541       3.2540       0.2992    2548.3262      28.6095      40.5050     343.6250       0.1039    4537.8774    -999.2500    1245.0000       0.3269       0.3269
  364.2360       0.7324      96.0000      96.3763       0.0578       0.0578       9.1586     213.6391     217.8110     219.5985     216.0234     213.6391     390.9503     388.6303     393.2703     393.2703     180.5582      36.3408       0.0612       0.0612      10.3839     194.7480       3.0943    2548.9756      20.2522      22.3123      20.5363      22.7108      25.8513      27.7093      49.3774      44.8184      48.6943      44.0318      38.6828      36.0889       0.0179       0.3511       0.3511       3.2432       0.2907    2554.7041      37.3377      46.4061     331.9375       0.0875    4680.7920    -999.2500    1245.0000       0.3161       0.3161
  364.3884       0.7332      96.0000      96.3763       0.0507       0.0507       2.8862     208.2564     212.2839     210.8756     213.6922     208.2564     369.4816     362.7165     376.2468     376.2468     156.0735      36.3476       0.0582       0.0582       1.3044     144.1210       3.2807    2553.9949      15.1417      17.7624      15.4123      18.0829      21.1716      23.3654      66.0427      56.2986      64.8831      55.3010      47.2330      42.7984       0.0179       0.2944       0.2944       3.2109       0.2792    2566.3586      49.3774      70.8362     334.3750       0.0736    4801.7720    -999.2500    1257.0000       0.2884       0.2884
  364.5408       0.7341      96.0000      96.7948       0.0387       0.0387       2.5298     206.2379     211.9172     213.1465     210.6879     206.2379     365.1411     365.4473     364.8348     364.8348     138.5935      36.3545       0.0282       0.0282       4.1240     129.3516       3.2785    2603.4441      11.8614      13.6259      12.1977      13.9297      18.2532      19.6633      84.3074      73.3897      81.9824      71.7889      54.7849      50.8561       0.0179       0.2257       0.2257       3.2471       0.2652    2586.0879      66.0427      87.3920     328.2500       0.0682    4848.7681    -999.2500    1236.0000       0.2550       0.2550
  364.6932       0.7340      96.0000      96.3763       0.0251       0.0251       7.8894     207.7118     211.5830     213.9794     209.1866     207.7118     368.8656     367.0149     370.7162     370.7162     135.6301      36.3613       0.0278       0.0278       5.4368     142.3079       3.1865    2604.1069       9.4674      10.6233       9.9805      10.9469      16.2142      16.9930     105.6254      94.1328     100.1957      91.3505      61.6743      58.8478       0.0178       0.2262       0.2262       3.2578       0.2712    2608.6301      84.3074      95.6519     323.7500       0.0722    4814.3638    -999.2500    1226.0000       0.2417       0.2417
  364.8456       0.7340      96.0000      96.5855       0.0220       0.0220      13.8971     207.9681     209.7693     211.1842     208.3544     207.9681     369.6468     362.8283     376.4653     376.4653     137.6221      36.3681       0.0188       0.0188      14.8119     134.3384       3.3062    2618.9958       7.4140       8.6069       8.0696       9.0390      14.4838      15.2740     134.8794     116.1859     123.9220     110.6321      69.0427      65.4706       0.0178       0.2386       0.2386       3.2537       0.2804    2613.6372     105.6254     110.9674     327.6250       0.0729    4808.4302    -999.2500    1247.0000       0.2351       0.2351
  364.9980       0.7335      96.0000      96.6901       0.0285       0.0285      10.5929     210.0506     208.6062     209.0489     208.1635     210.0506     370.5340     363.2792     377.7888     377.7888     135.0473      36.3750       0.0258       0.0258      10.7953     135.3274       3.2591    2607.3755       5.9113       7.4409       6.5796       8.0023      13.1025      14.4174     169.1663     134.3917     151.9841     124.9645      76.3212      69.3607       0.0178       0.2299       0.2299       3.2673       0.2763    2602.9243     134.8794     128.8958     322.1875       0.0783    4760.7568    -999.2500    1237.0000       0.2351       0.2351
  365.1504       0.7330      96.0000      96.4809       0.0253       0.0253      12.1611     204.7641     205.2952     208.4257     202.1648     204.7641     367.4665     362.8492     372.0838     372.0838     126.9535      36.3818       0.0403       0.0403       6.4157     134.5837       3.2175    2583.5242       5.3864       7.1770       6.0378       7.8795      12.5493      14.4033     185.6511     139.3337     165.6236     126.9121      79.6860      69.4284       0.0177       0.2363       0.2363       3.2647       0.2828    2608.2471     169.1663     181.7528     331.9375       0.0642    4883.6675    -999.2500    1271.0000       0.2288       0.2288
  365.3028       0.7319      96.0000      96.5332       0.0228       0.0228       6.4221     201.5282     203.6457     208.1282     199.1633     201.5282     360.5318     359.0282     362.0354     362.0354     130.1647      36.3886       0.0141       0.0141      11.4973     110.9495       3.3134    2626.8159       6.1176       7.8859       6.9338       8.7607      13.3422      15.2732     163.4641     126.8092     144.2213     114.1462      74.9499      65.4740       0.0177       0.2191       0.2191       3.2315       0.2755    2612.3145     185.6511     164.9675     322.1875       0.0552    4962.0859    -999.2500    1312.0000       0.2173       0.2173
  365.4552       0.7308      96.0000      96.5332       0.0158       0.0158       5.8229     201.0476     206.5716     206.8741     206.2690     201.0476     354.9676     351.0253     358.9099     358.9099     139.9331      36.3955       0.0110       0.0110       5.9051     144.9609       3.1375    2631.8105       8.2060       9.5934       9.2904      10.6431      15.5683      17.0528     121.8628     104.2388     107.6379      93.9573      64.2332      58.6414       0.0177       0.1908       0.1908       3.1554       0.2714    2623.9434     163.4641     103.1340     328.5000       0.0538    4973.9478    -999.2500    1302.0000       0.2042       0.2042
  365.6076       0.7301      96.0000      96.3763       0.0183       0.0183      -0.9757     198.5164     199.8275     198.8106     200.8444     198.5164     351.1033     349.3077     352.8990     352.8990     161.4343      36.4023       0.0250       0.0250      -3.6771     164.1786       3.0017    2608.6946      11.3123      12.2946      12.5462      13.4708      18.7188      19.7508      88.3991      81.3363      79.7056      74.2344      53.4221      50.6310       0.0176       0.1976       0.1976       3.1374       0.2685    2619.8013     121.8628      84.5856     326.6875       0.0466    5037.3657    -999.2500    1245.0000       0.1978       0.1978
  365.7600       0.7295      96.0000      96.6901       0.0098       0.0098       2.4575     196.6261     197.2569     196.4086     198.1053     196.6261     352.1911     348.4772     355.9051     355.9051     175.1783      36.4092       0.0154       0.0154       1.4670     175.4531       3.2657    2624.5432      14.8538      16.0532      16.0626      17.3028      22.1509      23.4786      67.3230      62.2928      62.2565      57.7942      45.1450      42.5919       0.0176       0.2079       0.2079       3.1775       0.2803    2633.8704      88.3991      67.0419     331.3125       0.0410    5085.7944    -999.2500    1247.0000       0.1975       0.1975
  365.9124       0.7280      96.0000      96.5332      -0.0013      -0.0013       4.4084     193.5824     197.6505     196.4397     198.8613     193.5824     339.0497     330.1685     347.9308     347.9308     223.6984      36.4160      -0.0120      -0.0120       9.6001     186.1929       3.2678    2669.8442      18.2177      21.0691      19.2400      22.3686      25.1712      28.4610      54.8917      47.4628      51.9751      44.7056      39.7279      35.1358       0.0176       0.2009       0.2009       3.4714       0.2758    2652.1716      67.3230      57.0641     334.8750       0.0318    5165.7598    -999.2500    1243.0000       0.1959       0.1959
  366.0648       0.7266      96.0000      96.4809      -0.0104      -0.0104       8.7604     193.8387     195.9772     194.2824     197.6719     193.8387     337.8434     329.0161     346.6706     346.6706     502.1837      36.4228      -0.0093      -0.0093       6.2104     300.1096       3.9229    2665.4019      23.5796      27.2839      24.5906      28.6260      30.1854      34.4751      42.4095      36.6517      40.6660      34.9333      33.1286      29.0065       0.0176       0.1768       0.1768       3.9599       0.2726    2667.1245      54.8917      73.9379     328.8750       0.0326    5158.9287    -999.2500    1219.0000       0.1931       0.1931
  366.2172       0.7262      96.0000      96.5855       0.0035       0.0035       8.9734     199.5417     198.2858     195.7508     200.8208     199.5417     346.0471     347.7321     344.3621     344.3621     731.9633      36.4297      -0.0087      -0.0087      10.3829     987.3602       4.8495    2664.2786      34.7914      34.2031      35.9543      35.5292      41.1307      40.9592      28.7428      29.2371      27.8131      28.1458      24.3127      24.4145       0.0175       0.1752       0.1752       4.0962       0.2473    2644.2473      42.4095      35.1533     340.9375       0.0495    5011.4834    -999.2500    1226.0000       0.1902       0.1902
  366.3696       0.7258      96.0000      96.6901       0.0282       0.0282       4.8045     207.0069     205.9657     199.1446     212.7869     207.0069     371.1245     367.8636     374.3854     374.3854     738.5279      36.4365       0.0303       0.0303       6.1046     875.5317       3.6269    2599.9539      47.8272      40.3192      49.0032      41.5862      53.6968      46.7003      20.9086      24.8021      20.4068      24.0465      18.6231      21.4131       0.0175       0.1829       0.1829       3.8689       0.2798    2603.3906      28.7428      19.9511     335.0625       0.0703    4830.7568    -999.2500    1243.0000       0.1924       0.1924
  366.5220       0.7283      96.0000      96.4809       0.0522       0.0522       2.1965     217.0673     219.0189     217.3935     220.6443     217.0673     387.4629     382.6592     392.2665     392.2665     465.6589      36.4433       0.0594       0.0594       0.3462     329.1431       3.3265    2551.9478      53.2878      43.4337      54.3408      44.5764      58.9059      49.2695      18.7660      23.0236      18.4024      22.4334      16.9762      20.2965       0.0175       0.2042       0.2042       3.4336       0.2793    2563.8257      20.9086      18.8727     345.4375       0.0960    4606.8667    -999.2500    1252.0000       0.2021       0.2021
  366.6744       0.7307      96.0000      96.3763       0.0686       0.0686      -2.9253     222.7062     224.2136     222.3525     226.0747     222.7062     396.5811     396.0770     397.0853     397.0853     233.8505      36.4502       0.0706       0.0706      -5.6824     192.3019       3.3727    2533.4670      49.0231      42.8322      49.9592      43.8401      54.7341      48.4030      20.3986      23.3469      20.0163      22.8102      18.2702      20.6599       0.0174       0.2347       0.2347       3.3563       0.2705    2536.8733      18.7660      23.4969     342.8125       0.1094    4490.2202    -999.2500    1271.0000       0.2177       0.2177
  366.8268       0.7325      96.0000      96.3763       0.0690       0.0690       2.7517     221.4567     226.8586     227.2586     226.4587     221.4567     402.7097     409.6306     395.7888     395.7888     168.7024      36.4570       0.0732       0.0732       2.1697     181.3476       3.3778    2529.1997      40.4127      39.1588      41.2332      40.0766      46.4065      44.8496      24.7447      25.5370      24.2523      24.9522      21.5487      22.2967       0.0174       0.2449       0.2449       3.1836       0.2721    2536.2256      20.3986      32.2443     351.7500       0.1065    4515.5557    -999.2500    1281.0000       0.2334       0.2334
  366.9792       0.7343      96.0000      96.3763       0.0646       0.0646       2.3827     219.7266     225.9754     226.0724     225.8784     219.7266     398.0974     401.9037     394.2910     394.2910     146.5335      36.4638       0.0670       0.0670       5.1287     133.6989       2.8243    2539.5293      32.3797      34.1701      33.1945      34.9370      38.6063      40.1105      30.8836      29.2654      30.1255      28.6230      25.9025      24.9311       0.0174       0.2486       0.2486       3.0597       0.2748    2543.4255      24.7447      40.5224     356.6250       0.1024    4551.1108    -999.2500    1280.0000       0.2402       0.2402
  367.1316       0.7346      96.0000      96.6901       0.0550       0.0550       5.0483     216.6187     221.0874     220.2462     221.9287     216.6187     392.5309     393.2867     391.7751     391.7751     130.9821      36.4707       0.0505       0.0505       4.3932     125.7953       2.9939    2566.7466      26.4950      29.3503      27.2329      30.1890      33.0298      35.5808      37.7430      34.0712      36.7204      33.1247      30.2757      28.1051       0.0173       0.2519       0.2519       3.0224       0.2798    2559.3083      30.8836      42.2468     351.4375       0.0949    4616.4058    -999.2500    1241.0000       0.2433       0.2433
  367.2840       0.7349      96.0000      96.6901       0.0471       0.0471       5.6462     214.3760     216.1897     218.0513     214.3281     214.3760     386.3153     389.5361     383.0944     383.0944     126.6273      36.4775       0.0467       0.0467       5.7449     133.1834       3.2812    2572.9241      22.8768      25.4857      23.5684      26.2551      29.4042      32.0514      43.7123      39.2377      42.4297      38.0878      34.0087      31.1999       0.0173       0.2345       0.2345       3.1549       0.2720    2572.2134      37.7430      45.8505     361.2500       0.0894    4664.7017    -999.2500    1228.0000       0.2343       0.2343
  367.4364       0.7354      96.0000      96.5855       0.0399       0.0399      10.8396     211.9730     213.7813     216.4992     211.0634     211.9730     377.6629     374.9234     380.4025     380.4025     122.5212      36.4844       0.0414       0.0414      11.7382     120.6344       3.2108    2581.6428      21.1326      23.1304      21.8330      23.8637      27.5523      29.6988      47.3202      43.2332      45.8023      41.9046      36.2946      33.6713       0.0173       0.2332       0.2332       3.2616       0.2748    2584.1765      43.7123      46.6889     350.9375       0.0833    4717.5815    -999.2500    1231.0000       0.2276       0.2276
  367.5888       0.7358      96.0000      96.4809       0.0327       0.0327      12.5413     210.6914     214.5208     216.3028     212.7388     210.6914     373.0070     371.5330     374.4810     374.4810     115.7354      36.4912       0.0321       0.0321      14.2235     113.4771       3.3108    2597.1133      20.9484      21.8548      21.7141      22.5909      27.2470      28.3089      47.7364      45.7564      46.0531      44.2657      36.7013      35.3246       0.0172       0.2165       0.2165       3.2126       0.2684    2596.0476      47.3202      45.1276     361.2500       0.0800    4746.2773    -999.2500    1236.0000       0.2145       0.2145
  367.7412       0.7367      96.0000      96.3763       0.0304       0.0304      10.5626     209.5380     212.4109     215.3854     209.4364     209.5380     368.8299     364.4775     373.1823     373.1823     116.5495      36.4980       0.0235       0.0235      13.2899     112.0392       3.1179    2611.1807      21.0940      21.2423      21.8915      21.9962      27.2468      27.5274      47.4069      47.0758      45.6797      45.4624      36.7015      36.3275       0.0172       0.1993       0.1993       3.1661       0.2698    2599.8577      47.7364      44.2104     351.8125       0.0770    4772.4038    -999.2500    1268.0000       0.2060       0.2060
  367.8936       0.7376      96.0000      96.4809       0.0330       0.0330       6.7395     207.9361     208.6617     212.6583     204.6650     207.9361     362.6608     360.1408     365.1807     365.1807     121.2423      36.5049       0.0339       0.0339       7.7728     123.0765       3.0821    2594.0972      21.3355      20.9379      22.1770      21.6992      27.3417      27.0457      46.8703      47.7603      45.0919      46.0847      36.5742      36.9744       0.0172       0.1941       0.1941       3.1771       0.2601    2595.5686      47.4069      45.4730     352.6875       0.0728    4809.1709    -999.2500    1237.0000       0.1962       0.1962
  368.0460       0.7378      96.0000      96.4809       0.0315       0.0315       7.6762     206.8787     208.0845     210.1567     206.0123     206.8787     361.5688     360.2758     362.8617     362.8617     124.2223      36.5117       0.0370       0.0370       7.3269     126.6105       3.3436    2588.9294      20.9056      20.9768      21.7759      21.7673      26.7759      26.9215      47.8340      47.6716      45.9222      45.9405      37.3470      37.1451       0.0171       0.1815       0.1815       3.1934       0.2592    2598.0720      46.8703      46.9510     353.8125       0.0699    4833.7495    -999.2500    1243.0000       0.1894       0.1894
  368.1984       0.7380      96.0000      96.5332       0.0370       0.0370       5.7105     207.1030     209.5619     210.0428     209.0809     207.1030     363.0114     361.5392     364.4835     364.4835     122.4919      36.5185       0.0218       0.0218      11.3773     122.7417       3.1676    2614.0051      20.3671      21.1608      21.2909      21.9085      26.1147      26.8959      49.0988      47.2572      46.9685      45.6444      38.2927      37.1803       0.0171       0.1767       0.1767       3.2216       0.2616    2588.9080      47.8340      46.3820     350.0000       0.0705    4828.5146    -999.2500    1221.0000       0.1869       0.1869
  368.3508       0.7383      96.0000      96.4809       0.0489       0.0489       4.4740     207.3273     204.5547     198.1479     210.9615     207.3273     364.4904     361.9182     367.0626     367.0626     122.3018      36.5254       0.0493       0.0493       3.0730     117.8851       3.1529    2568.7136      20.5349      21.2894      21.5082      22.1702      26.1646      26.9886      48.6976      46.9717      46.4939      45.1056      38.2195      37.0526       0.0171       0.1820       0.1820       3.1318       0.2658    2569.2510      49.0988      45.9808     361.2500       0.0711    4823.2915    -999.2500    1225.0000       0.1929       0.1929
  368.5032       0.7385      96.0000      96.6901       0.0655       0.0655       3.9726     207.4875     205.0804     198.5234     211.6374     207.4875     369.3773     368.4933     370.2613     370.2613     124.9865      36.5322       0.0734       0.0734       0.5254     125.5435       3.0757    2528.8442      20.9301      21.4551      22.0067      22.4922      26.4913      27.1635      47.7781      46.6090      45.4408      44.4599      37.7482      36.8141       0.0170       0.2022       0.2022       3.1542       0.2711    2541.8977      48.6976      40.6693     351.0000       0.0716    4819.5674    -999.2500    1244.0000       0.2085       0.2085
  368.6556       0.7388      96.0000      96.6901       0.0722       0.0722       7.8896     206.2700     210.1170     208.8167     211.4173     206.2700     371.5246     371.2420     371.8072     371.8072     126.4769      36.5391       0.0720       0.0720       9.0286     130.0886       3.2427    2531.1179      20.6388      22.1601      21.6059      23.1674      25.9730      27.6338      48.4525      45.1262      46.2836      43.1640      38.5015      36.1875       0.0170       0.2461       0.2461       3.2188       0.2777    2530.8018      47.7781      36.5135     357.3750       0.0683    4848.0146    -999.2500    1237.0000       0.2303       0.2303
  368.8080       0.7392      96.0000      96.5332       0.0671       0.0671       8.2246     207.3273     209.3347     206.9875     211.6819     207.3273     373.3629     374.4428     372.2829     372.2829     132.1856      36.5459       0.0736       0.0736       8.7734     122.3565       3.3531    2528.6279      21.6354      24.0915      22.4763      25.0815      26.6712      29.4474      46.2205      41.5085      44.4913      39.8700      37.4936      33.9589       0.0170       0.2622       0.2622       3.3845       0.2752    2539.3530      48.4525      41.1204     350.4375       0.0711    4823.2915    -999.2500    1241.0000       0.2544       0.2544
  368.9604       0.7381      96.0000      96.3763       0.0613       0.0613       8.0676     210.5633     213.7850     213.2313     214.3387     210.5633     379.7393     383.8398     375.6387     375.6387     136.3263      36.5527       0.0521       0.0521      10.4586     144.1118       3.5848    2564.0505      24.9567      26.8442      25.8270      27.9174      29.7963      32.1115      40.0695      37.2521      38.7192      35.8199      33.5612      31.1414       0.0169       0.2622       0.2622       3.5184       0.2709    2548.9207      46.2205      47.9813     354.3750       0.0797    4749.1660    -999.2500    1266.0000       0.2678       0.2678
  369.1128       0.7371      96.0000      96.5332       0.0598       0.0598       7.1170     214.6964     219.2796     217.3298     221.2293     214.6964     391.6104     394.9848     388.2359     388.2359     140.0952      36.5596       0.0560       0.0560       7.8708     142.2558       3.6434    2557.5198      30.4288      29.5822      31.3443      30.6799      35.5178      34.9372      32.8636      33.8041      31.9037      32.5946      28.1549      28.6228       0.0169       0.2821       0.2821       3.5609       0.2797    2551.2642      40.0695      36.0483     351.4375       0.0902    4657.7407    -999.2500    1257.0000       0.2796       0.2796
  369.2652       0.7376      96.0000      96.5855       0.0644       0.0644       9.1504     219.8227     224.9017     223.7383     226.0650     219.8227     407.5795     409.9253     405.2337     405.2337     129.4398      36.5664       0.0673       0.0673       8.1091     133.6633       3.4700    2538.8975      37.5160      33.0269      38.3287      33.9188      42.4223      38.1175      26.6553      30.2784      26.0901      29.4822      23.5725      26.2347       0.0169       0.2905       0.2905       3.5533       0.2915    2543.7117      32.8636      28.6171     351.4375       0.1026    4549.1211    -999.2500    1266.0000       0.2840       0.2840
  369.4176       0.7382      96.0000      96.3763       0.0723       0.0723       7.3863     221.5208     226.0345     225.5131     226.5559     221.5208     410.4352     412.0834     408.7871     408.7871     120.4019      36.5732       0.0702       0.0702       9.1226     112.3476       3.5600    2534.1045      38.5431      35.4661      39.1201      36.2653      43.6624      40.3559      25.9450      28.1959      25.5623      27.5746      22.9030      24.7795       0.0169       0.3033       0.3033       3.5034       0.2921    2530.7112      26.6553      26.0166     361.2500       0.1066    4514.2495    -999.2500    1252.0000       0.2944       0.2944
  369.5700       0.7389      96.0000      96.5332       0.0679       0.0679       8.2749     221.5208     224.5226     224.9171     224.1281     221.5208     411.5320     412.8705     410.1934     410.1934     114.5575      36.5801       0.0793       0.0793       3.7923     115.3970       3.4843    2519.1575      36.7881      36.6923      37.1791      37.2927      41.9668      41.8310      27.1827      27.2537      26.8968      26.8149      23.8284      23.9057       0.0168       0.3278       0.3278       3.4992       0.2941    2537.9312      25.9450      25.4015     351.4375       0.1066    4514.2495    -999.2500    1252.0000       0.3122       0.3122
  369.7224       0.7395      96.0000      96.6901       0.0655       0.0655       9.2495     219.7586     220.4383     221.0463     219.8303     219.7586     407.3858     406.4354     408.3361     408.3361     115.6820      36.5869       0.0528       0.0528      13.6194     116.1301       3.4538    2562.8359      37.0720      37.4328      37.3929      37.7856      42.3082      42.7330      26.9745      26.7146      26.7430      26.4651      23.6361      23.4011       0.0168       0.3120       0.3120       3.5175       0.2961    2541.9023      27.1827      27.1487     361.2500       0.1025    4550.4478    -999.2500    1240.0000       0.3123       0.3123
  369.8748       0.7397      96.0000      96.5855       0.0617       0.0617      12.3778     219.4382     217.2372     218.7960     215.6785     219.4382     406.8815     406.5411     407.2218     407.2218     117.1012      36.5938       0.0620       0.0620      13.2384     115.7893       3.5884    2547.7644      37.7863      38.0165      38.0139      38.2020      43.1214      43.3239      26.4646      26.3044      26.3061      26.1767      23.1904      23.0819       0.0168       0.2942       0.2942       3.5358       0.2954    2548.2698      26.9745      27.7305     351.4375       0.1017    4557.0918    -999.2500    1268.0000       0.3036       0.3036
  370.0272       0.7398      96.0000      96.6901       0.0669       0.0669      10.3509     219.2139     218.9476     221.5508     216.3444     219.2139     402.0151     396.7652     407.2650     407.2650     110.9949      36.6006       0.0700       0.0700      10.0429     119.6547       3.5439    2534.5796      38.3935      38.4932      38.6116      38.6891      43.6573      43.7580      26.0461      25.9786      25.8990      25.8470      22.9057      22.8530       0.0167       0.2955       0.2955       3.5302       0.2960    2539.6616      26.4646      28.4651     361.2500       0.1012    4561.7539    -999.2500    1257.0000       0.2940       0.2940
  370.1796       0.7406      96.0000      96.5855       0.0700       0.0700       7.4635     219.6304     223.2400     225.1342     221.3457     219.6304     408.2610     407.6036     408.9183     408.9183     113.2855      36.6074       0.0671       0.0671       9.8008      97.8111       3.4331    2539.2263      38.9724      38.8794      39.2735      39.1332      44.4227      44.2001      25.6592      25.7206      25.4625      25.5537      22.5110      22.6244       0.0167       0.2874       0.2874       3.4586       0.2973    2534.4446      26.0461      26.3802     351.6250       0.1022    4553.1025    -999.2500    1260.0000       0.2947       0.2947
  370.3320       0.7413      96.0000      96.3763       0.0650       0.0650       5.0260     218.2207     219.6789     220.3982     218.9596     218.2207     400.7525     396.5690     404.9361     404.9361     112.0948      36.6143       0.0734       0.0734       1.9516     122.3907       3.3982    2528.9429      39.7048      39.2831      40.1402      39.6145      45.3566      44.7667      25.1859      25.4562      24.9127      25.2433      22.0475      22.3380       0.0167       0.3089       0.3089       3.3445       0.2954    2542.6931      25.6592      24.9137     357.3750       0.0988    4582.5166    -999.2500    1254.0000       0.3092       0.3092
  370.4844       0.7417      96.0000      96.5332       0.0628       0.0628       4.3907     217.5479     219.2494     219.8819     218.6169     217.5479     401.3731     395.3862     407.3599     407.3599     109.8136      36.6211       0.0514       0.0514       8.3932     116.0827       3.2098    2565.1257      39.4662      39.7241      39.9940      40.1326      45.0784      45.3439      25.3381      25.1736      25.0038      24.9174      22.1836      22.0537       0.0166       0.3320       0.3320       3.3294       0.3005    2546.4302      25.1859      24.4989     361.0625       0.0972    4596.6895    -999.2500    1245.0000       0.3167       0.3167
  370.6368       0.7422      96.0000      96.3763       0.0598       0.0598       4.8941     220.1751     222.8184     224.9909     220.6459     220.1751     406.3885     404.9023     407.8746     407.8746     108.8875      36.6279       0.0645       0.0645       2.0005      90.7676       3.3807    2543.5967      39.0369      40.0910      39.8357      40.6447      44.8088      45.9522      25.6168      24.9432      25.1031      24.6035      22.3171      21.7618       0.0166       0.3057       0.3057       3.2412       0.2944    2551.3115      25.3381      28.0001     351.4375       0.1035    4541.8394    -999.2500    1264.0000       0.3151       0.3151
  370.7892       0.7425      96.0000      96.4809       0.0663       0.0663       5.1302     222.0334     225.3660     227.8324     222.8996     222.0334     415.3521     413.9987     416.7054     416.7054     106.2342      36.6348       0.0638       0.0638       2.5728     119.6125       3.1492    2544.8022      40.8904      40.3796      41.6696      41.0685      46.5643      46.1907      24.4556      24.7650      23.9983      24.3496      21.4757      21.6494       0.0166       0.3113       0.3113       3.2621       0.3018    2540.6858      25.6168      24.4169     361.2500       0.1078    4503.8267    -999.2500    1236.0000       0.3197       0.3197
  370.9416       0.7428      96.0000      96.4809       0.0660       0.0660      10.2604     224.6286     228.0088     229.9327     226.0849     224.6286     419.0654     416.3961     421.7348     421.7348     118.7284      36.6416       0.0712       0.0712       6.7404     107.4657       3.2685    2532.4377      42.8372      40.3264      43.8026      41.1238      48.6230      46.0172      23.3442      24.7976      22.8297      24.3168      20.5664      21.7310       0.0165       0.3368       0.3368       3.3424       0.3020    2541.0798      24.4556      21.9421     351.4375       0.1138    4451.7930    -999.2500    1262.0000       0.3298       0.3298
  371.0940       0.7434      96.0000      96.5332       0.0649       0.0649      14.1273     225.5257     227.9733     230.4427     225.5038     225.5257     415.5295     414.3503     416.7088     416.7088     115.6966      36.6485       0.0641       0.0641      15.7001     128.4496       3.6326    2544.2039      40.5560      39.8022      41.5818      40.6912      46.3289      45.5052      24.6572      25.1243      24.0490      24.5753      21.5848      21.9755       0.0165       0.3520       0.3520       3.4904       0.2929    2542.8538      23.3442      22.4347     354.6875       0.1158    4434.0845    -999.2500    1272.0000       0.3368       0.3368
  371.2464       0.7441      96.0000      96.5332       0.0604       0.0604      17.1278     223.5393     226.1220     229.0015     223.2424     223.5393     411.6872     411.5848     411.7896     411.7896     120.4363      36.6553       0.0588       0.0588      19.7490     111.3311       3.5795    2553.0547      36.8086      39.3186      37.6971      40.2914      42.3672      45.0469      27.1676      25.4333      26.5273      24.8192      23.6031      22.1991       0.0164       0.3349       0.3349       3.5745       0.2911    2550.4084      24.6572      24.2868     358.2500       0.1113    4473.4873    -999.2500    1204.0000       0.3278       0.3278
  371.3988       0.7447      96.0000      96.5332       0.0636       0.0636      10.9884     220.6877     223.8699     227.1332     220.6066     220.6877     409.9742     408.0518     411.8965     411.8965     117.4906      36.6621       0.0606       0.0606      12.0248     122.3419       3.5054    2550.0420      36.6650      39.3035      37.4500      40.2742      41.9274      44.9450      27.2740      25.4430      26.7023      24.8298      23.8508      22.2494       0.0164       0.3327       0.3327       3.4709       0.2987    2545.0798      27.1676      25.9126     351.4375       0.1047    4531.2891    -999.2500    1234.0000       0.3289       0.3289
  371.5512       0.7452      96.0000      96.5855       0.0678       0.0678       7.2635     222.7703     226.5641     229.2793     223.8490     222.7703     411.6026     411.4210     411.7841     411.7841     111.5166      36.6690       0.0696       0.0696       4.3383     119.6125       3.3236    2535.1838      40.2778      39.7101      40.9711      40.7062      45.6955      45.2168      24.8276      25.1825      24.4074      24.5663      21.8840      22.1157       0.0164       0.3196       0.3196       3.4647       0.2931    2538.1965      27.2740      27.7477     360.7500       0.1095    4488.9287    -999.2500    1209.0000       0.3252       0.3252
  371.7036       0.7452      96.0000      96.5855       0.0759       0.0759       1.6937     225.3335     229.5036     231.4557     227.5515     225.3335     423.8718     423.7684     423.9753     423.9753     109.4614      36.6758       0.0759       0.0759       0.7616      91.3375       3.5609    2524.8237      42.8101      39.9120      43.5290      40.7748      48.1856      45.5588      23.3590      25.0551      22.9732      24.5250      20.7531      21.9496       0.0163       0.2996       0.2996       3.3901       0.3032    2524.8284      24.8276      27.3926     351.4375       0.1154    4437.8672    -999.2500    1226.0000       0.3168       0.3168
  371.8560       0.7452      96.0000      96.3763       0.0738       0.0738       5.7622     227.9607     232.9797     234.7965     231.1630     227.9607     427.8658     428.9036     426.8280     426.8280     111.2318      36.6826       0.0793       0.0793       4.4311     116.1763       3.2886    2519.1445      41.9207      40.5254      42.5100      41.2136      47.5349      45.8787      23.8546      24.6759      23.5239      24.2638      21.0372      21.7966       0.0163       0.3116       0.3116       3.3913       0.3005    2528.2681      23.3590      24.3032     355.9375       0.1213    4386.7207    -999.2500    1212.0000       0.3190       0.3190
  372.0084       0.7463      96.0000      96.3763       0.0734       0.0734       6.1218     230.6200     236.7471     237.8265     235.6677     230.6200     431.0802     432.8444     429.3161     429.3161     120.2258      36.6895       0.0700       0.0700       7.6494     124.9237       3.3323    2534.5706      40.4543      40.3078      40.8611      40.8984      46.1093      45.9234      24.7192      24.8091      24.4732      24.4508      21.6876      21.7754       0.0163       0.3378       0.3378       3.3248       0.2972    2528.9443      23.8546      22.7775     358.5625       0.1271    4336.1377    -999.2500    1219.0000       0.3230       0.3230
  372.1608       0.7473      96.0000      96.6901       0.0693       0.0693       6.3574     230.0433     233.5618     236.7953     230.3283     230.0433     428.4909     429.4398     427.5421     427.5421     120.7862      36.6963       0.0725       0.0725       6.4716     119.8332       3.3486    2530.3550      39.6981      39.9987      40.0720      40.3280      45.2276      45.7283      25.1901      25.0008      24.9551      24.7967      22.1104      21.8683       0.0162       0.3405       0.3405       3.3132       0.2963    2535.6299      24.7192      24.0721     351.4375       0.1258    4347.0083    -999.2500    1208.0000       0.3311       0.3311
  372.3132       0.7477      96.0000      96.4809       0.0719       0.0719       0.4666     229.3384     233.7670     234.0158     233.5181     229.3384     426.7390     429.3818     424.0963     424.0963     110.0340      36.7031       0.0697       0.0697       0.6782     117.8575       3.2458    2535.0720      39.3499      39.6700      39.6861      39.8465      44.9705      45.3390      25.4130      25.2080      25.1977      25.0963      22.2368      22.0561       0.0162       0.3263       0.3263       3.2882       0.2934    2531.2932      25.1901      26.2427     357.3750       0.1243    4360.3687    -999.2500    1213.0000       0.3264       0.3264
  372.4656       0.7481      96.0000      96.6901       0.0638       0.0638       4.9105     228.0568     232.9491     231.2267     234.6714     228.0568     423.2873     426.0645     420.5102     420.5102     112.0821      36.7100       0.0704       0.0704       0.9040      92.6673       3.2662    2533.8467      39.1990      39.2224      39.5776      39.5723      44.9171      44.8656      25.5109      25.4956      25.2668      25.2702      22.2632      22.2888       0.0162       0.3169       0.3169       3.3136       0.2917    2544.7981      25.4130      27.3219     351.4375       0.1215    4384.8721    -999.2500    1229.0000       0.3220       0.3220
  372.6180       0.7489      96.0000      96.2717       0.0635       0.0635       6.3566     228.3452     233.5499     231.1200     235.9798     228.3452     423.0896     426.6893     419.4900     419.4900     104.8356      36.7168       0.0528       0.0528       9.9630     125.7215       3.3954    2562.9019      38.7996      38.7477      39.2538      39.1727      44.5942      44.4356      25.7735      25.8080      25.4753      25.5280      22.4245      22.5045       0.0161       0.3016       0.3016       3.3789       0.2895    2545.2336      25.5109      27.7207     351.4375       0.1221    4379.3350    -999.2500    1242.0000       0.3116       0.3116
  372.7704       0.7497      96.0000      96.4809       0.0589       0.0589      10.2585     228.8258     234.3972     231.5193     237.2752     228.8258     422.7088     426.4728     418.9449     418.9449     115.7109      36.7237       0.0669       0.0669       8.8488      96.1180       3.4806    2539.5896      38.2094      38.2705      38.8321      38.7296      44.0485      44.0008      26.1716      26.1298      25.7519      25.8201      22.7022      22.7268       0.0161       0.3039       0.3039       3.3988       0.2874    2552.7354      25.7735      27.0536     351.4375       0.1232    4370.1372    -999.2500    1258.0000       0.3063       0.3063
  372.9228       0.7501      96.0000      96.6901       0.0634       0.0634       7.6938     230.2675     237.3339     236.4165     238.2513     230.2675     425.5262     430.6799     420.3726     420.3726     112.5195      36.7305       0.0572       0.0572      11.6665     123.8931       3.3197    2555.6274      37.5563      37.7330      38.1405      38.3453      43.5690      43.6756      26.6267      26.5020      26.2189      26.0788      22.9521      22.8961       0.0161       0.3123       0.3123       3.3747       0.2857    2545.3567      26.1716      27.2429     345.0000       0.1263    4342.7744    -999.2500    1226.0000       0.3106       0.3106
  373.0752       0.7505      96.0000      96.4809       0.0623       0.0623      11.6517     231.8375     239.5252     239.7210     239.3294     231.8375     429.0013     433.7932     424.2096     424.2096     125.9396      36.7373       0.0604       0.0604      11.6356     116.1473       3.3497    2550.3804      37.3174      37.3310      37.7814      37.9500      42.8238      43.1637      26.7971      26.7874      26.4680      26.3505      23.3515      23.1676       0.0160       0.3305       0.3305       3.3752       0.2871    2547.1492      26.6267      27.2038     351.4375       0.1297    4313.3667    -999.2500    1256.0000       0.3249       0.3249
  373.2276       0.7515      96.0000      96.3763       0.0664       0.0664      12.2029     233.1831     240.5549     239.2233     241.8864     233.1831     431.8967     437.3407     426.4527     426.4527     131.6392      36.7442       0.0695       0.0695      11.1453     136.3783       3.4596    2535.3906      37.4613      37.0088      37.9518      37.5437      42.9205      42.5919      26.6942      27.0206      26.3492      26.6356      23.2989      23.4786       0.0160       0.3466       0.3466       3.4146       0.2867    2540.5110      26.7971      27.7708     342.6250       0.1326    4288.4751    -999.2500    1281.0000       0.3356       0.3356
  373.3800       0.7525      96.0000      96.3763       0.0722       0.0722       8.9966     235.3939     241.4372     239.2915     243.5829     235.3939     434.2305     439.9925     428.4685     428.4685     148.5820      36.7510       0.0722       0.0722       9.3658     141.2645       3.4382    2530.8591      37.8339      36.4418      38.2556      36.8721      42.9986      41.7318      26.4313      27.4410      26.1400      27.1207      23.2566      23.9626       0.0160       0.3268       0.3268       3.3677       0.2838    2530.7966      26.6942      28.3995     346.4375       0.1372    4248.1992    -999.2500    1281.0000       0.3345       0.3345
  373.5324       0.7534      96.0000      96.4809       0.0716       0.0716       6.6163     234.7210     241.6820     239.2295     244.1345     234.7210     434.2433     440.8301     427.6565     427.6565     151.7410      36.7578       0.0774       0.0774       3.4784     166.9759       3.2027    2522.2454      37.6152      35.0811      38.1609      35.5318      42.5398      40.2625      26.5850      28.5054      26.2048      28.1438      23.5074      24.8370       0.0159       0.3174       0.3174       3.3635       0.2844    2531.8823      26.4313      28.1562     341.6875       0.1358    4260.3770    -999.2500    1247.0000       0.3276       0.3276
  373.6848       0.7543      96.0000      96.5855       0.0763       0.0763       5.2095     232.9268     239.6467     236.2237     243.0696     232.9268     432.0712     437.3043     426.8382     426.8382     148.7849      36.7647       0.0645       0.0645       8.7780     145.8550       3.4463    2543.5195      35.9688      32.0015      36.7347      32.6316      40.8603      37.0046      27.8019      31.2486      27.2222      30.6452      24.4737      27.0237       0.0159       0.3200       0.3200       3.2842       0.2880    2524.1836      26.5850      29.2391     342.7500       0.1320    4293.1938    -999.2500    1233.0000       0.3255       0.3255
  373.8372       0.7560      96.0000      96.5332       0.0827       0.0827       3.8460     228.1209     234.6029     231.6179     237.5879     228.1209     423.1541     426.2722     420.0362     420.0362     137.6873      36.7715       0.0877       0.0877       1.2528     135.0056       3.1999    2505.3652      29.9014      28.2775      30.8983      29.0695      34.8198      33.1631      33.4433      35.3638      32.3643      34.4003      28.7193      30.1540       0.0159       0.3563       0.3563       3.3383       0.2908    2513.5396      27.8019      30.4674     347.5625       0.1216    4383.6406    -999.2500    1244.0000       0.3342       0.3342
  373.9896       0.7578      96.0000      96.4809       0.0926       0.0926      -0.2985     220.7518     228.4623     226.6351     230.2895     220.7518     412.0486     413.4218     410.6754     410.6754     130.9823      36.7784       0.0988       0.0988      -4.4281     133.6831       3.3629    2486.9534      18.6606      24.6230      19.3940      25.6200      22.9996      29.4129      53.5888      40.6124      51.5624      39.0321      43.4789      33.9987       0.0158       0.3642       0.3642       3.2334       0.2968    2497.1372      33.4433      35.2745     337.1250       0.1048    4529.9741    -999.2500    1247.0000       0.3443       0.3443
  374.1420       0.7581      96.0000      96.5332       0.0913       0.0913       0.5737     214.8245     218.6199     217.3426     219.8973     214.8245     396.2660     395.7332     396.7988     396.7988     131.2621      36.7852       0.0914       0.0914       2.1754     125.7399       3.1317    2499.2107      14.9056      21.2514      15.0992      22.2033      18.1028      25.8355      67.0889      47.0556      66.2286      45.0384      55.2401      38.7064       0.0158       0.3324       0.3324       3.2640       0.2927    2499.4355      53.5888      47.4630     345.6875       0.0905    4654.9619    -999.2500    1237.0000       0.3350       0.3350
  374.2944       0.7584      96.0000      96.5332       0.0862       0.0862       4.5411     210.3070     215.2453     214.3087     216.1819     210.3070     389.7130     392.6540     386.7720     386.7720     131.8123      36.7920       0.0839       0.0839       4.2044     133.9956       3.2899    2511.5835      19.3756      20.4229      20.4951      21.2975      23.3801      24.3030      51.6114      48.9645      48.7921      46.9538      42.7714      41.1471       0.0158       0.3108       0.3108       3.2072       0.2901    2507.8335      67.0889      55.8754     331.9375       0.0790    4754.9546    -999.2500    1256.0000       0.3219       0.3219
  374.4468       0.7580      96.0000      96.7948       0.0851       0.0851       8.1172     208.7691     213.8355     212.4850     215.1859     208.7691     387.1145     391.1523     383.0767     383.0767     130.1017      36.7989       0.0830       0.0830       8.2828     135.3340       3.2093    2513.0554      22.6988      20.4097      24.1011      21.4515      27.2287      23.9926      44.0553      48.9964      41.4919      46.6168      36.7260      41.6795       0.0157       0.3057       0.3057       3.2694       0.2888    2509.5837      51.6114      57.0089     341.6875       0.0750    4789.9819    -999.2500    1228.0000       0.3079       0.3079
  374.5992       0.7576      96.0000      96.3763       0.0827       0.0827       8.2154     209.5380     214.1785     213.7179     214.6391     209.5380     388.8612     391.5360     386.1863     386.1863     133.0710      36.8057       0.0913       0.0913       7.2530     120.6080       3.3102    2499.4114      20.6287      20.8982      21.7522      22.0039      25.3346      24.7676      48.4762      47.8511      45.9724      45.4466      39.4716      40.3753       0.0157       0.3049       0.3049       3.2822       0.2914    2513.5042      44.0553      54.7450     331.9375       0.0770    4772.4038    -999.2500    1268.0000       0.3030       0.3030
  374.7516       0.7574      96.0000      96.6901       0.0801       0.0801       4.0302     210.8516     213.6496     213.9287     213.3704     210.8516     391.5620     392.1053     391.0187     391.0187     136.5841      36.8125       0.0749       0.0749       7.2101     142.7851       3.3426    2526.4741      18.8176      21.8824      19.6874      22.9644      23.7942      26.5792      53.1419      45.6988      50.7938      43.5456      42.0271      37.6233       0.0157       0.2857       0.2857       3.3531       0.2950    2517.8901      48.4762      51.6575     335.5000       0.0804    4742.6714    -999.2500    1258.0000       0.2939       0.2939
  374.9040       0.7571      96.0000      96.3763       0.0773       0.0773       0.9976     214.7925     214.5336     216.0140     213.0533     214.7925     397.2790     395.4474     399.1106     399.1106     136.2953      36.8194       0.0694       0.0694       3.9408     145.8734       3.3885    2535.5024      22.2175      23.9441      22.9407      24.9031      27.4511      29.0803      45.0095      41.7639      43.5906      40.1557      36.4284      34.3875       0.0156       0.2696       0.2696       3.4163       0.2961    2522.4375      53.1419      47.5029     341.6875       0.0904    4655.6563    -999.2500    1256.0000       0.2892       0.2892
  375.0564       0.7575      96.0000      96.6901       0.0694       0.0694       1.2708     217.8362     217.9709     216.6675     219.2743     217.8362     406.6427     409.6548     403.6306     403.6306     126.1859      36.8262       0.0841       0.0841      -2.3756     119.7417       3.5124    2511.1746      27.6026      25.8795      28.1014      26.6171      33.4282      31.6316      36.2284      38.6406      35.5854      37.5699      29.9148      31.6140       0.0156       0.2950       0.2950       3.4065       0.2945    2535.4846      45.0095      36.7797     335.3750       0.0979    4590.6045    -999.2500    1288.0000       0.2939       0.2939
  375.2088       0.7579      96.0000      96.6901       0.0603       0.0603       3.4141     219.1499     221.0431     217.7491     224.3372     219.1499     414.0986     414.7796     413.4176     413.4176     116.9014      36.8331       0.0500       0.0500       7.3075     113.6330       3.3051    2567.5313      31.3972      27.7758      31.7834      28.3455      37.3414      33.6723      31.8500      36.0025      31.4630      35.2790      26.7800      29.6980       0.0156       0.3263       0.3263       3.3638       0.3046    2550.4539      36.2284      32.9587     341.6875       0.1010    4563.0874    -999.2500    1227.0000       0.3000       0.3000
  375.3612       0.7583      96.0000      96.4809       0.0473       0.0473       4.5774     220.7198     220.3823     223.3345     217.4302     220.7198     411.3154     410.7425     411.8883     411.8883     114.9148      36.8399       0.0458       0.0458       3.8581     118.0196       3.2779    2574.4902      30.7082      28.7888      31.1225      29.2413      36.9050      34.7920      32.5646      34.7357      32.1311      34.1982      27.0966      28.7422       0.0155       0.3134       0.3134       3.2817       0.2986    2572.0303      31.8500      34.3611     331.9375       0.1048    4530.6313    -999.2500    1218.0000       0.3067       0.3067
  375.5136       0.7587      96.0000      96.5855       0.0455       0.0455       4.8463     220.2072     218.8632     221.1542     216.5723     220.2072     410.4988     411.7810     409.2166     409.2166     118.6272      36.8467       0.0446       0.0446       3.6444     114.8208       3.2676    2576.3394      28.4160      28.9417      28.9206      29.3913      34.6628      35.1741      35.1915      34.5522      34.5775      34.0236      28.8494      28.4300       0.0155       0.3007       0.3007       3.3090       0.2962    2574.9028      32.5646      37.4951     341.5625       0.1035    4541.1787    -999.2500    1234.0000       0.3052       0.3052
  375.6660       0.7589      96.0000      96.5332       0.0537       0.0537       4.6530     221.4247     222.6502     225.2069     220.0935     221.4247     412.8540     416.6363     409.0717     409.0717     122.3812      36.8536       0.0457       0.0457       7.7653     124.0798       3.3836    2574.6333      27.5054      28.7013      28.1230      29.2431      34.0033      34.8492      36.3565      34.8417      35.5581      34.1961      29.4089      28.6951       0.0155       0.2821       0.2821       3.4066       0.2928    2561.3850      35.1915      38.2458     330.2500       0.1064    4516.2090    -999.2500    1208.0000       0.3002       0.3002
  375.8184       0.7591      96.0000      96.5332       0.0615       0.0615       6.8050     223.7315     225.9055     227.5111     224.2998     223.7315     418.7841     424.1844     413.3839     413.3839     124.8445      36.8604       0.0703       0.0703       2.4648     129.2817       3.5754    2534.0662      27.9167      28.2657      28.7139      28.9349      34.2550      34.4463      35.8208      35.3785      34.8264      34.5604      29.1928      29.0307       0.0154       0.3050       0.3050       3.4512       0.2929    2548.4678      36.3565      36.4095     337.5625       0.1118    4469.6436    -999.2500    1200.0000       0.3104       0.3104
  375.9708       0.7606      96.0000      96.4809       0.0676       0.0676       6.2022     224.5645     228.2925     229.8215     226.7635     224.5645     419.2354     424.5656     413.9052     413.9052     121.3542      36.8672       0.0711       0.0711       4.4878     121.6747       3.3974    2532.6313      28.6339      27.5110      29.6181      28.3268      35.1028      33.8258      34.9237      36.3492      33.7632      35.3022      28.4877      29.5632       0.0154       0.3377       0.3377       3.4410       0.2914    2538.5059      35.8208      34.5747     331.9375       0.1137    4453.0630    -999.2500    1207.0000       0.3248       0.3248
  376.1232       0.7620      96.0000      96.5855       0.0630       0.0630       8.3821     222.4819     224.4371     229.0722     219.8021     222.4819     414.5199     416.3895     412.6503     412.6503     116.9615      36.8741       0.0620       0.0620       9.9615     113.6090       3.3562    2547.6260      28.8559      26.1276      30.0146      27.0772      35.3253      32.5993      34.6550      38.2737      33.3171      36.9315      28.3083      30.6755       0.0154       0.3537       0.3537       3.3490       0.2951    2545.9929      34.9237      34.1476     331.3125       0.1089    4494.7466    -999.2500    1188.0000       0.3430       0.3430
  376.2756       0.7638      96.0000      96.3763       0.0590       0.0590      10.1636     216.8750     220.4858     224.1056     216.8660     216.8750     404.9077     404.5729     405.2424     405.2424     129.8935      36.8809       0.0559       0.0559      10.4458     116.1037       3.2908    2557.7925      27.0885      23.8138      28.3571      24.8711      33.5473      30.2068      36.9161      41.9924      35.2645      40.2073      29.8087      33.1052       0.0153       0.3463       0.3463       3.3808       0.2993    2552.7134      34.6550      34.9643     333.3750       0.0955    4610.9497    -999.2500    1209.0000       0.3379       0.3379
  376.4280       0.7656      96.0000      96.6901       0.0559       0.0559      11.4795     211.9730     216.0344     217.1554     214.9134     211.9730     392.6651     393.3578     391.9724     391.9724     135.1492      36.8878       0.0592       0.0592      10.6928     159.9677       3.5011    2552.3840      21.4130      20.7102      22.5724      21.8311      27.8371      27.0189      46.7007      48.2854      44.3020      45.8061      35.9233      37.0111       0.0153       0.3275       0.3275       3.3958       0.2933    2557.8462      36.9161      45.9361     323.5625       0.0833    4717.5815    -999.2500    1209.0000       0.3263       0.3263
  376.5804       0.7661      96.0000      96.3763       0.0624       0.0624       9.1903     207.6477     212.4904     213.6323     211.3486     207.6477     378.8384     376.0052     381.6716     381.6716     135.7677      36.8946       0.0508       0.0508      16.2160     130.7272       3.3901    2566.2603      14.7246      17.4656      15.5732      18.5604      20.9144      23.7774      67.9137      57.2556      64.2130      53.8780      47.8140      42.0567       0.0153       0.2987       0.2987       3.3498       0.2898    2547.1179      46.7007      67.1448     333.0000       0.0720    4815.8496    -999.2500    1221.0000       0.3090       0.3090
  376.7328       0.7665      96.0000      96.6901       0.0703       0.0703       4.8573     205.4049     210.5381     212.4944     208.5817     205.4049     378.4904     376.3138     380.6671     380.6671     130.7848      36.9014       0.0752       0.0752       3.5209     117.9590       3.1838    2525.9031      11.9073      14.7456      12.5787      15.7328      17.8027      21.0698      83.9820      67.8170      79.4994      63.5615      56.1713      47.4613       0.0152       0.2997       0.2997       3.2255       0.2946    2533.9585      67.9137      75.7925     324.8125       0.0660    4868.4321    -999.2500    1203.0000       0.3025       0.3025
  376.8852       0.7672      96.0000      96.8471       0.0780       0.0780       4.4143     204.9564     208.4693     211.2383     205.7003     204.9564     378.6539     376.3855     380.9222     380.9222     128.9955      36.9083       0.0796       0.0796       2.8021     145.0189       3.1197    2518.7310      12.3274      12.9999      13.1633      13.8765      18.2930      19.1022      81.1201      76.9237      75.9689      72.0641      54.6657      52.3501       0.0152       0.3116       0.3116       3.1998       0.2963    2521.2549      83.9820      75.4144     328.4375       0.0647    4879.0874    -999.2500    1211.0000       0.3055       0.3055
  377.0376       0.7679      96.0000      96.6901       0.0717       0.0717       8.1335     204.5719     206.8062     209.4880     204.1243     204.5719     378.2548     376.5293     379.9803     379.9803     127.2629      36.9151       0.0799       0.0799       5.7419     124.0087       3.3121    2518.0837      12.5145      11.8617      13.4443      12.6986      18.6146      17.8429      79.9076      84.3049      74.3809      78.7486      53.7213      56.0447       0.0152       0.3170       0.3170       3.2744       0.2959    2531.6255      81.1201      77.8271     323.6875       0.0637    4888.2568    -999.2500    1209.0000       0.3078       0.3078
  377.1900       0.7687      96.0000      96.4809       0.0774       0.0774       7.5063     203.8670     199.5491     197.8036     201.2946     203.8670     377.8838     379.3535     376.4140     376.4140     120.1302      36.9219       0.0561       0.0561      14.6154     114.1420       3.3972    2557.3589      11.2473      10.9462      12.3013      11.7851      17.5309      17.0574      88.9105      91.3556      81.2924      84.8528      57.0423      58.6256       0.0151       0.3006       0.3006       3.2881       0.2925    2522.3416      79.9076      84.2176     327.9375       0.0617    4905.1582    -999.2500    1230.0000       0.3040       0.3040
  377.3424       0.7694      96.0000      96.6901       0.0753       0.0753       6.4611     203.5466     201.0552     196.8589     205.2515     203.5466     375.6437     377.4653     373.8221     373.8221     121.9081      36.9288       0.0967       0.0967      -0.1585     123.1241       3.1647    2490.4702       9.8290      10.2333      10.7918      11.1205      16.0586      16.4035     101.7394      97.7199      92.6629      89.9241      62.2718      60.9627       0.0151       0.2901       0.2901       3.2317       0.2893    2525.7371      88.9105      86.2074     326.1250       0.0609    4912.8789    -999.2500    1225.0000       0.2970       0.2970
  377.4948       0.7687      96.0000      96.4809       0.0858       0.0858       2.4752     203.8029     203.7405     198.5974     208.8837     203.8029     375.3875     377.0528     373.7222     373.7222     126.0723      36.9356       0.0727       0.0727       6.5688     129.3423       3.1382    2530.0933       8.8332       9.7929       9.8304      10.7584      15.1021      16.0089     113.2091     102.1150     101.7255      92.9509      66.2157      62.4651       0.0151       0.2883       0.2883       3.1297       0.2884    2508.3850     101.7394      88.9840     321.3750       0.0616    4906.7002    -999.2500    1209.0000       0.2906       0.2906
  377.6472       0.7679      96.0000      96.7948       0.0767       0.0767      10.1800     204.3156     210.6408     210.9720     210.3096     204.3156     375.3575     376.2809     374.4341     374.4341     119.5172      36.9425       0.0868       0.0868       5.5416     124.8651       3.0987    2506.8267       8.2054       9.8245       9.1527      10.8731      14.4464      16.0923     121.8703     101.7866     109.2579      91.9705      69.2214      62.1414       0.0150       0.2863       0.2863       3.1319       0.2880    2523.3953     113.2091      92.6119     332.0000       0.0630    4894.3892    -999.2500    1208.0000       0.2877       0.2877
  377.7996       0.7672      96.0000      96.3763       0.0835       0.0835      10.1197     206.1098     212.5085     213.1289     211.8880     206.1098     378.6030     379.4279     377.7780     377.7780     117.1921      36.9493       0.0746       0.0746      13.9735     103.9557       3.1595    2526.8623       8.2341      10.6538       8.9031      11.7116      14.2320      16.9574     121.4457      93.8633     112.3210      85.3855      70.2644      58.9714       0.0150       0.2776       0.2776       3.0920       0.2881    2512.2988     121.8703      89.2649     320.5625       0.0679    4851.7827    -999.2500    1219.0000       0.2834       0.2834
  377.9520       0.7666      96.0000      96.6901       0.0886       0.0886      10.9118     209.6021     215.3880     215.5720     215.2040     209.6021     393.0152     392.0286     394.0017     394.0017     110.3598      36.9561       0.0891       0.0891      10.9164     122.3670       3.0271    2502.9387      10.1668      12.8173      10.7771      13.8541      15.8732      19.1878      98.3598      78.0193      92.7892      72.1807      62.9994      52.1163       0.0150       0.2849       0.2849       3.1062       0.3026    2503.8843     121.4457      85.0562     331.9375       0.0772    4770.9448    -999.2500    1209.0000       0.2905       0.2905
  378.1044       0.7656      96.0000      96.5332       0.0969       0.0969       9.3668     214.7925     220.5699     219.6100     221.5299     214.7925     408.6229     410.1927     407.0530     407.0530     117.3791      36.9630       0.1025       0.1025       5.9793     105.7757       3.1282    2480.8359      14.6102      16.3481      15.5636      17.5213      20.4640      22.6234      68.4454      61.1692      64.2524      57.0732      48.8662      44.2021       0.0149       0.2930       0.2930       3.1708       0.3071    2490.0610      98.3598      76.3761     322.1875       0.0904    4655.6563    -999.2500    1218.0000       0.2992       0.2992
  378.2568       0.7646      96.0000      96.3763       0.1009       0.1009       8.2661     220.3994     227.4104     227.9577     226.8631     220.3994     422.7419     423.9343     421.5495     421.5495     120.7774      36.9698       0.0997       0.0997      10.1570     125.0134       3.3600    2485.5386      20.5961      19.7802      21.8811      21.2123      27.0297      26.3490      48.5530      50.5555      45.7015      47.1424      36.9963      37.9521       0.0149       0.3224       0.3224       3.2021       0.3119    2483.4956      68.4454      62.0840     330.0000       0.1040    4537.2178    -999.2500    1221.0000       0.3219       0.3219
  378.4092       0.7650      96.0000      96.5855       0.0964       0.0964       6.1497     227.2558     231.3560     233.7803     228.9317     227.2558     435.7290     437.9107     433.5474     433.5474     151.9862      36.9766       0.1047       0.1047       2.8599     131.6543       3.1208    2477.1812      27.3965      23.9761      28.6779      25.2583      33.6586      30.5043      36.5011      41.7082      34.8700      39.5910      29.7101      32.7822       0.0149       0.3473       0.3473       3.2212       0.3106    2490.9263      48.5530      47.0501     322.1875       0.1197    4400.3271    -999.2500    1224.0000       0.3356       0.3356
  378.5616       0.7655      96.0000      96.3763       0.0855       0.0855       5.6524     231.7093     237.1394     238.4808     235.7980     231.7093     443.2014     445.3155     441.0873     441.0873     236.0955      36.9835       0.0863       0.0863       2.9889     196.8372       3.1769    2507.5295      31.5645      27.1388      32.7100      28.4320      37.9197      33.4191      31.6812      36.8476      30.5717      35.1717      26.3715      29.9230       0.0148       0.3585       0.3585       3.1951       0.3094    2508.8494      36.5011      34.9744     328.3125       0.1294    4315.7524    -999.2500    1232.0000       0.3425       0.3425
  378.7140       0.7688      96.0000      96.6901       0.0804       0.0804       4.4403     230.8122     234.2709     236.9698     231.5719     230.8122     437.1463     439.5818     434.7107     434.7107     338.0263      36.9903       0.0672       0.0672       7.8760     377.3412       3.2941    2539.0952      32.8122      27.6620      33.7713      28.8540      39.2496      34.0663      30.4765      36.1507      29.6109      34.6572      25.4779      29.3545       0.0148       0.3754       0.3754       3.2619       0.3037    2517.3962      31.6812      30.0771     322.1875       0.1275    4332.5264    -999.2500    1268.0000       0.3499       0.3499
  378.8664       0.7722      96.0000      96.6901       0.0713       0.0713       7.8480     227.8966     230.8502     235.0436     226.6567     227.8966     423.5474     423.7185     423.3763     423.3763     345.3720      36.9971       0.0869       0.0869       1.6053     438.3545       3.3129    2506.5618      30.0204      25.9116      30.8349      26.9180      36.5461      32.3985      33.3107      38.5927      32.4308      37.1499      27.3627      30.8656       0.0148       0.3859       0.3859       3.2387       0.2960    2532.3337      30.4765      33.9038     322.1875       0.1211    4387.9546    -999.2500    1297.0000       0.3559       0.3559
  379.0188       0.7743      96.0000      96.5332       0.0646       0.0646       7.3303     223.1548     228.2477     229.5091     226.9863     223.1548     406.0397     405.1687     406.9107     406.9107     256.5462      37.0040       0.0628       0.0628       7.0645     217.7763       3.1101    2546.3140      23.6269      22.3741      24.3740      23.1984      30.2982      28.9119      42.3246      44.6946      41.0273      43.1064      33.0052      34.5878       0.0147       0.3162       0.3162       3.1698       0.2849    2543.4553      33.3107      52.6294     329.2500       0.1104    4481.1948    -999.2500    1312.0000       0.3266       0.3266
  379.1712       0.7764      96.0000      96.2717       0.0543       0.0543       7.9074     223.0587     227.8022     226.6145     228.9900     223.0587     395.5992     394.8189     396.3795     396.3795     141.8964      37.0108       0.0441       0.0441      10.5955     110.8637       3.0847    2577.1536      16.5870      18.0569      17.3207      18.7876      23.3661      24.6783      60.2882      55.3805      57.7345      53.2267      42.7970      40.5214       0.0147       0.2733       0.2733       3.0362       0.2683    2560.3989      42.3246      86.9797     317.8125       0.1102    4483.1255    -999.2500    1227.0000       0.2926       0.2926
  379.3236       0.7765      96.0000      96.4809       0.0535       0.0535       8.5793     228.6976     233.5390     229.1718     237.9061     228.6976     416.3867     415.5255     417.2479     417.2479     101.4506      37.0177       0.0571       0.0571       4.9117      94.4052       2.9170    2555.8135      11.2204      13.9036      11.9377      14.6583      18.1496      20.7039      89.1238      71.9237      83.7680      68.2208      55.0975      48.3002       0.0147       0.2607       0.2607       3.0353       0.2853    2561.7749      60.2882     118.2290     328.1875       0.1229    4372.5859    -999.2500    1280.0000       0.2784       0.2784
  379.4760       0.7767      96.0000      96.5332       0.0727       0.0727       8.0141     237.1560     244.4245     243.9288     244.9201     237.1560     432.4290     438.4441     426.4139     426.4139      96.8214      37.0245       0.0564       0.0564      15.2884      99.7144       3.1287    2556.8792       8.5271      10.5466       9.3055      11.3909      15.5709      17.5973     117.2731      94.8169     107.4637      87.7891      64.2223      56.8268       0.0146       0.2706       0.2706       3.0309       0.2761    2530.0537      89.1238     122.1389     313.4375       0.1408    4216.6333    -999.2500    1240.0000       0.2858       0.2858
  379.6284       0.7776      96.0000      96.6901       0.0814       0.0814      12.2192     245.4542     250.6475     246.5890     254.7061     245.4542     450.3621     457.0945     443.6297     443.6297     106.9943      37.0313       0.1003       0.1003       9.3478      96.9764       3.0752    2484.5481       7.3645       8.1280       8.3643       9.0532      14.5895      15.3180     135.7857     123.0308     119.5552     110.4581      68.5425      65.2827       0.0146       0.3200       0.3200       3.0286       0.2794    2515.6687     117.2731     113.3946     322.9375       0.1572    4074.0791    -999.2500    1219.0000       0.3086       0.3086
  379.7808       0.7786      96.0000      96.4809       0.1057       0.1057       8.7911     257.9176     262.4046     260.6222     264.1869     257.9176     457.8185     461.7195     453.9176     453.9176     112.3810      37.0382       0.0856       0.0856      14.4518     124.9238       2.9093    2508.6836       6.1438       6.4373       7.3114       7.3888      13.5963      13.6173     162.7662     155.3438     136.7726     135.3394      73.5492      73.4361       0.0146       0.3283       0.3283       3.0112       0.2616    2475.5493     135.7857     127.0961     313.4375       0.1798    3877.2075    -999.2500    1179.0000       0.3268       0.3268
  379.9332       0.7789      96.0000      96.8471       0.1105       0.1105      11.8129     262.1468     267.6559     264.4018     270.9101     262.1468     473.4307     476.8310     470.0304     470.0304     122.8922      37.0450       0.1301       0.1301       4.3785     115.2427       3.0545    2435.3091       4.7712       5.2493       5.9160       6.1792      12.2160      12.3765     209.5912     190.5023     169.0327     161.8335      81.8602      80.7980       0.0145       0.3464       0.3464       2.9340       0.2743    2467.6953     162.7662     178.2575     318.1875       0.1870    3814.6565    -999.2500    1171.0000       0.3411       0.3411
  380.0856       0.7793      96.0000      96.5332       0.1159       0.1159       9.3931     251.4456     265.2097     261.6945     268.7249     251.4456     472.3149     469.6526     474.9772     474.9772     121.3618      37.0518       0.1163       0.1163      12.9554     127.4904       2.8417    2458.0601       3.6192       4.5032       4.3807       5.3620      10.8723      11.6651     276.3022     222.0639     228.2751     186.4986      91.9768      85.7258       0.0145       0.3842       0.3842       3.0472       0.3053    2458.8250     209.5912     238.3119     326.8125       0.1683    3977.0029    -999.2500    1185.0000       0.3476       0.3476
  380.2380       0.7788      96.0000      96.2717       0.0885       0.0885      10.5062     235.7463     243.1914     238.6625     247.7202     235.7463     419.5161     419.9739     419.0584     419.0584     121.4023      37.0587       0.1034       0.1034       4.5493     120.6377       3.2753    2479.3220       3.1592       4.2607       3.7252       5.0832      10.3514      11.5783     316.5321     234.7014     268.4439     196.7246      96.6057      86.3684       0.0144       0.3537       0.3537       3.1666       0.2685    2504.0408     276.3022     302.8917     321.6250       0.1379    4241.8481    -999.2500    1137.0000       0.3226       0.3226
  380.3904       0.7784      96.0000      96.2194       0.0591       0.0591       5.7031     212.9022     208.6523     217.8382     199.4663     212.9022     357.3700     337.3898     377.3501     377.3501     120.5949      37.0655       0.0429       0.0429       7.8399     115.3640       3.4418    2579.2578       3.6017       4.5731       4.3364       5.4815      10.7795      12.1114     277.6463     218.6705     230.6049     182.4334      92.7689      82.5669       0.0144       0.2453       0.2453       3.3796       0.2665    2552.4619     316.5321     244.8708     331.9375       0.0856    4696.9932    -999.2500    1186.0000       0.2729       0.2729
  380.5428       0.7776      96.0000      96.5855       0.0283       0.0283      10.2640     196.1135     196.9771     198.6981     195.2561     196.1135     348.5506     350.4029     346.6982     346.6982     119.5013      37.0724       0.0170       0.0170      15.2279     125.6162       3.4348    2621.9514       5.0218       5.6814       5.9214       6.7394      12.2560      13.1674     199.1316     176.0114     168.8794     148.3810      81.5925      75.9452       0.0144       0.2076       0.2076       3.4564       0.2647    2603.3083     277.6463     165.8757     319.6250       0.0395    5099.0884    -999.2500    1208.0000       0.2460       0.2460
  380.6952       0.7767      96.0000      96.4809       0.0329       0.0329       8.4057     195.7610     198.2722     196.6682     199.8763     195.7610     350.1880     349.0880     351.2881     351.2881     129.4149      37.0792       0.0212       0.0212      12.3151     118.1410       3.4932    2615.0579       6.9930       7.3382       7.9141       8.3873      14.1906      14.7315     142.9992     136.2728     126.3563     119.2275      70.4692      67.8820       0.0143       0.2348       0.2348       3.4289       0.2748    2595.7532     199.1316     134.8450     334.1875       0.0384    5108.2681    -999.2500    1225.0000       0.2371       0.2371
  380.8476       0.7765      96.0000      96.3763       0.0503       0.0503       6.6737     199.6058     199.1504     198.3704     199.9305     199.6058     362.5815     359.9719     365.1912     365.1912     144.4115      37.0860       0.0538       0.0538       5.4514     145.1046       3.3651    2561.2134       9.1475       8.9498      10.0438       9.9566      16.1718      16.2212     109.3190     111.7345      99.5644     100.4356      61.8362      61.6476       0.0143       0.2295       0.2295       3.2920       0.2870    2566.9595     142.9992     118.8178     322.1875       0.0497    5009.8750    -999.2500    1226.0000       0.2426       0.2426
  381.0000       0.7762      96.0000      96.5855       0.0773       0.0773       1.5915     201.8485     204.0745     199.5120     208.6371     201.8485     367.0438     363.1865     370.9011     370.9011     155.8036      37.0929       0.0709       0.0709       6.9847     171.0781       3.0438    2533.0442      11.5652      10.6739      12.4757      11.6134      18.5336      17.7345      86.4663      93.6865      80.1557      86.1074      53.9559      56.3874       0.0143       0.2622       0.2622       3.1571       0.2896    2522.5356     109.3190      78.6050     337.6250       0.0561    4954.2095    -999.2500    1199.0000       0.2563       0.2563
  381.1524       0.7767      96.0000      96.3763       0.0826       0.0826       3.9617     203.2583     207.8816     208.8616     206.9016     203.2583     370.7646     367.1453     374.3838     374.3838     155.4548      37.0997       0.1012       0.1012      -1.6200     151.2281       3.0730    2482.9685      13.4328      11.8332      14.3816      12.7123      20.3696      18.8100      74.4448      84.5079      69.5333      78.6641      49.0928      53.1632       0.0143       0.3145       0.3145       3.1637       0.2910    2513.7480      86.4663      70.7176     323.8125       0.0601    4919.8486    -999.2500    1169.0000       0.2811       0.2811
  381.3048       0.7771      96.0000      96.5855       0.0867       0.0867       3.7477     201.5602     201.3174     199.4135     203.2213     201.5602     371.7056     370.3874     373.0237     373.0237     147.9380      37.1065       0.0770       0.0770       5.1768     143.3307       3.3714    2522.9155      14.0079      12.3456      15.0045      13.2222      20.9737      19.2213      71.3885      81.0008      66.6467      75.6305      47.6787      52.0257       0.0142       0.3063       0.3063       3.1978       0.2938    2506.9709      74.4448      67.0191     337.8125       0.0553    4961.2974    -999.2500    1210.0000       0.2875       0.2875
  381.4572       0.7773      96.0000      96.5855       0.0748       0.0748       7.1588     199.9903     198.9037     197.7890     200.0185     199.9903     366.1848     363.8183     368.5513     368.5513     138.6034      37.1134       0.0833       0.0833       6.3147     148.5277       3.1351    2512.5972      12.9946      12.1013      14.0018      13.0126      20.0297      18.9826      76.9551      82.6358      71.4195      76.8483      49.9258      52.6799       0.0142       0.2819       0.2819       3.3077       0.2913    2526.5452      71.3885      71.8744     324.8750       0.0508    5000.2432    -999.2500    1216.0000       0.2830       0.2830
  381.6096       0.7774      96.0000      96.4809       0.0704       0.0704       7.9278     199.6378     197.2031     195.2550     199.1511     199.6378     367.7412     369.7583     365.7241     365.7241     144.4304      37.1202       0.0646       0.0646      10.7591     123.2241       3.4018    2543.4756      11.3671      11.7109      12.3418      12.6072      18.3017      18.6130      87.9733      85.3908      81.0257      79.3195      54.6396      53.7259       0.0142       0.2700       0.2700       3.1979       0.2878    2533.8657      76.9551      90.5132     339.8750       0.0498    5009.0708    -999.2500    1217.0000       0.2704       0.2704
  381.7620       0.7765      96.0000      96.3763       0.0627       0.0627      13.5135     200.4068     199.4041     197.2672     201.5409     200.4068     368.5156     370.2999     366.7313     366.7313     145.4464      37.1271       0.0586       0.0586      13.8299     161.5394       3.0664    2553.2888       9.7077      11.1901      10.6108      12.1387      16.5936      18.0725     103.0111      89.3647      94.2435      82.3812      60.2643      55.3328       0.0141       0.2512       0.2512       3.2360       0.2871    2546.4949      87.9733      98.7567     337.9375       0.0520    4989.8516    -999.2500    1223.0000       0.2673       0.2673
  381.9144       0.7757      96.0000      96.6901       0.0761       0.0761       8.3896     202.2010     201.6018     196.8719     206.3318     202.2010     371.8157     371.0182     372.6132     372.6132     148.6022      37.1339       0.0672       0.0672      11.3873     150.7612       3.2611    2539.1987       9.1792      11.2757       9.9676      12.2119      15.9513      18.1802     108.9421      88.6860     100.3250      81.8874      62.6909      55.0050       0.0141       0.2601       0.2601       3.0931       0.2913    2524.5068     103.0111      90.6596     336.9375       0.0571    4945.5742    -999.2500    1216.0000       0.2690       0.2690
  382.0668       0.7754      96.0000      96.3763       0.0847       0.0847       7.1383     205.4049     211.9017     213.1177     210.6856     205.4049     376.2956     376.4569     376.1341     376.1341     135.8313      37.1407       0.1010       0.1010      -0.7571     131.3888       2.9589    2483.3396      10.2635      12.4556      11.0364      13.4196      16.8227      19.4072      97.4323      80.2851      90.6094      74.5179      59.4436      51.5272       0.0141       0.2717       0.2717       3.1272       0.2875    2510.3052     108.9421      85.6567     345.3750       0.0660    4868.4321    -999.2500    1256.0000       0.2788       0.2788
  382.2192       0.7752      96.0000      96.5332       0.1018       0.1018       1.6368     209.0895     214.7789     215.6955     213.8623     209.0895     392.4291     391.8338     393.0243     393.0243     117.9164      37.1476       0.0882       0.0882       5.2657     123.2267       3.1782    2504.4382      12.9403      14.9233      13.8106      15.9774      19.3354      21.7686      77.2778      67.0093      72.4079      62.5885      51.7186      45.9377       0.0140       0.2824       0.2824       3.0798       0.3026    2482.0818      97.4323      72.4214     341.6875       0.0758    4782.6416    -999.2500    1227.0000       0.2885       0.2885
  382.3716       0.7751      96.0000      96.6901       0.0985       0.0985       7.5459     213.9595     219.5758     219.7351     219.4165     213.9595     407.6346     408.1542     407.1149     407.1149     103.4384      37.1544       0.1120       0.1120       6.5164      97.8309       3.0942    2465.1409      17.3914      18.3538      18.4160      19.5276      23.6745      25.0580      57.4997      54.4847      54.3006      51.2096      42.2395      39.9075       0.0140       0.3294       0.3294       3.1787       0.3092    2487.4170      77.2778      61.7366     351.4375       0.0883    4673.7827    -999.2500    1210.0000       0.3116       0.3116
  382.5240       0.7750      96.0000      96.6901       0.1036       0.1036       8.3867     219.3421     226.7633     227.3575     226.1691     219.3421     422.5073     424.8977     420.1168     420.1168     103.1439      37.1612       0.0957       0.0957       9.3617      89.3801       3.2541    2492.1248      22.7159      21.7437      23.8156      22.9292      29.1664      28.3669      44.0220      45.9903      41.9893      43.6125      34.2860      35.2524       0.0140       0.3387       0.3387       3.2646       0.3126    2479.1189      57.4997      53.2969     345.6875       0.1015    4559.0884    -999.2500    1216.0000       0.3263       0.3263
  382.6764       0.7760      96.0000      96.5855       0.0998       0.0998       7.8245     225.2694     231.3955     230.6292     232.1617     225.2694     433.8773     433.6343     434.1205     434.1205     123.2075      37.1681       0.1028       0.1028       7.7355     122.3433       3.4422    2480.3726      28.3296      25.3725      29.3715      26.4828      34.3748      31.8890      35.2988      39.4127      34.0466      37.7603      29.0911      31.3588       0.0139       0.3444       0.3444       3.3254       0.3158    2485.3015      44.0220      42.2388     357.1250       0.1153    4439.1294    -999.2500    1247.0000       0.3385       0.3385
  382.8288       0.7770      96.0000      96.4809       0.0996       0.0996       7.6489     230.6200     236.0445     234.7567     237.3324     230.6200     442.3665     443.2068     441.5262     441.5262     175.0488      37.1749       0.0985       0.0985       9.0383     158.0215       3.2822    2487.5132      32.0914      27.8431      33.0166      28.8983      38.1082      33.9033      31.1610      35.9155      30.2878      34.6041      26.2411      29.4957       0.0139       0.3550       0.3550       3.3547       0.3124    2485.7297      35.2988      34.7215     348.6250       0.1271    4336.1377    -999.2500    1223.0000       0.3457       0.3457
  382.9812       0.7803      96.0000      96.1671       0.0902       0.0902       5.7572     232.9909     234.1367     232.9407     235.3328     232.9909     446.1869     447.5150     444.8587     444.8587     216.1306      37.1818       0.0973       0.0973       3.6413     244.7815       3.3384    2489.4182      32.9547      27.8141      33.7467      28.7730      39.0467      33.8664      30.3447      35.9531      29.6326      34.7548      25.6104      29.5278       0.0139       0.3790       0.3790       3.2411       0.3110    2501.1277      31.1610      32.1369     357.1875       0.1322    4292.0132    -999.2500    1229.0000       0.3537       0.3537
  383.1336       0.7835      96.0000      96.5332       0.0778       0.0778       7.5051     230.0753     232.1635     236.2918     228.0352     230.0753     436.0085     437.6872     434.3298     434.3298     209.4735      37.1886       0.0721       0.0721       7.3477     242.0149       3.1020    2530.9744      29.3720      25.5687      30.0777      26.4018      35.6448      31.7025      34.0460      39.1104      33.2472      37.8763      28.0545      31.5432       0.0138       0.3718       0.3718       3.2190       0.3050    2521.6736      30.3447      34.4379     341.6875       0.1259    4346.4028    -999.2500    1187.0000       0.3456       0.3456
  383.2860       0.7856      96.0000      96.5332       0.0707       0.0707       4.6693     226.9034     229.2279     230.3915     228.0643     226.9034     419.4137     423.4348     415.3926     415.3926     160.4996      37.1954       0.0658       0.0658       5.5328     138.0502       3.2061    2541.3503      22.5404      21.6290      23.2142      22.3474      29.0529      27.9151      44.3648      46.2342      43.0772      44.7480      34.4199      35.8229       0.0138       0.3217       0.3217       3.0926       0.2874    2533.4004      34.0460      52.2583     351.4375       0.1189    4407.1616    -999.2500    1196.0000       0.3228       0.3228
  383.4384       0.7877      96.0000      96.2717       0.0697       0.0697       4.8062     224.4364     227.2704     225.0897     229.4512     224.4364     403.4158     410.4678     396.3638     396.3638     112.7525      37.2023       0.0720       0.0720       4.3340      97.8599       2.9521    2531.1519      15.4099      17.0906      16.0386      17.7475      22.0808      23.5466      64.8932      58.5118      62.3496      56.3459      45.2883      42.4690       0.0138       0.2710       0.2710       3.0592       0.2640    2534.9272      44.3648      87.0917     334.3125       0.1134    4455.6060    -999.2500    1235.0000       0.2974       0.2974
  383.5908       0.7885      96.0000      96.7948       0.0710       0.0710       8.7375     224.6606     230.6187     228.6626     232.5748     224.6606     409.1887     414.2712     404.1061     404.1061     104.0358      37.2091       0.0689       0.0689       9.0668     102.6239       3.0197    2536.2871      10.2995      12.6837      10.8402      13.3067      17.0941      19.3477      97.0922      78.8413      92.2494      75.1501      58.4997      51.6858       0.0137       0.2793       0.2793       3.0312       0.2763    2532.8296      64.8932     113.0229     343.8125       0.1139    4451.1582    -999.2500    1204.0000       0.2894       0.2894
  383.7432       0.7892      96.0000      96.5332       0.0712       0.0712       7.6687     229.0821     234.4862     231.0426     237.9297     229.0821     413.9431     418.2634     409.6227     409.6227     110.6964      37.2159       0.0753       0.0753       7.2003     111.9001       3.1043    2525.6853       7.3738       9.3071       7.8906       9.8873      14.2632      16.1431     135.6156     107.4450     126.7329     101.1394      70.1103      61.9460       0.0137       0.2877       0.2877       3.0310       0.2724    2532.5083      97.0922     134.8251     329.8750       0.1237    4365.2476    -999.2500    1209.0000       0.2876       0.2876
  383.8956       0.7892      96.0000      96.5332       0.0766       0.0766       6.7684     231.5171     233.8913     228.1346     239.6481     231.5171     419.0547     425.2065     412.9030     412.9030     114.7548      37.2228       0.0685       0.0685       7.4621     118.5691       2.9690    2536.9973       5.6016       7.0725       6.1721       7.6390      12.6383      14.0134     178.5213     141.3932     162.0197     130.9073      79.1248      71.3603       0.0137       0.2879       0.2879       3.0748       0.2707    2523.6851     135.6156     169.8025     331.9375       0.1290    4319.3354    -999.2500    1195.0000       0.2878       0.2878
  384.0480       0.7891      96.0000      96.6901       0.0756       0.0756       4.9766     228.4413     232.9422     231.3635     234.5209     228.4413     414.2852     418.2064     410.3640     410.3640     119.0829      37.2296       0.0883       0.0883       0.4724     114.5228       3.1515    2504.3242       4.6845       5.8220       5.3321       6.4215      11.9068      12.8895     213.4699     171.7610     187.5427     155.7278      83.9856      77.5827       0.0136       0.2978       0.2978       3.0540       0.2755    2525.3247     178.5213     163.0837     338.8750       0.1223    4377.4922    -999.2500    1175.0000       0.2904       0.2904
  384.2004       0.7881      96.0000      96.3763       0.0714       0.0714       5.9069     222.8664     227.5717     226.5765     228.5670     222.8664     403.9543     406.1707     401.7379     401.7379     122.6110      37.2364       0.0674       0.0674       9.5198     124.8842       3.0416    2538.7295       4.3282       5.4469       4.9384       6.1160      11.6282      12.6926     231.0449     183.5910     202.4946     163.5069      85.9980      78.7860       0.0136       0.2912       0.2912       3.1323       0.2777    2532.1938     213.4699     192.5977     331.3750       0.1098    4486.9927    -999.2500    1210.0000       0.2859       0.2859
  384.3528       0.7871      96.0000      96.3763       0.0644       0.0644       5.8454     215.7537     219.4835     218.5013     220.4657     215.7537     389.7023     392.1012     387.3035     387.3035     124.8517      37.2433       0.0563       0.0563       9.4396     128.4259       3.2146    2557.0947       4.6027       5.9546       5.1294       6.7096      11.8447      13.4020     217.2646     167.9366     194.9538     149.0403      84.4262      74.6158       0.0136       0.2522       0.2522       3.1406       0.2750    2543.7266     231.0449     225.3304     341.6875       0.0928    4634.9155    -999.2500    1228.0000       0.2726       0.2726
  384.5052       0.7864      96.0000      96.3763       0.0617       0.0617       4.2425     210.9157     214.8586     214.3427     215.3745     210.9157     385.4966     391.5474     379.4458     379.4458     116.6901      37.2501       0.0672       0.0672       1.1826     119.8571       3.1741    2539.1362       5.8620       7.3907       6.4611       8.2471      12.9863      14.9654     170.5890     135.3059     154.7716     121.2552      77.0044      66.8210       0.0135       0.2395       0.2395       3.1718       0.2764    2548.2410     217.2646     151.1821     327.5000       0.0806    4741.2305    -999.2500    1210.0000       0.2602       0.2602
  384.6576       0.7856      96.0000      96.2194       0.0643       0.0643       4.0882     210.8516     215.0847     213.5403     216.6291     210.8516     389.0847     391.4456     386.7239     386.7239     111.7524      37.2570       0.0587       0.0587       5.6056     100.3994       3.1261    2553.1597       8.3395       9.7160       9.1022      10.6741      15.2037      17.2029     119.9106     102.9225     109.8631      93.6849      65.7734      58.1296       0.0135       0.2680       0.2680       3.1271       0.2885    2543.8391     170.5890     110.8799     341.6875       0.0804    4742.6714    -999.2500    1235.0000       0.2664       0.2664
  384.8100       0.7855      96.0000      96.3763       0.0630       0.0630       8.1384     216.2022     219.6742     218.5802     220.7682     216.2022     397.7553     396.3197     399.1910     399.1910     115.8260      37.2638       0.0662       0.0662       7.3371     113.6130       3.0993    2540.7336      12.3142      12.5137      13.2151      13.5376      19.0139      19.5279      81.2073      79.9121      75.6710      73.8683      52.5932      51.2087       0.0135       0.2840       0.2840       3.1984       0.2925    2546.0532     119.9106      86.2747     329.5000       0.0939    4625.2993    -999.2500    1226.0000       0.2783       0.2783
  384.9624       0.7853      96.0000      96.3763       0.0712       0.0712       8.2046     218.6372     220.7154     220.2369     221.1939     218.6372     409.4810     414.2732     404.6887     404.6887     127.8080      37.2706       0.0643       0.0643      11.1816     134.0593       3.4081    2543.8311      17.4620      15.5417      18.4291      16.5395      23.6454      22.1726      57.2673      64.3431      54.2621      60.4614      42.2915      45.1006       0.0134       0.2931       0.2931       3.2505       0.2939    2532.4897      81.2073      62.6653     335.1875       0.0998    4573.7866    -999.2500    1244.0000       0.2913       0.2913
  385.1148       0.7858      96.0000      96.5332       0.0753       0.0753      10.0374     218.3168     218.2708     219.2287     217.3128     218.3168     415.0317     415.0435     415.0199     415.0199     145.5416      37.2775       0.0813       0.0813       9.0283     136.3453       3.2851    2515.9053      21.0639      17.7571      21.9970      18.7122      27.0872      23.9307      47.4745      56.3153      45.4608      53.4411      36.9178      41.7874       0.0134       0.3046       0.3046       3.3619       0.3087    2525.7949      57.2673      46.1194     332.8125       0.0990    4580.4990    -999.2500    1249.0000       0.3022       0.3022
  385.2672       0.7863      96.0000      96.3763       0.0819       0.0819       8.8327     218.0285     216.5191     217.2072     215.8310     218.0285     413.7353     412.8785     414.5921     414.5921     143.6350      37.2843       0.0789       0.0789      11.4525     165.2851       3.4101    2519.7485      21.1649      18.7572      22.0329      19.6522      27.1938      24.7436      47.2480      53.3129      45.3868      50.8850      36.7731      40.4146       0.0134       0.3326       0.3326       3.2855       0.3089    2514.8582      47.4745      49.5384     338.5625       0.0983    4586.5566    -999.2500    1230.0000       0.3167       0.3167
  385.4196       0.7873      96.0000      96.3763       0.0866       0.0866       9.0645     213.5109     215.3599     216.1709     214.5490     213.5109     407.8656     410.2178     405.5135     405.5135     145.6726      37.2911       0.0822       0.0822      11.5494     128.1151       3.1660    2514.4368      19.3987      18.6280      20.2065      19.4784      25.4917      24.6404      51.5499      53.6826      49.4891      51.3390      39.2284      40.5837       0.0133       0.3281       0.3281       3.2847       0.3082    2507.0969      47.2480      58.7720     339.5625       0.0872    4683.6016    -999.2500    1228.0000       0.3303       0.3303
  385.5720       0.7882      96.0000      96.4809       0.0939       0.0939       4.4306     212.8381     213.7649     216.0157     211.5141     212.8381     400.0468     396.1664     403.9272     403.9272     129.0832      37.2980       0.1000       0.1000       1.8147     142.4582       3.2823    2485.0793      17.6992      17.8016      18.5055      18.6206      23.8405      23.9071      56.4996      56.1746      54.0380      53.7039      41.9455      41.8285       0.0133       0.3340       0.3340       3.1857       0.3078    2495.1296      51.5499      59.3424     331.5625       0.0855    4698.4072    -999.2500    1235.0000       0.3304       0.3304
  385.7244       0.7891      96.0000      96.2717       0.0917       0.0917       5.3999     212.3255     213.8124     217.1743     210.4505     212.3255     399.8484     406.6901     393.0066     393.0066     127.2982      37.3048       0.0964       0.0964       4.5091     115.5352       3.1067    2490.9756      16.4536      16.8284      17.2414      17.6045      22.6402      22.9872      60.7769      59.4233      58.0001      56.8036      44.1693      43.5025       0.0133       0.3487       0.3487       3.1787       0.2939    2498.6172      56.4996      58.1723     342.6875       0.0842    4709.7510    -999.2500    1210.0000       0.3368       0.3368
  385.8768       0.7899      96.0000      96.3763       0.0841       0.0841       6.5342     209.8264     212.7244     216.8245     208.6243     209.8264     393.1810     394.0016     392.3605     392.3605     120.8503      37.3117       0.0780       0.0780      10.8767     122.3907       3.1291    2521.3774      15.5096      15.7645      16.2963      16.5089      21.7674      21.9092      64.4761      63.4337      61.3637      60.5736      45.9402      45.6429       0.0132       0.3712       0.3712       3.1699       0.2997    2511.2998      60.7769      60.1752     330.8750       0.0777    4765.8452    -999.2500    1232.0000       0.3391       0.3391
  386.0292       0.7900      96.0000      96.4809       0.0734       0.0734      12.0685     207.5195     208.8110     212.5218     205.1003     207.5195     385.6511     391.0004     380.3017     380.3017     122.3165      37.3185       0.0731       0.0731      11.1056     123.1146       3.2605    2529.3669      14.6270      15.1277      15.3560      15.7844      20.9968      21.2577      68.3670      66.1038      65.1210      63.3536      47.6263      47.0419       0.0132       0.3538       0.3538       3.2168       0.2880    2528.8340      64.4761      71.7364     338.5000       0.0717    4818.8232    -999.2500    1249.0000       0.3262       0.3262
  386.1816       0.7900      96.0000      96.3763       0.0705       0.0705       8.6198     206.1098     203.1127     206.6459     199.5796     206.1098     374.6501     375.1550     374.1452     374.1452     120.2516      37.3253       0.0727       0.0727       8.0369     121.4440       3.2452    2530.0889      13.6960      15.1167      14.2278      15.6958      20.0529      21.3314      73.0142      66.1520      70.2850      63.7113      49.8682      46.8792       0.0132       0.2692       0.2692       3.1394       0.2822    2533.7048      68.3670      92.5680     331.7500       0.0679    4851.7827    -999.2500    1191.0000       0.2883       0.2883
  386.3340       0.7889      96.0000      96.5332       0.0684       0.0684      10.5339     207.4234     213.1745     217.8181     208.5309     207.4234     384.1683     382.2688     386.0677     386.0677     115.5065      37.3322       0.0617       0.0617      13.1256     116.1961       2.9334    2548.1411      12.9044      16.1143      13.3012      16.6799      19.1930      22.5090      77.4931      62.0569      75.1812      59.9522      52.1024      44.4266       0.0131       0.2249       0.2249       3.0800       0.2971    2537.2075      73.0142     103.9949     339.3125       0.0714    4821.0566    -999.2500    1197.0000       0.2644       0.2644
  386.4864       0.7877      96.0000      96.1671       0.0723       0.0723      11.3868     214.9206     222.1175     223.8272     220.4077     214.9206     399.9036     394.4072     405.4000     405.4000     114.0657      37.3390       0.0662       0.0662      15.3458     107.9909       3.0656    2540.7043      15.1539      18.3218      15.6002      18.9097      21.1489      24.6256      65.9897      54.5799      64.1019      52.8829      47.2837      40.6081       0.0131       0.2322       0.2322       3.0863       0.3045    2530.6235      77.4931      85.5891     333.4375       0.0907    4652.8799    -999.2500    1196.0000       0.2625       0.2625
  386.6388       0.7899      96.0000      96.4809       0.0785       0.0785      13.3467     225.4296     228.9615     228.6299     229.2931     225.4296     428.7061     434.5040     422.9081     422.9081     147.7845      37.3458       0.0827       0.0827      13.8712     117.1217       3.2729    2513.5745      21.7907      21.2210      22.2490      21.8078      27.6060      27.3748      45.8911      47.1232      44.9458      45.8551      36.2240      36.5300       0.0131       0.2843       0.2843       3.1799       0.3015    2520.4167      65.9897      55.2267     341.6250       0.1156    4435.9751    -999.2500    1182.0000       0.2779       0.2779
  386.7912       0.7920      96.0000      96.3763       0.0877       0.0877       7.6443     232.3821     239.6737     241.4649     237.8826     232.3821     441.9593     441.6468     442.2719     442.2719     213.3777      37.3527       0.0865       0.0865       8.5401     217.3523       3.2003    2507.2864      29.2659      23.4782      29.7156      24.0230      34.7070      29.3601      34.1695      42.5928      33.6524      41.6268      28.8126      34.0598       0.0130       0.3721       0.3721       3.1514       0.3093    2505.2898      45.8911      31.5893     341.6875       0.1309    4303.2563    -999.2500    1221.0000       0.3145       0.3145
  386.9436       0.7956      96.0000      96.3763       0.0829       0.0829       3.8134     237.3803     240.1559     240.7738     239.5380     237.3803     439.8060     438.7827     440.8292     440.8292     248.0129      37.3595       0.0943       0.0943      -0.0524     303.8895       2.9858    2494.3533      31.0612      23.6899      31.4949      24.1737      36.3989      29.1656      32.1945      42.2121      31.7512      41.3673      27.4733      34.2870       0.0130       0.3868       0.3868       3.0532       0.2958    2513.2832      34.1695      28.9304     341.6875       0.1413    4212.6494    -999.2500    1243.0000       0.3363       0.3363
  387.0960       0.7992      96.0000      96.2194       0.0790       0.0790       3.9045     241.5134     243.0286     245.1981     240.8592     241.5134     427.4984     422.1432     432.8535     432.8535     214.8703      37.3664       0.0654       0.0654       5.8006     221.0272       2.9788    2542.1296      24.8731      21.3892      25.3107      21.8108      30.4648      26.7142      40.2040      46.7526      39.5090      45.8488      32.8248      37.4332       0.0130       0.3321       0.3321       2.8992       0.2740    2519.6145      32.1945      54.1748     348.0000       0.1495    4140.5571    -999.2500    1233.0000       0.3370       0.3370
  387.2484       0.7997      96.0000      96.3763       0.0851       0.0851       6.4203     249.0427     251.1940     262.2391     240.1488     249.0427     451.4844     457.0002     445.9688     445.9688     145.8935      37.3732       0.0774       0.0774       7.6170     117.7786       2.7465    2522.3584      16.2431      17.2687      16.6766      17.6552      22.1677      22.8152      61.5645      57.9082      59.9644      56.6406      45.1106      43.8304       0.0129       0.2846       0.2846       2.9015       0.2734    2509.6284      40.2040     121.4428     329.5000       0.1639    4015.3762    -999.2500    1243.0000       0.3244       0.3244
  387.4008       0.8001      96.0000      96.2717       0.1125       0.1125      11.8220     265.0944     262.5834     262.3194     262.8475     265.0944     493.1051     510.9275     475.2827     475.2827     110.4232      37.3800       0.1059       0.1059      11.0062      99.4586       2.9860    2475.2969      10.3367      12.8048      10.8095      13.2235      16.6508      18.8146      96.7431      78.0955      92.5113      75.6231      60.0573      53.1501       0.0129       0.2908       0.2908       2.8868       0.2742    2464.3474      61.5645     186.2041     341.6875       0.1918    3772.2407    -999.2500    1233.0000       0.3322       0.3322
  387.5532       0.8001      96.0000      96.0625       0.1446       0.1446      16.8540     285.2793     280.5101     274.1235     286.8967     285.2793     542.1481     552.9050     531.3913     531.3913     108.9940      37.3869       0.1498       0.1498      14.2732     114.9772       2.9275    2402.7737       6.9170       8.9076       7.4644       9.4232      13.5339      15.2552     144.5714     112.2641     133.9695     106.1207      73.8885      65.5514       0.0129       0.3603       0.3603       2.9102       0.2975    2411.4805      96.7431     189.9588     325.0625       0.2225    3505.3369    -999.2500    1236.0000       0.3653       0.3653
  387.7056       0.8001      96.0000      96.3763       0.1730       0.1730      12.4544     291.6551     362.9645     305.5259     420.4031     291.6551     685.0701     591.9777     778.1625     778.1625     111.0013      37.3937       0.1775       0.1775      15.8811     113.6367       2.8274    2357.0916       4.6593       6.1700       5.1865       6.7745      11.5433      12.8146     214.6266     162.0751     192.8094     147.6118      86.6304      78.0361       0.0128       0.4718       0.4718       2.9282       0.4183    2364.6096     144.5714     148.9806     332.6250       0.2313    3428.7070    -999.2500    1233.0000       0.4144       0.4144
  387.8580       0.8002      96.0000      96.3763       0.1853       0.1853       5.1314     299.6009     307.3719     293.7403     321.0036     299.6009     574.9313     556.0767     593.7861     593.7861     117.8559      37.4005       0.1961       0.1961      -1.5879     104.7508       3.0484    2326.4060       3.3829       4.4457       3.7625       4.9818      10.4110      11.3168     295.6043     224.9361     265.7780     200.7287      96.0522      88.3640       0.0128       0.5128       0.5128       2.9884       0.3292    2344.2107     214.6266     146.7169     324.8125       0.2417    3337.7734    -999.2500    1209.0000       0.4518       0.4518
  388.0104       0.8003      96.0000      96.4809       0.1703       0.1703       2.2546     285.0230     289.3458     295.1106     283.5810     285.0230     515.4384     506.3145     524.5624     524.5624     125.9726      37.4074       0.1842       0.1842      -1.2558     134.4301       3.1154    2346.0762       2.7358       3.7560       2.6227       4.1028       9.2742      10.7520     365.5178     266.2382     381.2927     243.7339     107.8263      93.0063       0.0127       0.4362       0.4362       3.0321       0.2905    2368.9932     295.6043     355.2983     328.8125       0.2221    3508.4890    -999.2500    1205.0000       0.4166       0.4166
  388.1628       0.7988      96.0000      96.6901       0.1332       0.1332       3.1025     258.1739     267.9879     269.5872     266.3885     258.1739     431.7984     385.9592     477.6376     477.6376     139.9702      37.4142       0.1290       0.1290       7.9633     137.9869       2.9476    2437.1487       2.7939       4.0407       2.3704       4.4320       8.8750      11.0849     357.9285     247.4838     421.8732     225.6320     112.6760      90.2131       0.0127       0.3742       0.3742       3.1466       0.2936    2430.3005     365.5178     459.3990     344.8750       0.1802    3873.3582    -999.2500    1220.0000       0.3751       0.3751
  388.3152       0.7973      96.0000      96.3763       0.0855       0.0855       6.8766     241.8017     244.7595     240.2518     249.2671     241.8017     388.5472     363.3102     413.7842     413.7842     150.3541      37.4211       0.0750       0.0750       8.0771     146.7436       3.3643    2526.2043       3.5648       5.1450       3.8118       5.8924      10.0753      12.3990     280.5233     194.3624     262.3456     169.7087      99.2530      80.6517       0.0126       0.2922       0.2922       3.2418       0.2407    2508.9563     357.9285     358.7405     334.5000       0.1501    4135.6196    -999.2500    1230.0000       0.3104       0.3104
  388.4676       0.7964      96.0000      96.4809       0.0673       0.0673       4.4592     220.2712     222.9958     223.9604     222.0312     220.2712     399.8383     392.3243     407.3524     407.3524     153.5340      37.4279       0.0448       0.0448       8.1692     166.6428       3.4283    2576.0757       5.7162       7.2542       6.6026       8.4232      12.6166      14.6888     174.9418     137.8518     151.4544     118.7204      79.2603      68.0790       0.0126       0.2180       0.2180       3.3409       0.2934    2538.9150     280.5233     193.8662     353.5000       0.1037    4539.8574    -999.2500    1236.0000       0.2757       0.2757
  388.6200       0.7954      96.0000      96.3763       0.0657       0.0657      10.3303     210.7555     214.7864     214.9721     214.6007     210.7555     378.4629     375.1374     381.7883     381.7883     157.3641      37.4347       0.0736       0.0736      10.9508     147.5269       3.2063    2528.6074       9.8939      10.0972      11.0880      11.5192      16.9774      17.5440     101.0727      99.0374      90.1878      86.8116      58.9018      56.9997       0.0126       0.2670       0.2670       3.2556       0.2809    2541.5269     174.9418      86.3055     345.2500       0.0802    4744.8345    -999.2500    1243.0000       0.2674       0.2674
  388.7724       0.7962      96.0000      96.5332       0.0733       0.0733       2.4780     208.0001     214.3381     212.4456     216.2305     208.0001     382.6764     374.1801     391.1726     391.1726     154.3013      37.4416       0.0858       0.0858      -0.1100     158.2337       3.1514    2508.3708      14.9842      13.0312      16.4114      14.4944      22.2219      20.4314      66.7368      76.7391      60.9331      68.9920      45.0007      48.9442       0.0125       0.3259       0.3259       3.2609       0.3029    2529.0149     101.0727      59.3470     363.1250       0.0729    4807.6895    -999.2500    1280.0000       0.2766       0.2766
  388.9248       0.7970      96.0000      96.3763       0.0705       0.0705      -1.1660     205.4370     208.2943     207.4206     209.1680     205.4370     367.9471     362.1131     373.7810     373.7810     149.9759      37.4484       0.0590       0.0590      -1.0663     157.1425       3.4504    2552.7280      19.0542      15.1240      20.4350      16.4811      26.1223      22.3298      52.4818      66.1201      48.9357      60.6757      38.2815      44.7832       0.0125       0.2711       0.2711       3.4087       0.2836    2533.6416      66.7368      58.2789     351.4375       0.0660    4867.6729    -999.2500    1226.0000       0.2652       0.2652
  389.0772       0.7986      96.0000      96.5332       0.0699       0.0699      -6.0771     200.0864     202.4851     200.1109     204.8593     200.0864     365.2695     359.7710     370.7681     370.7681     145.5745      37.4552       0.0668       0.0668      -2.3473     134.5507       3.6687    2539.8289      19.8835      15.9051      21.0999      17.1077      26.6446      22.8239      50.2930      62.8728      47.3935      58.4534      37.5310      43.8138       0.0125       0.2328       0.2328       3.3312       0.2946    2534.6431      52.4818      52.6932     366.1250       0.0511    4997.8413    -999.2500    1262.0000       0.2570       0.2570
  389.2296       0.8002      96.0000      96.4809       0.0759       0.0759      -1.0060     199.3174     202.3600     198.4543     206.2656     199.3174     365.7928     360.3739     371.2117     371.2117     132.2205      37.4621       0.0746       0.0746       0.8859     145.0295       2.9584    2526.8464      16.9367      15.3220      17.9309      16.3961      23.6905      21.9383      59.0435      65.2655      55.7697      60.9901      42.2110      45.5824       0.0124       0.2620       0.2620       3.1577       0.2975    2524.7566      50.2930      68.2561     357.0000       0.0489    5017.1230    -999.2500    1289.0000       0.2550       0.2550
  389.3820       0.8001      96.0000      96.3763       0.0764       0.0764       1.9466     199.1252     198.8473     199.0200     198.6746     199.1252     365.6558     361.3923     369.9192     369.9192     122.3277      37.4689       0.0859       0.0859      -1.6279     116.4384       2.9271    2508.2988      13.2427      13.5971      14.0763      14.5143      20.0231      20.2709      75.5136      73.5452      71.0414      68.8977      49.9423      49.3318       0.0124       0.2801       0.2801       2.9488       0.2960    2524.0020      59.0435      83.9405     369.0000       0.0483    5021.9663    -999.2500    1203.0000       0.2637       0.2637
  389.5344       0.8001      96.0000      96.3763       0.0783       0.0783       0.1550     198.5164     198.5349     198.7718     198.2980     198.5164     364.2365     361.3389     367.1341     367.1341     109.9937      37.4757       0.0730       0.0730      -1.0771     104.8721       2.9753    2529.4998      10.7387      12.1420      11.5011      12.9726      17.4907      18.8857      93.1208      82.3585      86.9484      77.0854      57.1731      52.9500       0.0124       0.2590       0.2590       3.0018       0.2934    2520.7891      75.5136      99.5482     359.7500       0.0466    5037.3657    -999.2500    1261.0000       0.2628       0.2628
  389.6868       0.8001      96.0000      96.3763       0.0791       0.0791      -0.0858     198.1640     198.2540     198.2602     198.2477     198.1640     363.3112     360.8559     365.7665     365.7665     106.2268      37.4826       0.0754       0.0754       2.2685     107.5189       3.0981    2525.5527       9.1466      10.6483       9.8686      11.4480      15.9234      17.4198     109.3305      93.9115     101.3319      87.3513      62.8005      57.4058       0.0123       0.2512       0.2512       2.9857       0.2923    2519.5515      93.1208     108.7696     361.2500       0.0455    5046.3247    -999.2500    1231.0000       0.2663       0.2663
  389.8392       0.8001      96.0000      96.3763       0.0884       0.0884      -1.2320     198.2281     197.5669     197.9543     197.1796     198.2281     364.8992     362.8575     366.9408     366.9408     102.1273      37.4894       0.0855       0.0855       1.8671     105.7806       2.8800    2508.9958       8.3052       9.8276       9.0160      10.5837      15.2586      16.6105     120.4069     101.7540     110.9136      94.4850      65.5367      60.2029       0.0123       0.2651       0.2651       3.0465       0.2939    2504.1853     109.3305     100.4508     380.1875       0.0457    5044.6934    -999.2500    1243.0000       0.2717       0.2717
  389.9916       0.7995      96.0000      96.3763       0.0943       0.0943       4.8577     199.2854     198.0597     195.2854     200.8340     199.2854     371.3603     371.6455     371.0752     371.0752     102.5162      37.4963       0.0961       0.0961       3.2004      92.5737       3.1665    2491.4014       8.2462       9.8772       8.9886      10.6331      15.2008      16.8748     121.2676     101.2432     111.2524      94.0462      65.7859      59.2598       0.0123       0.2800       0.2800       3.0916       0.2973    2494.3970     120.4069      90.9736     365.8750       0.0488    5017.9297    -999.2500    1256.0000       0.2805       0.2805
  390.1440       0.7990      96.0000      96.5332       0.0947       0.0947       9.3374     200.5349     200.9108     199.1482     202.6734     200.5349     373.6359     374.4342     372.8377     372.8377     106.2808      37.5031       0.1010       0.1010       9.6489     109.1944       3.2352    2483.3992       9.2254      10.9419      10.0710      11.7976      16.1329      18.0065     108.3967      91.3916      99.2952      84.7633      61.9851      55.5354       0.0123       0.2962       0.2962       3.2095       0.2965    2493.8081     121.2676      87.4120     385.6875       0.0524    4986.6626    -999.2500    1230.0000       0.2911       0.2911
  390.2964       0.7985      96.0000      96.4809       0.0917       0.0917      12.9963     203.0340     202.1620     197.1522     207.1719     203.0340     377.2489     378.4594     376.0385     376.0385     119.6267      37.5099       0.0874       0.0874      14.1565     117.0743       3.2167    2505.8123      11.6747      12.8514      12.7202      13.8540      18.6154      19.9128      85.6554      77.8126      78.6151      72.1814      53.7190      50.2190       0.0122       0.3104       0.3104       3.2535       0.2943    2498.6152     108.3967      79.3067     369.1250       0.0594    4925.2832    -999.2500    1248.0000       0.3051       0.3051
  390.4488       0.7979      96.0000      96.5332       0.0896       0.0896      13.4121     206.2059     212.1053     213.1575     211.0533     206.2059     387.6131     390.1571     385.0691     385.0691     126.6481      37.5168       0.0886       0.0886      12.3330     131.9957       3.3017    2503.8101      14.9460      15.4304      16.1676      16.5594      21.9611      22.4514      66.9074      64.8072      61.8519      60.3885      45.5351      44.5407       0.0122       0.3152       0.3152       3.2852       0.2990    2502.1086      85.6554      66.0323     386.6875       0.0681    4849.5215    -999.2500    1253.0000       0.3233       0.3233
  390.6012       0.7975      96.0000      96.3763       0.0961       0.0961       9.8757     210.5312     215.3834     216.2911     214.4758     210.5312     394.8182     394.6273     395.0090     395.0090     121.1764      37.5236       0.0940       0.0940      11.8319     130.2587       3.3277    2494.8977      18.2824      18.4321      19.5484      19.6520      25.3424      25.4420      54.6973      54.2531      51.1550      50.8853      39.4595      39.3051       0.0122       0.3523       0.3523       3.4031       0.3016    2491.4399      66.9074      53.0249     375.2500       0.0796    4749.8887    -999.2500    1227.0000       0.3399       0.3399
  390.7536       0.7972      96.0000      96.4809       0.1028       0.1028       5.8203     216.1702     220.2718     221.2491     219.2946     216.1702     410.7185     410.5904     410.8466     410.8466     106.9795      37.5304       0.1037       0.1037       7.6961     101.8411       3.6038    2478.9321      21.5780      21.5087      22.7766      22.7542      28.5438      28.5723      46.3434      46.4927      43.9046      43.9479      35.0338      34.9990       0.0121       0.3397       0.3397       3.4159       0.3086    2480.3848      54.6973      45.7163     390.5000       0.0938    4625.9849    -999.2500    1243.0000       0.3429       0.3429
  390.9060       0.7972      96.0000      96.5332       0.1045       0.1045       3.0132     221.2004     226.1786     226.4371     225.9200     221.2004     416.8124     417.9609     415.6639     415.6639      88.8850      37.5373       0.1063       0.1063       4.0598      90.0209       3.3315    2474.5962      25.1667      24.7803      26.2910      25.9867      31.9639      31.7013      39.7351      40.3546      38.0359      38.4813      31.2853      31.5445       0.0121       0.3380       0.3380       3.4553       0.3025    2477.5266      46.3434      37.9160     390.5000       0.1059    4520.7881    -999.2500    1300.0000       0.3373       0.3373
  391.0584       0.7973      96.0000      96.1671       0.0998       0.0998       3.8667     225.2053     231.3418     231.5884     231.0952     225.2053     432.3164     431.8265     432.8064     432.8064      81.5377      37.5441       0.0983       0.0983       4.7094      75.9754       3.4183    2487.8347      28.8757      27.8204      29.9106      28.9807      35.5517      34.6898      34.6312      35.9448      33.4330      34.5057      28.1280      28.8269       0.0121       0.3488       0.3488       3.3370       0.3144    2485.3269      39.7351      32.2669     383.8750       0.1151    4440.3926    -999.2500    1268.0000       0.3415       0.3415
  391.2108       0.7977      96.0000      96.6901       0.0916       0.0916       6.4396     228.1529     230.2375     231.7867     228.6881     228.1529     436.0588     433.1079     439.0097     439.0097      85.0354      37.5510       0.0931       0.0931       6.1163      78.9039       3.2128    2496.3169      31.9061      30.3791      32.7891      31.4051      38.2859      37.0399      31.3420      32.9174      30.4979      31.8419      26.1193      26.9979       0.0120       0.3482       0.3482       3.3729       0.3150    2498.7825      34.6312      30.2406     390.7500       0.1217    4383.0249    -999.2500    1249.0000       0.3480       0.3480
  391.3632       0.7981      96.0000      96.3763       0.0898       0.0898       5.9997     228.9539     231.4250     232.1846     230.6654     228.9539     430.2896     432.8089     427.7702     427.7702      91.1391      37.5578       0.0835       0.0835       8.2483     100.5142       3.4271    2512.2751      33.5496      32.3732      34.2828      33.2229      39.6753      38.7128      29.8066      30.8898      29.1692      30.0997      25.2046      25.8313       0.0120       0.3569       0.3569       3.3512       0.2993    2501.8044      31.3420      29.3984     381.5625       0.1235    4367.6909    -999.2500    1249.0000       0.3531       0.3531
  391.5156       0.7982      96.0000      96.8471       0.0815       0.0815       8.9031     229.0821     232.7284     234.5719     230.8849     229.0821     429.8662     432.5858     427.1466     427.1466      97.4382      37.5646       0.0907       0.0907       7.7090      94.2865       3.3890    2500.3914      34.3580      33.7864      34.9872      34.4881      40.2694      39.8843      29.1053      29.5977      28.5819      28.9955      24.8328      25.0725       0.0120       0.3450       0.3450       3.4105       0.2981    2515.5322      29.8066      28.9011     390.5000       0.1237    4365.2476    -999.2500    1241.0000       0.3492       0.3492
  391.6680       0.7983      96.0000      96.3763       0.0839       0.0839      10.3539     229.5947     233.6983     236.5228     230.8739     229.5947     430.0970     433.1898     427.0042     427.0042      98.3089      37.5715       0.0659       0.0659      17.4143      97.3126       3.4066    2541.3462      34.8498      34.9275      35.3993      35.5445      40.6677      40.8223      28.6946      28.6307      28.2492      28.1337      24.5895      24.4964       0.0119       0.3394       0.3394       3.4340       0.2967    2511.6262      29.1053      29.6512     380.7500       0.1249    4355.5010    -999.2500    1253.0000       0.3400       0.3400
  391.8204       0.7987      96.0000      96.0625       0.0901       0.0901       9.2082     230.9404     236.3387     233.6950     238.9824     230.9404     432.7611     437.6393     427.8829     427.8829      99.7994      37.5783       0.0948       0.0948       6.7727     103.4546       3.5091    2493.6262      35.6890      36.0417      36.1827      36.5759      41.3461      41.8394      28.0199      27.7457      27.6375      27.3404      24.1861      23.9009       0.0119       0.3435       0.3435       3.4407       0.2945    2501.3320      28.6946      29.2551     390.5000       0.1278    4330.1221    -999.2500    1243.0000       0.3444       0.3444
  391.9728       0.7991      96.0000      96.2717       0.0974       0.0974       8.6789     233.0550     239.3848     237.7356     241.0339     233.0550     435.3541     441.3418     429.3665     429.3665     103.1153      37.5851       0.1107       0.1107       1.3494      98.7578       3.4026    2467.3459      36.7421      37.2080      37.2039      37.6531      42.2753      42.8703      27.2168      26.8759      26.8789      26.5582      23.6545      23.3262       0.0119       0.3450       0.3450       3.4208       0.2912    2489.2717      28.0199      27.1683     387.9375       0.1323    4290.8330    -999.2500    1240.0000       0.3460       0.3460
  392.1252       0.7994      96.0000      96.3763       0.1028       0.1028       4.2383     234.9133     241.8188     240.7564     242.8811     234.9133     438.8772     444.9652     432.7893     432.7893      97.3976      37.5920       0.0919       0.0919      10.1086     107.4618       3.3429    2498.4263      38.3614      38.3418      38.8148      38.8152      43.8355      43.9890      26.0679      26.0812      25.7633      25.7631      22.8126      22.7330       0.0118       0.3583       0.3583       3.3434       0.2912    2480.3240      27.2168      25.5450     386.0000       0.1362    4256.8901    -999.2500    1242.0000       0.3630       0.3630
  392.2776       0.7996      96.0000      96.1671       0.0982       0.0982       8.9653     235.6822     242.9068     242.0823     243.7313     235.6822     440.8044     446.1913     435.4174     435.4174     101.4681      37.5988       0.1033       0.1033       6.1790      85.4489       3.2687    2479.5159      40.2493      39.4433      40.7180      39.9161      45.5866      44.9592      24.8452      25.3528      24.5592      25.0525      21.9363      22.2424       0.0118       0.3739       0.3739       3.3391       0.2928    2488.0173      26.0679      24.9357     390.5000       0.1378    4243.0020    -999.2500    1225.0000       0.3611       0.3611
  392.4300       0.8004      96.0000      96.2717       0.0983       0.0983       8.7554     234.6249     241.8260     241.1644     242.4876     234.6249     437.9821     442.2638     433.7003     433.7003     100.2761      37.6057       0.1007       0.1007       9.3397     110.9692       3.4039    2483.8364      41.2076      40.2224      41.6676      40.6896      46.4362      45.5559      24.2674      24.8618      23.9995      24.5763      21.5349      21.9510       0.0117       0.3592       0.3592       3.3717       0.2931    2487.8564      24.8452      23.9754     385.6875       0.1356    4262.1221    -999.2500    1231.0000       0.3600       0.3600
  392.5824       0.8011      96.0000      96.5332       0.0911       0.0911      13.0746     234.2404     240.3074     240.5209     240.0939     234.2404     436.1081     441.0731     431.1431     431.1431     102.4892      37.6125       0.0891       0.0891      14.5046     103.8858       3.4403    2503.0669      41.0871      40.4278      41.5364      40.8686      46.1979      45.6423      24.3385      24.7354      24.0753      24.4687      21.6460      21.9095       0.0117       0.3656       0.3656       3.3874       0.2906    2499.6299      24.2674      23.8230     390.5000       0.1348    4269.1177    -999.2500    1228.0000       0.3601       0.3601
  392.7348       0.8018      96.0000      96.4809       0.0868       0.0868       9.2806     231.6773     238.8593     239.2474     238.4711     231.6773     433.1331     438.0206     428.2456     428.2456      95.7689      37.6193       0.0884       0.0884       7.7842      93.2501       3.3306    2504.1804      40.7842      40.1080      41.2547      40.5269      45.7812      45.2056      24.5193      24.9327      24.2396      24.6750      21.8430      22.1212       0.0117       0.3722       0.3722       3.3385       0.2931    2506.8110      24.3385      25.5719     380.7500       0.1294    4316.3491    -999.2500    1237.0000       0.3672       0.3672
  392.8872       0.8024      96.0000      96.2194       0.0913       0.0913       5.1633     229.9792     236.2628     235.2070     237.3186     229.9792     430.0417     432.9073     427.1761     427.1761      98.2707      37.6262       0.0827       0.0827       6.2457      90.8081       3.2592    2513.5034      40.4972      39.2987      41.0137      39.7278      45.4658      44.2896      24.6931      25.4462      24.3821      25.1713      21.9946      22.5787       0.0116       0.3665       0.3665       3.2978       0.2959    2499.3704      24.5193      25.0770     390.5000       0.1257    4348.2197    -999.2500    1271.0000       0.3709       0.3709
  393.0396       0.8027      96.0000      96.4809       0.0883       0.0883       3.2557     228.9219     233.9299     232.6168     235.2430     228.9219     427.0984     429.3616     424.8353     424.8353     102.0526      37.6330       0.1054       0.1054      -1.5196     113.8635       3.3213    2476.1587      39.3063      37.9150      39.9445      38.4328      44.4843      42.8826      25.4412      26.3748      25.0348      26.0194      22.4799      23.3195       0.0116       0.3543       0.3543       3.3373       0.2954    2504.2742      24.6931      25.8513     375.8125       0.1234    4368.3022    -999.2500    1234.0000       0.3612       0.3612
  393.1920       0.8030      96.0000      96.3763       0.0885       0.0885       4.4460     226.3267     231.6410     231.4480     231.8341     226.3267     423.8922     427.6384     420.1461     420.1461     110.5314      37.6398       0.0759       0.0759       6.3543     103.9583       3.4285    2524.7559      36.3027      36.5210      37.0266      37.1423      41.5183      41.6083      27.5462      27.3815      27.0076      26.9235      24.0858      24.0336       0.0116       0.3660       0.3660       3.4708       0.2956    2503.9941      25.4412      27.3169     384.1875       0.1176    4418.3916    -999.2500    1242.0000       0.3604       0.3604
  393.3444       0.8031      96.0000      96.0625       0.0848       0.0848       6.2300     225.8141     231.0161     231.0891     230.9431     225.8141     424.0385     427.1782     420.8989     420.8989     114.7807      37.6467       0.0858       0.0858       6.0790     114.6843       3.6709    2508.4536      31.9352      35.1507      32.6879      35.9241      37.0041      40.2773      31.3135      28.4490      30.5924      27.8365      27.0240      24.8279       0.0115       0.3590       0.3590       3.5297       0.2979    2510.0205      27.5462      28.8410     371.0000       0.1165    4428.4224    -999.2500    1226.0000       0.3553       0.3553
  393.4968       0.8033      96.0000      96.3763       0.0826       0.0826      11.3267     225.6539     231.1584     230.9510     231.3659     225.6539     423.1792     427.3844     418.9740     418.9740     116.4041      37.6535       0.0932       0.0932       6.2251     124.1392       3.5039    2496.2573      30.9116      34.5044      31.5994      35.3321      35.8591      39.6202      32.3503      28.9818      31.6461      28.3028      27.8869      25.2396       0.0115       0.3551       0.3551       3.6493       0.2957    2513.6377      31.3135      29.2153     373.2500       0.1161    4431.5659    -999.2500    1197.0000       0.3574       0.3574
  393.6492       0.8035      96.0000      84.7477       0.0830       0.0830       3.2614     225.7820     231.5531     231.1057     232.0005     225.7820     423.7104     428.1319     419.2890     419.2890     112.8955      37.6604       0.0755       0.0755       6.4769     109.5392       3.6563    2525.4871      33.7480      35.1576      34.5049      35.9425      38.4765      40.2013      29.6314      28.4434      28.9814      27.8222      25.9899      24.8748       0.0115       0.3563       0.3563       3.4834       0.2958    2513.0593      32.3503      28.7743     371.0000       0.1164    4429.0508    -999.2500    1234.0000       0.3592       0.3592
  393.8016       0.8038      96.0000      96.2717       0.0716       0.0716      16.3668     225.7179     231.1630     230.0869     232.2392     225.7179     425.1725     429.1996     421.1452     421.1452     109.0650      37.6672       0.0723       0.0723      17.9340     105.6270       3.5145    2530.7014      36.8185      36.5073      37.2964      37.4272      41.7774      41.4773      27.1603      27.3918      26.8122      26.7186      23.9364      24.1096       0.0114       0.3447       0.3447       3.6434       0.2985    2531.8901      29.6314      27.5696     367.8125       0.1163    4430.3081    -999.2500    1221.0000       0.3434       0.3434
  393.9540       0.8039      96.0000      96.5855       0.0719       0.0719      11.8205     225.3655     230.5233     228.7890     232.2576     225.3655     423.7219     426.2322     421.2115     421.2115     108.8347      37.6740       0.0725       0.0725      11.6870     112.6478       3.6403    2530.4473      39.4861      37.4482      40.2411      38.2575      44.7957      42.6934      25.3254      26.7036      24.8502      26.1387      22.3236      23.4228       0.0114       0.3409       0.3409       3.5083       0.2995    2531.3472      27.1603      26.5035     370.4375       0.1155    4437.2363    -999.2500    1248.0000       0.3360       0.3360
  394.1064       0.8040      96.0000      96.3763       0.0678       0.0678      10.1749     226.2626     230.6486     228.9572     232.3400     226.2626     424.0221     426.7864     421.2579     421.2579     112.6384      37.6809       0.0690       0.0690       9.0480     109.8185       3.3645    2536.2295      41.7226      38.5430      42.3956      39.2446      46.9661      43.8513      23.9678      25.9451      23.5874      25.4812      21.2919      22.8043       0.0114       0.3496       0.3496       3.4576       0.2973    2538.0520      25.3254      26.5861     361.8125       0.1175    4419.6431    -999.2500    1256.0000       0.3356       0.3356
  394.2588       0.8046      96.0000      96.5855       0.0654       0.0654       6.9507     226.7752     231.3506     229.5248     233.1763     226.7752     428.0193     433.1442     422.8944     422.8944     108.3878      37.6877       0.0639       0.0639       6.6632     117.0723       3.3743    2544.5996      40.8415      38.7563      41.3717      39.4308      46.4650      43.9996      24.4849      25.8022      24.1711      25.3609      21.5216      22.7275       0.0113       0.3189       0.3189       3.3209       0.2982    2542.1111      23.9678      26.5823     366.8750       0.1186    4409.6523    -999.2500    1254.0000       0.3318       0.3318
  394.4112       0.8053      96.0000      96.3763       0.0609       0.0609       8.8591     227.3520     232.2231     230.7561     233.6902     227.3520     430.8230     437.5489     424.0971     424.0971     105.8392      37.6945       0.0615       0.0615       7.5435      99.7078       3.2218    2548.5005      38.4497      37.5144      38.6598      38.1021      44.1151      43.1936      26.0080      26.6564      25.8666      26.2453      22.6680      23.1516       0.0113       0.3279       0.3279       3.3109       0.2984    2549.4956      24.4849      25.7132     351.4375       0.1199    4398.4668    -999.2500    1240.0000       0.3287       0.3287
  394.5636       0.8069      96.0000      96.3763       0.0630       0.0630       5.7331     227.5762     232.4365     231.2536     233.6194     227.5762     429.3801     435.2048     423.5553     423.5553      95.9898      37.7014       0.0607       0.0607       6.7607     100.4918       3.3402    2549.8418      36.2044      35.5888      36.3755      36.0376      41.9575      41.4899      27.6209      28.0987      27.4911      27.7488      23.8337      24.1022       0.0113       0.3334       0.3334       3.2749       0.2971    2546.0918      26.0080      26.3957     361.2500       0.1204    4394.1318    -999.2500    1267.0000       0.3267       0.3267
  394.7160       0.8086      96.0000      96.3763       0.0612       0.0612       2.5720     223.5072     230.1498     230.0522     230.2474     223.5072     419.0373     425.0887     412.9859     412.9859      96.5671      37.7082       0.0691       0.0691      -1.1010      86.8734       3.2561    2536.0376      34.0355      33.1496      34.3800      33.5010      39.9856      39.0794      29.3811      30.1663      29.0867      29.8499      25.0090      25.5890       0.0112       0.3327       0.3327       3.2335       0.2929    2549.0493      27.6209      28.5850     347.2500       0.1112    4474.1284    -999.2500    1243.0000       0.3224       0.3224
  394.8684       0.8094      96.0000      96.5855       0.0554       0.0554      -1.3478     218.7333     225.6906     224.7354     226.6457     218.7333     407.3073     411.3060     403.3087     403.3087      95.9553      37.7150       0.0563       0.0563      -2.3502     102.4294       3.1009    2557.1609      30.7418      30.5770      31.2026      30.9396      36.9701      36.5573      32.5289      32.7044      32.0486      32.3210      27.0489      27.3543       0.0112       0.3253       0.3253       3.1798       0.2916    2558.6553      29.3811      32.5681     351.4375       0.1000    4571.7769    -999.2500    1242.0000       0.3093       0.3093
  395.0208       0.8102      96.0000      96.5855       0.0472       0.0472       0.2556     215.0168     220.5544     218.7506     222.3582     215.0168     393.5767     395.1306     392.0227     392.0227      95.9759      37.7219       0.0384       0.0384       2.0841      98.6563       3.1658    2586.6482      26.3391      27.6251      26.9626      28.0694      32.9010      33.8766      37.9664      36.1990      37.0884      35.6260      30.3942      29.5189       0.0112       0.2791       0.2791       3.1563       0.2849    2572.1201      32.5289      40.8967     344.0625       0.0910    4650.8003    -999.2500    1249.0000       0.2902       0.2902
  395.1732       0.8097      96.0000      96.3763       0.0365       0.0365       4.2382     212.3895     218.2784     218.1749     218.3820     212.3895     391.1572     394.1708     388.1435     388.1435      97.3407      37.7287       0.0453       0.0453       3.6753      87.5123       3.1921    2575.2476      23.0171      25.3010      23.7874      25.9093      29.9505      31.8506      43.4460      39.5241      42.0391      38.5962      33.3884      31.3966       0.0111       0.2549       0.2549       3.1430       0.2863    2589.7695      37.9664      45.4447     346.3125       0.0843    4708.3301    -999.2500    1227.0000       0.2739       0.2739
  395.3256       0.8092      96.0000      96.5332       0.0395       0.0395       7.1712     212.7420     214.9029     213.0303     216.7755     212.7420     390.7717     393.2209     388.3225     388.3225     100.2086      37.7356       0.0224       0.0224      12.9474     105.7226       3.0677    2613.1160      21.2776      24.1828      22.1228      24.9810      28.4944      31.1458      46.9979      41.3517      45.2023      40.0304      35.0946      32.1070       0.0111       0.2696       0.2696       3.1937       0.2856    2584.8030      43.4460      45.6006     351.4375       0.0852    4700.5303    -999.2500    1245.0000       0.2730       0.2730
  395.4780       0.8082      96.0000      96.4809       0.0441       0.0441       8.4744     215.6896     217.5614     217.5791     217.5437     215.6896     394.3664     395.2672     393.4655     393.4655     108.5764      37.7424       0.0499       0.0499       7.4612     107.7184       3.2972    2567.6138      21.5550      24.5908      22.4398      25.5381      28.8546      31.9112      46.3930      40.6656      44.5637      39.1571      34.6565      31.3370       0.0111       0.2659       0.2659       3.1918       0.2852    2577.1680      46.9979      45.7823     337.8750       0.0926    4636.2925    -999.2500    1242.0000       0.2703       0.2703
  395.6304       0.8072      96.0000      96.4809       0.0554       0.0554       5.9955     222.0654     224.1955     224.7109     223.6802     222.0654     409.7773     414.4317     405.1229     405.1229     109.8904      37.7492       0.0603       0.0603       4.1349     112.7467       3.2004    2550.5518      23.9921      26.5665      24.9785      27.6331      31.3114      34.0497      41.6804      37.6415      40.0344      36.1884      31.9372      29.3688       0.0110       0.2524       0.2524       3.2631       0.2852    2558.6201      46.3930      44.4939     364.8750       0.1079    4503.1772    -999.2500    1256.0000       0.2748       0.2748
  395.7828       0.8072      96.0000      96.5855       0.0629       0.0629       8.7105     228.8898     237.9447     242.1821     233.7074     228.8898     429.2112     426.6465     431.7759     431.7759     108.8248      37.7561       0.0540       0.0540       8.8264     110.5740       3.2794    2560.9216      28.8887      29.3883      30.0467      30.5164      36.2080      36.7152      34.6156      34.0272      33.2815      32.7693      27.6182      27.2366       0.0110       0.2863       0.2863       3.3149       0.3046    2546.1396      41.6804      36.1358     345.8125       0.1233    4368.9141    -999.2500    1221.0000       0.2838       0.2838
  395.9352       0.8072      96.0000      96.5332       0.0611       0.0611      10.2055     231.8054     234.7612     232.0940     237.4285     231.8054     448.6617     458.8544     438.4689     438.4689     107.0588      37.7629       0.0770       0.0770       6.1129     104.0113       3.4774    2522.9741      35.0255      32.0826      36.2595      33.3106      42.1603      39.3116      28.5506      31.1696      27.5789      30.0204      23.7190      25.4378       0.0110       0.3285       0.3285       3.3383       0.3060    2549.2651      34.6156      28.2858     349.1875       0.1296    4313.9629    -999.2500    1176.0000       0.3038       0.3038
  396.0876       0.8077      96.0000      96.5332       0.0630       0.0630      13.4084     234.8171     237.2984     238.4582     236.1386     234.8171     445.5963     440.9179     450.2747     450.2747     104.0858      37.7697       0.0505       0.0505      16.4331     107.4486       3.2628    2566.6836      39.0319      34.2653      40.1307      35.4496      45.9245      41.3480      25.6200      29.1841      24.9186      28.2090      21.7749      24.1850       0.0109       0.3240       0.3240       3.4118       0.3132    2546.1099      28.5506      22.0128     330.3125       0.1360    4258.6328    -999.2500    1206.0000       0.3184       0.3184
  396.2400       0.8081      96.0000      96.3763       0.0636       0.0636      10.2655     236.1628     238.9567     234.9599     242.9536     236.1628     444.5502     445.4991     443.6013     443.6013     106.3750      37.7766       0.0677       0.0677       8.3271     100.9051       3.5001    2538.3516      37.8028      34.9214      38.6208      35.9424      44.1432      41.7508      26.4531      28.6357      25.8928      27.8223      22.6536      23.9516       0.0109       0.3157       0.3157       3.3947       0.3022    2545.0994      25.6200      31.1899     339.8750       0.1388    4234.3672    -999.2500    1251.0000       0.3228       0.3228
  396.3924       0.8097      96.0000      96.5332       0.0707       0.0707      11.5584     233.2152     235.3057     228.7750     241.8364     233.2152     446.5612     447.7089     445.4134     445.4134     113.4049      37.7834       0.0703       0.0703      11.1621     110.9310       3.4307    2533.9248      35.8026      33.9008      36.4341      34.7152      41.8093      40.2442      27.9310      29.4978      27.4468      28.8058      23.9181      24.8483       0.0109       0.3200       0.3200       3.4773       0.3112    2533.2749      26.4531      32.8590     331.9375       0.1326    4287.8857    -999.2500    1230.0000       0.3270       0.3270
  396.5448       0.8113      96.0000      96.4809       0.0700       0.0700      11.8533     232.5103     238.8929     236.5305     241.2553     232.5103     430.2037     441.4852     418.9222     418.9222     123.2489      37.7903       0.0764       0.0764      12.5957     128.0875       3.4993    2523.8704      34.1613      31.2032      34.7389      31.8855      40.1372      37.2596      29.2729      32.0480      28.7862      31.3622      24.9145      26.8387       0.0108       0.3394       0.3394       3.5040       0.2774    2534.4690      27.9310      27.8723     333.7500       0.1311    4300.8848    -999.2500    1243.0000       0.3295       0.3295
  396.6972       0.8128      96.0000      96.4809       0.0664       0.0664       9.9992     227.0316     234.2316     230.4054     238.0578     227.0316     430.6047     428.7532     432.4561     432.4561     126.7146      37.7971       0.0621       0.0621      11.7597     129.2028       3.5839    2547.5425      28.3504      27.4589      28.9160      28.0387      34.4139      33.4349      35.2729      36.4181      34.5829      35.6650      29.0580      29.9089       0.0108       0.3495       0.3495       3.4721       0.3098    2540.4937      29.2729      36.0189     331.3125       0.1192    4404.6738    -999.2500    1240.0000       0.3328       0.3328
  396.8496       0.8143      96.0000      96.5332       0.0609       0.0609       7.7155     218.1887     223.6364     221.7281     225.5446     218.1887     408.0678     408.9182     407.2175     407.2175     124.2971      37.8039       0.0587       0.0587       6.4233     121.3280       3.3344    2553.2205      21.7029      24.0376      22.3118      24.5615      27.8785      30.1090      46.0768      41.6015      44.8193      40.7141      35.8700      33.2127       0.0107       0.3432       0.3432       3.4119       0.2987    2549.5125      35.2729      44.5191     326.5625       0.0987    4583.1895    -999.2500    1245.0000       0.3330       0.3330
  397.0020       0.8147      96.0000      96.3763       0.0618       0.0618       3.2112     212.1653     216.9582     214.9867     218.9297     212.1653     393.0171     392.3775     393.6567     393.6567     120.7056      37.8108       0.0612       0.0612       4.1051     122.0862       3.3218    2549.0886      17.5676      20.1349      18.1544      20.7985      23.7794      26.3670      56.9230      49.6649      55.0831      48.0805      42.0531      37.9263       0.0107       0.3268       0.3268       3.2966       0.2953    2548.0779      46.0768      55.1304     336.8750       0.0838    4713.3071    -999.2500    1256.0000       0.3221       0.3221
  397.1544       0.8152      96.0000      96.3763       0.0623       0.0623       4.3529     208.0322     213.5368     211.8145     215.2590     208.0322     387.3975     383.2512     391.5439     391.5439     115.5051      37.8176       0.0615       0.0615       5.3793     121.2141       3.2398    2548.5791      15.4869      17.0651      16.1480      17.6716      21.7983      23.3004      64.5708      58.5990      61.9272      56.5881      45.8752      42.9177       0.0107       0.2985       0.2985       3.2535       0.3033    2547.2590      56.9230      68.7861     322.5625       0.0730    4806.9492    -999.2500    1260.0000       0.3014       0.3014
  397.3068       0.8142      96.0000      96.2717       0.0723       0.0723       6.6723     207.1991     212.2974     211.4413     213.1535     207.1991     382.0145     381.8598     382.1692     382.1692     117.1244      37.8244       0.0610       0.0610       9.9572     105.7265       3.2100    2549.3142      13.6812      15.5705      14.3911      16.1612      20.1793      21.8119      73.0932      64.2239      69.4873      61.8766      49.5558      45.8465       0.0107       0.2720       0.2720       3.2745       0.2918    2530.7000      64.5708      74.0016     337.2500       0.0708    4826.2749    -999.2500    1220.0000       0.2875       0.2875
  397.4592       0.8132      96.0000      96.2194       0.0747       0.0747      11.5828     208.6409     213.5137     213.9115     213.1158     208.6409     385.4145     381.2319     389.5971     389.5971     115.4943      37.8313       0.0937       0.0937       5.8080     126.3940       3.3807    2495.3909      12.8042      15.3735      13.5231      16.0750      19.4795      21.8647      78.0996      65.0471      73.9477      62.2082      51.3361      45.7359       0.0106       0.2759       0.2759       3.2281       0.2989    2526.7346      73.0932      69.2161     322.1875       0.0746    4792.9238    -999.2500    1170.0000       0.2871       0.2871
  397.6116       0.8119      96.0000      96.5332       0.0827       0.0827      12.9425     211.4604     214.5765     216.8042     212.3488     211.4604     392.0811     392.2349     391.9272     391.9272     118.9864      37.8381       0.0710       0.0710      17.0262     115.6989       3.1070    2532.7734      13.4084      16.6166      14.1312      17.5275      20.1172      23.4865      74.5802      60.1807      70.7652      57.0534      49.7087      42.5777       0.0106       0.3079       0.3079       3.3153       0.2947    2513.6179      78.0996      66.6091     335.5000       0.0820    4729.0181    -999.2500    1210.0000       0.3034       0.3034
  397.7640       0.8106      96.0000      96.4809       0.0800       0.0800      11.0508     215.4333     219.7010     221.6171     217.7849     215.4333     406.5937     408.2080     404.9794     404.9794     112.6721      37.8450       0.0885       0.0885       8.2653     116.2027       3.4548    2503.9807      16.8311      19.3367      17.6643      20.4200      23.4513      26.4097      59.4139      51.7152      56.6115      48.9715      42.6416      37.8649       0.0106       0.3058       0.3058       3.2894       0.3027    2517.9473      74.5802      57.9156     322.1875       0.0920    4641.8086    -999.2500    1242.0000       0.3167       0.3167
  397.9164       0.8103      96.0000      96.5332       0.0758       0.0758      11.8406     220.7198     225.2329     227.7551     222.7108     220.7198     419.1432     422.7263     415.5601     415.5601     106.8113      37.8518       0.0795       0.0795      10.7301     105.9094       3.3069    2518.8267      23.2731      22.6574      24.2651      23.7766      29.9187      29.4479      42.9680      44.1358      41.2114      42.0582      33.4239      33.9583       0.0105       0.3322       0.3322       3.4336       0.3035    2524.8884      59.4139      45.8962     331.6250       0.1048    4530.6313    -999.2500    1275.0000       0.3287       0.3287
  398.0688       0.8100      96.0000      96.2717       0.0759       0.0759      11.0387     225.2053     229.5061     229.6443     229.3678     225.2053     430.5435     429.6122     431.4749     431.4749     103.0104      37.8586       0.0600       0.0600      15.4534      97.0305       3.5418    2550.9424      30.0810      26.1547      30.9887      27.1481      36.4187      32.8603      33.2436      38.2340      32.2699      36.8350      27.4584      30.4318       0.0105       0.3411       0.3411       3.3931       0.3128    2524.7986      42.9680      34.7190     322.1875       0.1151    4440.3926    -999.2500    1301.0000       0.3305       0.3305
  398.2212       0.8113      96.0000      96.3763       0.0710       0.0710      13.5505     228.9219     231.5776     232.5871     230.5682     228.9219     438.1393     436.4448     439.8339     439.8339     103.5951      37.8655       0.0866       0.0866       8.4303     103.9214       3.3485    2507.0667      33.2171      28.5554      33.9829      29.4180      39.3505      34.8720      30.1049      35.0197      29.4266      33.9928      25.4126      28.6763       0.0105       0.3441       0.3441       3.4143       0.3142    2532.8640      33.2436      30.4025     326.2500       0.1234    4368.3022    -999.2500    1308.0000       0.3348       0.3348
  398.3736       0.8127      96.0000      96.3763       0.0795       0.0795       6.4911     229.0500     232.0269     236.6629     227.3909     229.0500     434.7819     437.0850     432.4789     432.4789     100.4529      37.8723       0.0693       0.0693      10.5993     108.0591       3.3654    2535.6001      32.4501      28.9490      33.1061      29.7281      38.7302      35.0974      30.8165      34.5435      30.2059      33.6382      25.8196      28.4921       0.0104       0.3598       0.3598       3.2298       0.3051    2518.7839      30.1049      31.4477     320.1250       0.1237    4365.8584    -999.2500    1265.0000       0.3395       0.3395
  398.5260       0.8140      96.0000      96.3763       0.0711       0.0711       6.0700     226.6471     230.2568     231.4285     229.0852     226.6471     427.8431     428.9269     426.7592     426.7592      88.2273      37.8791       0.0803       0.0803       3.5221      87.0436       2.9909    2517.5403      28.9688      27.4765      29.5649      28.1977      35.4468      33.8235      34.5199      36.3948      33.8239      35.4639      28.2113      29.5652       0.0104       0.3576       0.3576       3.1724       0.3036    2532.7085      30.8165      38.1810     319.3125       0.1184    4412.1460    -999.2500    1219.0000       0.3416       0.3416
  398.6784       0.8154      96.0000      96.4809       0.0722       0.0722       1.7305     224.1480     228.0682     229.3053     226.8312     224.1480     415.7053     415.9677     415.4430     415.4430      79.2201      37.8860       0.0621       0.0621       4.9480      68.1232       3.1837    2547.5461      24.9196      24.9593      25.5402      25.6245      31.4510      31.5087      40.1290      40.0653      39.1540      39.0251      31.7955      31.7373       0.0104       0.3297       0.3297       3.0712       0.2947    2530.8767      34.5199      45.6000     314.5000       0.1127    4461.3379    -999.2500    1215.0000       0.3366       0.3366
  398.8308       0.8165      96.0000      96.3763       0.0676       0.0676       4.3882     223.5072     228.4686     227.2388     229.6983     223.5072     408.4272     410.8626     405.9917     405.9917      75.6636      37.8928       0.0702       0.0702       1.4206      82.4417       3.0529    2534.0979      21.5406      21.9855      22.1899      22.6309      28.1815      28.6355      46.4239      45.4845      45.0655      44.1873      35.4842      34.9216       0.0103       0.3086       0.3086       3.1000       0.2826    2538.4788      40.1290      52.0567     312.3750       0.1112    4474.1284    -999.2500    1188.0000       0.3226       0.3226
  398.9832       0.8175      96.0000      96.4809       0.0687       0.0687       7.6516     227.4160     232.5770     228.2048     236.9493     227.4160     413.8085     414.2459     413.3711     413.3711      84.4278      37.8997       0.0715       0.0715       3.6183      76.3876       3.0697    2532.0605      18.6873      18.8157      19.4695      19.5020      25.5999      25.4964      53.5124      53.1472      51.3623      51.2768      39.0626      39.2212       0.0103       0.3036       0.3036       3.0445       0.2830    2536.6331      46.4239      55.2779     322.1875       0.1201    4397.2271    -999.2500    1261.0000       0.3115       0.3115
  399.1356       0.8185      96.0000      96.3763       0.0751       0.0751       8.1413     235.7783     237.3881     233.1354     241.6408     235.7783     425.2205     428.5833     421.8577     421.8577      96.6655      37.9065       0.0691       0.0691      10.6028      94.4157       3.0053    2535.9348      16.0011      15.6354      16.7190      16.4069      23.1145      22.3899      62.4957      63.9576      59.8123      60.9498      43.2628      44.6630       0.0102       0.3083       0.3083       3.0351       0.2729    2526.0190      53.5124      60.0209     311.8125       0.1380    4241.2720    -999.2500    1269.0000       0.3026       0.3026
  399.2880       0.8196      96.0000      96.4809       0.0829       0.0829       8.3128     242.5387     246.7368     247.1707     246.3030     242.5387     437.3102     440.2859     434.3343     434.3343     110.8922      37.9133       0.0864       0.0864       7.8540     119.7202       3.0205    2507.4958      12.2021      12.5159      13.1805      13.3159      19.5723      19.4202      81.9531      79.8983      75.8699      75.0984      51.0927      51.4928       0.0102       0.3105       0.3105       2.9819       0.2734    2513.2180      62.4957      85.9966     327.3750       0.1516    4123.0542    -999.2500    1257.0000       0.3101       0.3101
  399.4404       0.8195      96.0000      96.4809       0.0939       0.0939       6.1482     250.1961     256.7502     255.4182     258.0822     250.1961     446.3241     450.0483     442.6000     442.6000     123.6758      37.9202       0.0926       0.0926       7.1349     119.5749       2.9129    2497.1506       8.1123       9.6325       9.0039      10.4908      15.6058      16.8628     123.2702     103.8153     111.0634      95.3215      64.0789      59.3023       0.0102       0.3144       0.3144       2.9715       0.2652    2495.1091      81.9531     129.5958     306.8750       0.1660    3996.8650    -999.2500    1234.0000       0.3190       0.3190
  399.5928       0.8194      96.0000      96.8471       0.0963       0.0963       9.5335     255.9632     261.7569     261.6005     261.9133     255.9632     457.0179     459.0919     454.9440     454.9440     129.4310      37.9270       0.0985       0.0985       9.6139     132.7667       2.9792    2487.4595       5.9171       7.3288       6.8140       8.2921      13.4593      14.8859     169.0028     136.4483     146.7559     120.5965      74.2979      67.1775       0.0101       0.3159       0.3159       2.9736       0.2684    2491.1733     123.2702     145.1346     314.2500       0.1764    3906.8118    -999.2500    1239.0000       0.3271       0.3271
  399.7452       0.8196      96.0000      96.3763       0.1019       0.1019       7.9752     256.9884     264.1544     264.1618     264.1469     256.9884     462.1223     460.8621     463.3824     463.3824     134.8817      37.9338       0.0992       0.0992       8.0683     135.3708       3.0178    2486.3308       5.0464       5.8382       6.0494       6.8820      12.8067      13.5050     198.1598     171.2860     165.3058     145.3058      78.0842      74.0468       0.0101       0.3427       0.3427       2.9709       0.2779    2481.8467     169.0028     148.0040     302.6250       0.1782    3891.2256    -999.2500    1247.0000       0.3400       0.3400
  399.8976       0.8198      96.0000      96.4809       0.1011       0.1011       9.1855     257.1487     260.4931     260.6342     260.3519     257.1487     459.9214     461.7444     458.0984     458.0984     138.1017      37.9407       0.1080       0.1080       6.5774     135.9994       2.9161    2471.8335       4.2220       4.8346       5.2507       5.8974      12.1171      12.6165     236.8573     206.8440     190.4493     169.5655      82.5280      79.2611       0.0101       0.3603       0.3603       3.0044       0.2700    2483.1545     198.1598     194.1326     310.4375       0.1785    3888.8015    -999.2500    1243.0000       0.3466       0.3466
  400.0500       0.8187      96.0000      96.5332       0.1012       0.1012       7.9424     252.7913     260.0236     260.2957     259.7514     252.7913     454.1430     453.6654     454.6205     454.6205     139.4227      37.9475       0.0993       0.0993       7.7252     144.2074       3.0888    2486.2244       3.5794       4.2202       4.4978       5.2200      11.3125      12.0675     279.3739     236.9570     222.3312     191.5697      88.3978      82.8670       0.0100       0.3455       0.3455       3.0904       0.2762    2483.1011     236.8573     252.2564     302.6250       0.1708    3955.8328    -999.2500    1242.0000       0.3425       0.3425
  400.2024       0.8176      96.0000      96.4809       0.0946       0.0946       9.5636     249.8436     248.2105     247.9978     248.4234     249.8436     453.0293     455.4960     450.5626     450.5626     143.7605      37.9543       0.0965       0.0965       9.5237     139.8751       3.3028    2490.7688       3.5193       4.1698       4.3931       5.1100      11.0978      11.9283     284.1500     239.8208     227.6318     195.6951      90.1078      83.8343       0.0100       0.3030       0.3030       3.2042       0.2780    2493.9751     279.3739     268.7064     311.6875       0.1654    4002.5032    -999.2500    1228.0000       0.3228       0.3228
  400.3548       0.8167      96.0000      96.5855       0.0937       0.0937       9.2494     247.1203     251.0985     253.6502     248.5468     247.1203     441.7186     452.8717     430.5654     430.5654     146.6776      37.9612       0.0888       0.0888      11.4967     148.5849       3.2555    2503.5452       3.9448       4.5513       4.8900       5.5137      11.5065      12.2224     253.4955     219.7171     204.4997     181.3663      86.9075      81.8172       0.0099       0.3025       0.3025       3.2597       0.2544    2495.3474     284.1500     200.7092     319.8750       0.1603    4046.6123    -999.2500    1227.0000       0.3089       0.3089
  400.5072       0.8158      96.0000      96.5332       0.0929       0.0929       8.1882     238.7580     240.5480     244.6832     236.4127     238.7580     434.2866     440.4666     428.1066     428.1066     149.4540      37.9680       0.0942       0.0942      10.9674     151.1780       3.2097    2494.6516       4.5633       5.3383       5.5212       6.3914      12.0860      13.0120     219.1400     187.3270     181.1209     156.4611      82.7403      76.8520       0.0099       0.3233       0.3233       3.3012       0.2743    2496.6526     253.4955     188.6507     303.6250       0.1441    4188.3413    -999.2500    1239.0000       0.3088       0.3088
  400.6596       0.8146      96.0000      96.5855       0.0892       0.0892       9.2613     231.8054     236.4950     240.0310     232.9590     231.8054     423.3444     427.2825     419.4063     419.4063     152.1990      37.9749       0.0936       0.0936       7.0188     148.3343       3.4161    2495.5757       5.8288       6.5404       6.9204       7.7180      13.4484      14.2874     171.5615     152.8969     144.4994     129.5676      74.3583      69.9920       0.0099       0.3112       0.3112       3.3291       0.2801    2502.8376     219.1400     219.7314     317.5625       0.1296    4313.9629    -999.2500    1245.0000       0.3067       0.3067
  400.8120       0.8134      96.0000      96.5332       0.0800       0.0800       7.2289     223.7635     225.1703     229.2589     221.0817     223.7635     404.6115     403.0318     406.1913     406.1913     155.4203      37.9817       0.0801       0.0801       9.9133     157.2145       3.3375    2517.8386       8.1284       8.1195       9.4609       9.3477      15.9212      15.8891     123.0251     123.1596     105.6987     106.9779      62.8092      62.9362       0.0098       0.2872       0.2872       3.3471       0.2822    2518.0737     171.5615     105.9402     305.4375       0.1118    4469.0034    -999.2500    1245.0000       0.3051       0.3051
  400.9644       0.8131      96.0000      96.6901       0.0736       0.0736       8.0089     214.3760     215.1686     216.4439     213.8932     214.3760     393.8211     392.4778     395.1644     395.1644     175.3119      37.9885       0.0626       0.0626       7.9139     159.6727       3.2906    2546.7253      10.4633       9.6823      11.7827      11.0077      18.2221      17.5156      95.5725     103.2816      84.8705      90.8452      54.8785      57.0919       0.0098       0.3043       0.3043       3.4178       0.2915    2528.6150     123.0251      86.0005     318.5000       0.0894    4664.7017    -999.2500    1243.0000       0.3032       0.3032
  401.1168       0.8128      96.0000      96.5332       0.0690       0.0690       7.9913     210.9157     219.6334     215.2297     224.0371     210.9157     391.0406     390.6391     391.4422     391.4422     195.3034      37.9954       0.0777       0.0777       4.3859     207.9170       3.6344    2521.7986      11.9278      11.0249      13.2601      12.3768      19.5974      18.8199      83.8377      90.7035      75.4145      80.7966      51.0273      53.1352       0.0098       0.2931       0.2931       3.3911       0.2955    2536.2202      95.5725      89.5325     330.0625       0.0806    4741.2305    -999.2500    1233.0000       0.2934       0.2934
  401.2692       0.8132      96.0000      96.5332       0.0726       0.0726       7.5312     207.4555     210.9563     210.0004     211.9122     207.4555     378.0382     373.9985     382.0779     382.0779     199.5928      38.0022       0.0666       0.0666       9.6073     218.2635       3.2459    2540.0757      12.9999      11.8317      14.3758      13.1795      20.6710      19.5204      76.9238      84.5186      69.5614      75.8756      48.3769      51.2284       0.0097       0.2901       0.2901       3.4461       0.2910    2530.1650      83.8377      70.7420     331.9375       0.0715    4820.3120    -999.2500    1219.0000       0.2853       0.2853
  401.4216       0.8136      96.0000      96.5855       0.0709       0.0709       8.2187     202.5854     208.0870     205.6727     210.5013     202.5854     370.4710     365.7177     375.2244     375.2244     177.4816      38.0090       0.0760       0.0760       6.0544     173.7100       3.4556    2524.5203      13.3286      11.8403      14.7493      13.1589      21.0392      19.4702      75.0266      84.4571      67.7999      75.9942      47.5304      51.3605       0.0097       0.3030       0.3030       3.3508       0.2943    2533.0166      76.9238      66.3878     317.8750       0.0582    4936.1885    -999.2500    1225.0000       0.2833       0.2833
  401.5740       0.8145      96.0000      96.6901       0.0707       0.0707       4.5561     199.4135     202.6784     198.9160     206.4409     199.4135     365.7028     361.5196     369.8861     369.8861     153.1410      38.0159       0.0739       0.0739       4.3223     141.5458       3.3423    2528.0947      12.1909      11.1173      13.5546      12.3932      19.8148      18.6967      82.0283      89.9499      73.7755      80.6891      50.4673      53.4853       0.0097       0.2923       0.2923       3.2624       0.2951    2533.3396      75.0266      77.6162     314.4375       0.0492    5014.7041    -999.2500    1213.0000       0.2826       0.2826
  401.7264       0.8154      96.0000      96.7948       0.0632       0.0632       5.7616     197.7155     197.4322     198.9973     195.8671     197.7155     362.3204     358.9728     365.6681     365.6681     144.7249      38.0227       0.0609       0.0609       4.7796     143.7247       3.0109    2549.4927      10.1924      10.0432      11.4059      11.2846      17.6291      17.5309      98.1121      99.5702      87.6738      88.6161      56.7242      57.0423       0.0096       0.2914       0.2914       3.1432       0.2934    2545.6707      82.0283      97.2887     325.3750       0.0442    5057.7734    -999.2500    1211.0000       0.2795       0.2795
  401.8788       0.8149      96.0000      96.4809       0.0578       0.0578       4.4107     196.5620     197.8347     198.2539     197.4156     196.5620     358.0665     355.6003     360.5327     360.5327     138.2303      38.0296       0.0562       0.0562       4.2587     148.4617       3.0770    2557.3367       8.4667       9.0896       9.5245      10.2269      15.8162      16.4509     118.1097     110.0157     104.9926      97.7810      63.2264      60.7869       0.0096       0.2653       0.2653       3.0452       0.2885    2554.6243      98.1121     114.3629     316.6875       0.0408    5087.4526    -999.2500    1213.0000       0.2694       0.2694
  402.0312       0.8143      96.0000      96.8471       0.0518       0.0518       6.7195     195.9533     198.4039     198.5095     198.2984     195.9533     354.8587     353.2852     356.4322     356.4322     131.7811      38.0364       0.0555       0.0555       4.6085     123.2056       3.0513    2558.3545       7.5378       8.1423       8.5209       9.1750      14.7469      15.4692     132.6640     122.8151     117.3581     108.9913      67.8109      64.6447       0.0096       0.2459       0.2459       3.0309       0.2834    2564.5872     118.1097     124.9391     331.9375       0.0390    5103.2568    -999.2500    1218.0000       0.2544       0.2544
  402.1836       0.8138      96.0000      96.6901       0.0492       0.0492       6.2190     195.9533     198.4477     198.0473     198.8480     195.9533     354.3304     354.0101     354.6507     354.6507     124.9120      38.0432       0.0457       0.0457       6.0218     124.8196       2.9605    2574.6240       7.0434       7.6974       7.9607       8.6675      14.0800      14.8831     141.9764     129.9136     125.6172     115.3732      71.0227      67.1903       0.0096       0.2354       0.2354       3.0058       0.2803    2568.8665     132.6640     132.8763     315.1875       0.0390    5103.2568    -999.2500    1221.0000       0.2449       0.2449
  402.3360       0.8132      96.0000      96.5332       0.0517       0.0517       5.4170     196.6902     198.3474     197.9562     198.7386     196.6902     353.0639     349.8438     356.2840     356.2840     132.5407      38.0501       0.0460       0.0460       7.5343     126.1790       3.0124    2574.1282       6.7853       7.8445       7.5995       8.7887      13.6172      14.8832     147.3785     127.4772     131.5872     113.7830      73.4366      67.1898       0.0095       0.2302       0.2302       3.0197       0.2808    2564.7432     141.9764     132.0489     331.6875       0.0412    5084.1372    -999.2500    1228.0000       0.2389       0.2389
  402.4884       0.8123      96.0000      96.6901       0.0662       0.0662       2.5694     198.5805     198.5119     197.7720     199.2517     198.5805     358.6796     359.4225     357.9366     357.9366     140.0806      38.0569       0.0616       0.0616       4.5389     144.9478       3.0893    2548.4067       6.9905       8.6811       7.6534       9.6241      13.5928      15.6177     143.0519     115.1923     130.6617     103.9062      73.5683      64.0299       0.0095       0.2290       0.2290       3.0472       0.2777    2540.8442     147.3785     130.2686     312.6250       0.0467    5035.7407    -999.2500    1249.0000       0.2391       0.2391
  402.6408       0.8114      96.0000      96.5855       0.0891       0.0891      -0.7779     202.2330     201.0470     199.0889     203.0052     202.2330     369.5542     371.0358     368.0726     368.0726     145.4979      38.0637       0.0873       0.0873      -0.1654     148.0925       3.0314    2505.8938       8.6048      10.2334       9.2319      11.1574      14.9407      17.0953     116.2135      97.7195     108.3202      89.6270      66.9313      58.4958       0.0095       0.2217       0.2217       3.1089       0.2838    2503.0161     143.0519     107.1678     329.5625       0.0572    4944.7910    -999.2500    1253.0000       0.2447       0.2447
  402.7932       0.8116      96.0000      96.6901       0.0943       0.0943       1.8251     206.5904     212.1130     214.6068     209.6192     206.5904     376.9014     378.6957     375.1071     375.1071     151.0319      38.0706       0.1138       0.1138      -2.5713     144.1120       3.1954    2462.1638      12.0825      12.2306      12.8392      13.1298      18.4139      18.8836      82.7647      81.7623      77.8862      76.1627      54.3069      52.9560       0.0094       0.2708       0.2708       3.2178       0.2823    2494.4436     116.2135      73.1662     320.2500       0.0692    4840.4966    -999.2500    1281.0000       0.2607       0.2607
  402.9456       0.8118      96.0000      96.5855       0.0930       0.0930       3.3975     209.5380     214.6223     215.5828     213.6619     209.5380     391.9912     390.9005     393.0820     393.0820     154.0614      38.0774       0.0801       0.0801       8.5272     161.5500       3.4244    2517.8186      16.6328      14.2037      17.4778      15.0246      22.9281      20.7169      60.1222      70.4041      57.2154      66.5574      43.6147      48.2697       0.0094       0.3309       0.3309       3.3757       0.3015    2496.6206      82.7647      57.6086     338.5625       0.0770    4772.4038    -999.2500    1275.0000       0.2868       0.2868
  403.0980       0.8134      96.0000      96.5855       0.0732       0.0732       7.5742     211.1400     215.5583     217.1610     213.9555     211.1400     390.2304     391.7806     388.6801     388.6801     141.2328      38.0843       0.0831       0.0831       5.2175     155.1608       3.5055    2512.8110      19.5266      15.5003      20.3660      16.2704      25.6697      21.7513      51.2121      64.5150      49.1014      61.4612      38.9564      45.9743       0.0094       0.3210       0.3210       3.4188       0.2907    2529.2688      60.1222      51.5524     331.9375       0.0811    4736.1943    -999.2500    1253.0000       0.2941       0.2941
  403.2504       0.8151      96.0000      96.5332       0.0608       0.0608       5.6937     207.9361     214.1875     214.8923     213.4827     207.9361     379.3434     377.1331     381.5537     381.5537     123.9875      38.0911       0.0564       0.0564       6.6645     105.6210       3.3333    2556.9204      18.1748      15.5108      18.9500      16.2804      24.5138      21.5851      55.0213      64.4711      52.7705      61.4236      40.7933      46.3282       0.0093       0.2904       0.2904       3.3846       0.2888    2549.6570      51.2121      59.6348     326.8750       0.0728    4809.1709    -999.2500    1213.0000       0.2872       0.2872
  403.4028       0.8154      96.0000      96.5855       0.0426       0.0426       8.6202     204.6680     210.9171     209.9050     211.9293     204.6680     372.8023     371.7733     373.8313     373.8313     105.6448      38.0979       0.0374       0.0374      12.5474     108.5401       3.3312    2588.2373      14.5676      14.2417      15.2357      14.9855      21.0433      20.5504      68.6456      70.2165      65.6353      66.7311      47.5212      48.6608       0.0093       0.2692       0.2692       3.2858       0.2860    2579.7273      55.0213      75.6598     330.3125       0.0639    4885.9614    -999.2500    1254.0000       0.2690       0.2690
  403.5552       0.8157      96.0000      96.5855       0.0369       0.0369       6.5329     201.9767     201.5210     195.6602     207.3818     201.9767     363.6905     362.5625     364.8186     364.8186      94.9059      38.1048       0.0329       0.0329       8.3087     100.9880       3.2094    2595.6575      11.4342      12.9020      12.1458      13.3779      17.9686      19.1752      87.4567      77.5076      82.3328      74.7504      55.6525      52.1508       0.0093       0.2395       0.2395       3.2746       0.2790    2589.0613      68.6456      95.3165     322.1875       0.0565    4951.0659    -999.2500    1240.0000       0.2576       0.2576
  403.7076       0.8155      96.0000      96.3763       0.0450       0.0450       4.8607     200.8874     200.6352     195.7213     205.5491     200.8874     362.7528     361.8833     363.6223     363.6223      90.2463      38.1116       0.0366       0.0366       5.2932      73.4041       3.2899    2589.6602       9.8491      11.4756      10.5504      12.2350      16.5868      18.0551     101.5320      87.1417      94.7830      81.7324      60.2889      55.3861       0.0092       0.2407       0.2407       3.2192       0.2804    2575.6877      87.4567     100.4875     331.9375       0.0534    4977.9141    -999.2500    1257.0000       0.2490       0.2490
  403.8600       0.8154      96.0000      96.8471       0.0535       0.0535       5.0879     204.4758     203.2160     196.6217     209.8103     204.4758     366.7454     364.6330     368.8578     368.8578      97.6258      38.1184       0.0648       0.0648       0.7862      95.8150       3.1696    2543.0740       9.6389      10.2446      10.5257      11.0061      16.6044      17.0464     103.7462      97.6125      95.0052      90.8588      60.2252      58.6635       0.0092       0.2341       0.2341       3.2296       0.2782    2561.6946     101.5320      97.6309     316.8125       0.0634    4890.5547    -999.2500    1247.0000       0.2480       0.2480
  404.0124       0.8147      96.0000      96.6901       0.0589       0.0589       5.0143     209.1215     212.5509     212.5566     212.5451     209.1215     376.1894     379.4352     372.9435     372.9435     109.5709      38.1253       0.0605       0.0605       4.4075     123.8669       3.2326    2550.1326       9.3814       9.6717      10.4374      10.5013      16.5528      16.5817     106.5941     103.3940      95.8092      95.2263      60.4128      60.3074       0.0092       0.2579       0.2579       3.1502       0.2707    2552.8484     103.7462      89.0578     322.8750       0.0759    4781.9092    -999.2500    1219.0000       0.2547       0.2547
  404.1648       0.8141      96.0000      96.5855       0.0647       0.0647       5.6066     213.7031     217.8208     217.0837     218.5578     213.7031     387.5981     393.4911     381.7051     381.7051     114.1830      38.1321       0.0504       0.0504      10.7726     109.2392       3.0581    2566.7668       8.6794       9.4755       9.7513      10.4400      15.9084      16.5522     115.2153     105.5352     102.5500      95.7851      62.8599      60.4148       0.0091       0.2730       0.2730       3.2102       0.2717    2543.2129     106.5941     109.0224     322.1875       0.0877    4679.3882    -999.2500    1206.0000       0.2664       0.2664
  404.3172       0.8140      96.0000      96.7948       0.0688       0.0688       5.4587     216.0420     220.8078     218.9559     222.6597     216.0420     395.1155     396.2104     394.0207     394.0207     111.1446      38.1390       0.0806       0.0806       3.1446     109.7091       3.3496    2517.0435       8.4848       9.7141       9.4955      10.8049      15.6346      16.9641     117.8572     102.9431     105.3135      92.5509      63.9607      58.9479       0.0091       0.2654       0.2654       3.2086       0.2851    2536.4595     115.2153     114.3906     322.1875       0.0935    4628.7290    -999.2500    1206.0000       0.2771       0.2771
  404.4696       0.8139      96.0000      96.4809       0.0706       0.0706       8.0156     217.1954     220.6986     219.2882     222.1090     217.1954     396.3665     399.9636     392.7693     392.7693     111.1151      38.1458       0.0708       0.0708       8.0460     113.8671       3.2057    2533.1460       9.7877      10.4481      10.8935      11.6148      16.9223      17.7566     102.1692      95.7115      91.7975      86.0974      59.0935      56.3170       0.0091       0.2851       0.2851       3.3198       0.2798    2533.5762     117.8572      82.6525     341.9375       0.0963    4604.1479    -999.2500    1248.0000       0.2862       0.2862
  404.6220       0.8142      96.0000      96.7948       0.0687       0.0687      11.0770     216.5226     218.9772     218.5728     219.3816     216.5226     398.0278     403.8681     392.1874     392.1874     118.2441      38.1526       0.0589       0.0589      13.4355     109.1509       3.3926    2552.8281      11.6128      11.5565      12.7870      12.7615      18.7192      18.7931      86.1120      86.5316      78.2044      78.3604      53.4211      53.2110       0.0090       0.3055       0.3055       3.2881       0.2808    2536.5952     102.1692      76.9449     332.5625       0.0947    4618.4551    -999.2500    1254.0000       0.2940       0.2940
  404.7744       0.8144      96.0000      96.7948       0.0734       0.0734       8.1915     217.5479     218.9232     219.0040     218.8425     217.5479     400.5811     407.6001     393.5622     393.5622     122.8790      38.1595       0.0787       0.0787       5.9582     131.6366       3.2515    2520.1001      13.2043      12.7199      14.3354      13.9358      20.1765      19.8621      75.7326      78.6172      69.7572      71.7576      49.5626      50.3470       0.0090       0.3095       0.3095       3.3037       0.2800    2528.8440      86.1120      76.4925     341.3750       0.0972    4596.6895    -999.2500    1245.0000       0.3020       0.3020
  404.9268       0.8141      96.0000      96.7948       0.0825       0.0825       6.7551     219.0537     219.4244     221.2732     217.5756     219.0537     406.7449     412.4319     401.0579     401.0579     124.9197      38.1663       0.0808       0.0808       6.9325     128.4273       3.2625    2516.6902      14.4657      14.0939      15.4447      15.2235      21.2693      21.0694      69.1289      70.9525      64.7470      65.6878      47.0162      47.4621       0.0090       0.2992       0.2992       3.3024       0.2874    2513.8459      75.7326      80.2227     317.3750       0.1008    4565.0898    -999.2500    1203.0000       0.3035       0.3035
  405.0792       0.8139      96.0000      96.4809       0.0867       0.0867       5.4872     220.3994     221.5366     224.4109     218.6624     220.3994     411.7920     415.5657     408.0182     408.0182     117.0218      38.1731       0.0903       0.0903       3.5794     115.2730       3.4055    2501.0540      15.7332      15.1544      16.7153      16.2461      22.5382      22.0665      63.5598      65.9874      59.8255      61.5532      44.3691      45.3177       0.0090       0.3027       0.3027       3.3382       0.2940    2507.0171      69.1289      62.3896     330.3125       0.1040    4537.2178    -999.2500    1216.0000       0.3167       0.3167
  405.2316       0.8146      96.0000      96.6901       0.0860       0.0860       7.3177     222.0654     224.3664     229.1145     219.6182     222.0654     413.4284     418.0335     408.8232     408.8232     116.7666      38.1800       0.0896       0.0896       6.2116     106.3634       3.3656    2502.1663      16.8435      15.8894      17.7840      16.9132      23.5635      22.7386      59.3700      62.9352      56.2303      59.1253      42.4385      43.9781       0.0089       0.3420       0.3420       3.3292       0.2907    2508.1152      63.5598      58.3161     320.6250       0.1079    4503.1772    -999.2500    1260.0000       0.3250       0.3250
  405.3840       0.8152      96.0000      96.8471       0.0765       0.0765       9.8351     218.4129     221.8783     227.8921     215.8644     218.4129     410.7870     411.4310     410.1429     410.1429     121.4986      38.1868       0.0798       0.0798      10.8003     128.3165       3.2303    2518.4114      17.2260      16.2125      18.1097      17.1576      23.8238      22.9393      58.0519      61.6807      55.2189      58.2832      41.9748      43.5932       0.0089       0.3516       0.3516       3.2788       0.3021    2523.7788      59.3700      53.9747     324.4375       0.0993    4578.4834    -999.2500    1268.0000       0.3325       0.3325
  405.5364       0.8155      96.0000      96.5855       0.0658       0.0658       7.9959     215.4012     216.6073     218.5215     214.6930     215.4012     394.6517     393.0468     396.2566     396.2566     139.4590      38.1936       0.0619       0.0619       9.5984     128.7775       3.2579    2547.8718      16.6989      16.1055      17.5560      16.9676      23.2579      22.6765      59.8842      62.0908      56.9606      58.9360      42.9962      44.0985       0.0088       0.3415       0.3415       3.2995       0.2903    2541.5029      58.0519      63.3723     320.1250       0.0919    4642.4990    -999.2500    1234.0000       0.3254       0.3254
  405.6888       0.8157      96.0000      96.6901       0.0519       0.0519       7.2201     211.7808     213.7125     213.9775     213.4475     211.7808     383.6238     375.8224     391.4252     391.4252     159.2318      38.2005       0.0531       0.0531       7.9595     160.6481       3.4412    2562.3606      15.7171      15.5196      16.5946      16.3500      22.2757      22.0643      63.6250      64.4346      60.2607      61.1623      44.8920      45.3221       0.0088       0.2808       0.2808       3.3047       0.2931    2564.4460      59.8842      74.6545     317.9375       0.0828    4721.8638    -999.2500    1217.0000       0.2968       0.2968
  405.8412       0.8162      96.0000      96.7948       0.0510       0.0510       5.1462     207.7118     210.8843     211.6408     210.1277     207.7118     375.3464     372.4218     378.2710     378.2710     163.2604      38.2073       0.0376       0.0376       8.7102     186.9801       3.2396    2587.9094      14.8847      14.7526      15.8056      15.6257      21.4893      21.2941      67.1829      67.7844      63.2689      63.9973      46.5348      46.9614       0.0088       0.2522       0.2522       3.3182       0.2842    2565.7729      63.6250      69.7133     326.1250       0.0722    4814.3638    -999.2500    1216.0000       0.2815       0.2815
  405.9936       0.8166      96.0000      96.6901       0.0555       0.0555       3.3589     206.3020     207.3234     210.0991     204.5476     206.3020     374.6172     370.7628     378.4716     378.4716     155.0868      38.2142       0.0626       0.0626      -1.4220     141.5550       3.2737    2546.6345      13.9020      13.7742      14.8211      14.7003      20.4810      20.3933      71.9320      72.5997      67.4714      68.0259      48.8258      49.0357       0.0088       0.2969       0.2969       3.2224       0.2886    2558.4258      67.1829      59.1122     313.9375       0.0684    4847.2622    -999.2500    1253.0000       0.2804       0.2804
  406.1460       0.8176      96.0000      96.8993       0.0628       0.0628       3.2195     203.9311     203.8310     208.3332     199.3288     203.9311     371.2370     365.7680     376.7059     376.7059     128.5374      38.2210       0.0677       0.0677      -0.1173     137.8388       3.1475    2538.3484      12.8324      12.6987      13.7438      13.6064      19.3795      19.2653      77.9277      78.7479      72.7599      73.4947      51.6010      51.9068       0.0087       0.3122       0.3122       3.1913       0.2927    2546.3748      71.9320      69.6539     322.1875       0.0619    4903.6167    -999.2500    1241.0000       0.2825       0.2825
  406.2984       0.8186      96.0000      96.5332       0.0555       0.0555       8.3277     201.7204     200.2348     203.2439     197.2257     201.7204     365.5447     361.4502     369.6393     369.6393     125.2963      38.2278       0.0606       0.0606       6.1235     108.0804       3.1401    2549.9617      11.8797      11.5113      12.6871      12.4176      18.4732      18.0419      84.1775      86.8713      78.8199      80.5307      54.1324      55.4264       0.0087       0.2932       0.2932       3.2052       0.2879    2558.4180      77.9277      93.9693     312.0625       0.0557    4957.3569    -999.2500    1243.0000       0.2772       0.2772
  406.4508       0.8185      96.0000      96.7948       0.0494       0.0494      12.7930     199.6378     197.5305     198.8791     196.1818     199.6378     362.0233     359.7915     364.2552     364.2552     117.1450      38.2347       0.0367       0.0367      20.6756     131.8318       3.3629    2589.5269      10.5593      10.4255      11.2860      11.1441      17.2254      16.8386      94.7031      95.9184      88.6053      89.7339      58.0537      59.3873       0.0087       0.2603       0.2603       3.1599       0.2853    2568.5708      84.1775     104.5554     331.0000       0.0498    5009.0708    -999.2500    1230.0000       0.2602       0.2602
  406.6032       0.8184      96.0000      96.5855       0.0475       0.0475      13.0783     198.9650     197.2337     196.8790     197.5885     198.9650     356.7600     354.9319     358.5883     358.5883     128.8060      38.2415       0.0498       0.0498      12.5119     111.3054       3.0144    2567.7581       8.7716       9.3508       9.3779       9.9354      15.7045      15.9535     114.0044     106.9432     106.6336     100.6504      63.6759      62.6821       0.0086       0.2377       0.2377       3.0855       0.2776    2571.6211      94.7031     108.3222     312.3750       0.0479    5026.0098    -999.2500    1242.0000       0.2449       0.2449
  406.7556       0.8182      96.0000      96.6901       0.0563       0.0563       5.5664     198.6766     196.4341     195.1995     197.6686     198.6766     355.1310     353.9852     356.2769     356.2769     137.8323      38.2483       0.0555       0.0555       5.6954     142.3146       2.9252    2558.3997       7.5223       8.6738       8.0363       9.2149      14.5908      15.5866     132.9386     115.2901     124.4348     108.5201      68.5364      64.1576       0.0086       0.2217       0.2217       2.9281       0.2743    2557.0747     114.0044     114.2763     312.3750       0.0470    5033.3042    -999.2500    1292.0000       0.2310       0.2310
  406.9080       0.8180      96.0000      96.5332       0.0569       0.0569       1.1312     197.8436     196.4531     194.8901     198.0161     197.8436     352.2358     349.9101     354.5614     354.5614     158.9491      38.2552       0.0631       0.0631      -1.8743     158.2885       2.8420    2545.8877       7.1367       8.9603       7.5982       9.5077      14.5809      16.0273     140.1210     111.6034     131.6096     105.1783      68.5828      62.3935       0.0086       0.2114       0.2114       2.8520       0.2739    2556.1201     132.9386     121.1075     319.8125       0.0446    5054.4971    -999.2500    1308.0000       0.2204       0.2204
  407.0604       0.8169      96.0000      96.7948       0.0566       0.0566      -1.1819     198.7407     199.5427     197.4899     201.5954     198.7407     356.6652     356.4833     356.8470     356.8470     228.0369      38.2620       0.0516       0.0516       0.1415     175.6219       2.7827    2564.9290       7.5959      10.4345       8.0070      11.0058      15.2131      17.9470     131.6491      95.8363     124.8902      90.8610      65.7326      55.7196       0.0085       0.1878       0.1878       2.9368       0.2752    2556.5786     140.1210     133.5381     312.3750       0.0472    5031.6812    -999.2500    1266.0000       0.2146       0.2146
  407.2128       0.8159      96.0000      96.8993       0.0575       0.0575       0.5552     203.3864     202.6701     199.1368     206.2034     203.3864     369.8973     372.8609     366.9338     366.9338     270.3951      38.2689       0.0541       0.0541       0.4925     352.6655       3.1921    2560.7161       9.4490      13.2469       9.8083      13.8364      16.7935      21.0162     105.8315      75.4891     101.9540      72.2734      59.5470      47.5823       0.0085       0.1923       0.1923       3.1261       0.2783    2555.1523     131.6491     102.0273     321.5000       0.0604    4916.7485    -999.2500    1229.0000       0.2232       0.2232
  407.3652       0.8158      96.0000      96.5332       0.0671       0.0671       2.6673     209.7943     213.5474     214.3500     212.7448     209.7943     383.2948     391.6608     374.9288     374.9288     309.2301      38.2757       0.0653       0.0653       3.5273     286.5469       3.4170    2542.3069      16.0825      16.8586      16.5954      17.4475      22.7321      23.7839      62.1793      59.3170      60.2577      57.3149      43.9906      42.0453       0.0085       0.2672       0.2672       3.3376       0.2721    2539.2544     105.8315      65.6144     313.0000       0.0777    4766.5732    -999.2500    1299.0000       0.2510       0.2510
  407.5176       0.8158      96.0000      96.7948       0.0734       0.0734       7.2601     216.7789     217.0182     212.6643     221.3720     216.7789     407.6342     406.2497     409.0188     409.0188     309.2439      38.2825       0.0806       0.0806       5.4073     290.2159       3.4100    2516.9849      24.2241      20.4897      24.9287      21.0768      30.4622      27.1395      41.2812      48.8050      40.1143      47.4456      32.8276      36.8467       0.0084       0.3344       0.3344       3.4098       0.3047    2528.9487      62.1793      44.3491     322.4375       0.0953    4612.9946    -999.2500    1227.0000       0.2900       0.2900
  407.6700       0.8186      96.0000      96.6901       0.0734       0.0734       8.6470     221.5849     221.4762     215.5682     227.3842     221.5849     417.7279     422.8864     412.5693     412.5693     300.1811      38.2894       0.0773       0.0773       7.2884     349.6193       3.3883    2522.5208      28.2622      22.8414      29.0567      23.4638      33.9332      29.0391      35.3829      43.7802      34.4155      42.6189      29.4697      34.4363       0.0084       0.3570       0.3570       3.4022       0.2973    2528.9290      41.2812      38.1356     312.3750       0.1068    4512.9438    -999.2500    1269.0000       0.3228       0.3228
  407.8224       0.8214      96.0000      96.5855       0.0702       0.0702       7.7530     221.3285     227.4412     227.2374     227.6449     221.3285     417.1663     421.6136     412.7190     412.7190     252.7760      38.2962       0.0654       0.0654       7.9027     253.4706       3.3974    2542.0522      27.2842      23.2830      28.0788      23.9861      32.8059      28.8842      36.6513      42.9497      35.6140      41.6909      30.4823      34.6209       0.0084       0.3566       0.3566       3.3189       0.2982    2534.1689      35.3829      41.7782     322.1875       0.1062    4518.1704    -999.2500    1264.0000       0.3395       0.3395
  407.9748       0.8248      96.0000      96.6901       0.0616       0.0616       9.8607     220.0470     225.7748     225.4516     226.0981     220.0470     410.7260     410.4229     411.0290     411.0290     172.9197      38.3030       0.0682       0.0682       8.8075     148.3952       3.1677    2537.5378      23.7839      21.5554      24.5187      22.3118      29.4946      27.0388      42.0452      46.3922      40.7852      44.8193      33.9045      36.9839       0.0083       0.3366       0.3366       3.3386       0.2991    2548.4312      36.6513      52.5970     307.2500       0.1032    4544.4849    -999.2500    1237.0000       0.3280       0.3280
  408.1272       0.8282      96.0000      96.6901       0.0535       0.0535      10.6938     215.7537     216.1894     215.0742     217.3047     215.7537     394.2357     393.6325     394.8388     394.8388     130.6115      38.3099       0.0512       0.0512      13.4810     110.0502       3.4384    2565.4700      19.5064      18.2188      20.1812      18.9318      25.5305      23.9074      51.2652      54.8883      49.5511      52.8213      39.1688      41.8281       0.0083       0.3343       0.3343       3.2318       0.2871    2561.6770      42.0452      61.7224     305.2500       0.0928    4634.9155    -999.2500    1218.0000       0.3220       0.3220
  408.2796       0.8294      96.0000      96.5855       0.0521       0.0521       7.3589     212.2614     214.2850     216.7556     211.8144     212.2614     377.9220     376.0365     379.8075     379.8075     129.8043      38.3167       0.0413       0.0413       9.5787     131.4494       3.0729    2581.9299      14.2126      14.2447      14.8327      14.8631      20.4991      20.2552      70.3599      70.2014      67.4187      67.2805      48.7825      49.3699       0.0083       0.3199       0.3199       3.2240       0.2729    2564.0188      51.2652      86.9434     323.6875       0.0840    4711.1729    -999.2500    1205.0000       0.3046       0.3046
  408.4320       0.8306      96.0000      96.8993       0.0505       0.0505       3.8923     210.9798     212.8400     215.0358     210.6441     210.9798     370.8611     371.2606     370.4616     370.4616     154.2314      38.3236       0.0644       0.0644      -2.7743     146.9777       3.1482    2543.7939       8.5031      10.3312       8.9997      10.8824      15.0649      16.6141     117.6041      96.7939     111.1151      91.8915      66.3793      60.1898       0.0082       0.2775       0.2775       3.1518       0.2600    2566.6006      70.3599     167.8925     308.8125       0.0807    4739.7905    -999.2500    1216.0000       0.2853       0.2853
  408.5844       0.8297      96.0000      96.6901       0.0488       0.0488       2.3333     206.9428     209.4547     209.3177     209.5918     206.9428     362.8962     361.1606     364.6318     364.6318     169.5568      38.3304       0.0449       0.0449       5.2057     184.9333       3.2364    2575.8643       4.6481       7.1970       4.9160       7.6901      11.1502      13.7490     215.1402     138.9469     203.4184     130.0373      89.6844      72.7326       0.0082       0.2563       0.2563       3.2859       0.2624    2569.4080     117.6041     254.9051     317.8125       0.0701    4832.2529    -999.2500    1231.0000       0.2618       0.2618
  408.7368       0.8288      96.0000      96.5855       0.0408       0.0408       5.8024     210.3390     209.6499     211.7321     207.5677     210.3390     368.1856     367.0452     369.3259     369.3259     178.7745      38.3372       0.0343       0.0343       7.1361     179.0693       3.4814    2593.3591       3.5094       5.1787       3.7587       5.6055      10.0080      11.8296     284.9529     193.0978     266.0483     178.3950      99.9204      84.5334       0.0082       0.2283       0.2283       3.4884       0.2600    2582.6436     215.1402     290.8835     302.2500       0.0791    4754.2300    -999.2500    1265.0000       0.2447       0.2447
  408.8892       0.8276      96.0000      96.6901       0.0469       0.0469       7.0008     220.6557     225.4528     227.8371     223.0684     220.6557     376.3197     378.7476     373.8918     373.8918     171.5562      38.3441       0.0403       0.0403       8.9767     175.3241       3.7675    2583.4656       3.3632       4.2463       3.7835       4.6425      10.0703      10.8769     297.3325     235.4993     264.3041     215.3990      99.3014      91.9380       0.0082       0.2037       0.2037       3.4693       0.2328    2572.6904     284.9529     304.6108     319.8750       0.1046    4531.9473    -999.2500    1290.0000       0.2343       0.2343
  409.0416       0.8264      96.0000      96.8993       0.0525       0.0525      12.1866     223.5713     229.9317     230.6900     229.1734     223.5713     389.3751     391.7455     387.0047     387.0047     176.7123      38.3509       0.0622       0.0622      10.2267     161.6766       3.1788    2547.4070       3.2152       4.2495       3.5525       4.6950       9.8226      10.9485     311.0251     235.3232     281.4901     212.9916     101.8059      91.3364       0.0081       0.2422       0.2422       3.4118       0.2495    2563.3789     297.3325     325.1376     308.3750       0.1114    4472.8457    -999.2500    1277.0000       0.2443       0.2443
  409.1940       0.8247      96.0000      96.6901       0.0533       0.0533      14.6482     223.1548     226.6911     230.2514     223.1307     223.1548     395.2471     393.4838     397.0105     397.0105     179.1982      38.3577       0.0562       0.0562      15.6899     194.1271       3.3216    2557.2134       3.4799       5.1949       3.4062       5.7352       9.6610      11.9861     287.3638     192.4956     293.5794     174.3629     103.5085      83.4302       0.0081       0.2959       0.2959       3.2817       0.2691    2561.9863     311.0251     377.7662     320.1250       0.1104    4481.1948    -999.2500    1172.0000       0.2556       0.2556
  409.3464       0.8231      96.0000      96.6901       0.0419       0.0419      11.1722     217.0993     220.8139     225.0729     216.5548     217.0993     375.0133     370.6411     379.3854     379.3854     182.9799      38.3646       0.0466       0.0466      10.8633     183.5681       3.3388    2573.1685       5.1469       7.3165       5.1994       7.9360      11.2498      14.1909     194.2914     136.6776     192.3284     126.0076      88.8904      70.4677       0.0080       0.2633       0.2633       3.3342       0.2566    2580.8455     287.3638     224.5180     322.1875       0.0961    4606.1865    -999.2500    1172.0000       0.2536       0.2536
  409.4988       0.8215      96.0000      97.0039       0.0274       0.0274       5.9697     203.7709     202.8616     206.9703     198.7529     203.7709     357.9519     351.7393     364.1644     364.1644     172.2903      38.3714       0.0214       0.0214       5.9284     173.0216       3.3279    2614.7004       8.9462      10.6888       9.4408      11.4028      15.2247      17.4538     111.7798      93.5554     105.9231      87.6977      65.6828      57.2943       0.0080       0.2268       0.2268       3.3787       0.2721    2604.7256     194.2914     145.0895     324.1875       0.0615    4907.4717    -999.2500    1229.0000       0.2377       0.2377
  409.6512       0.8200      96.0000      96.6901       0.0159       0.0159       5.7104     198.8368     197.2759     198.8072     195.7446     198.8368     350.7473     348.3226     353.1719     353.1719     182.4430      38.3783       0.0079       0.0079       7.9137     162.8301       3.4480    2636.9060      14.6017      14.6147      15.3528      15.4736      20.9156      21.2538      68.4851      68.4243      65.1348      64.6263      47.8112      47.0503       0.0080       0.2111       0.2111       3.4991       0.2680    2623.7412     111.7798      98.3178     344.6875       0.0475    5029.2495    -999.2500    1305.0000       0.2229       0.2229
  409.8036       0.8203      96.0000      96.7948       0.0208       0.0208       8.9128     200.6951     197.7894     198.4764     197.1024     200.6951     355.5240     354.2457     356.8022     356.8022     189.7118      38.3851       0.0121       0.0121      11.8622     212.9839       3.7334    2629.9727      21.0818      18.8744      21.8760      19.6682      27.2907      25.3566      47.4343      52.9819      45.7122      50.8436      36.6426      39.4374       0.0080       0.1987       0.1987       3.6514       0.2686    2615.7327      68.4851      47.6969     336.2500       0.0528    4982.6821    -999.2500    1368.0000       0.2134       0.2134
  409.9560       0.8206      96.0000      96.7948       0.0301       0.0301      10.1524     203.4826     201.3298     199.0986     203.5611     203.4826     364.3686     359.7348     369.0024     369.0024     191.3119      38.3919       0.0409       0.0409       6.9805     194.4319       3.7653    2582.5215      25.9873      22.4231      26.6667      23.2320      31.9548      28.6445      38.4804      44.5968      37.4999      43.0441      31.2942      34.9107       0.0079       0.2129       0.2129       3.7652       0.2815    2600.3203      47.4343      36.3078     351.4375       0.0607    4914.4263    -999.2500    1309.0000       0.2173       0.2173
  410.1084       0.8219      96.0000      96.8471       0.0395       0.0395       9.7065     206.2700     210.6609     212.7513     208.5706     206.2700     367.3207     362.9059     371.7355     371.7355     166.6919      38.3988       0.0373       0.0373      10.0000     166.0490       3.7837    2588.4297      27.7126      24.4402      28.2059      25.1399      33.3785      30.4248      36.0847      40.9163      35.4536      39.7774      29.9594      32.8680       0.0079       0.2477       0.2477       4.0561       0.2776    2584.8132      38.4804      38.9612     342.2500       0.0683    4848.0146    -999.2500    1242.0000       0.2277       0.2277
  410.2608       0.8233      96.0000      96.8993       0.0320       0.0320      10.3766     207.4234     211.8818     212.8390     210.9245     207.4234     369.0444     363.9718     374.1170     374.1170     145.6968      38.4056       0.0438       0.0438       5.2388     139.4475       4.6768    2577.6611      26.9498      25.0361      27.2627      25.5336      32.4831      30.7024      37.1061      39.9424      36.6801      39.1641      30.7852      32.5708       0.0079       0.2384       0.2384       4.1029       0.2781    2597.1609      36.0847      43.9605     351.4375       0.0714    4821.0566    -999.2500    1180.0000       0.2333       0.2333
  410.4132       0.8241      96.0000      96.7948       0.0328       0.0328      10.4535     207.9040     213.2531     213.7628     212.7435     207.9040     371.3571     367.5449     375.1694     375.1694     127.2176      38.4124       0.0120       0.0120      18.6072     131.8898       3.8900    2630.1917      25.2356      24.4000      25.4584      24.6757      30.8056      29.9110      39.6265      40.9835      39.2798      40.5256      32.4616      33.4325       0.0078       0.2232       0.2232       3.9268       0.2784    2595.8806      37.1061      49.4758     363.5625       0.0727    4809.9121    -999.2500    1219.0000       0.2309       0.2309
  410.5656       0.8249      96.0000      97.0039       0.0352       0.0352       8.6683     207.9040     213.5020     213.9343     213.0696     207.9040     370.2267     369.0666     371.3867     371.3867     119.8084      38.4193       0.0407       0.0407       7.6403     111.1411       3.3336    2582.7954      23.1199      23.0337      23.3224      23.2902      28.6352      28.6100      43.2528      43.4146      42.8773      42.9366      34.9221      34.9528       0.0078       0.2431       0.2431       3.5085       0.2718    2591.9441      39.6265      50.6105     351.5625       0.0727    4809.9121    -999.2500    1305.0000       0.2318       0.2318
  410.7180       0.8250      96.0000      96.7948       0.0340       0.0340      10.4305     207.7758     212.9962     212.2943     213.6980     207.7758     369.1978     366.7339     371.6617     371.6617     117.9273      38.4261       0.0483       0.0483       4.8749     116.9714       3.3204    2570.3225      20.9028      21.8602      21.0564      22.0077      26.6125      27.4542      47.8405      45.7453      47.4915      45.4387      37.5763      36.4243       0.0078       0.2363       0.2363       3.3168       0.2727    2593.9670      43.2528      50.3136     361.2500       0.0723    4812.8789    -999.2500    1379.0000       0.2332       0.2332
  410.8704       0.8252      96.0000      97.0039       0.0348       0.0348       7.7157     207.9040     212.6713     212.0357     213.3068     207.9040     370.7357     367.6695     373.8018     373.8018     126.1568      38.4329       0.0158       0.0158      12.3925     125.1420       3.3111    2623.9312      19.6106      20.8640      19.7180      21.0129      25.1511      26.5527      50.9929      47.9294      50.7151      47.5897      39.7597      37.6609       0.0077       0.2246       0.2246       3.3031       0.2760    2592.6450      47.8405      52.6832     352.8750       0.0727    4809.9121    -999.2500    1293.0000       0.2292       0.2292
  411.0228       0.8253      96.0000      97.0039       0.0365       0.0365       5.4748     206.9108     211.6669     211.2730     212.0608     206.9108     367.8374     363.6843     371.9905     371.9905     129.4961      38.4398       0.0403       0.0403       5.2115     135.2997       3.2815    2583.4380      19.5644      20.3962      19.6203      20.4994      24.7277      25.9180      51.1133      49.0288      50.9675      48.7819      40.4405      38.5832       0.0077       0.2212       0.2212       3.2076       0.2760    2589.8569      50.9929      49.5113     355.4375       0.0700    4833.0010    -999.2500    1231.0000       0.2278       0.2278
  411.1752       0.8253      96.0000      97.3177       0.0489       0.0489       1.9240     206.5583     211.2131     210.8650     211.5612     206.5583     365.4537     364.0380     366.8694     366.8694     137.7969      38.4466       0.0507       0.0507       1.5336     125.8388       3.0427    2566.3638      20.1164      20.2853      20.2238      20.3297      24.8764      25.4299      49.7107      49.2968      49.4467      49.1891      40.1988      39.3238       0.0077       0.2200       0.2200       3.0951       0.2679    2569.2700      51.1133      48.7654     369.1250       0.0691    4841.2471    -999.2500    1123.0000       0.2247       0.2247
  411.3276       0.8247      96.0000      97.3177       0.0520       0.0520       4.9806     206.5263     210.9941     210.2659     211.7222     206.5263     365.4149     363.0903     367.7395     367.7395     136.3713      38.4535       0.0527       0.0527       3.3853     151.1016       2.9642    2563.0911      20.4625      20.2919      20.7936      20.4053      25.1077      25.0746      48.8698      49.2807      48.0918      49.0070      39.8284      39.8811       0.0076       0.2202       0.2202       3.0347       0.2696    2564.2634      49.7107      51.0790     357.6875       0.0690    4841.9980    -999.2500    1267.0000       0.2309       0.2309
  411.4800       0.8240      96.0000      97.0039       0.0535       0.0535       7.9235     206.9428     210.7068     209.8913     211.5222     206.9428     370.4124     370.2699     370.5549     370.5549     139.0876      38.4603       0.0526       0.0526       9.7003     130.7378       3.0905    2563.1716      20.8540      20.3947      21.7560      20.7745      25.7046      25.1211      47.9525      49.0324      45.9644      48.1359      38.9035      39.8072       0.0076       0.2388       0.2388       3.0633       0.2734    2561.7900      48.8698      55.0569     369.3750       0.0701    4832.2529    -999.2500    1349.0000       0.2386       0.2386
  411.6324       0.8233      96.0000      97.0039       0.0601       0.0601       6.4990     209.0574     212.1356     211.3885     212.8827     209.0574     373.3674     373.8848     372.8499     372.8499     134.0141      38.4671       0.0560       0.0560       9.6390     134.5338       3.1358    2557.5181      18.9993      20.7663      20.0646      21.5797      23.7476      25.5108      52.6337      48.1549      49.8390      46.3399      42.1095      39.1991       0.0076       0.2444       0.2444       3.1837       0.2707    2550.9011      47.9525      53.2033     371.0000       0.0757    4783.3745    -999.2500    1324.0000       0.2517       0.2517
  411.7848       0.8226      96.0000      96.8993       0.0676       0.0676       1.4985     210.9798     215.6505     215.8833     215.4178     210.9798     377.4391     379.8882     374.9900     374.9900     132.0109      38.4740       0.0713       0.0713      -0.3330     134.8960       3.3125    2532.3054      15.8375      22.0075      16.7329      23.2382      19.8218      26.6572      63.1411      45.4390      59.7624      43.0326      50.4495      37.5133       0.0075       0.2834       0.2834       3.2462       0.2684    2538.4500      52.6337      37.7201     371.0000       0.0807    4739.7905    -999.2500    1285.0000       0.2689       0.2689
  411.9372       0.8221      96.0000      97.1608       0.0674       0.0674       3.7800     213.7672     218.2401     218.5358     217.9443     213.7672     385.0088     391.4201     378.5974     378.5974     134.6953      38.4808       0.0711       0.0711       0.9749     125.0134       3.2791    2532.6721      18.9196      24.8471      19.3895      26.2310      21.7589      29.2704      52.8552      40.2461      51.5742      38.1228      45.9582      34.1642       0.0075       0.3053       0.3053       3.3587       0.2660    2538.8667      63.1411      32.7646     380.7500       0.0878    4677.9854    -999.2500    1195.0000       0.2876       0.2876
  412.0896       0.8215      96.0000      97.0039       0.0570       0.0570       6.5777     219.4062     224.5748     224.7593     224.3903     219.4062     395.3692     395.9472     394.7912     394.7912     136.1016      38.4876       0.0634       0.0634       1.7574     143.1914       3.4544    2545.3452      28.2952      30.0239      29.4533      31.5709      30.9055      33.9597      35.3417      33.3068      33.9521      31.6747      32.3567      29.4467       0.0075       0.3021       0.3021       3.3839       0.2766    2555.9954      52.8552      34.1307     363.2500       0.1016    4557.7573    -999.2500    1154.0000       0.2997       0.2997
  412.2420       0.8211      96.0000      97.0039       0.0530       0.0530      10.7271     223.9558     229.2705     230.2215     228.3194     223.9558     411.4059     413.4203     409.3915     409.3915     137.8238      38.4945       0.0345       0.0345      17.6796     138.9581       3.4084    2593.0261      38.5869      33.7819      40.0010      35.3848      43.4073      38.2763      25.9155      29.6017      24.9994      28.2607      23.0376      26.1258       0.0074       0.3014       0.3014       3.4317       0.2865    2562.5884      35.3417      32.7130     372.6875       0.1123    4465.1675    -999.2500    1243.0000       0.3120       0.3120
  412.3944       0.8206      96.0000      97.3177       0.0573       0.0573       6.0404     228.4413     233.0801     234.0148     232.1454     228.4413     425.4392     426.9507     423.9277     423.9277     137.2634      38.5013       0.0629       0.0629       7.8332     130.1278       3.4126    2546.2793      49.2056      38.4161      50.3704      39.5768      53.6237      43.0533      20.3229      26.0307      19.8529      25.2673      18.6485      23.2270       0.0074       0.3312       0.3312       3.4506       0.2954    2555.5093      25.9155      27.3554     377.2500       0.1223    4377.4922    -999.2500    1276.0000       0.3291       0.3291
  412.5468       0.8214      96.0000      97.1085       0.0673       0.0673       3.3463     231.9656     236.5401     238.7373     234.3429     231.9656     427.4389     428.2550     426.6228     426.6228     124.1600      38.5082       0.0667       0.0667       3.5631     141.5102       3.5150    2539.8901      48.4424      41.7624      49.0624      42.6255      53.5785      45.9414      20.6431      23.9450      20.3822      23.4601      18.6642      21.7669       0.0074       0.3577       0.3577       3.4397       0.2901    2538.8914      20.3229      22.6324     368.0000       0.1300    4310.9834    -999.2500    1330.0000       0.3412       0.3412
  412.6992       0.8222      96.0000      97.3177       0.0707       0.0707       4.1686     232.5423     234.6638     239.3700     229.9576     232.5423     431.0392     428.1605     433.9178     433.9178     132.2797      38.5150       0.0699       0.0699       2.2284     100.3731       3.3776    2534.6318      42.1434      42.1604      42.3018      42.7746      47.5269      47.2408      23.7285      23.7189      23.6396      23.3784      21.0407      21.1682       0.0073       0.3438       0.3438       3.5301       0.2985    2533.3167      20.6431      24.6966     374.1875       0.1312    4300.2920    -999.2500    1331.0000       0.3417       0.3417
  412.8516       0.8222      96.0000      97.3177       0.0706       0.0706       5.5317     232.0618     234.7841     236.0578     233.5104     232.0618     431.4807     427.7745     435.1869     435.1869     135.6443      38.5218       0.0760       0.0760       4.1027     154.5391       3.6868    2524.5178      39.0355      42.6721      39.1500      41.7598      43.4814      47.7072      25.6177      23.4345      25.5428      23.9465      22.9983      20.9612       0.0073       0.3272       0.3272       3.4915       0.3013    2533.4626      23.7285      26.1975     361.7500       0.1302    4309.1978    -999.2500    1249.0000       0.3321       0.3321
  413.0040       0.8221      96.0000      97.1085       0.0687       0.0687       5.2157     232.2860     236.0837     234.6009     237.5665     232.2860     427.3622     428.9181     425.8064     425.8064     148.3132      38.5287       0.0674       0.0674       7.3917     153.1144       3.3902    2538.7913      39.6657      42.6839      39.5029      42.0474      44.2959      47.8292      25.2107      23.4281      25.3146      23.7827      22.5755      20.9077       0.0073       0.3360       0.3360       3.4535       0.2882    2536.6704      25.6177      26.2361     371.0000       0.1307    4305.0371    -999.2500    1186.0000       0.3310       0.3310
  413.1564       0.8223      96.0000      97.5269       0.0676       0.0676       1.4470     232.3181     237.2402     234.4495     240.0310     232.3181     428.9468     432.3232     425.5704     425.5704     145.1361      38.5355       0.0633       0.0633       1.9888     138.7966       3.2802    2545.5642      42.5173      42.6014      42.3505      42.2744      47.0825      47.7595      23.5198      23.4734      23.6125      23.6550      21.2393      20.9382       0.0072       0.3213       0.3213       3.3931       0.2877    2538.3899      25.2107      25.7409     374.1875       0.1307    4304.4438    -999.2500    1234.0000       0.3255       0.3255
  413.3088       0.8224      96.0000      97.3177       0.0664       0.0664       2.6650     231.7414     233.5291     227.7264     239.3319     231.7414     424.8258     429.2658     420.3858     420.3858     138.5502      38.5423       0.0687       0.0687       0.1225     145.7973       3.4888    2536.5820      44.6941      42.9166      44.8084      42.6819      49.4033      47.4965      22.3743      23.3010      22.3172      23.4291      20.2416      21.0542       0.0072       0.3297       0.3297       3.4746       0.2817    2540.3982      23.5198      24.2531     363.0000       0.1295    4315.1553    -999.2500    1300.0000       0.3323       0.3323
  413.4612       0.8232      96.0000      97.2131       0.0612       0.0612       4.7165     229.6908     235.9060     233.4411     238.3709     229.6908     421.5388     427.2275     415.8500     415.8500     139.1637      38.5492       0.0687       0.0687       4.3636     132.0483       3.6645    2536.6841      45.2768      41.9351      45.8020      41.9723      50.0980      46.6091      22.0864      23.8464      21.8331      23.8252      19.9609      21.4550       0.0072       0.3437       0.3437       3.4840       0.2805    2549.0630      22.3743      23.3744     371.0000       0.1251    4353.6782    -999.2500    1372.0000       0.3345       0.3345
  413.6136       0.8239      96.0000      97.3177       0.0511       0.0511       7.8477     225.2694     232.7540     229.7850     235.7231     225.2694     411.9509     413.7335     410.1682     410.1682     128.7865      38.5560       0.0465       0.0465      10.1055     140.6373       3.3108    2573.3508      43.3995      40.0243      44.2807      40.4458      48.2561      44.7707      23.0418      24.9848      22.5832      24.7244      20.7228      22.3360       0.0071       0.3623       0.3623       3.5408       0.2840    2565.6169      22.0864      23.0484     357.5625       0.1153    4439.1294    -999.2500    1343.0000       0.3364       0.3364
  413.7660       0.8246      96.0000      97.3177       0.0393       0.0393       8.9619     220.5916     228.2750     226.7264     229.8237     220.5916     397.6061     395.4843     399.7279     399.7279     126.5836      38.5629       0.0376       0.0376       8.2881     113.6031       3.6565    2587.9844      37.1561      37.4644      38.1352      38.2393      41.9125      42.2247      26.9135      26.6920      26.2225      26.1511      23.8592      23.6828       0.0071       0.3064       0.3064       3.4862       0.2810    2585.1003      23.0418      26.7050     359.9375       0.1044    4533.2637    -999.2500    1262.0000       0.3152       0.3152
  413.9184       0.8252      96.0000      97.4746       0.0333       0.0333      11.0162     215.4974     215.9135     209.5450     222.2821     215.4974     389.3398     392.3385     386.3411     386.3411     121.3757      38.5697       0.0305       0.0305      10.8883     125.2888       3.4788    2599.6345      31.0920      34.9444      31.9812      35.9280      35.7448      39.6721      32.1626      28.6169      31.2684      27.8334      27.9761      25.2066       0.0071       0.2769       0.2769       3.5351       0.2742    2595.1040      26.9135      26.6124     361.8125       0.0921    4640.4282    -999.2500    1207.0000       0.2985       0.2985
  414.0708       0.8254      96.0000      97.1608       0.0364       0.0364      12.7050     212.5177     216.7058     214.8703     218.5414     212.5177     387.0899     391.0049     383.1750     383.1750     131.9845      38.5765       0.0290       0.0290      15.1209     125.0134       3.4450    2602.1633      31.1481      32.7738      32.0005      33.7653      35.5877      37.5185      32.1047      30.5122      31.2495      29.6162      28.0996      26.6535       0.0070       0.3003       0.3003       3.4970       0.2779    2589.9651      32.1626      27.7067     355.8125       0.0847    4705.4907    -999.2500    1195.0000       0.2934       0.2934
  414.2232       0.8256      96.0000      97.4223       0.0466       0.0466      11.9693     211.3322     215.7503     214.1586     217.3420     211.3322     385.2310     390.6240     379.8381     379.8381     138.5994      38.5834       0.0485       0.0485      11.3799     148.1418       3.5878    2569.9534      32.4088      31.4407      33.2378      32.3017      36.8970      35.8851      30.8558      31.8060      30.0862      30.9581      27.1025      27.8667       0.0070       0.2932       0.2932       3.5035       0.2758    2573.0791      32.1047      30.1001     368.6250       0.0816    4731.8862    -999.2500    1299.0000       0.2890       0.2890
  414.3756       0.8256      96.0000      97.4223       0.0621       0.0621       3.4391     210.1468     214.0271     213.6624     214.3919     210.1468     379.4622     381.4716     377.4528     377.4528     146.8798      38.5902       0.0646       0.0646       3.0460     145.0822       3.5058    2543.4070      31.0984      30.6557      31.7736      31.3780      35.5427      34.8681      32.1560      32.6203      31.4727      31.8695      28.1352      28.6795       0.0070       0.2962       0.2962       3.3654       0.2754    2547.5320      30.8558      33.5534     352.6250       0.0786    4758.5791    -999.2500    1378.0000       0.2845       0.2845
  414.5280       0.8256      96.0000      97.6315       0.0641       0.0641       0.6111     209.4099     211.7495     211.2273     212.2717     209.4099     377.3874     376.9682     377.8066     377.8066     144.1759      38.5970       0.0717       0.0717      -3.2177     151.6894       3.0527    2531.7310      28.1135      30.4769      28.5534      31.0688      32.5131      34.6878      35.5701      32.8117      35.0222      32.1867      30.7568      28.8286       0.0069       0.2766       0.2766       3.2619       0.2783    2544.2192      32.1560      37.1044     360.8125       0.0767    4775.3242    -999.2500    1355.0000       0.2789       0.2789
  414.6804       0.8235      96.0000      97.4746       0.0639       0.0639      -2.3758     212.2293     212.1390     215.2880     208.9900     212.2293     381.7053     386.2628     377.1478     377.1478     137.6026      38.6039       0.0576       0.0576      -1.3319     139.4844       3.2243    2554.9583      26.9469      31.2620      27.2187      31.7361      31.4036      35.6937      37.1100      31.9877      36.7395      31.5098      31.8435      28.0162       0.0069       0.2553       0.2553       3.2347       0.2683    2544.5071      35.5701      41.6563     362.6875       0.0839    4711.8843    -999.2500    1278.0000       0.2719       0.2719
  414.8328       0.8214      96.0000      97.5269       0.0500       0.0500       5.2525     216.2663     217.9048     217.2440     218.5656     216.2663     389.6505     396.2845     383.0167     383.0167     127.5184      38.6107       0.0592       0.0592       1.4208     125.2751       3.4295    2552.3784      32.5355      33.0294      32.6810      33.3833      36.9942      37.5739      30.7356      30.2760      30.5988      29.9551      27.0312      26.6142       0.0069       0.2587       0.2587       3.4431       0.2660    2567.5364      37.1100      34.4110     351.4375       0.0940    4623.9287    -999.2500    1208.0000       0.2760       0.2760
  414.9852       0.8214      96.0000      97.4223       0.0443       0.0443       6.1257     219.6945     220.3423     217.0242     223.6603     219.6945     410.5263     412.9484     408.1043     408.1043     125.3473      38.6175       0.0350       0.0350       9.5420     119.6019       3.6754    2592.2363      38.9453      34.8391      38.9600      35.0170      43.4388      39.3283      25.6770      28.7034      25.6673      28.5576      23.0209      25.4270       0.0068       0.2961       0.2961       3.5295       0.2960    2576.8518      30.7356      26.2536     363.0000       0.1023    4551.7749    -999.2500    1300.0000       0.2824       0.2824
  415.1376       0.8215      96.0000      97.7883       0.0349       0.0349       8.6930     222.7703     226.4880     227.1125     225.8636     222.7703     414.1632     415.0828     413.2436     413.2436     128.0310      38.6244       0.0349       0.0349      11.3933     130.9279       3.4841    2592.4756      39.7062      35.7564      39.7251      35.8588      44.4813      40.3028      25.1850      27.9670      25.1730      27.8872      22.4813      24.8122       0.0068       0.3096       0.3096       3.5199       0.2952    2592.4731      25.6770      25.9985     355.8125       0.1095    4488.9287    -999.2500    1337.0000       0.2965       0.2965
  415.2900       0.8212      96.0000      97.3177       0.0342       0.0342       3.5113     223.2189     225.5511     228.8923     222.2100     223.2189     415.6704     418.2555     413.0853     413.0853     129.9549      38.6312       0.0335       0.0335       5.1197     133.2902       3.3814    2594.7627      36.3767      35.4100      36.2878      35.5209      41.2782      40.2304      27.4901      28.2406      27.5575      28.1524      24.2259      24.8568       0.0068       0.3090       0.3090       3.3674       0.2938    2593.6321      25.1850      28.9576     354.1250       0.1106    4479.9082    -999.2500    1366.0000       0.2961       0.2961
  415.4424       0.8208      96.0000      97.5269       0.0283       0.0283       2.9142     222.0014     223.2473     227.6375     218.8571     222.0014     412.2907     413.8619     410.7195     410.7195     125.2875      38.6381       0.0296       0.0296       0.4636     126.0096       3.2331    2601.1243      33.2972      34.2342      33.5267      34.3836      38.3901      39.3644      30.0326      29.2106      29.8269      29.0837      26.0484      25.4037       0.0067       0.2902       0.2902       3.3722       0.2936    2603.3030      27.4901      30.4904     361.2500       0.1078    4504.4771    -999.2500    1286.0000       0.2934       0.2934
  415.5948       0.8218      96.0000      97.7883       0.0240       0.0240       6.6236     223.8276     224.6912     228.2990     221.0835     223.8276     416.7982     419.4663     414.1302     414.1302     126.9596      38.6449       0.0182       0.0182       7.6592     116.2967       3.5010    2619.9126      32.2530      32.7974      32.5802      32.9981      37.5481      37.8411      31.0049      30.4902      30.6935      30.3048      26.6325      26.4263       0.0067       0.2683       0.2683       3.3910       0.2937    2610.4019      30.0326      32.5439     349.0000       0.1120    4467.7236    -999.2500    1251.0000       0.2854       0.2854
  415.7472       0.8228      96.0000      97.7883       0.0354       0.0354       4.5190     223.6354     225.3801     227.5693     223.1909     223.6354     410.3705     411.9046     408.8364     408.8364     134.0852      38.6517       0.0237       0.0237      12.5007     138.1880       3.4378    2610.8638      31.1998      31.3528      31.6741      31.6809      36.4291      36.3867      32.0515      31.8951      31.5715      31.5648      27.4506      27.4826       0.0067       0.2806       0.2806       3.3983       0.2865    2591.5269      31.0049      31.9502     355.3750       0.1115    4471.5645    -999.2500    1196.0000       0.2893       0.2893
  415.8996       0.8234      96.0000      97.6315       0.0400       0.0400       5.5415     223.9558     227.2806     228.6257     225.9356     223.9558     413.0709     415.5848     410.5569     410.5569     172.8325      38.6586       0.0593       0.0593      -1.3063     146.7502       3.2554    2552.1355      29.6780      30.0532      30.2872      30.5208      34.8485      35.2837      33.6950      33.2744      33.0172      32.7645      28.6956      28.3417       0.0066       0.3129       0.3129       3.3637       0.2882    2584.0354      32.0515      35.7369     352.6250       0.1123    4465.1675    -999.2500    1248.0000       0.2948       0.2948
  416.0520       0.8240      96.0000      97.6315       0.0475       0.0475       5.5338     223.4752     227.7724     227.9398     227.6049     223.4752     409.7172     410.7523     408.6821     408.6821     224.7537      38.6654       0.0335       0.0335       9.5449     233.0141       3.3973    2594.7666      28.0462      28.9288      28.7211      29.5110      33.0626      34.0693      35.6554      34.5676      34.8176      33.8857      30.2457      29.3520       0.0066       0.2875       0.2875       3.4634       0.2867    2571.5984      33.6950      39.2597     349.5000       0.1112    4474.7700    -999.2500    1295.0000       0.2900       0.2900
  416.2044       0.8239      96.0000      97.6315       0.0393       0.0393      12.8459     220.1431     227.3313     227.5409     227.1218     220.1431     402.0597     395.7518     408.3677     408.3677     256.7171      38.6722       0.0462       0.0462      12.6695     292.6860       3.7661    2573.8416      28.0212      27.9497      28.7710      28.6412      32.9263      32.9798      35.6873      35.7786      34.7572      34.9147      30.3709      30.3216       0.0066       0.2643       0.2643       3.5973       0.2952    2585.1555      35.6554      38.3012     359.5625       0.1034    4542.5005    -999.2500    1286.0000       0.2810       0.2810
  416.3568       0.8238      96.0000      97.6315       0.0466       0.0466       8.6176     217.0352     221.8291     225.2355     218.4228     217.0352     397.7677     393.4224     402.1131     402.1131     235.2163      38.6791       0.0433       0.0433       8.9036     242.6402       3.6684    2578.6165      27.6509      27.2955      28.3752      27.8925      32.3683      32.0341      36.1652      36.6360      35.2421      35.8519      30.8944      31.2167       0.0065       0.2870       0.2870       3.5948       0.2945    2573.1506      35.6873      33.4943     347.8750       0.0959    4607.5464    -999.2500    1314.0000       0.2826       0.2826
  416.5092       0.8244      96.0000      97.5269       0.0455       0.0455       6.3075     212.1012     215.3994     216.4118     214.3870     212.1012     374.3488     370.9413     377.7562     377.7562     192.2594      38.6859       0.0497       0.0497       4.2243     169.4364       3.3849    2567.9585      25.6439      26.5406      26.1453      27.2161      29.9255      31.1610      38.9957      37.6781      38.2477      36.7429      33.4163      32.0914       0.0065       0.3102       0.3102       3.4289       0.2698    2574.9155      36.1652      32.3020     345.5625       0.0836    4714.7314    -999.2500    1268.0000       0.2775       0.2775
  416.6616       0.8251      96.0000      97.6315       0.0468       0.0468       4.6362     208.8331     211.5646     212.2409     210.8883     208.8331     365.6167     362.4677     368.7657     368.7657     164.0818      38.6928       0.0438       0.0438       4.3431     163.9798       3.2394    2577.6543      25.8961      25.7976      26.2999      26.3404      30.1259      30.2825      38.6158      38.7633      38.0230      37.9645      33.1940      33.0224       0.0065       0.2794       0.2794       3.3504       0.2639    2572.8013      38.9957      37.2125     361.2500       0.0751    4788.5117    -999.2500    1202.0000       0.2703       0.2703
  416.8140       0.8242      96.0000      97.6315       0.0457       0.0457       4.9428     205.8535     208.3575     209.6150     207.1001     205.8535     364.1771     361.5436     366.8106     366.8106     161.8621      38.6996       0.0466       0.0466       4.3899     158.7528       3.3966    2573.0457      26.9488      24.9411      27.2931      25.4335      31.1252      29.2006      37.1073      40.0944      36.6394      39.3182      32.1283      34.2458       0.0064       0.2425       0.2425       3.3167       0.2701    2574.5762      38.6158      42.2359     341.6875       0.0672    4857.8242    -999.2500    1196.0000       0.2524       0.2524
  416.9664       0.8234      96.0000      97.6315       0.0474       0.0474       4.4991     204.4437     198.7796     197.1082     200.4510     204.4437     361.8636     359.0620     364.6652     364.6652     159.9819      38.7064       0.0467       0.0467       6.0724     161.6102       3.2704    2572.9854      25.0857      24.0010      25.4735      24.4158      29.2733      28.1674      39.8634      41.6649      39.2565      40.9572      34.1608      35.5020       0.0064       0.2340       0.2340       3.3206       0.2708    2571.7502      37.1073      43.7652     348.6250       0.0633    4891.3213    -999.2500    1264.0000       0.2438       0.2438
  417.1188       0.8231      96.0000      97.7360       0.0496       0.0496       3.0038     203.4185     199.0289     196.9713     201.0867     203.4185     361.0414     360.0921     361.9907     361.9907     153.1594      38.7133       0.0495       0.0495       0.9637     157.9430       3.2696    2568.4031      22.8703      22.9737      23.0202      23.3823      26.9654      27.3279      43.7249      43.5280      43.4401      42.7673      37.0846      36.5927       0.0064       0.2340       0.2340       3.3085       0.2692    2568.1865      39.8634      45.0464     337.2500       0.0605    4915.9741    -999.2500    1336.0000       0.2363       0.2363
  417.2712       0.8227      96.0000      97.6315       0.0442       0.0442       8.5657     203.8670     202.9550     200.6354     205.2746     203.8670     362.0144     361.3340     362.6947     362.6947     153.1256      38.7201       0.0484       0.0484       6.0849     138.0828       3.3599    2570.1758      20.1648      22.3609      20.6341      22.8956      24.5454      26.8217      49.5914      44.7210      48.4634      43.6764      40.7409      37.2833       0.0063       0.2306       0.2306       3.3617       0.2691    2576.9966      43.7249      51.0542     343.1875       0.0617    4905.1582    -999.2500    1346.0000       0.2338       0.2338
  417.4236       0.8210      96.0000      97.6315       0.0485       0.0485       7.9614     206.8467     209.6854     208.2698     211.1010     206.8467     371.2552     371.4980     371.0125     371.0125     138.1453      38.7269       0.0362       0.0362      14.1231     161.3649       3.4472    2590.2134      18.0655      22.6124      18.4013      23.1891      22.6728      27.0290      55.3541      44.2235      54.3441      43.1237      44.1058      36.9973       0.0063       0.2157       0.2157       3.3746       0.2745    2569.9209      49.5914      57.4576     345.5625       0.0699    4834.4980    -999.2500    1266.0000       0.2355       0.2355
  417.5760       0.8192      96.0000      97.9452       0.0480       0.0480      10.8420     212.1012     216.2274     213.8665     218.5883     212.1012     379.9727     383.6756     376.2697     376.2697     142.1872      38.7338       0.0576       0.0576       7.2506     114.0857       3.3052    2554.8987      19.3769      24.2856      19.4596      24.7282      23.4389      28.9841      51.6078      41.1767      51.3884      40.4397      42.6641      34.5016       0.0063       0.2416       0.2416       3.4010       0.2671    2570.8120      55.3541      44.4847     340.9375       0.0836    4714.7314    -999.2500    1217.0000       0.2472       0.2472
  417.7284       0.8191      96.0000      97.6315       0.0597       0.0597       2.9061     217.7722     220.9812     217.8648     224.0976     217.7722     394.3900     397.0333     391.7468     391.7468     134.6041      38.7406       0.0533       0.0533       4.5612     149.5663       3.4382    2562.0725      26.4862      27.5866      26.7499      27.9827      30.2065      32.0291      37.7555      36.2495      37.3834      35.7363      33.1055      31.2216       0.0062       0.2726       0.2726       3.4818       0.2764    2551.5222      51.6078      32.2573     351.4375       0.0977    4591.9551    -999.2500    1261.0000       0.2642       0.2642
  417.8808       0.8190      96.0000      98.0498       0.0584       0.0584      -1.5567     221.1043     225.5138     224.0740     226.9535     221.1043     411.5436     414.6240     408.4633     408.4633     146.7194      38.7475       0.0683       0.0683      -4.8356     139.2673       3.7160    2537.3499      36.3314      30.4194      36.7795      30.7320      40.6849      34.8330      27.5244      32.8738      27.1890      32.5393      24.5791      28.7084       0.0062       0.2996       0.2996       3.5864       0.2928    2553.7148      37.7555      27.9564     341.6875       0.1057    4522.7534    -999.2500    1340.0000       0.2803       0.2803
  418.0332       0.8191      96.0000      97.9452       0.0528       0.0528      -1.5070     221.0081     225.3232     224.3548     226.2915     221.0081     412.7099     414.0048     411.4152     411.4152     139.4547      38.7543       0.0507       0.0507      -1.5992     151.0871       3.6243    2566.2957      40.7393      32.6731      41.1444      32.9698      44.8741      36.9398      24.5463      30.6062      24.3047      30.3308      22.2845      27.0711       0.0062       0.3043       0.3043       3.6433       0.2972    2562.9380      27.5244      28.6423     351.4375       0.1054    4524.7202    -999.2500    1397.0000       0.2876       0.2876
  418.1856       0.8192      96.0000      98.1543       0.0347       0.0347       4.4024     219.4382     222.9467     224.3539     221.5396     219.4382     410.2039     411.4142     408.9938     408.9938     132.0409      38.7611       0.0366       0.0366       3.6429     129.3104       3.5994    2589.6396      35.5845      33.1199      35.8741      33.4909      40.5484      37.2176      28.1021      30.1933      27.8752      29.8588      24.6619      26.8690       0.0061       0.2975       0.2975       3.5749       0.2979    2592.6948      24.5463      31.5418     342.0625       0.1017    4557.0918    -999.2500    1405.0000       0.2867       0.2867
  418.3380       0.8192      96.0000      97.7883       0.0246       0.0246       8.5784     217.5158     217.9069     219.7665     216.0473     217.5158     400.0593     404.9276     395.1911     395.1911     120.4296      38.7680       0.0163       0.0163       9.6722     117.0637       3.5022    2623.0466      30.1552      31.7407      30.4651      31.9984      35.1170      36.6513      33.1617      31.5053      32.8244      31.2516      28.4762      27.2842       0.0061       0.2631       0.2631       3.5401       0.2827    2609.3931      28.1021      34.3523     344.5000       0.0971    4597.3662    -999.2500    1292.0000       0.2765       0.2765
  418.4904       0.8191      96.0000      98.1543       0.0277       0.0277       5.2764     216.8750     216.3425     218.7176     213.9674     216.8750     401.8071     404.7745     398.8397     398.8397     117.6499      38.7748       0.0233       0.0233       6.2261     116.8747       3.5084    2611.5674      27.7179      30.7528      28.0374      31.1903      33.0527      35.9732      36.0778      32.5174      35.6667      32.0613      30.2548      27.7985       0.0061       0.2572       0.2572       3.5000       0.2901    2604.2188      33.1617      34.6380     362.7500       0.0955    4610.9497    -999.2500    1228.0000       0.2706       0.2706
  418.6428       0.8188      96.0000      97.9452       0.0335       0.0335       3.4202     217.4838     217.2256     219.7513     214.6999     217.4838     405.2888     405.2593     405.3181     405.3181     126.9308      38.7816       0.0410       0.0410       2.5535     119.8861       3.4810    2582.2856      28.3606      30.2110      28.6787      30.5218      33.9769      35.5512      35.2601      33.1006      34.8691      32.7634      29.4318      28.1284       0.0060       0.2739       0.2739       3.5671       0.2978    2594.7415      36.0778      33.7356     340.8750       0.0970    4598.0439    -999.2500    1218.0000       0.2697       0.2697
  418.7952       0.8186      96.0000      97.4746       0.0352       0.0352       4.1046     217.4838     218.6720     220.5585     216.7855     217.4838     405.9362     404.7042     407.1683     407.1683     132.6621      38.7885       0.0342       0.0342       4.0414     142.7721       3.7098    2593.5037      29.6425      29.7950      30.0570      30.1441      35.2610      35.4260      33.7354      33.5627      33.2702      33.1740      28.3600      28.2279       0.0060       0.2719       0.2719       3.5309       0.3004    2591.9524      35.2601      33.3428     351.4375       0.0970    4598.0439    -999.2500    1328.0000       0.2706       0.2706
  418.9476       0.8178      96.0000      98.0498       0.0322       0.0322       6.0655     218.2848     219.4716     220.4801     218.4631     218.2848     406.7784     405.1013     408.4556     408.4556     136.4365      38.7953       0.0310       0.0310       6.5893     132.2986       3.4276    2598.8008      30.1001      29.9335      30.3982      30.4042      35.5070      35.4209      33.2225      33.4073      32.8967      32.8902      28.1634      28.2319       0.0060       0.2677       0.2677       3.5734       0.3001    2596.8994      33.7354      34.9019     339.9375       0.0989    4581.1714    -999.2500    1390.0000       0.2717       0.2717
  419.1000       0.8169      96.0000      97.9452       0.0336       0.0336       4.7011     218.7654     220.4190     221.7469     219.0910     218.7654     408.5179     408.0128     409.0230     409.0230     131.6014      38.8022       0.0327       0.0327       6.2113     130.9560       3.5878    2595.9912      29.8339      29.7135      30.4684      30.3682      35.4165      35.4010      33.5189      33.6547      32.8209      32.9292      28.2354      28.2478       0.0059       0.2737       0.2737       3.4480       0.2997    2594.6096      33.2225      35.8274     348.3750       0.1001    4571.1074    -999.2500    1414.0000       0.2794       0.2794
  419.2524       0.8162      96.0000      98.1020       0.0404       0.0404       0.0578     220.1431     222.3490     224.4803     220.2177     220.1431     411.3766     411.3790     411.3744     411.3744     130.7832      38.8090       0.0387       0.0387       0.3541     130.0527       3.3478    2586.2229      30.3924      29.8044      31.0557      30.4278      35.9665      35.4047      32.9030      33.5521      32.2002      32.8647      27.8036      28.2448       0.0059       0.2739       0.2739       3.4532       0.2994    2583.2917      33.5189      34.1090     347.5625       0.1034    4542.5005    -999.2500    1337.0000       0.2847       0.2847
  419.4048       0.8155      96.0000      98.0498       0.0456       0.0456       1.7731     221.4567     224.7726     226.2742     223.2710     221.4567     414.1152     414.3192     413.9112     413.9112     134.0050      38.8158       0.0469       0.0469      -0.7019     131.7230       3.4388    2572.6521      31.5052      29.6698      32.1508      30.2950      36.9089      35.2491      31.7408      33.7043      31.1034      33.0087      27.0937      28.3695       0.0059       0.3047       0.3047       3.5067       0.2995    2574.6829      32.9030      31.9997     341.6875       0.1065    4515.5557    -999.2500    1260.0000       0.2935       0.2935
  419.5572       0.8168      96.0000      98.2589       0.0524       0.0524       4.1715     222.4819     224.5931     227.0425     222.1436     222.4819     416.1202     417.6616     414.5788     414.5788     133.8310      38.8227       0.0521       0.0521       5.3043     141.4635       3.7577    2564.0544      31.3827      28.9286      32.0047      29.5619      36.7817      34.3274      31.8647      34.5678      31.2454      33.8274      27.1874      29.1313       0.0058       0.3070       0.3070       3.6766       0.2978    2563.6116      31.7408      32.2719     351.4375       0.1089    4494.7466    -999.2500    1167.0000       0.2994       0.2994
  419.7096       0.8182      96.0000      98.2589       0.0519       0.0519      14.5557     223.2829     225.5551     227.2828     223.8274     223.2829     420.2738     425.3813     415.1663     415.1663     139.4977      38.8295       0.0558       0.0558      13.6402     130.0790       3.8574    2557.8865      28.9534      26.9623      29.5578      27.5984      34.5981      32.3757      34.5382      37.0888      33.8320      36.2340      28.9033      30.8873       0.0058       0.3236       0.3236       3.7423       0.2965    2564.4358      31.8647      35.3642     341.6875       0.1107    4478.6226    -999.2500    1204.0000       0.3117       0.3117
  419.8620       0.8188      96.0000      97.8406       0.0585       0.0585      13.4785     222.8024     227.2970     228.9244     225.6696     222.8024     421.2655     426.6768     415.8542     415.8542     146.2481      38.8363       0.0536       0.0536      16.5046     148.5438       3.6334    2561.5813      24.4850      24.4628      25.0388      24.9469      30.4109      29.9878      40.8414      40.8783      39.9380      40.0851      32.8829      33.3469       0.0058       0.3348       0.3348       3.6042       0.2987    2553.5005      34.5382      40.5063     346.9375       0.1096    4488.2832    -999.2500    1301.0000       0.3282       0.3282
  420.0144       0.8193      96.0000      97.9452       0.0662       0.0662       8.4215     222.7703     228.0520     229.7599     226.3441     222.7703     419.1183     424.1160     414.1206     414.1206     164.3792      38.8432       0.0685       0.0685       7.4596     160.2695       3.3655    2536.9419      19.9092      22.2288      20.5112      22.8466      25.8023      27.9494      50.2280      44.9867      48.7539      43.7702      38.7562      35.7789       0.0057       0.3352       0.3352       3.3814       0.2964    2540.7390      40.8414      50.4184     351.4375       0.1095    4488.9287    -999.2500    1378.0000       0.3307       0.3307
  420.1668       0.8181      96.0000      97.6315       0.0698       0.0698       5.2370     221.6169     227.7330     228.8272     226.6387     221.6169     411.9256     414.6706     409.1806     409.1806     187.4651      38.8500       0.0768       0.0768      -0.1596     184.2724       3.1584    2523.3225      17.2326      19.8885      17.7663      20.5480      23.1717      25.8162      58.0296      50.2804      56.2863      48.6665      43.1562      38.7354       0.0057       0.3182       0.3182       3.3405       0.2924    2534.8752      50.2280      60.9329     357.0000       0.1069    4512.2915    -999.2500    1304.0000       0.3229       0.3229
  420.3192       0.8169      96.0000      97.3177       0.0644       0.0644       7.7811     218.0285     222.9354     224.4955     221.3752     218.0285     404.9933     405.8339     404.1526     404.1526     227.9791      38.8568       0.0626       0.0626       8.5753     215.3037       3.5175    2546.7893      17.2466      18.4556      17.8933      19.0833      23.0144      24.4912      57.9824      54.1841      55.8870      52.4017      43.4511      40.8309       0.0057       0.3006       0.3006       3.3796       0.2948    2543.7771      58.0296      59.0672     350.5625       0.0983    4586.5566    -999.2500    1200.0000       0.3081       0.3081
  420.4716       0.8171      96.0000      97.4223       0.0574       0.0574       8.5170     214.4721     217.9049     218.3265     217.4833     214.4721     394.0962     393.2344     394.9579     394.9579     312.2002      38.8637       0.0541       0.0541      12.7174     279.6811       3.4892    2560.7195      17.9163      17.5977      18.5785      18.3984      23.9305      23.5218      55.8150      56.8256      53.8258      54.3526      41.7878      42.5138       0.0056       0.2926       0.2926       3.5302       0.2909    2555.2344      57.9824      53.3227     336.5000       0.0896    4662.6113    -999.2500    1205.0000       0.2940       0.2940
  420.6240       0.8173      96.0000      97.4223       0.0588       0.0588       2.5718     210.5633     214.7902     214.5797     215.0007     210.5633     382.6012     374.0538     391.1487     391.1487     351.2805      38.8705       0.0580       0.0580      -0.2309     437.0423       3.5935    2554.3357      18.0546      16.5948      19.0040      17.4558      24.2416      22.5768      55.3876      60.2600      52.6206      57.2877      41.2515      44.2932       0.0056       0.2819       0.2819       3.5121       0.2960    2553.0054      55.8150      50.0833     342.7500       0.0797    4749.1660    -999.2500    1317.0000       0.2928       0.2928
  420.7764       0.8178      96.0000      97.1608       0.0635       0.0635      -2.1132     206.3661     211.2704     210.8234     211.7173     206.3661     376.1686     371.2968     381.0403     381.0403     320.4077      38.8774       0.0656       0.0656      -5.7777     336.9076       3.4458    2541.7749      16.6372      15.6221      17.5875      16.3709      22.7652      21.6232      60.1062      64.0118      56.8585      61.0841      43.9268      46.2465       0.0056       0.2978       0.2978       3.4412       0.2925    2545.2664      55.3876      51.4649     341.6875       0.0686    4845.7568    -999.2500    1341.0000       0.2916       0.2916
  420.9288       0.8184      96.0000      97.5269       0.0640       0.0640       1.6424     204.0593     206.8491     210.3855     203.3128     204.0593     371.6133     366.3832     376.8435     376.8435     226.8237      38.8842       0.0672       0.0672       1.9747     189.7465       3.2807    2539.1489      14.3339      14.3784      15.2067      15.2621      20.5983      20.5157      69.7647      69.5489      65.7606      65.5216      48.5477      48.7431       0.0055       0.3131       0.3131       3.2735       0.2926    2544.3545      60.1062      65.3081     338.1875       0.0623    4900.5371    -999.2500    1385.0000       0.2945       0.2945
  421.0812       0.8176      96.0000      97.4223       0.0685       0.0685       3.1817     202.8738     203.6741     209.3914     197.9568     202.8738     368.8330     363.9157     373.7503     373.7503     167.4516      38.8910       0.0605       0.0605       7.4260     156.2237       3.0916    2550.1821      12.6759      13.2322      13.5248      14.0886      18.9779      19.4696      78.8896      75.5732      73.9384      70.9793      52.6928      51.3620       0.0055       0.2903       0.2903       3.1440       0.2911    2536.9041      69.7647      85.3453     351.4375       0.0590    4929.1724    -999.2500    1332.0000       0.2852       0.2852
  421.2336       0.8169      96.0000      97.6315       0.0712       0.0712       4.5703     201.6884     200.0286     201.8002     198.2570     201.6884     366.5929     362.6584     370.5273     370.5273     156.7342      38.8979       0.0766       0.0766       2.3905     155.3771       3.0491    2523.6707      11.4020      12.1164      12.2065      12.9834      17.7471      18.4288      87.7038      82.5325      81.9239      77.0216      56.3473      54.2630       0.0055       0.2673       0.2673       3.0921       0.2895    2532.4944      78.8896      94.2112     335.7500       0.0557    4958.1445    -999.2500    1265.0000       0.2745       0.2745
  421.3860       0.8147      96.0000      97.9452       0.0741       0.0741       3.2135     201.2718     199.8872     200.3305     199.4438     201.2718     365.2892     361.4200     369.1584     369.1584     159.2263      38.9047       0.0760       0.0760       3.2367     159.7523       3.1030    2524.6392      10.1893      11.2890      10.9229      12.1190      16.6969      17.6127      98.1419      88.5817      91.5504      82.5148      59.8913      56.7771       0.0055       0.2568       0.2568       3.1145       0.2885    2527.6812      87.7038      92.7723     344.4375       0.0545    4968.4048    -999.2500    1241.0000       0.2640       0.2640
  421.5384       0.8124      96.0000      97.6315       0.0681       0.0681       5.9577     201.7845     202.6520     200.0992     205.2049     201.7845     365.5805     361.2006     369.9604     369.9604     163.4662      38.9115       0.0674       0.0674       6.3450     163.5387       3.1614    2538.8240       9.6287      11.0561      10.2850      11.8128      15.9654      17.5853     103.8564      90.4480      97.2292      84.6538      62.6356      56.8658       0.0054       0.2628       0.2628       3.1051       0.2883    2537.6145      98.1419      95.5313     333.9375       0.0559    4955.7827    -999.2500    1226.0000       0.2585       0.2585
  421.6908       0.8113      96.0000      97.8406       0.0617       0.0617       5.4207     202.5534     204.1456     200.8277     207.4635     202.5534     367.1131     363.7145     370.5117     370.5117     167.8409      38.9184       0.0603       0.0603       8.3422     169.0923       3.0261    2550.4712      10.2019      11.7225      10.9165      12.5028      16.3802      18.1865      98.0208      85.3060      91.6042      79.9821      61.0495      54.9858       0.0054       0.2453       0.2453       3.1939       0.2869    2548.2283     103.8564      93.0016     343.1250       0.0581    4936.9692    -999.2500    1336.0000       0.2516       0.2516
  421.8432       0.8103      96.0000      97.8406       0.0522       0.0522       7.5647     203.6107     207.5129     205.3825     209.6433     203.6107     370.1383     367.6786     372.5981     372.5981     166.5300      38.9252       0.0542       0.0542       5.6842     170.7677       3.4009    2560.5581      12.0898      12.8413      12.9845      13.7773      18.3474      19.2441      82.7145      77.8736      77.0148      72.5833      54.5035      51.9639       0.0054       0.2443       0.2443       3.2977       0.2871    2563.8506      98.0208      76.0193     368.6250       0.0610    4911.3330    -999.2500    1361.0000       0.2510       0.2510
  421.9956       0.8089      96.0000      97.9452       0.0439       0.0439       6.1824     205.1806     209.9817     208.6349     211.3284     205.1806     373.1494     371.8662     374.4325     374.4325     165.0056      38.9321       0.0429       0.0429       7.3389     158.9265       3.4773    2579.2734      15.2189      13.9825      16.2984      14.9692      21.4851      20.3771      65.7076      71.5178      61.3556      66.8040      46.5439      49.0746       0.0053       0.2651       0.2651       3.4657       0.2854    2577.5242      82.7145      60.0308     341.6875       0.0653    4873.7539    -999.2500    1349.0000       0.2556       0.2556
  422.1480       0.8075      96.0000      97.8406       0.0359       0.0359       7.2248     204.4437     210.1729     209.8706     210.4753     204.4437     372.8298     371.6446     374.0150     374.0150     160.4571      38.9389       0.0327       0.0327       7.7689     161.8527       3.5227    2596.1252      17.8556      14.8844      19.0121      15.9282      24.3128      21.1153      56.0048      67.1846      52.5981      62.7816      41.1305      47.3589       0.0053       0.2687       0.2687       3.3830       0.2869    2590.8308      65.7076      50.8788     343.1250       0.0633    4891.3213    -999.2500    1348.0000       0.2590       0.2590
  422.3004       0.8061      96.0000      97.7883       0.0267       0.0267       2.1401     200.5670     199.0511     199.0661     199.0361     200.5670     364.9566     359.9729     369.9403     369.9403     159.5888      38.9457       0.0350       0.0350       0.8711     157.1222       3.1672    2592.2502      17.1439      14.8551      18.2081      15.8724      23.7765      21.1740      58.3299      67.3169      54.9205      63.0023      42.0583      47.2277       0.0053       0.2751       0.2751       3.3594       0.2918    2605.9038      56.0048      52.2586     333.9375       0.0525    4985.8657    -999.2500    1273.0000       0.2556       0.2556
  422.4528       0.8047      96.0000      98.1020       0.0139       0.0139       1.0018     196.6902     198.5300     198.2130     198.8470     196.6902     354.2279     349.1926     359.2631     359.2631     157.1222      38.9526       0.0101       0.0101       0.5759     157.1222       3.4113    2633.3716      13.8254      14.1878      14.6774      15.1063      20.3930      20.6755      72.3306      70.4830      68.1321      66.1977      49.0365      48.3665       0.0052       0.2518       0.2518       3.4271       0.2860    2627.0945      58.3299      72.7148     337.1875       0.0412    5084.1372    -999.2500    1242.0000       0.2449       0.2449
  422.6052       0.8041      96.0000      97.7883      -0.0006      -0.0006       3.4510     194.0950     197.2374     197.3807     197.0940     194.0950     348.8950     347.5850     350.2050     350.2050     157.1222      38.9594      -0.0019      -0.0019       1.5545     157.1222       3.7233    2653.1260      11.4654      13.4898      12.1131      14.3077      17.9905      20.0710      87.2187      74.1300      82.5553      69.8923      55.5850      49.8232       0.0052       0.2034       0.2034       3.4978       0.2783    2650.9985      72.3306      94.9968     344.0000       0.0334    5152.1157    -999.2500    1292.0000       0.2261       0.2261
  422.7576       0.8034      96.0000      97.8406      -0.0041      -0.0041       7.3247     192.5251     197.1617     197.2113     197.1122     192.5251     349.5972     348.8486     350.3457     350.3457     157.1222      38.9662      -0.0097      -0.0097      10.4875     157.1222       3.3676    2666.0386      11.9375      13.2205      12.6027      13.9482      18.4722      19.8229      83.7694      75.6402      79.3481      71.6938      54.1355      50.4468       0.0052       0.1892       0.1892       3.4680       0.2837    2656.7239      87.2187      73.1792     331.9375       0.0286    5194.1289    -999.2500    1339.0000       0.2156       0.2156
  422.9100       0.8030      96.0000      97.9452       0.0015       0.0015       7.1489     194.2872     197.4712     197.1655     197.7770     194.2872     352.8770     351.7891     353.9649     353.9649     157.1222      38.9731       0.0050       0.0050       5.3480     157.1222       3.3218    2641.7454      13.2196      13.5976      13.9643      14.3039      19.8064      20.1720      75.6450      73.5425      71.6114      69.9110      50.4886      49.5737       0.0051       0.2211       0.2211       3.3821       0.2844    2647.5015      83.7694      66.3585     342.0625       0.0340    5147.0181    -999.2500    1405.0000       0.2165       0.2165
  423.0624       0.8026      96.0000      97.9452       0.0090       0.0090       7.7446     196.5941     197.9142     197.6928     198.1357     196.5941     357.5933     357.6136     357.5731     357.5731     157.1222      38.9799       0.0088       0.0088       6.8557     157.1222       3.4516    2635.5432      13.9110      14.5957      14.6496      15.3457      20.4624      21.1868      71.8855      68.5132      68.2612      65.1648      48.8702      47.1992       0.0051       0.2325       0.2325       3.4005       0.2834    2635.0859      75.6450      72.4222     332.0000       0.0409    5086.6230    -999.2500    1416.0000       0.2236       0.2236
  423.2148       0.8015      96.0000      98.2589       0.0170       0.0170       6.8676     198.6446     196.6232     198.6371     194.6093     198.6446     361.9211     361.3024     362.5399     362.5399     157.1222      38.9868       0.0168       0.0168       8.1890     157.1222       3.4275    2622.2231      14.9818      16.0898      15.6747      16.8656      21.5030      22.6683      66.7478      62.1513      63.7970      59.2923      46.5051      44.1145       0.0051       0.2179       0.2179       3.4651       0.2855    2621.9526      71.8855      64.9622     340.8750       0.0469    5034.1162    -999.2500    1265.0000       0.2302       0.2302
  423.3672       0.8005      96.0000      98.1543       0.0271       0.0271       5.5732     203.7709     201.9231     199.3558     204.4903     203.7709     370.0219     368.5374     371.5065     371.5065     157.1222      38.9936       0.0243       0.0243       6.7750     157.1222       3.5066    2609.9214      17.3815      17.8034      18.0583      18.5570      23.7753      24.2884      57.5324      56.1692      55.3763      53.8881      42.0605      41.1719       0.0051       0.2326       0.2326       3.4595       0.2848    2605.2354      66.7478      57.4475     346.3125       0.0615    4907.4717    -999.2500    1285.0000       0.2331       0.2331
  423.5196       0.8002      96.0000      98.2589       0.0370       0.0370       1.8170     206.3020     209.6793     210.1721     209.1866     206.3020     377.7860     379.2055     376.3665     376.3665     157.1222      39.0004       0.0392       0.0392       2.2154     157.1222       3.4473    2585.3958      20.6935      19.4689      21.4009      20.1663      27.0929      25.8638      48.3243      51.3639      46.7270      49.5878      36.9101      38.6641       0.0050       0.2433       0.2433       3.5247       0.2852    2588.9465      57.5324      47.5670     361.2500       0.0684    4847.2622    -999.2500    1264.0000       0.2331       0.2331
  423.6720       0.7999      96.0000      98.1020       0.0418       0.0418       2.7654     208.7370     213.7769     213.9228     213.6310     208.7370     391.9341     393.4927     390.3756     390.3756     157.1222      39.0073       0.0424       0.0424       2.1321     157.1222       3.6147    2580.0212      23.2256      20.6997      23.9564      21.3565      29.4687      27.0602      43.0558      48.3098      41.7424      46.8241      33.9343      36.9546       0.0050       0.2348       0.2348       3.5200       0.2998    2581.0403      48.3243      40.2857     360.9375       0.0749    4790.7168    -999.2500    1306.0000       0.2266       0.2266
  423.8244       0.7998      96.0000      98.2589       0.0360       0.0360       6.2091     211.4604     215.1010     214.6077     215.5943     211.4604     389.5376     391.9662     387.1090     387.1090     157.1222      39.0141       0.0432       0.0432       3.3101     157.1222       3.4976    2578.6992      22.8951      21.2589      23.5902      21.9158      29.1137      27.4361      43.6774      47.0392      42.3905      45.6291      34.3481      36.4484       0.0050       0.2255       0.2255       3.4752       0.2873    2590.5652      43.0558      47.1816     346.6250       0.0820    4729.0181    -999.2500    1356.0000       0.2248       0.2248
  423.9768       0.7996      96.0000      98.2589       0.0381       0.0381       7.1191     212.6138     217.2053     216.6779     217.7326     212.6138     391.6902     392.0003     391.3801     391.3801     157.1222      39.0209       0.0238       0.0238       9.9177     157.1222       3.3193    2610.8005      21.4171      20.9673      22.0216      21.6288      27.6775      27.1517      46.6917      47.6934      45.4099      46.2346      36.1304      36.8301       0.0049       0.2232       0.2232       3.4112       0.2907    2587.1064      43.6774      52.6017     346.8750       0.0849    4703.3633    -999.2500    1406.0000       0.2235       0.2235
  424.1292       0.7986      96.0000      98.1543       0.0419       0.0419       7.5871     214.5041     218.6188     217.6737     219.5639     214.5041     393.8372     392.5074     395.1672     395.1672     157.1222      39.0278       0.0488       0.0488       5.1296     157.1222       3.4381    2569.5215      20.1375      20.2490      20.7624      20.8796      26.5028      26.5352      49.6586      49.3852      48.1641      47.8937      37.7318      37.6858       0.0049       0.2246       0.2246       3.3154       0.2911    2580.9102      46.6917      50.2022     353.8750       0.0897    4661.9150    -999.2500    1344.0000       0.2246       0.2246
  424.2816       0.7975      96.0000      98.2589       0.0551       0.0551       5.0875     216.3945     221.4369     222.8372     220.0367     216.3945     394.6526     392.9123     396.3931     396.3931     157.1222      39.0346       0.0537       0.0537       5.0100     157.1222       3.2192    2561.3416      19.1446      19.5113      19.7744      20.0369      25.5347      25.8186      52.2341      51.2523      50.5703      49.9080      39.1624      38.7318       0.0049       0.2202       0.2202       3.3347       0.2877    2559.1118      49.6586      53.9553     341.6875       0.0944    4621.1904    -999.2500    1272.0000       0.2227       0.2227
  424.4340       0.7968      96.0000      98.2589       0.0594       0.0594       5.5102     217.0352     219.6010     221.6424     217.5595     217.0352     397.8805     395.6078     400.1532     400.1532     157.1222      39.0415       0.0635       0.0635       3.2280     157.1222       3.3634    2545.1665      18.3739      18.7373      19.0015      19.3562      24.8590      25.1096      54.4252      53.3694      52.6275      51.6631      40.2269      39.8254       0.0048       0.2241       0.2241       3.3499       0.2916    2551.9277      52.2341      57.9211     351.4375       0.0959    4607.5464    -999.2500    1219.0000       0.2215       0.2215
  424.5864       0.7961      96.0000      98.2589       0.0596       0.0596       7.6778     214.1197     216.1705     219.4416     212.8993     214.1197     394.0003     391.5987     396.4020     396.4020     157.1222      39.0483       0.0613       0.0613       8.6372     157.1222       3.4691    2548.9250      18.1755      18.0141      18.8199      18.6079      24.7035      24.4631      55.0191      55.5122      53.1352      53.7406      40.4801      40.8779       0.0048       0.2221       0.2221       3.3694       0.2940    2551.6682      54.4252      52.7107     341.6250       0.0887    4670.2856    -999.2500    1268.0000       0.2207       0.2207
  424.7388       0.7955      96.0000      98.4157       0.0452       0.0452       9.8090     208.1283     208.3151     214.5762     202.0539     208.1283     375.6218     370.1564     381.0871     381.0871     157.1222      39.0551       0.0555       0.0555       9.1317     157.1222       3.2736    2558.4800      17.3352      17.5539      17.9588      18.1206      23.8390      23.9947      57.6862      56.9675      55.6830      55.1858      41.9480      41.6759       0.0048       0.2198       0.2198       3.3823       0.2875    2575.3599      55.0191      53.1089     342.3125       0.0733    4804.7290    -999.2500    1334.0000       0.2198       0.2198
  424.8912       0.7949      96.0000      98.4680       0.0293       0.0293       6.9203     203.7068     202.1980     207.5601     196.8360     203.7068     365.3600     359.7132     371.0067     371.0067     157.1222      39.0620       0.0210       0.0210       7.5880     157.1222       3.4052    2615.3086      15.9464      17.4346      16.4837      17.9845      22.3940      23.8978      62.7100      57.3571      60.6660      55.6035      44.6547      41.8448       0.0047       0.2198       0.2198       3.3922       0.2842    2601.6204      57.6862      72.4037     351.4375       0.0613    4909.0151    -999.2500    1370.0000       0.2198       0.2198
  425.0436       0.7937      96.0000      98.2589       0.0219       0.0219       2.0033     201.2718     197.3883     198.9587     195.8179     201.2718     362.8756     358.7756     366.9756     366.9756     157.1222      39.0688       0.0110       0.0110       2.3970     157.1222       3.5036    2631.8052      16.1835      17.8444      16.7086      18.3954      22.4779      24.3027      61.7913      56.0399      59.8496      54.3614      44.4881      41.1477       0.0047       0.2199       0.2199       3.4111       0.2849    2613.8154      62.7100      74.1372     341.6875       0.0545    4968.4048    -999.2500    1379.0000       0.2199       0.2199
  425.1960       0.7925      96.0000      98.5726       0.0319       0.0319       1.3928     201.3359     197.9207     199.3527     196.4887     201.3359     363.2993     361.3017     365.2969     365.2969     157.1222      39.0756       0.0327       0.0327      -1.6693     157.1222       3.3315    2596.0601      18.4442      18.7881      19.0259      19.3460      24.3487      25.1096      54.2174      53.2252      52.5600      51.6903      41.0699      39.8254       0.0047       0.2197       0.2197       3.3416       0.2818    2597.4084      61.7913      47.9266     351.4375       0.0547    4966.8237    -999.2500    1323.0000       0.2197       0.2197
  425.3484       0.7914      96.0000      98.4941       0.0472       0.0472       2.8996     205.6933     208.9602     210.0391     207.8813     205.6933     368.6880     366.3178     371.0582     371.0582     157.1222      39.0825       0.0486       0.0486       5.7140     157.1222       3.2103    2569.8806      20.4998      20.0907      21.1627      20.6492      26.1925      25.9258      48.7809      49.7742      47.2530      48.4280      38.1789      38.5717       0.0046       0.2198       0.2198       3.2697       0.2782    2572.1335      54.2174      44.4531     361.2500       0.0667    4861.6074    -999.2500    1285.0000       0.2198       0.2198
  425.5008       0.7904      96.0000      98.5098       0.0534       0.0534       3.6398     207.7758     211.8770     211.8530     211.9009     207.7758     371.8918     371.2559     372.5277     372.5277     157.1222      39.0893       0.0598       0.0598       3.1922     157.1222       3.2821    2551.3447      22.0314      21.2610      22.8476      21.8799      27.4340      26.8410      45.3897      47.0345      43.7683      45.7041      36.4511      37.2565       0.0046       0.2197       0.2197       3.3106       0.2742    2561.8306      48.7809      45.9146     361.0625       0.0723    4812.8789    -999.2500    1242.0000       0.2197       0.2197
  425.6532       0.7893      96.0000      98.3844       0.0558       0.0558       2.3156     208.3846     212.3614     211.9304     212.7923     208.3846     372.8138     372.8575     372.7701     372.7701     157.1222      39.0961       0.0514       0.0514       3.1318     157.1222       3.4546    2565.1233      22.2624      22.4053      23.4854      23.0234      27.8196      27.6371      44.9189      44.6324      42.5797      43.4340      35.9459      36.1833       0.0046       0.2198       0.2198       3.4601       0.2727    2557.9968      45.3897      46.8200     361.2500       0.0740    4798.8193    -999.2500    1273.0000       0.2198       0.2198
  425.8056       0.7882      96.0000      57.1500       0.0604       0.0604     -17.2644     210.7235     213.9881     213.5538     214.4224     210.7235     374.1388     374.8601     373.4174     373.4174     157.1222      39.1030       0.0627       0.0627     -18.2879     157.1222       3.4421    2546.5876      21.2285      23.2768      22.3842      24.2558      26.3861      28.5492      47.1065      42.9612      44.6744      41.2273      37.8987      35.0273       0.0045       0.2517       0.2517       3.2253       0.2664    2550.2834      44.9189      43.7168     346.5000       0.0801    4745.5557    -999.2500    1410.0000       0.2517       0.2517
  425.9580       0.7872      96.0000      57.1500       0.0632       0.0632     -15.8644     212.1653     215.7243     215.1025     216.3462     212.1653     382.8396     390.5515     375.1276     375.1276     157.1222      39.1098       0.0572       0.0572     -13.2651     157.1222       3.0281    2555.6787      22.2276      24.4553      23.4384      25.6558      27.0252      29.6617      44.9892      40.8909      42.6651      38.9775      37.0025      33.7135       0.0045       0.2517       0.2517       3.1552       0.2648    2545.7837      47.1065      36.9159     351.6875       0.0838    4713.3071    -999.2500    1419.0000       0.2517       0.2517
  426.1104       0.7862      96.0000      57.1500       0.0630       0.0630     -13.6006     213.5430     217.1118     216.3021     217.9215     213.5430     383.9630     391.1723     376.7538     376.7538     157.1222      39.1167       0.0686       0.0686     -15.6663     157.1222       3.0385    2536.8259      25.0025      26.5878      26.5075      27.8540      29.7523      31.4485      39.9960      37.6113      37.7251      35.9014      33.6109      31.7980       0.0045       0.2517       0.2517       3.0477       0.2633    2546.0637      44.9892      33.8906     352.1250       0.0873    4682.8989    -999.2500    1328.0000       0.2517       0.2517
  426.2628       0.7856      96.0000      57.1500       0.0659       0.0659     -12.8049     214.9206     217.8979     216.4926     219.3031     214.9206     386.4749     391.6938     381.2562     381.2562     157.1222      39.1235       0.0630       0.0630     -11.5867     157.1222       3.0898    2546.0491      27.1572      30.2312      28.0871      31.5405      31.1521      34.7827      36.8227      33.0784      35.6036      31.7052      32.1006      28.7499       0.0045       0.2517       0.2517       3.1128       0.2671    2541.1902      39.9960      33.2547     346.5625       0.0907    4652.8799    -999.2500    1262.0000       0.2517       0.2517
  426.4152       0.7850      96.0000      57.1500       0.0639       0.0639     -12.3228     216.5226     217.7530     217.4602     218.0459     216.5226     392.1571     393.5272     390.7871     390.7871     157.1222      39.1303       0.0671       0.0671     -12.4263     157.1222       3.2099    2539.3494      33.4650      33.4793      33.9195      35.1544      37.7574      38.7287      29.8820      29.8692      29.4816      28.4459      26.4849      25.8206       0.0044       0.2517       0.2517       3.2110       0.2785    2544.6470      36.8227      32.5029     357.0000       0.0947    4618.4551    -999.2500    1185.0000       0.2517       0.2517
  426.5676       0.7845      96.0000      57.1500       0.0584       0.0584     -11.5212     218.4450     221.0508     219.8449     222.2566     218.4450     399.3115     405.1924     393.4306     393.4306     157.1222      39.1372       0.0612       0.0612     -12.3801     157.1222       3.3387    2549.0552      43.9603      37.5462      44.9040      38.6139      48.9790      42.5243      22.7478      26.6339      22.2697      25.8974      20.4169      23.5160       0.0044       0.2517       0.2517       3.3126       0.2772    2553.5676      29.8820      28.8346     351.4375       0.0993    4577.8115    -999.2500    1306.0000       0.2517       0.2517
  426.7200       0.7840      96.0000      57.1500       0.0499       0.0499      -9.8251     220.7839     223.6377     224.2253     223.0502     220.7839     404.6034     410.6797     398.5272     398.5272     157.1222      39.1440       0.0461       0.0461      -8.9990     157.1222       3.3920    2573.9861      47.8763      41.2310      48.4855      42.0043      52.9601      46.1247      20.8872      24.2536      20.6247      23.8071      18.8821      21.6803       0.0044       0.2517       0.2517       3.3764       0.2786    2567.6377      22.7478      24.2273     351.4375       0.1049    4529.3164    -999.2500    1435.0000       0.2517       0.2517
  426.8724       0.7826      96.0000      57.1500       0.0408       0.0408      -7.4363     222.7062     223.5890     226.8337     220.3442     222.7062     416.9040     422.6660     411.1420     411.1420     157.1222      39.1508       0.0374       0.0374      -7.1987     157.1222       3.3894    2588.2937      44.4921      42.8308      44.2259      43.4647      49.6543      47.9363      22.4759      23.3477      22.6112      23.0072      20.1393      20.8610       0.0043       0.2517       0.2517       3.4143       0.2924    2582.6790      20.8872      24.8585     357.0000       0.1094    4490.2202    -999.2500    1452.0000       0.2517       0.2517
  427.0248       0.7812      96.0000      57.1500       0.0374       0.0374      -9.1927     223.7635     224.8716     227.3194     222.4237     223.7635     417.5023     423.8149     411.1896     411.1896     157.1222      39.1577       0.0382       0.0382      -8.7512     157.1222       3.4275    2586.9531      41.6475      43.2167      42.3621      43.4297      47.1369      48.8507      24.0110      23.1392      23.6060      23.0257      21.2148      20.4705       0.0043       0.2517       0.2517       3.3777       0.2896    2588.2915      22.4759      25.7202     347.2500       0.1118    4469.0034    -999.2500    1414.0000       0.2517       0.2517
  427.1772       0.7805      96.0000      57.1500       0.0359       0.0359      -9.4284     224.8529     227.1405     229.4141     224.8669     224.8529     418.2521     424.7017     411.8025     411.8025     157.1222      39.1645       0.0325       0.0325      -8.4816     157.1222       3.2930    2596.3965      42.3751      43.3431      42.4818      43.2915      47.6088      49.2102      23.5988      23.0717      23.5395      23.0992      21.0045      20.3210       0.0043       0.2517       0.2517       3.3459       0.2876    2590.7783      24.0110      24.9219     354.0625       0.1143    4447.3525    -999.2500    1260.0000       0.2517       0.2517
  427.3296       0.7798      96.0000      57.1500       0.0339       0.0339      -9.7625     224.7568     227.9651     229.4177     226.5125     224.7568     415.0534     417.7640     412.3428     412.3428     157.1222      39.1714       0.0385       0.0385     -10.4739     157.1222       3.3082    2586.4822      44.2889      43.2207      44.1626      43.1568      49.4067      48.7762      22.5790      23.1371      22.6436      23.1713      20.2402      20.5018       0.0042       0.2517       0.2517       3.3386       0.2887    2594.1069      23.5988      23.8205     351.4375       0.1141    4449.2544    -999.2500    1278.0000       0.2517       0.2517
  427.4820       0.7808      96.0000      57.1500       0.0356       0.0356      -9.6846     224.2121     228.7043     230.2529     227.1557     224.2121     412.6551     412.9711     412.3391     412.3391     157.1222      39.1782       0.0286       0.0286      -7.7454     157.1222       3.4290    2602.8655      44.9227      42.4092      44.9242      42.2298      50.3087      47.4969      22.2604      23.5798      22.2597      23.6799      19.8773      21.0540       0.0042       0.2517       0.2517       3.3257       0.2901    2591.2151      22.5790      23.5035     349.6250       0.1129    4460.0630    -999.2500    1305.0000       0.2517       0.2517
  427.6344       0.7818      96.0000      57.1500       0.0497       0.0497     -14.0523     219.9508     225.5564     224.6808     226.4320     219.9508     402.4466     396.8929     408.0003     408.0003     157.1222      39.1850       0.0532       0.0532     -15.3183     157.1222       3.2460    2562.2661      43.1760      39.8839      43.3796      39.7920      48.6668      45.2159      23.1610      25.0728      23.0523      25.1307      20.5479      22.1161       0.0041       0.2517       0.2517       3.3795       0.2952    2567.9358      22.2604      25.7025     355.8125       0.1029    4546.4707    -999.2500    1341.0000       0.2517       0.2517
  427.7868       0.7831      96.0000      57.1500       0.0652       0.0652     -17.3868     216.7789     221.7528     223.7471     219.7585     216.7789     393.8540     393.0652     394.6428     394.6428     157.1222      39.1919       0.0780       0.0780     -21.5082     157.1222       3.6533    2521.2310      38.9574      36.2620      39.3445      36.3653      44.5751      41.6880      25.6691      27.5771      25.4165      27.4987      22.4340      23.9877       0.0041       0.2517       0.2517       3.4823       0.2839    2542.4346      23.1610      27.5279     342.3750       0.0953    4612.9946    -999.2500    1306.0000       0.2517       0.2517
  427.9392       0.7844      96.0000      57.1500       0.0761       0.0761     -18.3265     209.6341     215.8261     217.2734     214.3788     209.6341     375.4192     370.7304     380.1079     380.1079     157.1222      39.1987       0.0753       0.0753     -16.9659     157.1222       3.7506    2525.7732      32.4064      31.9964      32.8998      32.2472      38.5122      37.5528      30.8581      31.2535      30.3954      31.0104      25.9658      26.6292       0.0041       0.2517       0.2517       3.6533       0.2814    2524.4128      25.6691      34.3051     351.4375       0.0772    4770.2153    -999.2500    1386.0000       0.2517       0.2517
  428.0916       0.7848      96.0000      57.1500       0.0752       0.0752     -16.8371     201.9447     208.9203     209.3114     208.5293     201.9447     364.1445     359.7067     368.5823     368.5823     157.1222      39.2055       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      25.4920      27.3999      26.0084      27.8874      31.9044      33.5485      39.2280      36.4965      38.4491      35.8584      31.3437      29.8076       0.0040       0.2517       0.2517       3.7506       0.2855    2525.9021      30.8581      42.6418     351.4375       0.0564    4951.8516    -999.2500    1360.0000       0.2517       0.2517
  428.2440       0.7851      96.0000      57.1500       0.0752       0.0752     -16.8371     196.8504     197.5677     198.6058     196.5295     196.8504     350.2921     350.0290     350.5551     350.5551     157.1222      39.2124       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      19.9259      23.5488      20.3205      24.0862      26.7948      29.9197      50.1859      42.4649      49.2115      41.5175      37.3206      33.4228       0.0040       0.2517       0.2517       3.7506       0.2697    2525.9021      39.2280      52.0569     341.0000       0.0417    5080.0000    -999.2500    1357.0000       0.2517       0.2517
  428.3964       0.7846      96.0000      57.1500       0.0752       0.0752     -16.8371     191.1474     195.0957     195.8312     194.3602     191.1474     350.5521     348.4185     352.6857     352.6857     157.1222      39.2192       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      17.6659      21.0455      17.8983      21.4642      24.5195      27.9187      56.6063      47.5161      55.8712      46.5893      40.7839      35.8183       0.0040       0.2517       0.2517       3.7506       0.2920    2525.9021      50.1859      58.1019     356.1875       0.0243    5231.5659    -999.2500    1388.0000       0.2517       0.2517
  428.5488       0.7840      96.0000      57.1500       0.0752       0.0752     -16.8371     195.2164     195.1929     196.2657     194.1201     195.2164     355.8574     358.4219     353.2928     353.2928     157.1222      39.2261       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      17.9525      20.5891      18.1616      20.8369      24.6246      27.4514      55.7025      48.5694      55.0612      47.9917      40.6099      36.4280       0.0040       0.2517       0.2517       3.7506       0.2802    2525.9021      56.6063      63.2841     346.9375       0.0368    5122.5210    -999.2500    1352.0000       0.2517       0.2517
  428.7012       0.7831      96.0000      57.1500       0.0752       0.0752     -16.8371     201.2718     200.8111     195.9661     205.6561     201.2718     359.7418     363.3380     356.1456     356.1456     157.1222      39.2329       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      19.8442      21.6888      20.1386      21.8856      26.2941      28.3416      50.3926      46.1067      49.6559      45.6921      38.0314      35.2838       0.0039       0.2517       0.2517       3.7506       0.2654    2525.9021      55.7025      51.5415     368.1875       0.0545    4968.4048    -999.2500    1371.0000       0.2517       0.2517
  428.8536       0.7822      96.0000      57.1500       0.0752       0.0752     -16.8371     204.2836     205.3842     199.1044     211.6641     204.2836     377.9982     379.6959     376.3005     376.3005     157.1222      39.2397       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      23.0334      23.9214      23.4427      24.1860      29.1144      30.3349      43.4152      41.8036      42.6572      41.3462      34.3473      32.9654       0.0039       0.2517       0.2517       3.7506       0.2911    2525.9021      50.3926      41.4255     371.0000       0.0629    4895.1567    -999.2500    1358.0000       0.2517       0.2517
  429.0060       0.7800      96.0000      57.1500       0.0752       0.0752     -16.8371     210.2108     212.4616     211.3857     213.5375     210.2108     387.4077     391.6934     383.1221     383.1221     157.1222      39.2466       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      26.4952      27.2818      26.8443      27.7113      32.0500      33.3483      37.7427      36.6545      37.2518      36.0863      31.2013      29.9866       0.0039       0.2517       0.2517       3.7506       0.2846    2525.9021      43.4152      45.2727     362.8750       0.0787    4757.1284    -999.2500    1319.0000       0.2517       0.2517
  429.1584       0.7778      96.0000      57.1500       0.0752       0.0752     -16.8371     213.0303     213.4616     213.3417     213.5815     213.0303     386.5542     392.6552     380.4533     380.4533     157.1222      39.2534       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      29.5428      31.7438      30.0960      32.2639      34.8024      37.4251      33.8492      31.5022      33.2270      30.9944      28.7336      26.7200       0.0038       0.2517       0.2517       3.7506       0.2716    2525.9021      37.7427      43.6540     366.5000       0.0860    4694.1675    -999.2500    1302.0000       0.2517       0.2517
  429.3108       0.7776      96.0000      57.1500       0.0752       0.0752     -16.8371     214.8245     217.5106     217.6238     217.3973     214.8245     396.2193     403.0240     389.4146     389.4146     157.1222      39.2602       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      34.2426      36.5818      34.7713      37.1013      39.0754      41.8152      29.2034      27.3360      28.7593      26.9533      25.5916      23.9148       0.0038       0.2517       0.2517       3.7506       0.2813    2525.9021      33.8492      27.9264     359.8750       0.0905    4654.9619    -999.2500    1333.0000       0.2517       0.2517
  429.4632       0.7773      96.0000      57.1500       0.0752       0.0752     -16.8371     219.6945     224.0797     224.7282     223.4312     219.6945     401.6522     409.4348     393.8696     393.8696     157.1222      39.2671       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      41.8389      41.6104      42.4277      42.1759      46.2575      46.4864      23.9012      24.0324      23.5695      23.7102      21.6181      21.5117       0.0038       0.2517       0.2517       3.7506       0.2742    2525.9021      29.2034      21.7803     361.2500       0.1023    4551.7749    -999.2500    1293.0000       0.2517       0.2517
  429.6156       0.7776      96.0000      57.1500       0.0752       0.0752     -16.8371     221.8732     225.9817     225.1889     226.7745     221.8732     402.6104     410.3558     394.8649     394.8649     157.1222      39.2739       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      49.4496      46.1121      49.9839      46.5717      53.5898      50.5403      20.2226      21.6863      20.0064      21.4723      18.6603      19.7862       0.0037       0.2517       0.2517       3.7506       0.2693    2525.9021      23.9012      21.2566     358.9375       0.1075    4507.0786    -999.2500    1337.0000       0.2517       0.2517
  429.7680       0.7778      96.0000      57.1500       0.0752       0.0752     -16.8371     222.0014     224.5937     226.2569     222.9305     222.0014     403.5924     410.9767     396.2082     396.2082     157.1222      39.2808       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      53.7654      49.3003      54.2855      49.7064      57.6138      53.3776      18.5993      20.2838      18.4211      20.1181      17.3569      18.7344       0.0037       0.2517       0.2517       3.7506       0.2712    2525.9021      20.2226      20.7054     352.8750       0.1078    4504.4771    -999.2500    1333.0000       0.2517       0.2517
  429.9204       0.7781      96.0000      57.1500       0.0752       0.0752     -16.8371     221.8732     222.6931     225.8880     219.4981     221.8732     403.8732     411.3046     396.4417     396.4417     157.1222      39.2876       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      54.5495      51.1239      55.0130      51.5179      58.3277      54.8971      18.3320      19.5603      18.1775      19.4107      17.1445      18.2159       0.0037       0.2517       0.2517       3.7506       0.2720    2525.9021      18.5993      20.7893     361.0000       0.1075    4507.0786    -999.2500    1379.0000       0.2517       0.2517
  430.0728       0.7784      96.0000      57.1500       0.0752       0.0752     -16.8371     222.0654     222.9290     225.8556     220.0024     222.0654     404.4263     412.2414     396.6112     396.6112     157.1222      39.2944       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      52.9324      51.7653      53.2899      52.1762      57.2907      55.4981      18.8920      19.3180      18.7653      19.1658      17.4548      18.0186       0.0036       0.2517       0.2517       3.7506       0.2717    2525.9021      18.3320      21.8377     354.1250       0.1079    4503.1772    -999.2500    1393.0000       0.2517       0.2517
  430.2252       0.7784      96.0000      57.1500       0.0752       0.0752     -16.8371     222.2897     222.9101     225.8014     220.0187     222.2897     404.6630     413.0385     396.2875     396.2875     157.1222      39.3013       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      51.0756      51.3611      51.3784      51.6943      55.6715      55.6887      19.5788      19.4700      19.4634      19.3445      17.9625      17.9570       0.0036       0.2517       0.2517       3.7506       0.2705    2525.9021      18.8920      21.3780     361.2500       0.1084    4498.6338    -999.2500    1365.0000       0.2517       0.2517
  430.3776       0.7784      96.0000      57.1500       0.0752       0.0752     -16.8371     223.2509     225.6920     227.4316     223.9525     223.2509     406.3188     414.5076     398.1300     398.1300     157.1222      39.3081       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      49.2943      51.0821      49.4294      51.1302      54.0920      55.7300      20.2863      19.5763      20.2309      19.5579      18.4870      17.9436       0.0036       0.2517       0.2517       3.7506       0.2707    2525.9021      19.5788      20.6355     361.2500       0.1106    4479.2651    -999.2500    1343.0000       0.2517       0.2517
  430.5300       0.7789      96.0000      57.1500       0.0752       0.0752     -16.8371     223.8917     227.2859     227.8444     226.7274     223.8917     409.7758     415.0667     404.4850     404.4850     157.1222      39.3149       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      49.7207      50.6977      49.7710      50.8110      54.7853      55.6465      20.1124      19.7247      20.0920      19.6808      18.2531      17.9706       0.0035       0.2517       0.2517       3.7506       0.2791    2525.9021      20.2863      19.7557     361.8125       0.1121    4466.4453    -999.2500    1339.0000       0.2517       0.2517
  430.6824       0.7794      96.0000      57.1500       0.0752       0.0752     -16.8371     224.4043     227.7815     228.3937     227.1694     224.4043     409.8859     414.2018     405.5699     405.5699     157.1222      39.3218       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      53.0576      50.3266      53.1350      50.3697      58.2560      55.3628      18.8474      19.8702      18.8200      19.8532      17.1656      18.0627       0.0035       0.2517       0.2517       3.7506       0.2794    2525.9021      20.1124      19.6040     373.6875       0.1133    4456.2422    -999.2500    1352.0000       0.2517       0.2517
  430.8348       0.7799      96.0000      57.1500       0.0752       0.0752     -16.8371     222.8985     226.7996     226.9060     226.6932     222.8985     405.9322     409.8601     402.0042     402.0042     157.1222      39.3286       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      52.5832      49.1996      52.8043      49.2675      58.2203      54.4232      19.0175      20.3253      18.9379      20.2973      17.1761      18.3745       0.0035       0.2517       0.2517       3.7506       0.2780    2525.9021      18.8474      21.2473     356.7500       0.1098    4486.3477    -999.2500    1402.0000       0.2517       0.2517
  430.9872       0.7804      96.0000      57.1500       0.0752       0.0752     -16.8371     219.6945     223.3000     222.1754     224.4246     219.6945     396.4562     396.8193     396.0931     396.0931     157.1222      39.3355       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      46.7789      47.6730      47.1794      47.8787      52.9074      53.4296      21.3772      20.9762      21.1957      20.8861      18.9009      18.7162       0.0034       0.2517       0.2517       3.7506       0.2778    2525.9021      19.0175      23.3932     363.2500       0.1023    4551.7749    -999.2500    1413.0000       0.2517       0.2517
  431.1396       0.7804      96.0000      57.1500       0.0752       0.0752     -16.8371     218.4770     218.8155     220.4086     217.2225     218.4770     394.0675     393.5869     394.5481     394.5481     157.1222      39.3423       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      42.3752      46.2968      42.9192      46.7124      49.0583      52.4035      23.5987      21.5998      23.2996      21.4076      20.3839      19.0827       0.0034       0.2517       0.2517       3.7506       0.2789    2525.9021      21.3772      24.4926     367.5625       0.0994    4577.1401    -999.2500    1404.0000       0.2517       0.2517
  431.2920       0.7803      96.0000      57.1500       0.0752       0.0752     -16.8371     216.9071     219.5751     218.7025     220.4478     216.9071     392.9458     393.3452     392.5464     392.5464     157.1222      39.3491       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      42.5759      45.7671      43.2046      46.3512      49.5363      52.4569      23.4875      21.8497      23.1457      21.5744      20.1872      19.0633       0.0034       0.2517       0.2517       3.7506       0.2802    2525.9021      23.5987      21.9734     361.2500       0.0956    4610.2686    -999.2500    1396.0000       0.2517       0.2517
  431.4444       0.7808      96.0000      57.1500       0.0752       0.0752     -16.8371     216.9071     218.8003     218.7679     218.8327     216.9071     392.7791     393.7656     391.7925     391.7925     157.1222      39.3560       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      45.1809      46.2873      45.9117      46.9507      51.8860      53.2731      22.1332      21.6042      21.7810      21.2989      19.2730      18.7712       0.0033       0.2517       0.2517       3.7506       0.2790    2525.9021      23.4875      21.5786     364.5625       0.0956    4610.2686    -999.2500    1380.0000       0.2517       0.2517
  431.5968       0.7813      96.0000      57.1500       0.0752       0.0752     -16.8371     218.5091     219.3468     219.6294     219.0643     218.5091     393.0871     393.9642     392.2101     392.2101     157.1222      39.3628       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      47.6697      47.7564      48.5596      48.5019      54.0584      54.4705      20.9777      20.9396      20.5933      20.6178      18.4985      18.3586       0.0033       0.2517       0.2517       3.7506       0.2750    2525.9021      22.1332      21.9621     361.2500       0.0995    4576.4692    -999.2500    1381.0000       0.2517       0.2517
  431.7492       0.7817      96.0000      57.1500       0.0752       0.0752     -16.8371     218.3489     219.1055     219.5421     218.6689     218.3489     393.4215     394.1943     392.6486     392.6486     157.1222      39.3696       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      49.9883      49.0502      50.7612      49.7455      56.4459      55.4761      20.0047      20.3873      19.7001      20.1023      17.7161      18.0258       0.0033       0.2517       0.2517       3.7506       0.2762    2525.9021      20.9777      19.9954     361.2500       0.0991    4579.8267    -999.2500    1361.0000       0.2517       0.2517
  431.9016       0.7820      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0717     219.5428     218.6007     218.6372     393.4726     394.2239     392.7212     392.7212     157.1222      39.3765       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      52.2044      50.1625      52.8751      50.6985      58.4297      56.4671      19.1555      19.9352      18.9125      19.7245      17.1146      17.7094       0.0032       0.2517       0.2517       3.7506       0.2754    2525.9021      20.0047      19.3237     363.7500       0.0998    4573.7866    -999.2500    1323.0000       0.2517       0.2517
  432.0540       0.7825      96.0000      57.1500       0.0752       0.0752     -16.8371     218.8935     219.1895     219.5500     218.8289     218.8935     393.6425     394.2053     393.0797     393.0797     157.1222      39.3833       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      52.5644      50.9558      53.1010      51.6450      58.5372      57.0272      19.0243      19.6249      18.8320      19.3630      17.0832      17.5355       0.0032       0.2517       0.2517       3.7506       0.2753    2525.9021      19.1555      18.9844     357.1250       0.1004    4568.4307    -999.2500    1348.0000       0.2517       0.2517
  432.2064       0.7829      96.0000      57.1500       0.0752       0.0752     -16.8371     218.8295     219.0810     219.5345     218.6275     218.8295     393.9340     394.2101     393.6579     393.6579     157.1222      39.3901       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      51.3500      51.5437      51.7407      52.0551      57.2683      57.6490      19.4742      19.4010      19.3272      19.2104      17.4617      17.3464       0.0032       0.2517       0.2517       3.7506       0.2764    2525.9021      19.0243      20.2297     363.5625       0.1003    4569.7686    -999.2500    1389.0000       0.2517       0.2517
  432.3588       0.7833      96.0000      57.1500       0.0752       0.0752     -16.8371     218.7333     219.0931     219.5077     218.6786     218.7333     393.9449     394.2225     393.6673     393.6673     157.1222      39.3970       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      50.2193      52.6897      50.5867      53.1547      55.9784      58.6216      19.9126      18.9790      19.7680      18.8130      17.8640      17.0585       0.0031       0.2517       0.2517       3.7506       0.2767    2525.9021      19.4742      23.1814     372.1875       0.1000    4571.7769    -999.2500    1381.0000       0.2517       0.2517
  432.5112       0.7837      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6693     219.0931     219.5077     218.6786     218.6693     393.9449     394.2225     393.6673     393.6673     157.1222      39.4038       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      51.3644      54.6013      51.6646      54.9692      57.0209      60.3623      19.4687      18.3146      19.3556      18.1920      17.5374      16.5666       0.0031       0.2517       0.2517       3.7506       0.2769    2525.9021      19.9126      20.5971     364.1875       0.0999    4573.1167    -999.2500    1401.0000       0.2517       0.2517
  432.6636       0.7842      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.4107       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      55.5810      56.7090      55.7989      56.8172      61.1734      62.6416      17.9918      17.6339      17.9215      17.6003      16.3470      15.9638       0.0031       0.2517       0.2517       3.7506       0.2770    2525.9021      19.4687      16.7711     362.3750       0.0998    4573.7866    -999.2500    1352.0000       0.2517       0.2517
  432.8160       0.7847      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.4175       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      61.6210      59.2299      61.8383      59.4701      66.9916      64.8483      16.2282      16.8834      16.1712      16.8152      14.9273      15.4206       0.0030       0.2517       0.2517       3.7506       0.2770    2525.9021      17.9918      15.2952     361.2500       0.0998    4573.7866    -999.2500    1345.0000       0.2517       0.2517
  432.9684       0.7855      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.4243       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      64.8201      60.7617      65.1251      60.9431      70.2184      66.1286      15.4273      16.4577      15.3551      16.4087      14.2413      15.1221       0.0030       0.2517       0.2517       3.7506       0.2770    2525.9021      16.2282      16.2017     359.0625       0.0998    4573.7866    -999.2500    1338.0000       0.2517       0.2517
  433.1208       0.7862      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.4312       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      63.7148      60.7952      64.1264      61.0390      69.2819      66.1730      15.6949      16.4487      15.5942      16.3830      14.4338      15.1119       0.0030       0.2517       0.2517       3.7506       0.2770    2525.9021      15.4273      17.8150     364.4375       0.0998    4573.7866    -999.2500    1361.0000       0.2517       0.2517
  433.2732       0.7877      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.4380       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      60.8933      59.5338      61.3901      59.9077      66.8009      65.0879      16.4222      16.7972      16.2893      16.6923      14.9699      15.3638       0.0029       0.2517       0.2517       3.7506       0.2770    2525.9021      15.6949      16.6280     356.4375       0.0998    4573.7866    -999.2500    1363.0000       0.2517       0.2517
  433.4256       0.7892      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.4448       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      57.8393      57.2796      58.3783      57.7806      63.9835      63.1935      17.2893      17.4582      17.1296      17.3068      15.6290      15.8244       0.0029       0.2517       0.2517       3.7506       0.2770    2525.9021      16.4222      17.2512     360.2500       0.0998    4573.7866    -999.2500    1345.0000       0.2517       0.2517
  433.5780       0.7894      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.4517       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      54.0365      54.7404      54.5939      55.2830      60.3518      60.8681      18.5060      18.2681      18.3171      18.0888      16.5695      16.4290       0.0029       0.2517       0.2517       3.7506       0.2770    2525.9021      17.2893      19.9930     362.1250       0.0998    4573.7866    -999.2500    1352.0000       0.2517       0.2517
  433.7304       0.7896      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.4585       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      50.1791      52.4454      50.7616      53.0356      56.5593      58.7677      19.9286      19.0675      19.6999      18.8552      17.6806      17.0162       0.0028       0.2517       0.2517       3.7506       0.2770    2525.9021      18.5060      22.9253     353.7500       0.0998    4573.7866    -999.2500    1365.0000       0.2517       0.2517
  433.8828       0.7900      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.4654       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      48.8960      50.6415      49.5244      51.2636      55.2428      57.0463      20.4516      19.7467      20.1921      19.5070      18.1019      17.5296       0.0028       0.2517       0.2517       3.7506       0.2770    2525.9021      19.9286      21.9476     359.6875       0.0998    4573.7866    -999.2500    1380.0000       0.2517       0.2517
  434.0352       0.7904      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.4722       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      49.5765      49.3154      50.2492      49.9717      55.8067      55.6925      20.1708      20.2776      19.9008      20.0113      17.9190      17.9557       0.0028       0.2517       0.2517       3.7506       0.2770    2525.9021      20.4516      19.4526     367.8125       0.0998    4573.7866    -999.2500    1405.0000       0.2517       0.2517
  434.1876       0.7914      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.4790       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      49.2964      48.1064      49.9543      48.7977      55.5186      54.3505      20.2855      20.7872      20.0183      20.4928      18.0120      18.3991       0.0027       0.2517       0.2517       3.7506       0.2770    2525.9021      20.1708      19.0499     365.8125       0.0998    4573.7866    -999.2500    1444.0000       0.2517       0.2517
  434.3400       0.7924      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.4859       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      47.2601      46.8536      47.8683      47.5741      53.3903      52.9313      21.1595      21.3431      20.8907      21.0198      18.7300      18.8924       0.0027       0.2517       0.2517       3.7506       0.2770    2525.9021      20.2855      22.2366     361.2500       0.0998    4573.7866    -999.2500    1366.0000       0.2517       0.2517
  434.4924       0.7930      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.4927       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      44.9235      45.6113      45.4646      46.1838      50.8708      51.4899      22.2600      21.9244      21.9951      21.6526      19.6577      19.4213       0.0027       0.2517       0.2517       3.7506       0.2770    2525.9021      21.1595      24.3171     358.7500       0.0998    4573.7866    -999.2500    1314.0000       0.2517       0.2517
  434.6448       0.7937      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.4995       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      43.3940      44.5104      43.9278      45.0388      49.4328      50.4436      23.0447      22.4667      22.7646      22.2031      20.2295      19.8241       0.0026       0.2517       0.2517       3.7506       0.2770    2525.9021      22.2600      23.7722     348.5000       0.0998    4573.7866    -999.2500    1296.0000       0.2517       0.2517
  434.7972       0.7942      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.5064       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      42.8219      44.1389      43.3459      44.7090      48.8700      50.2160      23.3525      22.6557      23.0703      22.3669      20.4625      19.9140       0.0026       0.2517       0.2517       3.7506       0.2770    2525.9021      23.0447      23.8649     352.3750       0.0998    4573.7866    -999.2500    1378.0000       0.2517       0.2517
  434.9496       0.7947      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.5132       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      43.1875      44.5809      43.6925      45.1571      49.2226      50.6770      23.1548      22.4311      22.8872      22.1449      20.3159      19.7328       0.0026       0.2517       0.2517       3.7506       0.2770    2525.9021      23.3525      24.4914     351.7500       0.0998    4573.7866    -999.2500    1450.0000       0.2517       0.2517
  435.1020       0.7953      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.5201       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      44.5623      45.5567      45.0390      46.1068      50.6052      51.6295      22.4405      21.9507      22.2030      21.6888      19.7608      19.3688       0.0025       0.2517       0.2517       3.7506       0.2770    2525.9021      23.1548      22.9780     346.7500       0.0998    4573.7866    -999.2500    1433.0000       0.2517       0.2517
  435.2544       0.7959      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.5269       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      46.1635      46.9343      46.6112      47.4487      52.2705      52.9965      21.6621      21.3064      21.4541      21.0754      19.1313      18.8692       0.0025       0.2517       0.2517       3.7506       0.2770    2525.9021      22.4405      21.3007     351.4375       0.0998    4573.7866    -999.2500    1343.0000       0.2517       0.2517
  435.4068       0.7962      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.5337       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      48.0020      48.5738      48.4044      49.0779      53.8538      54.5517      20.8325      20.5872      20.6593      20.3758      18.5688      18.3313       0.0025       0.2517       0.2517       3.7506       0.2770    2525.9021      21.6621      21.5729     351.4375       0.0998    4573.7866    -999.2500    1293.0000       0.2517       0.2517
  435.5592       0.7964      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.5406       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      51.3108      50.2442      51.7082      50.6629      57.0830      56.0484      19.4891      19.9028      19.3393      19.7383      17.5184      17.8417       0.0024       0.2517       0.2517       3.7506       0.2770    2525.9021      20.8325      20.1273     342.6250       0.0998    4573.7866    -999.2500    1272.0000       0.2517       0.2517
  435.7116       0.7972      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.5474       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      54.5317      51.5841      54.8665      51.9374      60.0678      57.3420      18.3380      19.3858      18.2261      19.2539      16.6479      17.4392       0.0024       0.2517       0.2517       3.7506       0.2770    2525.9021      19.4891      19.1536     345.2500       0.0998    4573.7866    -999.2500    1296.0000       0.2517       0.2517
  435.8640       0.7980      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.5542       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      54.6398      52.2332      54.8660      52.5358      59.8885      57.7736      18.3017      19.1449      18.2262      19.0346      16.6977      17.3089       0.0024       0.2517       0.2517       3.7506       0.2770    2525.9021      18.3380      20.1628     367.3750       0.0998    4573.7866    -999.2500    1338.0000       0.2517       0.2517
  436.0164       0.8000      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.5611       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      52.9517      51.9196      53.0130      52.1545      58.3432      57.1800      18.8851      19.2606      18.8633      19.1738      17.1400      17.4886       0.0023       0.2517       0.2517       3.7506       0.2770    2525.9021      18.3017      22.3945     351.4375       0.0998    4573.7866    -999.2500    1418.0000       0.2517       0.2517
  436.1688       0.8021      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.5679       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      51.4114      50.4303      51.3608      50.5439      57.1153      55.8758      19.4510      19.8293      19.4701      19.7848      17.5084      17.8968       0.0023       0.2517       0.2517       3.7506       0.2770    2525.9021      18.8851      20.2480     351.4375       0.0998    4573.7866    -999.2500    1386.0000       0.2517       0.2517
  436.3212       0.8039      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.5748       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      50.0424      47.9548      50.0403      47.9879      56.1760      53.7445      19.9830      20.8530      19.9839      20.8386      17.8012      18.6066       0.0023       0.2517       0.2517       3.7506       0.2770    2525.9021      19.4510      20.5599     341.6875       0.0998    4573.7866    -999.2500    1340.0000       0.2517       0.2517
  436.4736       0.8058      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.5816       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      46.4243      44.4145      46.5554      44.4845      52.9098      50.6056      21.5405      22.5152      21.4798      22.4798      18.9001      19.7607       0.0022       0.2517       0.2517       3.7506       0.2770    2525.9021      19.9830      24.3239     348.9375       0.0998    4573.7866    -999.2500    1267.0000       0.2517       0.2517
  436.6260       0.8098      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.5884       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      40.8043      39.9800      41.0924      40.1441      47.4840      46.4765      24.5072      25.0125      24.3354      24.9103      21.0597      21.5163       0.0022       0.2517       0.2517       3.7506       0.2770    2525.9021      21.5405      23.7814     341.6875       0.0998    4573.7866    -999.2500    1338.0000       0.2517       0.2517
  436.7784       0.8138      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.5953       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      34.6847      35.4325      35.1108      35.7239      41.4613      41.8880      28.8312      28.2227      28.4812      27.9925      24.1189      23.8732       0.0022       0.2517       0.2517       3.7506       0.2770    2525.9021      24.5072      28.4682     348.1250       0.0998    4573.7866    -999.2500    1435.0000       0.2517       0.2517
  436.9308       0.8158      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.6021       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      28.8827      30.4398      29.4287      30.8060      35.7511      37.1537      34.6228      32.8518      33.9805      32.4612      27.9712      26.9152       0.0021       0.2517       0.2517       3.7506       0.2770    2525.9021      28.8312      35.9846     367.3750       0.0998    4573.7866    -999.2500    1461.0000       0.2517       0.2517
  437.0832       0.8179      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.6089       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      23.4975      27.0115      24.0968      27.4091      30.4555      33.7296      42.5578      37.0213      41.4993      36.4842      32.8348      29.6475       0.0021       0.2517       0.2517       3.7506       0.2770    2525.9021      34.6228      49.1313     347.1250       0.0998    4573.7866    -999.2500    1416.0000       0.2517       0.2517
  437.2356       0.8162      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.6158       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      19.8583      25.4795      20.5006      26.0661      26.8479      32.4241      50.3568      39.2472      48.7791      38.3640      37.2469      30.8412       0.0021       0.2517       0.2517       3.7506       0.2770    2525.9021      42.5578      72.8485     341.6875       0.0998    4573.7866    -999.2500    1328.0000       0.2517       0.2517
  437.3880       0.8146      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.6226       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      21.0798      26.4279      21.8608      27.3258      27.9620      33.6877      47.4387      37.8387      45.7439      36.5955      35.7628      29.6844       0.0020       0.2517       0.2517       3.7506       0.2770    2525.9021      50.3568      73.2974     341.6875       0.0998    4573.7866    -999.2500    1306.0000       0.2517       0.2517
  437.5404       0.8138      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.6294       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      26.8868      29.9108      27.8436      31.0271      33.5533      37.1348      37.1930      33.4327      35.9149      32.2299      29.8034      26.9290       0.0020       0.2517       0.2517       3.7506       0.2770    2525.9021      47.4387      36.9184     363.0625       0.0998    4573.7866    -999.2500    1358.0000       0.2517       0.2517
  437.6928       0.8130      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.6363       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      35.3481      34.6644      36.4323      35.8891      41.9503      41.5512      28.2901      28.8481      27.4482      27.8636      23.8377      24.0667       0.0020       0.2517       0.2517       3.7506       0.2770    2525.9021      37.1930      26.3446     351.5625       0.0998    4573.7866    -999.2500    1418.0000       0.2517       0.2517
  437.8452       0.8141      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.6431       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      43.4208      39.1769      44.4677      40.2266      49.7409      45.7905      23.0304      25.5253      22.4882      24.8592      20.1042      21.8386       0.0019       0.2517       0.2517       3.7506       0.2770    2525.9021      28.2901      22.6017     347.1250       0.0998    4573.7866    -999.2500    1450.0000       0.2517       0.2517
  437.9976       0.8152      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.6500       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      47.2813      42.8270      48.1760      43.7508      53.1378      49.0723      21.1500      23.3498      20.7572      22.8567      18.8190      20.3781       0.0019       0.2517       0.2517       3.7506       0.2770    2525.9021      23.0304      22.7056     349.7500       0.0998    4573.7866    -999.2500    1425.0000       0.2517       0.2517
  438.1500       0.8165      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.6568       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      47.3116      45.0841      48.0484      45.9041      53.1243      50.8840      21.1365      22.1807      20.8123      21.7846      18.8238      19.6525       0.0019       0.2517       0.2517       3.7506       0.2770    2525.9021      21.1500      23.3680     343.4375       0.0998    4573.7866    -999.2500    1390.0000       0.2517       0.2517
  438.3024       0.8178      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.6636       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      46.4779      45.7400      47.0524      46.4979      52.2697      51.5714      21.5156      21.8627      21.2529      21.5064      19.1315      19.3906       0.0018       0.2517       0.2517       3.7506       0.2770    2525.9021      21.1365      23.3682     336.4375       0.0998    4573.7866    -999.2500    1333.0000       0.2517       0.2517
  438.4548       0.8178      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.6705       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      45.8896      45.5425      46.4187      46.1937      51.7663      51.4797      21.7914      21.9575      21.5431      21.6480      19.3176      19.4251       0.0018       0.2517       0.2517       3.7506       0.2770    2525.9021      21.5156      23.3684     341.4375       0.0998    4573.7866    -999.2500    1333.0000       0.2517       0.2517
  438.6072       0.8179      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.6773       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      45.6096      45.6487      46.3199      46.2465      51.4100      51.3452      21.9252      21.9064      21.5890      21.6233      19.4515      19.4760       0.0018       0.2517       0.2517       3.7506       0.2770    2525.9021      21.7914      23.3684     338.1250       0.0998    4573.7866    -999.2500    1397.0000       0.2517       0.2517
  438.7596       0.8184      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.6841       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      43.7287      45.2361      44.4197      45.9827      49.5111      50.9602      22.8683      22.1063      22.5125      21.7473      20.1975      19.6232       0.0017       0.2517       0.2517       3.7506       0.2770    2525.9021      21.9252      23.3684     335.5625       0.0998    4573.7866    -999.2500    1516.0000       0.2517       0.2517
  438.9120       0.8190      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.6910       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      41.7784      45.4332      42.3041      46.1217      47.0966      51.2143      23.9358      22.0103      23.6384      21.6818      21.2330      19.5258       0.0017       0.2517       0.2517       3.7506       0.2770    2525.9021      22.8683      23.3685     331.9375       0.0998    4573.7866    -999.2500    1475.0000       0.2517       0.2517
  439.0644       0.8188      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.6978       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      43.7877      47.3170      44.2475      47.9545      48.6624      52.7497      22.8375      21.1341      22.6001      20.8531      20.5497      18.9575       0.0017       0.2517       0.2517       3.7506       0.2770    2525.9021      23.9358      23.3686     331.9375       0.0998    4573.7866    -999.2500    1363.0000       0.2517       0.2517
  439.2168       0.8186      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.7047       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      50.5724      48.8072      51.1516      49.7166      56.0611      54.4894      19.7736      20.4888      19.5497      20.1140      17.8377      18.3522       0.0016       0.2517       0.2517       3.7506       0.2770    2525.9021      22.8375      23.3686     331.9375       0.0998    4573.7866    -999.2500    1224.0000       0.2517       0.2517
  439.3692       0.8186      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.7115       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      57.0757      51.1540      57.6066      51.6699      62.0294      56.6398      17.5206      19.5488      17.3591      19.3536      16.1214      17.6554       0.0016       0.2517       0.2517       3.7506       0.2770    2525.9021      19.7736      23.3686     331.9375       0.0998    4573.7866    -999.2500    1343.0000       0.2517       0.2517
  439.5216       0.8186      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.7183       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      56.2168      52.6429      56.6289      53.1292      61.5718      57.5687      17.7883      18.9959      17.6588      18.8220      16.2412      17.3705       0.0016       0.2517       0.2517       3.7506       0.2770    2525.9021      17.5206      23.3686     331.9375       0.0998    4573.7866    -999.2500    1448.0000       0.2517       0.2517
  439.6740       0.8171      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.7252       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      52.8637      52.0406      53.0836      52.5173      58.5658      57.4558      18.9166      19.2158      18.8382      19.0414      17.0748      17.4047       0.0015       0.2517       0.2517       3.7506       0.2770    2525.9021      17.7883      23.3686     331.9375       0.0998    4573.7866    -999.2500    1458.0000       0.2517       0.2517
  439.8264       0.8155      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.7320       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      50.2365      50.5139      50.5426      50.8910      56.2987      56.5097      19.9059      19.7965      19.7853      19.6499      17.7624      17.6961       0.0015       0.2517       0.2517       3.7506       0.2770    2525.9021      18.9166      23.3683     331.9375       0.0998    4573.7866    -999.2500    1428.0000       0.2517       0.2517
  439.9788       0.8162      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.7388       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      49.1296      48.3698      49.5050      48.7320      55.5675      54.7468      20.3543      20.6741      20.2000      20.5204      17.9961      18.2659       0.0015       0.2517       0.2517       3.7506       0.2770    2525.9021      19.9059      23.3680     331.9375       0.0998    4573.7866    -999.2500    1324.0000       0.2517       0.2517
  440.1312       0.8169      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.7457       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      47.7769      45.5654      48.3299      45.9947      54.3022      52.0578      20.9306      21.9465      20.6911      21.7416      18.4155      19.2094       0.0014       0.2517       0.2517       3.7506       0.2770    2525.9021      20.3543      23.3681     331.9375       0.0998    4573.7866    -999.2500    1336.0000       0.2517       0.2517
  440.2836       0.8191      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.7525       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      43.1938      41.8786      43.9552      42.3901      50.0508      48.3546      23.1515      23.8786      22.7504      23.5904      19.9797      20.6806       0.0014       0.2517       0.2517       3.7506       0.2770    2525.9021      20.9306      23.3682     331.9375       0.0998    4573.7866    -999.2500    1373.0000       0.2517       0.2517
  440.4360       0.8213      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.7594       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      36.9454      37.8617      37.8302      38.6326      43.9496      44.6233      27.0670      26.4119      26.4339      25.8848      22.7533      22.4098       0.0014       0.2517       0.2517       3.7506       0.2770    2525.9021      23.1515      23.3686     331.9375       0.0998    4573.7866    -999.2500    1457.0000       0.2517       0.2517
  440.5884       0.8213      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.7662       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      31.7890      33.9614      32.7013      34.7831      38.9831      40.9007      31.4574      29.4452      30.5798      28.7496      25.6521      24.4495       0.0013       0.2517       0.2517       3.7506       0.2770    2525.9021      27.0670      23.3690     331.9375       0.0998    4573.7866    -999.2500    1494.0000       0.2517       0.2517
  440.7408       0.8212      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.7730       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      29.4842      30.6017      30.4639      31.4806      36.8540      37.7605      33.9164      32.6780      32.8258      31.7656      27.1341      26.4827       0.0013       0.2517       0.2517       3.7506       0.2770    2525.9021      31.4574      23.3690     331.9375       0.0998    4573.7866    -999.2500    1433.0000       0.2517       0.2517
  440.8932       0.8226      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.7799       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      27.5121      28.1162      28.4375      29.0042      34.6984      35.3920      36.3477      35.5666      35.1649      34.4778      28.8198      28.2550       0.0013       0.2517       0.2517       3.7506       0.2770    2525.9021      33.9164      23.3690     331.9375       0.0998    4573.7866    -999.2500    1336.0000       0.2517       0.2517
  441.0456       0.8240      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.7867       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      24.5880      26.7692      25.3275      27.6166      31.5322      34.0086      40.6703      37.3564      39.4828      36.2100      31.7136      29.4043       0.0012       0.2517       0.2517       3.7506       0.2770    2525.9021      36.3477      23.3692     331.9375       0.0998    4573.7866    -999.2500    1323.0000       0.2517       0.2517
  441.1980       0.8258      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.7935       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      23.0905      26.9698      23.6233      27.7389      29.4451      33.9179      43.3079      37.0785      42.3310      36.0504      33.9615      29.4829       0.0012       0.2517       0.2517       3.7506       0.2770    2525.9021      40.6703      23.3695     331.9375       0.0998    4573.7866    -999.2500    1305.0000       0.2517       0.2517
  441.3504       0.8277      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.8004       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      26.0092      28.8506      26.3417      29.4817      31.5895      35.2660      38.4479      34.6614      37.9626      33.9193      31.6561      28.3559       0.0012       0.2517       0.2517       3.7506       0.2770    2525.9021      43.3079      23.3698     331.9375       0.0998    4573.7866    -999.2500    1387.0000       0.2517       0.2517
  441.5028       0.8256      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.8072       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      31.8707      32.1521      31.8431      32.5370      36.1328      37.7670      31.3768      31.1021      31.4040      30.7343      27.6757      26.4781       0.0011       0.2517       0.2517       3.7506       0.2770    2525.9021      38.4479      23.3701     331.9375       0.0998    4573.7866    -999.2500    1437.0000       0.2517       0.2517
  441.6552       0.8236      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.8141       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      36.9302      36.2304      36.0356      36.1985      39.7204      40.3215      27.0781      27.6011      27.7503      27.6255      25.1760      24.8006       0.0011       0.2517       0.2517       3.7506       0.2770    2525.9021      31.3768      23.3697     331.9375       0.0998    4573.7866    -999.2500    1481.0000       0.2517       0.2517
  441.8076       0.8227      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.8209       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      41.4169      39.7755      40.0883      39.0570      42.9470      42.6579      24.1448      25.1411      24.9450      25.6036      23.2845      23.4423       0.0011       0.2517       0.2517       3.7506       0.2770    2525.9021      27.0781      23.3694     331.9375       0.0998    4573.7866    -999.2500    1443.0000       0.2517       0.2517
  441.9600       0.8218      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.8277       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      47.3746      43.0489      44.6293      41.4215      47.6896      44.6278      21.1084      23.2294      22.4068      24.1420      20.9689      22.4076       0.0010       0.2517       0.2517       3.7506       0.2770    2525.9021      24.1448      23.3692     331.9375       0.0998    4573.7866    -999.2500    1380.0000       0.2517       0.2517
  442.1124       0.8220      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.8346       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      51.2725      45.5892      47.1969      42.8923      49.7630      45.8690      19.5036      21.9350      21.1878      23.3142      20.0952      21.8012       0.0010       0.2517       0.2517       3.7506       0.2770    2525.9021      21.1084      23.3691     331.9375       0.0998    4573.7866    -999.2500    1366.0000       0.2517       0.2517
  442.2648       0.8223      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.8414       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      51.0286      47.5513      46.0151      43.6853      48.5026      46.1180      19.5969      21.0299      21.7320      22.8910      20.6175      21.6835       0.0010       0.2517       0.2517       3.7506       0.2770    2525.9021      19.5036      23.3691     331.9375       0.0998    4573.7866    -999.2500    1356.0000       0.2517       0.2517
  442.4172       0.8232      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.8482       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      49.4171      48.4194      43.5289      43.5993      46.5455      45.9944      20.2359      20.6529      22.9733      22.9361      21.4844      21.7418       0.0009       0.2517       0.2517       3.7506       0.2770    2525.9021      19.5969      23.3692     331.9375       0.0998    4573.7866    -999.2500    1412.0000       0.2517       0.2517
  442.5696       0.8241      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.8551       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      48.6876      48.9177      43.4440      42.7435      46.5629      45.8708      20.5391      20.4425      23.0181      23.3954      21.4763      21.8004       0.0009       0.2517       0.2517       3.7506       0.2770    2525.9021      20.2359      23.3693     331.9375       0.0998    4573.7866    -999.2500    1442.0000       0.2517       0.2517
  442.7220       0.8264      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.8619       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      48.8148      49.1701      42.8835      42.5986      46.1643      45.7978      20.4856      20.3376      23.3190      23.4750      21.6618      21.8351       0.0009       0.2517       0.2517       3.7506       0.2770    2525.9021      20.5391      23.3695     331.9375       0.0998    4573.7866    -999.2500    1440.0000       0.2517       0.2517
  442.8744       0.8287      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.8687       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      48.1484      48.9788      42.7013      42.5551      46.0374      45.7815      20.7691      20.4170      23.4185      23.4990      21.7215      21.8429       0.0008       0.2517       0.2517       3.7506       0.2770    2525.9021      20.4856      23.3699     331.9375       0.0998    4573.7866    -999.2500    1384.0000       0.2517       0.2517
  443.0268       0.8289      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.8756       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      48.1074      48.5168      42.5639      42.5051      45.9130      45.7618      20.7868      20.6114      23.4941      23.5266      21.7803      21.8523       0.0008       0.2517       0.2517       3.7506       0.2770    2525.9021      20.7691      23.3703     331.9375       0.0998    4573.7866    -999.2500    1426.0000       0.2517       0.2517
  443.1792       0.8290      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.8824       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      47.1216      47.9039      42.4940      42.4391      45.8916      45.7306      21.2217      20.8751      23.5327      23.5632      21.7905      21.8672       0.0008       0.2517       0.2517       3.7506       0.2770    2525.9021      20.7868      23.3703     331.9375       0.0998    4573.7866    -999.2500    1372.0000       0.2517       0.2517
  443.3316       0.8294      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.8893       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      46.1101      46.8807      42.2145      42.3630      45.5856      45.6836      21.6872      21.3307      23.6886      23.6055      21.9368      21.8897       0.0007       0.2517       0.2517       3.7506       0.2770    2525.9021      21.2217      23.3703     331.9375       0.0998    4573.7866    -999.2500    1438.0000       0.2517       0.2517
  443.4840       0.8298      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.8961       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      45.1415      45.9554      42.2451      42.2973      45.6485      45.6695      22.1526      21.7602      23.6714      23.6422      21.9065      21.8964       0.0007       0.2517       0.2517       3.7506       0.2770    2525.9021      21.6872      23.3704     331.9375       0.0998    4573.7866    -999.2500    1445.0000       0.2517       0.2517
  443.6364       0.8315      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.9029       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      44.2958      45.0767      42.0857      42.2568      45.5370      45.6590      22.5755      22.1844      23.7610      23.6648      21.9602      21.9015       0.0007       0.2517       0.2517       3.7506       0.2770    2525.9021      22.1526      23.3705     331.9375       0.0998    4573.7866    -999.2500    1443.0000       0.2517       0.2517
  443.7888       0.8331      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.9098       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      43.8555      44.3966      42.0558      42.1973      45.5174      45.6515      22.8022      22.5243      23.7779      23.6982      21.9696      21.9051       0.0006       0.2517       0.2517       3.7506       0.2770    2525.9021      22.5755      23.3707     331.9375       0.0998    4573.7866    -999.2500    1434.0000       0.2517       0.2517
  443.9412       0.8334      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.9166       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      43.7381      43.9746      42.1489      42.1835      45.5919      45.6466      22.8634      22.7404      23.7254      23.7060      21.9337      21.9074       0.0006       0.2517       0.2517       3.7506       0.2770    2525.9021      22.8022      23.3710     331.9375       0.0998    4573.7866    -999.2500    1434.0000       0.2517       0.2517
  444.0936       0.8336      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.9234       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      43.8009      43.7944      42.2284      42.2007      45.6563      45.6428      22.8306      22.8340      23.6808      23.6963      21.9028      21.9093       0.0006       0.2517       0.2517       3.7506       0.2770    2525.9021      22.8634      23.3711     331.9375       0.0998    4573.7866    -999.2500    1405.0000       0.2517       0.2517
  444.2460       0.8324      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.9303       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      43.9822      43.8090      42.1824      42.2185      45.6267      45.6408      22.7365      22.8264      23.7066      23.6863      21.9170      21.9102       0.0005       0.2517       0.2517       3.7506       0.2770    2525.9021      22.8306      23.3711     331.9375       0.0998    4573.7866    -999.2500    1349.0000       0.2517       0.2517
  444.3984       0.8312      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.9371       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      44.2335      43.9640      42.1892      42.2134      45.6316      45.6397      22.6073      22.7459      23.7027      23.6892      21.9146      21.9107       0.0005       0.2517       0.2517       3.7506       0.2770    2525.9021      22.7365      23.3709     331.9375       0.0998    4573.7866    -999.2500    1448.0000       0.2517       0.2517
  444.5508       0.8321      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.9440       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      44.4912      44.2028      42.2012      42.2040      45.6388      45.6389      22.4764      22.6230      23.6960      23.6944      21.9112      21.9111       0.0005       0.2517       0.2517       3.7506       0.2770    2525.9021      22.6073      23.3707     331.9375       0.0998    4573.7866    -999.2500    1369.0000       0.2517       0.2517
  444.7032       0.8329      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.9508       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      45.7761      45.2620      42.3308      42.3413      45.6329      45.6375      21.8455      22.0936      23.6235      23.6176      21.9140      21.9118       0.0004       0.2517       0.2517       3.7506       0.2770    2525.9021      22.4764      23.3708     331.9375       0.0998    4573.7866    -999.2500    1409.0000       0.2517       0.2517
  444.8556       0.8409      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.9576       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      49.3443      48.0525      42.8421      42.8635      45.6388      45.6360      20.2658      20.8106      23.3415      23.3299      21.9112      21.9125       0.0004       0.2517       0.2517       3.7506       0.2770    2525.9021      21.8455      23.3710     331.9375       0.0998    4573.7866    -999.2500    1360.0000       0.2517       0.2517
  445.0080       0.8489      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.9645       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      58.5161      55.0753      44.2825      44.4232      45.6440      45.6352      17.0893      18.1569      22.5823      22.5107      21.9087      21.9129       0.0004       0.2517       0.2517       3.7506       0.2770    2525.9021      20.2658      23.3724     331.9375       0.0998    4573.7866    -999.2500    1394.0000       0.2517       0.2517
  445.1604       0.8615      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.9713       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021      78.8611      71.6243      42.1883      42.1834      45.6469      45.6352      12.6805      13.9617      23.7033      23.7060      21.9073      21.9129       0.0003       0.2517       0.2517       3.7506       0.2770    2525.9021      17.0893      23.3737     331.9375       0.0998    4573.7866    -999.2500    1391.0000       0.2517       0.2517
  445.3128       0.8740      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.9781       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021     118.5795     131.9691      42.1848      76.0517      45.6505      77.4962       8.4332       7.5775      23.7052      13.1489      21.9056      12.9039       0.0003       0.2517       0.2517       3.7506       0.2770    2525.9021      12.6805      23.3759     331.9375       0.0998    4573.7866    -999.2500    1388.0000       0.2517       0.2517
  445.4652       0.8831      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.9850       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021     212.2391     309.6988      67.4177     207.4916      71.0419     213.2738       4.7117       3.2289      14.8329       4.8195      14.0762       4.6888       0.0003       0.2517       0.2517       3.7506       0.2770    2525.9021       8.4332      23.3780     331.9375       0.0998    4573.7866    -999.2500    1341.0000       0.2517       0.2517
  445.6176       0.8921      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.9918       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021     413.8098     631.3884     157.8073     492.9892     164.6610     502.7801       2.4166       1.5838       6.3368       2.0284       6.0731       1.9889       0.0002       0.2517       0.2517       3.7506       0.2770    2525.9021       4.7117      23.3796     331.9375       0.0998    4573.7866    -999.2500    1329.0000       0.2517       0.2517
  445.7700       0.5864      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      39.9987       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021    1372.0317    1440.5967    1173.0159    1219.6139    1216.3335    1240.9158       0.7288       0.6942       0.8525       0.8199       0.8221       0.8059       0.0002       0.2517       0.2517       3.7506       0.2770    2525.9021       2.4166      23.3811     331.9375       0.0998    4573.7866    -999.2500    1324.0000       0.2517       0.2517
  445.9224       0.2807      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      40.0055       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021    1534.8389    1565.3937    1179.9091    1318.8199    1223.2063    1340.1978       0.6515       0.6388       0.8475       0.7583       0.8175       0.7462       0.0002       0.2517       0.2517       3.7506       0.2770    2525.9021       0.7288      23.3811     331.9375       0.0998    4573.7866    -999.2500    1209.0000       0.2517       0.2517
  446.0748       0.2807      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      40.0123       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021    1613.6725    1639.5999    1179.9160    1318.8223    1223.2122    1340.1991       0.6197       0.6099       0.8475       0.7583       0.8175       0.7462       0.0001       0.2517       0.2517       3.7506       0.2770    2525.9021       0.6515      23.3811     331.9375       0.0998    4573.7866    -999.2500     792.0000       0.2517       0.2517
  446.2272       0.2807      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      40.0192       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021    1613.6725    1639.5999    1179.9160    1318.8223    1223.2122    1340.1991       0.6197       0.6099       0.8475       0.7583       0.8175       0.7462       0.0001       0.2517       0.2517       3.7506       0.2770    2525.9021       0.6197      23.3811     331.9375       0.0998    4573.7866    -999.2500     792.0000       0.2517       0.2517
  446.3796       0.2807      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      40.0260       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021    1613.6725    1639.5999    1179.9160    1318.8223    1223.2122    1340.1991       0.6197       0.6099       0.8475       0.7583       0.8175       0.7462       0.0001       0.2517       0.2517       3.7506       0.2770    2525.9021       0.6197      23.3811     331.9375       0.0998    4573.7866    -999.2500     792.0000       0.2517       0.2517
  446.5320       0.2807      96.0000      57.1500       0.0752       0.0752     -16.8371     218.6372     219.0931     219.5077     218.6786     218.6372     393.9449     394.2225     393.6673     393.6673     157.1222      40.0328       0.0752       0.0752     -16.8371     157.1222       3.7506    2525.9021    1613.6725    1639.5999    1179.9160    1318.8223    1223.2122    1340.1991       0.6197       0.6099       0.8475       0.7583       0.8175       0.7462       0.0000       0.2517       0.2517       3.7506       0.2770    2525.9021       0.6197      23.3811     331.9375       0.0998    4573.7866    -999.2500     792.0000       0.2517       0.2517
